/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerAPI.input.userDesired;

import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.communication.controllerAPI.command.Command;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.PelvisHeightTrajectoryCommand;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class UserDesiredPelvisHeightControllerCommandGenerators {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoBoolean userDoPelvisHeight = new YoBoolean("userDesiredPelvisHeightExecute", this.registry);
    private final YoBoolean userDesiredSetPelvisHeightToActual = new YoBoolean("userDesiredPelvisSetHeightToActual", this.registry);
    private final YoDouble userDesiredPelvisHeightTrajectoryTime = new YoDouble("userDesiredPelvisHeightTrajectoryTime", this.registry);
    private final YoDouble userDesiredPelvisHeight = new YoDouble("userDesiredPelvisHeight", this.registry);

    public UserDesiredPelvisHeightControllerCommandGenerators(final CommandInputManager controllerCommandInputManager, final FullHumanoidRobotModel fullRobotModel, double defaultTrajectoryTime, YoRegistry parentRegistry) {
        this.userDesiredSetPelvisHeightToActual.addListener(new YoVariableChangedListener(){

            public void changed(YoVariable v) {
                if (UserDesiredPelvisHeightControllerCommandGenerators.this.userDesiredSetPelvisHeightToActual.getBooleanValue()) {
                    MovingReferenceFrame pelvisFrame = fullRobotModel.getPelvis().getBodyFixedFrame();
                    FramePose3D currentPose = new FramePose3D((ReferenceFrame)pelvisFrame);
                    currentPose.changeFrame(ReferenceFrame.getWorldFrame());
                    UserDesiredPelvisHeightControllerCommandGenerators.this.userDesiredPelvisHeight.set(currentPose.getZ());
                    UserDesiredPelvisHeightControllerCommandGenerators.this.userDesiredSetPelvisHeightToActual.set(false);
                }
            }
        });
        this.userDoPelvisHeight.addListener(new YoVariableChangedListener(){

            public void changed(YoVariable v) {
                if (UserDesiredPelvisHeightControllerCommandGenerators.this.userDoPelvisHeight.getBooleanValue()) {
                    PelvisHeightTrajectoryCommand pelvisHeightTrajectoryControllerCommand = new PelvisHeightTrajectoryCommand();
                    pelvisHeightTrajectoryControllerCommand.addTrajectoryPoint(UserDesiredPelvisHeightControllerCommandGenerators.this.userDesiredPelvisHeightTrajectoryTime.getDoubleValue(), UserDesiredPelvisHeightControllerCommandGenerators.this.userDesiredPelvisHeight.getDoubleValue(), 0.0);
                    System.out.println("Submitting " + pelvisHeightTrajectoryControllerCommand);
                    controllerCommandInputManager.submitCommand((Command)pelvisHeightTrajectoryControllerCommand);
                    UserDesiredPelvisHeightControllerCommandGenerators.this.userDoPelvisHeight.set(false);
                }
            }
        });
        this.userDesiredPelvisHeightTrajectoryTime.set(defaultTrajectoryTime);
        parentRegistry.addChild(this.registry);
    }
}

