/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerAPI.input.userDesired;

import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.communication.controllerAPI.command.Command;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.HandTrajectoryCommand;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.math.trajectories.trajectorypoints.FrameSE3TrajectoryPoint;
import us.ihmc.robotics.partNames.LimbName;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoseUsingYawPitchRoll;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoVariable;

public class UserDesiredHandPoseControllerCommandGenerator {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoBoolean userDoHandPose = new YoBoolean("userDoHandPose", this.registry);
    private final YoBoolean userDesiredSetHandPoseToActual = new YoBoolean("userDesiredSetHandPoseToActual", this.registry);
    private final YoDouble userDesiredHandPoseTrajectoryTime = new YoDouble("userDesiredHandPoseTrajectoryTime", this.registry);
    private final YoEnum<RobotSide> userHandPoseSide = new YoEnum("userHandPoseSide", this.registry, RobotSide.class);
    private final YoEnum<BaseForControl> userHandPoseBaseForControl = new YoEnum("userHandPoseBaseForControl", this.registry, BaseForControl.class);
    private final YoFramePoseUsingYawPitchRoll userDesiredHandPose;
    private final ReferenceFrame chestFrame;
    private final FramePose3D framePose = new FramePose3D(ReferenceFrame.getWorldFrame());

    public UserDesiredHandPoseControllerCommandGenerator(final CommandInputManager controllerCommandInputManager, final FullHumanoidRobotModel fullRobotModel, double defaultTrajectoryTime, YoRegistry parentRegistry) {
        this.userDesiredHandPose = new YoFramePoseUsingYawPitchRoll("userDesiredHandPose", ReferenceFrame.getWorldFrame(), this.registry);
        this.chestFrame = fullRobotModel.getChest().getBodyFixedFrame();
        this.userDesiredSetHandPoseToActual.addListener(new YoVariableChangedListener(){

            public void changed(YoVariable v) {
                if (UserDesiredHandPoseControllerCommandGenerator.this.userDesiredSetHandPoseToActual.getBooleanValue()) {
                    ReferenceFrame referenceFrame = UserDesiredHandPoseControllerCommandGenerator.this.getReferenceFrameToUse();
                    MovingReferenceFrame wristFrame = fullRobotModel.getEndEffectorFrame((Enum)((RobotSide)UserDesiredHandPoseControllerCommandGenerator.this.userHandPoseSide.getEnumValue()), LimbName.ARM);
                    FramePose3D currentPose = new FramePose3D((ReferenceFrame)wristFrame);
                    currentPose.changeFrame(referenceFrame);
                    UserDesiredHandPoseControllerCommandGenerator.this.userDesiredHandPose.setPosition((Tuple3DReadOnly)new Point3D((Tuple3DReadOnly)currentPose.getPosition()));
                    UserDesiredHandPoseControllerCommandGenerator.this.userDesiredHandPose.setOrientation((FrameOrientation3DReadOnly)currentPose.getOrientation());
                    UserDesiredHandPoseControllerCommandGenerator.this.userDesiredSetHandPoseToActual.set(false);
                }
            }
        });
        this.userDoHandPose.addListener(new YoVariableChangedListener(){

            public void changed(YoVariable v) {
                if (UserDesiredHandPoseControllerCommandGenerator.this.userDoHandPose.getBooleanValue()) {
                    UserDesiredHandPoseControllerCommandGenerator.this.framePose.setIncludingFrame((FramePose3DReadOnly)UserDesiredHandPoseControllerCommandGenerator.this.userDesiredHandPose);
                    ReferenceFrame referenceFrameToUse = UserDesiredHandPoseControllerCommandGenerator.this.getReferenceFrameToUse();
                    UserDesiredHandPoseControllerCommandGenerator.this.framePose.setIncludingFrame(referenceFrameToUse, (Pose3DReadOnly)UserDesiredHandPoseControllerCommandGenerator.this.framePose);
                    HandTrajectoryCommand handTrajectoryControllerCommand = new HandTrajectoryCommand((RobotSide)UserDesiredHandPoseControllerCommandGenerator.this.userHandPoseSide.getEnumValue(), referenceFrameToUse, referenceFrameToUse);
                    FrameSE3TrajectoryPoint trajectoryPoint = new FrameSE3TrajectoryPoint(referenceFrameToUse);
                    trajectoryPoint.setTime(UserDesiredHandPoseControllerCommandGenerator.this.userDesiredHandPoseTrajectoryTime.getDoubleValue());
                    trajectoryPoint.setPosition((FramePoint3DReadOnly)UserDesiredHandPoseControllerCommandGenerator.this.framePose.getPosition());
                    trajectoryPoint.setOrientation((FrameQuaternionReadOnly)UserDesiredHandPoseControllerCommandGenerator.this.framePose.getOrientation());
                    trajectoryPoint.setLinearVelocity((Vector3DReadOnly)new Vector3D());
                    trajectoryPoint.setAngularVelocity((Vector3DReadOnly)new Vector3D());
                    handTrajectoryControllerCommand.getSE3Trajectory().addTrajectoryPoint(trajectoryPoint);
                    System.out.println("Submitting " + handTrajectoryControllerCommand);
                    controllerCommandInputManager.submitCommand((Command)handTrajectoryControllerCommand);
                    UserDesiredHandPoseControllerCommandGenerator.this.userDoHandPose.set(false);
                }
            }
        });
        this.userDesiredHandPoseTrajectoryTime.set(defaultTrajectoryTime);
        this.userHandPoseSide.set((Enum)RobotSide.LEFT);
        this.userHandPoseBaseForControl.set((Enum)BaseForControl.CHEST);
        parentRegistry.addChild(this.registry);
    }

    private ReferenceFrame getReferenceFrameToUse() {
        ReferenceFrame referenceFrame2;
        switch ((BaseForControl)this.userHandPoseBaseForControl.getEnumValue()) {
            case CHEST: {
                referenceFrame2 = this.chestFrame;
                break;
            }
            case WORLD: {
                ReferenceFrame referenceFrame2 = ReferenceFrame.getWorldFrame();
            }
            case WALKING_PATH: {
                ReferenceFrame referenceFrame2 = ReferenceFrame.getWorldFrame();
            }
            default: {
                throw new RuntimeException("Shouldn't get here!");
            }
        }
        return referenceFrame2;
    }

    public static enum BaseForControl {
        CHEST,
        WORLD,
        WALKING_PATH;

    }
}

