/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.rigidBody;

import java.util.Map;
import us.ihmc.commonWalkingControlModules.controlModules.rigidBody.RigidBodyControlMode;
import us.ihmc.commonWalkingControlModules.controlModules.rigidBody.RigidBodyControlState;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.JointspaceAccelerationCommand;
import us.ihmc.communication.controllerAPI.command.Command;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.DesiredAccelerationsCommand;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class RigidBodyUserControlState
extends RigidBodyControlState {
    public static final double TIME_WITH_NO_MESSAGE_BEFORE_ABORT = 0.25;
    private final JointspaceAccelerationCommand jointspaceAccelerationCommand;
    private final OneDoFJointBasics[] jointsToControl;
    private final int numberOfJoints;
    private final YoDouble[] userDesiredJointAccelerations;
    private final DoubleProvider[] weights;
    private final YoBoolean abortUserControlMode;
    private final YoBoolean hasWeights;

    public RigidBodyUserControlState(String bodyName, OneDoFJointBasics[] jointsToControl, YoDouble yoTime, YoRegistry parentRegistry) {
        super(RigidBodyControlMode.USER, bodyName, yoTime, parentRegistry);
        String prefix = bodyName + "UserMode";
        this.hasWeights = new YoBoolean(prefix + "HasWeights", this.registry);
        this.jointsToControl = jointsToControl;
        this.numberOfJoints = jointsToControl.length;
        this.jointspaceAccelerationCommand = new JointspaceAccelerationCommand();
        this.userDesiredJointAccelerations = new YoDouble[jointsToControl.length];
        this.weights = new DoubleProvider[jointsToControl.length];
        for (int i = 0; i < this.numberOfJoints; ++i) {
            String jointName = jointsToControl[i].getName();
            this.userDesiredJointAccelerations[i] = new YoDouble(prefix + "_" + jointName + "_qdd_d", this.registry);
            this.jointspaceAccelerationCommand.addJoint(jointsToControl[i], Double.NaN);
        }
        this.abortUserControlMode = new YoBoolean(prefix + "Abort", this.registry);
    }

    public boolean handleDesiredAccelerationsCommand(DesiredAccelerationsCommand command) {
        if (!this.hasWeights.getBooleanValue()) {
            LogTools.warn((String)(this.warningPrefix + "Can not send joint desired accelerations. Do not have all weights set."));
            return false;
        }
        if (command.getNumberOfJoints() != this.jointsToControl.length) {
            LogTools.warn((String)(this.warningPrefix + "Unexpected number of joints."));
            return false;
        }
        if (!this.handleCommandInternal((Command<?, ?>)command)) {
            return false;
        }
        for (int i = 0; i < this.numberOfJoints; ++i) {
            this.userDesiredJointAccelerations[i].set(command.getDesiredJointAcceleration(i));
        }
        this.abortUserControlMode.set(false);
        return true;
    }

    public void doAction(double timeInState) {
        if (this.getTimeInTrajectory() > 0.25) {
            this.abortUserControlMode.set(true);
            return;
        }
        for (int jointIdx = 0; jointIdx < this.numberOfJoints; ++jointIdx) {
            double desiredAcceleration = this.userDesiredJointAccelerations[jointIdx].getDoubleValue();
            this.jointspaceAccelerationCommand.setOneDoFJointDesiredAcceleration(jointIdx, desiredAcceleration);
            this.jointspaceAccelerationCommand.setWeight(jointIdx, this.weights[jointIdx].getValue());
        }
    }

    public void setWeights(Map<String, DoubleProvider> weights) {
        this.hasWeights.set(true);
        for (int jointIdx = 0; jointIdx < this.numberOfJoints; ++jointIdx) {
            OneDoFJointBasics joint = this.jointsToControl[jointIdx];
            if (weights.containsKey(joint.getName())) {
                this.weights[jointIdx] = weights.get(joint.getName());
                continue;
            }
            this.hasWeights.set(false);
        }
    }

    public void setWeight(DoubleProvider weight) {
        this.hasWeights.set(true);
        for (int jointIdx = 0; jointIdx < this.numberOfJoints; ++jointIdx) {
            this.weights[jointIdx] = weight;
        }
    }

    public void onEntry() {
    }

    public void onExit() {
        this.abortUserControlMode.set(false);
    }

    @Override
    public InverseDynamicsCommand<?> getInverseDynamicsCommand() {
        return this.jointspaceAccelerationCommand;
    }

    @Override
    public boolean abortState() {
        return this.abortUserControlMode.getBooleanValue();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public double getLastTrajectoryPointTime() {
        return 0.0;
    }
}

