/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.rigidBody;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.PointFeedbackControlCommand;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.lists.RecyclingArrayDeque;
import us.ihmc.communication.packets.ExecutionMode;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tools.QuaternionTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.EuclideanTrajectoryControllerCommand;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotics.controllers.pidGains.PID3DGainsReadOnly;
import us.ihmc.robotics.math.trajectories.generators.MultipleWaypointsPositionTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.trajectorypoints.FrameEuclideanTrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FrameEuclideanTrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.lists.FrameEuclideanTrajectoryPointList;
import us.ihmc.robotics.screwTheory.SelectionMatrix3D;
import us.ihmc.robotics.weightMatrices.WeightMatrix3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class RigidBodyPositionControlHelper {
    private final PointFeedbackControlCommand feedbackControlCommand = new PointFeedbackControlCommand();
    private final MultipleWaypointsPositionTrajectoryGenerator trajectoryGenerator;
    private final FrameEuclideanTrajectoryPoint lastPointAdded = new FrameEuclideanTrajectoryPoint();
    private final RecyclingArrayDeque<FrameEuclideanTrajectoryPoint> pointQueue = new RecyclingArrayDeque(10000, FrameEuclideanTrajectoryPoint.class, FrameEuclideanTrajectoryPointBasics::set);
    private final YoDouble streamTimestampOffset;
    private final YoDouble streamTimestampSource;
    private boolean messageWeightValid = false;
    private final BooleanProvider useWeightFromMessage;
    private final WeightMatrix3D defaultWeightMatrix = new WeightMatrix3D();
    private final WeightMatrix3D messageWeightMatrix = new WeightMatrix3D();
    private final YoFrameVector3D currentWeight;
    private final SelectionMatrix3D selectionMatrix = new SelectionMatrix3D();
    private Vector3DReadOnly defaultWeight;
    private PID3DGainsReadOnly gains;
    private final FramePoint3D desiredPosition = new FramePoint3D();
    private final FrameVector3D desiredVelocity = new FrameVector3D();
    private final FrameVector3D feedForwardAcceleration = new FrameVector3D();
    private final BooleanProvider useBaseFrameForControl;
    private final RigidBodyTransform previousControlFramePose = new RigidBodyTransform();
    private final RigidBodyTransform controlFramePose = new RigidBodyTransform();
    private final ReferenceFrame defaultControlFrame;
    private final Point3D integratedPosition = new Point3D();
    private final ReferenceFrame baseFrame;
    private final ReferenceFrame bodyFrame;
    private final FramePoint3D currentPosition = new FramePoint3D();
    private final YoFramePoint3D yoCurrentPosition;
    private final YoFramePoint3D yoDesiredPosition;
    private final List<YoGraphicPosition> graphics = new ArrayList<YoGraphicPosition>();
    private final String warningPrefix;
    private final DoubleProvider time;

    public RigidBodyPositionControlHelper(String warningPrefix, RigidBodyBasics bodyToControl, RigidBodyBasics baseBody, RigidBodyBasics elevator, ReferenceFrame controlFrame, ReferenceFrame baseFrame, BooleanProvider useBaseFrameForControl, BooleanProvider useWeightFromMessage, DoubleProvider time, YoRegistry registry, YoGraphicsListRegistry graphicsListRegistry) {
        this.warningPrefix = warningPrefix;
        this.useBaseFrameForControl = useBaseFrameForControl;
        this.useWeightFromMessage = useWeightFromMessage;
        this.baseFrame = baseFrame;
        this.time = time;
        String bodyName = bodyToControl.getName();
        String prefix = bodyName + "TaskspacePosition";
        this.trajectoryGenerator = new MultipleWaypointsPositionTrajectoryGenerator(bodyName, 5, ReferenceFrame.getWorldFrame(), registry);
        this.trajectoryGenerator.clear(baseFrame);
        this.currentWeight = new YoFrameVector3D(prefix + "CurrentWeight", null, registry);
        this.feedbackControlCommand.set(elevator, bodyToControl);
        this.feedbackControlCommand.setPrimaryBase(baseBody);
        this.defaultControlFrame = controlFrame;
        this.bodyFrame = bodyToControl.getBodyFixedFrame();
        this.setDefaultControlFrame();
        if (graphicsListRegistry != null) {
            this.yoCurrentPosition = new YoFramePoint3D(prefix + "Current", ReferenceFrame.getWorldFrame(), registry);
            this.yoDesiredPosition = new YoFramePoint3D(prefix + "Desired", ReferenceFrame.getWorldFrame(), registry);
            this.setupViz(graphicsListRegistry, bodyName);
        } else {
            this.yoCurrentPosition = null;
            this.yoDesiredPosition = null;
        }
        this.streamTimestampOffset = new YoDouble(prefix + "StreamTimestampOffset", registry);
        this.streamTimestampOffset.setToNaN();
        this.streamTimestampSource = new YoDouble(prefix + "StreamTimestampSource", registry);
        this.streamTimestampSource.setToNaN();
    }

    public void setGains(PID3DGainsReadOnly gains) {
        this.gains = gains;
    }

    public void setWeights(Vector3DReadOnly weights) {
        this.defaultWeight = weights;
    }

    private void setupViz(YoGraphicsListRegistry graphicsListRegistry, String bodyName) {
        String listName = this.getClass().getSimpleName();
        YoGraphicPosition controlPoint = new YoGraphicPosition(bodyName + "Current", this.yoCurrentPosition, 0.005, YoAppearance.Red());
        graphicsListRegistry.registerYoGraphic(listName, (YoGraphic)controlPoint);
        this.graphics.add(controlPoint);
        YoGraphicPosition desiredPoint = new YoGraphicPosition(bodyName + "Desired", this.yoDesiredPosition, 0.005, YoAppearance.Blue());
        graphicsListRegistry.registerYoGraphic(listName, (YoGraphic)desiredPoint);
        this.graphics.add(desiredPoint);
    }

    public List<YoGraphicPosition> getGraphics() {
        return this.graphics;
    }

    private void setDefaultControlFrame() {
        this.defaultControlFrame.getTransformToDesiredFrame(this.controlFramePose, this.bodyFrame);
        this.currentPosition.setIncludingFrame(this.bodyFrame, (Tuple3DReadOnly)this.controlFramePose.getTranslation());
        this.feedbackControlCommand.setBodyFixedPointToControl((FramePoint3DReadOnly)this.currentPosition);
    }

    private void setControlFramePose(RigidBodyTransform controlFramePoseInBody) {
        this.controlFramePose.set(controlFramePoseInBody);
        this.currentPosition.setIncludingFrame(this.bodyFrame, (Tuple3DReadOnly)this.controlFramePose.getTranslation());
        this.feedbackControlCommand.setBodyFixedPointToControl((FramePoint3DReadOnly)this.currentPosition);
    }

    public static void modifyControlFrame(FixedFramePoint3DBasics desiredPositionToModify, FrameQuaternionBasics desiredOrientationOfPreviousControlFrame, RigidBodyTransform previousControlFramePose, RigidBodyTransform newControlFramePose) {
        if (previousControlFramePose.equals(newControlFramePose)) {
            return;
        }
        if (desiredOrientationOfPreviousControlFrame == null) {
            throw new RuntimeException("Changing the control frame requires a desired orientation. Bodies that are position controlled do not support control frame changes.");
        }
        desiredOrientationOfPreviousControlFrame.changeFrame(desiredPositionToModify.getReferenceFrame());
        previousControlFramePose.invert();
        previousControlFramePose.multiply((RigidBodyTransformReadOnly)newControlFramePose);
        QuaternionTools.addTransform((QuaternionReadOnly)desiredOrientationOfPreviousControlFrame, (Tuple3DReadOnly)previousControlFramePose.getTranslation(), (Tuple3DBasics)desiredPositionToModify);
    }

    public void holdCurrent() {
        this.clear();
        this.desiredPosition.setIncludingFrame(this.bodyFrame, (Tuple3DReadOnly)this.controlFramePose.getTranslation());
        this.queueInitialPoint(this.desiredPosition);
    }

    public void holdCurrentDesired(FrameQuaternionBasics currentDesiredOrientation) {
        this.getDesiredPosition(this.desiredPosition);
        this.previousControlFramePose.set(this.controlFramePose);
        this.clear();
        RigidBodyPositionControlHelper.modifyControlFrame((FixedFramePoint3DBasics)this.desiredPosition, currentDesiredOrientation, this.previousControlFramePose, this.controlFramePose);
        this.queueInitialPoint(this.desiredPosition);
    }

    public void goToPositionFromCurrent(FramePoint3DReadOnly position, double trajectoryTime) {
        this.holdCurrent();
        FrameEuclideanTrajectoryPoint trajectoryPoint = (FrameEuclideanTrajectoryPoint)this.pointQueue.addLast();
        trajectoryPoint.setToZero(this.trajectoryGenerator.getReferenceFrame());
        trajectoryPoint.setTime(trajectoryTime);
        this.desiredPosition.setIncludingFrame((FrameTuple3DReadOnly)position);
        this.desiredPosition.changeFrame(this.trajectoryGenerator.getReferenceFrame());
        trajectoryPoint.setPosition((FramePoint3DReadOnly)this.desiredPosition);
    }

    public void goToPosition(FramePoint3DReadOnly position, FrameQuaternionBasics currentDesiredOrientation, double trajectoryTime) {
        this.holdCurrentDesired(currentDesiredOrientation);
        FrameEuclideanTrajectoryPoint trajectoryPoint = (FrameEuclideanTrajectoryPoint)this.pointQueue.addLast();
        trajectoryPoint.setToZero(this.trajectoryGenerator.getReferenceFrame());
        trajectoryPoint.setTime(trajectoryTime);
        this.desiredPosition.setIncludingFrame((FrameTuple3DReadOnly)position);
        this.desiredPosition.changeFrame(this.trajectoryGenerator.getReferenceFrame());
        trajectoryPoint.setPosition((FramePoint3DReadOnly)this.desiredPosition);
    }

    public void getDesiredPosition(FramePoint3D positionToPack) {
        if (this.trajectoryGenerator.isEmpty()) {
            positionToPack.setIncludingFrame(this.bodyFrame, (Tuple3DReadOnly)this.controlFramePose.getTranslation());
            positionToPack.changeFrame(this.trajectoryGenerator.getReferenceFrame());
        } else {
            positionToPack.setIncludingFrame((FrameTuple3DReadOnly)this.trajectoryGenerator.getPosition());
        }
    }

    public boolean doAction(double timeInTrajectory) {
        boolean done = false;
        if (this.trajectoryGenerator.isDone() || this.trajectoryGenerator.getLastWaypointTime() <= timeInTrajectory) {
            done = this.fillAndReinitializeTrajectories();
        }
        if (done) {
            this.streamTimestampOffset.setToNaN();
            this.streamTimestampSource.setToNaN();
        }
        this.trajectoryGenerator.compute(timeInTrajectory);
        this.trajectoryGenerator.getLinearData((FramePoint3DBasics)this.desiredPosition, (FrameVector3DBasics)this.desiredVelocity, (FrameVector3DBasics)this.feedForwardAcceleration);
        this.desiredPosition.changeFrame(ReferenceFrame.getWorldFrame());
        this.desiredVelocity.changeFrame(ReferenceFrame.getWorldFrame());
        this.feedForwardAcceleration.changeFrame(ReferenceFrame.getWorldFrame());
        this.feedbackControlCommand.setInverseDynamics((FramePoint3DReadOnly)this.desiredPosition, (FrameVector3DReadOnly)this.desiredVelocity, (FrameVector3DReadOnly)this.feedForwardAcceleration);
        this.feedbackControlCommand.setGains(this.gains);
        if (this.useBaseFrameForControl.getValue()) {
            this.feedbackControlCommand.setControlBaseFrame(this.trajectoryGenerator.getReferenceFrame());
        } else {
            this.feedbackControlCommand.resetControlBaseFrame();
        }
        this.defaultWeightMatrix.set((Tuple3DReadOnly)this.defaultWeight);
        this.defaultWeightMatrix.setWeightFrame(null);
        WeightMatrix3D weightMatrix = this.useWeightFromMessage.getValue() ? this.messageWeightMatrix : this.defaultWeightMatrix;
        this.currentWeight.set((Tuple3DReadOnly)weightMatrix);
        this.feedbackControlCommand.setWeightMatrix(weightMatrix);
        this.feedbackControlCommand.setSelectionMatrix(this.selectionMatrix);
        if (this.yoCurrentPosition != null && this.yoDesiredPosition != null) {
            this.currentPosition.setIncludingFrame(this.bodyFrame, (Tuple3DReadOnly)this.controlFramePose.getTranslation());
            this.yoCurrentPosition.setMatchingFrame((FrameTuple3DReadOnly)this.currentPosition);
            this.yoDesiredPosition.setMatchingFrame((FrameTuple3DReadOnly)this.desiredPosition);
        }
        return done;
    }

    private boolean fillAndReinitializeTrajectories() {
        if (this.pointQueue.isEmpty()) {
            return true;
        }
        if (!this.trajectoryGenerator.isEmpty()) {
            this.trajectoryGenerator.clear();
            this.lastPointAdded.changeFrame(this.trajectoryGenerator.getReferenceFrame());
            this.trajectoryGenerator.appendWaypoint(this.lastPointAdded);
        }
        int currentNumberOfWaypoints = this.trajectoryGenerator.getCurrentNumberOfWaypoints();
        int pointsToAdd = 5 - currentNumberOfWaypoints;
        for (int pointIdx = 0; pointIdx < pointsToAdd && !this.pointQueue.isEmpty(); ++pointIdx) {
            FrameEuclideanTrajectoryPoint pointToAdd = (FrameEuclideanTrajectoryPoint)this.pointQueue.pollFirst();
            this.lastPointAdded.setIncludingFrame((FrameEuclideanTrajectoryPointBasics)pointToAdd);
            this.trajectoryGenerator.appendWaypoint(pointToAdd);
        }
        this.trajectoryGenerator.initialize();
        return false;
    }

    public boolean handleTrajectoryCommand(EuclideanTrajectoryControllerCommand command, FrameQuaternionBasics currentDesiredOrientation) {
        int i;
        double streamTimeOffset = 0.0;
        double streamTimestampOffset = this.streamTimestampOffset.getValue();
        double streamTimestampSource = this.streamTimestampSource.getValue();
        if (command.getExecutionMode() == ExecutionMode.STREAM) {
            if (command.getTimestamp() <= 0L) {
                streamTimestampOffset = Double.NaN;
                streamTimestampSource = Double.NaN;
            } else {
                double senderTime = Conversions.nanosecondsToSeconds((long)command.getTimestamp());
                if (!Double.isNaN(streamTimestampSource) && senderTime < streamTimestampSource) {
                    return true;
                }
                streamTimestampSource = senderTime;
                streamTimeOffset = this.time.getValue() - senderTime;
                streamTimestampOffset = Double.isNaN(streamTimestampOffset) ? streamTimeOffset : (Math.abs(streamTimeOffset - streamTimestampOffset) > 0.5 ? streamTimeOffset : Math.min(streamTimeOffset, streamTimestampOffset));
            }
        }
        if (command.getExecutionMode() != ExecutionMode.QUEUE || this.isEmpty()) {
            this.getDesiredPosition(this.desiredPosition);
            this.previousControlFramePose.set(this.controlFramePose);
            this.clear();
            if (command.useCustomControlFrame()) {
                this.setControlFramePose(command.getControlFramePose());
            }
            RigidBodyPositionControlHelper.modifyControlFrame((FixedFramePoint3DBasics)this.desiredPosition, currentDesiredOrientation, this.previousControlFramePose, this.controlFramePose);
            this.trajectoryGenerator.changeFrame(command.getTrajectoryFrame());
            this.selectionMatrix.set(command.getSelectionMatrix());
            if (command.getTrajectoryPoint(0).getTime() > 0.05) {
                this.queueInitialPoint(this.desiredPosition);
            }
            this.messageWeightMatrix.set(command.getWeightMatrix());
            boolean messageHasValidWeights = true;
            for (i = 0; i < 3; ++i) {
                double weight = this.messageWeightMatrix.getElement(i);
                messageHasValidWeights = messageHasValidWeights && !Double.isNaN(weight) && !(weight < 0.0);
            }
            this.messageWeightValid = messageHasValidWeights;
        } else {
            if (command.getTrajectoryFrame() != this.trajectoryGenerator.getReferenceFrame()) {
                LogTools.warn((String)(this.warningPrefix + "Was executing in " + this.trajectoryGenerator.getReferenceFrame() + " can not switch to " + command.getTrajectoryFrame() + " without override."));
                return false;
            }
            if (!this.selectionMatrix.equals((Object)command.getSelectionMatrix())) {
                LogTools.warn((String)(this.warningPrefix + "Received a change of selection matrix without an override. Was\n" + this.selectionMatrix + "\nRequested\n" + command.getSelectionMatrix()));
                return false;
            }
        }
        FrameEuclideanTrajectoryPointList trajectoryPoints = command.getTrajectoryPointList();
        trajectoryPoints.changeFrame(this.trajectoryGenerator.getReferenceFrame());
        if (command.getExecutionMode() == ExecutionMode.STREAM) {
            FrameEuclideanTrajectoryPoint integratedPoint;
            this.streamTimestampOffset.set(streamTimestampOffset);
            this.streamTimestampSource.set(streamTimestampSource);
            if (trajectoryPoints.getNumberOfTrajectoryPoints() != 1) {
                LogTools.warn((String)("When streaming, trajectories should contain only 1 trajectory point, was: " + trajectoryPoints.getNumberOfTrajectoryPoints()));
                return false;
            }
            FrameEuclideanTrajectoryPoint trajectoryPoint = trajectoryPoints.getTrajectoryPoint(0);
            if (trajectoryPoint.getTime() != 0.0) {
                LogTools.warn((String)("When streaming, the trajectory point should have a time of zero, was: " + trajectoryPoint.getTime()));
                return false;
            }
            FrameEuclideanTrajectoryPoint initialPoint = this.addPoint();
            if (initialPoint == null) {
                return false;
            }
            initialPoint.setIncludingFrame((FrameEuclideanTrajectoryPointBasics)trajectoryPoint);
            if (!Double.isNaN(streamTimestampOffset)) {
                initialPoint.setTime(streamTimestampOffset - streamTimeOffset);
            }
            if ((integratedPoint = this.addPoint()) == null) {
                return false;
            }
            integratedPoint.setIncludingFrame((FrameEuclideanTrajectoryPointBasics)trajectoryPoint);
            this.integratedPosition.scaleAdd(command.getStreamIntegrationDuration(), (Tuple3DReadOnly)integratedPoint.getLinearVelocity(), (Tuple3DReadOnly)integratedPoint.getPosition());
            integratedPoint.setPosition((Point3DReadOnly)this.integratedPosition);
            integratedPoint.setTime(command.getStreamIntegrationDuration() + initialPoint.getTime());
        } else {
            for (i = 0; i < command.getNumberOfTrajectoryPoints(); ++i) {
                if (!this.checkTime(command.getTrajectoryPoint(i).getTime())) {
                    return false;
                }
                if (this.queuePoint(command.getTrajectoryPoint(i))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isMessageWeightValid() {
        return this.messageWeightValid;
    }

    public int getNumberOfPointsInQueue() {
        return this.pointQueue.size();
    }

    public int getNumberOfPointsInGenerator() {
        return this.trajectoryGenerator.getCurrentNumberOfWaypoints();
    }

    private void queueInitialPoint(FramePoint3D initialPosition) {
        initialPosition.changeFrame(this.trajectoryGenerator.getReferenceFrame());
        FrameEuclideanTrajectoryPoint initialPoint = (FrameEuclideanTrajectoryPoint)this.pointQueue.addLast();
        initialPoint.setToZero(this.trajectoryGenerator.getReferenceFrame());
        initialPoint.setTime(0.0);
        initialPoint.setPosition((FramePoint3DReadOnly)initialPosition);
    }

    private FrameEuclideanTrajectoryPoint addPoint() {
        if (this.pointQueue.size() >= 10000) {
            LogTools.warn((String)(this.warningPrefix + "Reached maximum capacity of " + 10000 + " can not execute trajectory."));
            return null;
        }
        return (FrameEuclideanTrajectoryPoint)this.pointQueue.addLast();
    }

    private boolean queuePoint(FrameEuclideanTrajectoryPoint trajectoryPoint) {
        FrameEuclideanTrajectoryPoint point = this.addPoint();
        if (point == null) {
            return false;
        }
        point.setIncludingFrame((FrameEuclideanTrajectoryPointBasics)trajectoryPoint);
        return true;
    }

    private boolean checkTime(double time) {
        if (time <= this.getLastTrajectoryPointTime()) {
            LogTools.warn((String)(this.warningPrefix + "Time in trajectory must be strictly increasing."));
            return false;
        }
        return true;
    }

    public PointFeedbackControlCommand getFeedbackControlCommand() {
        return this.feedbackControlCommand;
    }

    public void onExit() {
        this.clear();
    }

    public boolean isEmpty() {
        if (!this.pointQueue.isEmpty()) {
            return false;
        }
        return this.trajectoryGenerator.isDone();
    }

    public double getLastTrajectoryPointTime() {
        if (this.isEmpty()) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this.pointQueue.isEmpty()) {
            return this.trajectoryGenerator.getLastWaypointTime();
        }
        return ((FrameEuclideanTrajectoryPoint)this.pointQueue.peekLast()).getTime();
    }

    public void clear() {
        this.selectionMatrix.resetSelection();
        this.trajectoryGenerator.clear(this.baseFrame);
        this.setDefaultControlFrame();
        this.pointQueue.clear();
        this.streamTimestampOffset.setToNaN();
        this.streamTimestampSource.setToNaN();
    }

    public void disable() {
        this.clear();
        this.holdCurrent();
        this.selectionMatrix.clearSelection();
    }
}

