/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.rigidBody;

import controller_msgs.msg.dds.TaskspaceTrajectoryStatusMessage;
import us.ihmc.commonWalkingControlModules.controlModules.TaskspaceTrajectoryStatusMessageHelper;
import us.ihmc.commonWalkingControlModules.controlModules.rigidBody.RigidBodyControlMode;
import us.ihmc.commonWalkingControlModules.controlModules.rigidBody.RigidBodyJointControlHelper;
import us.ihmc.commonWalkingControlModules.controlModules.rigidBody.RigidBodyOrientationControlHelper;
import us.ihmc.commonWalkingControlModules.controlModules.rigidBody.RigidBodyPositionControlHelper;
import us.ihmc.commonWalkingControlModules.controlModules.rigidBody.RigidBodyTaskspaceControlState;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommandList;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.OrientationFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.PointFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.SpatialFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.SpatialAccelerationCommand;
import us.ihmc.communication.controllerAPI.command.Command;
import us.ihmc.communication.packets.ExecutionMode;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.EuclideanTrajectoryControllerCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.JointspaceTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.SE3TrajectoryControllerCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.SO3TrajectoryControllerCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.converter.CommandConversionTools;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.robotics.controllers.pidGains.PID3DGainsReadOnly;
import us.ihmc.yoVariables.parameters.BooleanParameter;
import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class RigidBodyPoseController
extends RigidBodyTaskspaceControlState {
    private final SpatialFeedbackControlCommand feedbackControlCommand = new SpatialFeedbackControlCommand();
    private final FeedbackControlCommandList feedbackControlCommandList = new FeedbackControlCommandList();
    private final YoBoolean usingWeightFromMessage;
    private final YoInteger numberOfPointsInQueue;
    private final YoInteger numberOfPointsInGenerator;
    private final YoInteger numberOfPoints;
    private final SO3TrajectoryControllerCommand so3Command = new SO3TrajectoryControllerCommand();
    private final EuclideanTrajectoryControllerCommand euclideanCommand = new EuclideanTrajectoryControllerCommand();
    private final FrameQuaternion desiredOrientation = new FrameQuaternion();
    private final RigidBodyPositionControlHelper positionHelper;
    private final RigidBodyOrientationControlHelper orienationHelper;
    private final YoBoolean hybridModeActive;
    private final RigidBodyJointControlHelper jointControlHelper;
    private final TaskspaceTrajectoryStatusMessageHelper statusHelper;

    public RigidBodyPoseController(RigidBodyBasics bodyToControl, RigidBodyBasics baseBody, RigidBodyBasics elevator, ReferenceFrame controlFrame, ReferenceFrame baseFrame, YoDouble yoTime, RigidBodyJointControlHelper jointControlHelper, YoGraphicsListRegistry graphicsListRegistry, YoRegistry parentRegistry) {
        super(RigidBodyControlMode.TASKSPACE, bodyToControl.getName(), yoTime, parentRegistry);
        String bodyName = bodyToControl.getName();
        String prefix = bodyName + "Taskspace";
        this.numberOfPointsInQueue = new YoInteger(prefix + "NumberOfPointsInQueue", this.registry);
        this.numberOfPointsInGenerator = new YoInteger(prefix + "NumberOfPointsInGenerator", this.registry);
        this.numberOfPoints = new YoInteger(prefix + "NumberOfPoints", this.registry);
        this.usingWeightFromMessage = new YoBoolean(prefix + "UsingWeightFromMessage", this.registry);
        BooleanParameter useBaseFrameForControl = new BooleanParameter(prefix + "UseBaseFrameForControl", this.registry, false);
        this.positionHelper = new RigidBodyPositionControlHelper(this.warningPrefix, bodyToControl, baseBody, elevator, controlFrame, baseFrame, (BooleanProvider)useBaseFrameForControl, (BooleanProvider)this.usingWeightFromMessage, (DoubleProvider)yoTime, this.registry, graphicsListRegistry);
        this.orienationHelper = new RigidBodyOrientationControlHelper(this.warningPrefix, bodyToControl, baseBody, elevator, controlFrame, baseFrame, (BooleanProvider)useBaseFrameForControl, (BooleanProvider)this.usingWeightFromMessage, (DoubleProvider)yoTime, this.registry);
        this.jointControlHelper = jointControlHelper;
        this.hybridModeActive = new YoBoolean(prefix + "HybridModeActive", this.registry);
        this.statusHelper = new TaskspaceTrajectoryStatusMessageHelper((RigidBodyReadOnly)bodyToControl);
        this.feedbackControlCommand.set(elevator, bodyToControl);
        this.feedbackControlCommand.setPrimaryBase(baseBody);
        this.feedbackControlCommand.setSelectionMatrixToIdentity();
    }

    public void setWeights(Vector3DReadOnly angularWeight, Vector3DReadOnly linearWeight) {
        this.positionHelper.setWeights(linearWeight);
        this.orienationHelper.setWeights(angularWeight);
    }

    public void setGains(PID3DGainsReadOnly orientationGains, PID3DGainsReadOnly positionGains) {
        this.positionHelper.setGains(positionGains);
        this.orienationHelper.setGains(orientationGains);
    }

    public void doAction(double timeInState) {
        double timeInTrajectory = this.getTimeInTrajectory();
        boolean positionDone = this.positionHelper.doAction(timeInTrajectory);
        boolean orientationDone = this.orienationHelper.doAction(timeInTrajectory);
        this.trajectoryDone.set(positionDone && orientationDone);
        this.updateCommand();
        this.numberOfPointsInQueue.set(this.positionHelper.getNumberOfPointsInQueue());
        this.numberOfPointsInGenerator.set(this.positionHelper.getNumberOfPointsInGenerator());
        this.numberOfPoints.set(this.numberOfPointsInQueue.getIntegerValue() + this.numberOfPointsInGenerator.getIntegerValue());
        if (this.hybridModeActive.getBooleanValue()) {
            this.jointControlHelper.doAction(timeInTrajectory);
        }
        this.statusHelper.updateWithTimeInTrajectory(timeInTrajectory);
        this.updateGraphics();
    }

    private void updateCommand() {
        PointFeedbackControlCommand positionCommand = this.positionHelper.getFeedbackControlCommand();
        OrientationFeedbackControlCommand orientationCommand = this.orienationHelper.getFeedbackControlCommand();
        SpatialAccelerationCommand accelerationCommand = this.feedbackControlCommand.getSpatialAccelerationCommand();
        accelerationCommand.getWeightMatrix().setLinearPart(positionCommand.getSpatialAccelerationCommand().getWeightMatrix().getLinearPart());
        accelerationCommand.getWeightMatrix().setAngularPart(orientationCommand.getSpatialAccelerationCommand().getWeightMatrix().getAngularPart());
        accelerationCommand.getSelectionMatrix().setLinearPart(positionCommand.getSpatialAccelerationCommand().getSelectionMatrix().getLinearPart());
        accelerationCommand.getSelectionMatrix().setAngularPart(orientationCommand.getSpatialAccelerationCommand().getSelectionMatrix().getAngularPart());
        this.feedbackControlCommand.getGains().setPositionGains((PID3DGainsReadOnly)positionCommand.getGains());
        this.feedbackControlCommand.getGains().setOrientationGains((PID3DGainsReadOnly)orientationCommand.getGains());
        this.feedbackControlCommand.setGainsFrames(orientationCommand.getAngularGainsFrame(), positionCommand.getLinearGainsFrame());
        this.feedbackControlCommand.setInverseDynamics((FramePoint3DReadOnly)positionCommand.getReferencePosition(), (FrameVector3DReadOnly)positionCommand.getReferenceLinearVelocity(), (FrameVector3DReadOnly)positionCommand.getReferenceLinearAcceleration());
        this.feedbackControlCommand.setInverseDynamics((FrameQuaternionReadOnly)orientationCommand.getReferenceOrientation(), (FrameVector3DReadOnly)orientationCommand.getReferenceAngularVelocity(), (FrameVector3DReadOnly)orientationCommand.getReferenceAngularAcceleration());
        this.feedbackControlCommand.setControlFrameFixedInEndEffector((FramePoint3DReadOnly)positionCommand.getBodyFixedPointToControl(), (FrameQuaternionReadOnly)orientationCommand.getBodyFixedOrientationToControl());
        this.feedbackControlCommand.setControlBaseFrame(positionCommand.getControlBaseFrame());
    }

    public void onEntry() {
    }

    public void onExit() {
        this.positionHelper.onExit();
        this.orienationHelper.onExit();
        this.hybridModeActive.set(false);
        this.hideGraphics();
        this.clear();
    }

    @Override
    public void holdCurrent() {
        this.clear();
        this.setTrajectoryStartTimeToCurrentTime();
        this.positionHelper.holdCurrent();
        this.orienationHelper.holdCurrent();
        this.hybridModeActive.set(false);
    }

    @Override
    public void holdCurrentDesired() {
        this.clear();
        this.setTrajectoryStartTimeToCurrentTime();
        this.orienationHelper.getDesiredOrientation(this.desiredOrientation);
        this.positionHelper.holdCurrentDesired((FrameQuaternionBasics)this.desiredOrientation);
        this.orienationHelper.holdCurrentDesired();
        this.hybridModeActive.set(false);
    }

    @Override
    public void goToPoseFromCurrent(FramePose3DReadOnly pose, double trajectoryTime) {
        this.clear();
        this.setTrajectoryStartTimeToCurrentTime();
        this.positionHelper.goToPositionFromCurrent(pose.getPosition(), trajectoryTime);
        this.orienationHelper.goToOrientationFromCurrent(pose.getOrientation(), trajectoryTime);
        this.hybridModeActive.set(false);
    }

    @Override
    public void goToPose(FramePose3DReadOnly pose, double trajectoryTime) {
        this.clear();
        this.setTrajectoryStartTimeToCurrentTime();
        this.orienationHelper.getDesiredOrientation(this.desiredOrientation);
        this.positionHelper.goToPosition(pose.getPosition(), (FrameQuaternionBasics)this.desiredOrientation, trajectoryTime);
        this.orienationHelper.goToOrientation(pose.getOrientation(), trajectoryTime);
        this.hybridModeActive.set(false);
    }

    @Override
    public boolean handleTrajectoryCommand(SO3TrajectoryControllerCommand command) {
        this.positionHelper.disable();
        if (this.handleCommandInternal((Command<?, ?>)command) && this.orienationHelper.handleTrajectoryCommand(command)) {
            this.usingWeightFromMessage.set(this.orienationHelper.isMessageWeightValid());
            this.hybridModeActive.set(false);
            if (command.getExecutionMode() != ExecutionMode.STREAM) {
                this.statusHelper.registerNewTrajectory(command);
            }
            return true;
        }
        this.clear();
        this.positionHelper.clear();
        this.orienationHelper.clear();
        return false;
    }

    @Override
    public boolean handleTrajectoryCommand(SE3TrajectoryControllerCommand command) {
        if (!this.handleCommandInternal((Command<?, ?>)command)) {
            this.clear();
            this.positionHelper.clear();
            this.orienationHelper.clear();
            return false;
        }
        CommandConversionTools.convertToEuclidean((SE3TrajectoryControllerCommand)command, (EuclideanTrajectoryControllerCommand)this.euclideanCommand);
        CommandConversionTools.convertToSO3((SE3TrajectoryControllerCommand)command, (SO3TrajectoryControllerCommand)this.so3Command);
        this.orienationHelper.getDesiredOrientation(this.desiredOrientation);
        if (this.positionHelper.handleTrajectoryCommand(this.euclideanCommand, (FrameQuaternionBasics)this.desiredOrientation) && this.orienationHelper.handleTrajectoryCommand(this.so3Command)) {
            this.usingWeightFromMessage.set(this.positionHelper.isMessageWeightValid() && this.orienationHelper.isMessageWeightValid());
            this.hybridModeActive.set(false);
            if (command.getExecutionMode() != ExecutionMode.STREAM) {
                this.statusHelper.registerNewTrajectory(command);
            }
            return true;
        }
        this.clear();
        this.positionHelper.clear();
        this.orienationHelper.clear();
        return false;
    }

    @Override
    public boolean handleHybridTrajectoryCommand(SE3TrajectoryControllerCommand command, JointspaceTrajectoryCommand jointspaceCommand, double[] initialJointPositions) {
        if (this.handleTrajectoryCommand(command) && this.jointControlHelper.handleTrajectoryCommand(jointspaceCommand, initialJointPositions)) {
            this.hybridModeActive.set(true);
            this.statusHelper.registerNewTrajectory(command);
            return true;
        }
        this.clear();
        this.positionHelper.clear();
        this.orienationHelper.clear();
        return false;
    }

    @Override
    public FeedbackControlCommand<?> getFeedbackControlCommand() {
        if (this.hybridModeActive.getBooleanValue()) {
            this.feedbackControlCommandList.clear();
            this.feedbackControlCommandList.addCommand(this.feedbackControlCommand);
            this.feedbackControlCommandList.addCommand(this.jointControlHelper.getJointspaceCommand());
            return this.feedbackControlCommandList;
        }
        return this.feedbackControlCommand;
    }

    @Override
    public FeedbackControlCommand<?> createFeedbackControlTemplate() {
        this.feedbackControlCommandList.clear();
        this.feedbackControlCommandList.addCommand(this.feedbackControlCommand);
        if (this.jointControlHelper != null) {
            this.feedbackControlCommandList.addCommand(this.jointControlHelper.getJointspaceCommand());
        }
        return this.feedbackControlCommandList;
    }

    @Override
    public double getLastTrajectoryPointTime() {
        return this.positionHelper.getLastTrajectoryPointTime();
    }

    @Override
    public boolean isEmpty() {
        return this.positionHelper.isEmpty();
    }

    private void clear() {
        this.numberOfPointsInQueue.set(0);
        this.numberOfPointsInGenerator.set(0);
        this.numberOfPoints.set(0);
        this.hybridModeActive.set(false);
        this.usingWeightFromMessage.set(false);
        this.trajectoryDone.set(true);
        this.resetLastCommandId();
    }

    public TaskspaceTrajectoryStatusMessage pollStatusToReport() {
        return this.statusHelper.pollStatusMessage(this.feedbackControlCommand);
    }
}

