/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.rigidBody;

import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.OrientationFeedbackControlCommand;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.lists.RecyclingArrayDeque;
import us.ihmc.communication.packets.ExecutionMode;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameQuaternionBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.SO3TrajectoryControllerCommand;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotics.controllers.pidGains.PID3DGainsReadOnly;
import us.ihmc.robotics.math.trajectories.generators.MultipleWaypointsOrientationTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.trajectorypoints.FrameSO3TrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FrameSO3TrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.lists.FrameSO3TrajectoryPointList;
import us.ihmc.robotics.screwTheory.SelectionMatrix3D;
import us.ihmc.robotics.weightMatrices.WeightMatrix3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class RigidBodyOrientationControlHelper {
    private final OrientationFeedbackControlCommand feedbackControlCommand = new OrientationFeedbackControlCommand();
    private final MultipleWaypointsOrientationTrajectoryGenerator trajectoryGenerator;
    private final FrameSO3TrajectoryPoint lastPointAdded = new FrameSO3TrajectoryPoint();
    private final RecyclingArrayDeque<FrameSO3TrajectoryPoint> pointQueue = new RecyclingArrayDeque(10000, FrameSO3TrajectoryPoint.class, FrameSO3TrajectoryPointBasics::set);
    private final YoDouble streamTimestampOffset;
    private final YoDouble streamTimestampSource;
    private boolean messageWeightValid = false;
    private final BooleanProvider useWeightFromMessage;
    private final WeightMatrix3D defaultWeightMatrix = new WeightMatrix3D();
    private final WeightMatrix3D messageWeightMatrix = new WeightMatrix3D();
    private final YoFrameVector3D currentWeight;
    private final SelectionMatrix3D selectionMatrix = new SelectionMatrix3D();
    private Vector3DReadOnly defaultWeight;
    private PID3DGainsReadOnly gains;
    private final FrameQuaternion desiredOrientation = new FrameQuaternion();
    private final FrameVector3D desiredVelocity = new FrameVector3D();
    private final FrameVector3D feedForwardAcceleration = new FrameVector3D();
    private final BooleanProvider useBaseFrameForControl;
    private final FixedFrameQuaternionBasics previousControlFrameOrientation;
    private final FixedFrameQuaternionBasics controlFrameOrientation;
    private final ReferenceFrame defaultControlFrame;
    private final Quaternion integratedOrientation = new Quaternion();
    private final Vector3D integratedRotationVector = new Vector3D();
    private final ReferenceFrame baseFrame;
    private final ReferenceFrame bodyFrame;
    private final String warningPrefix;
    private final DoubleProvider time;

    public RigidBodyOrientationControlHelper(String warningPrefix, RigidBodyBasics bodyToControl, RigidBodyBasics baseBody, RigidBodyBasics elevator, ReferenceFrame controlFrame, ReferenceFrame baseFrame, BooleanProvider useBaseFrameForControl, BooleanProvider useWeightFromMessage, DoubleProvider time, YoRegistry registry) {
        this.warningPrefix = warningPrefix;
        this.useBaseFrameForControl = useBaseFrameForControl;
        this.useWeightFromMessage = useWeightFromMessage;
        this.baseFrame = baseFrame;
        this.time = time;
        String bodyName = bodyToControl.getName();
        String prefix = bodyName + "TaskspaceOrientation";
        this.trajectoryGenerator = new MultipleWaypointsOrientationTrajectoryGenerator(bodyName, 5, ReferenceFrame.getWorldFrame(), registry);
        this.trajectoryGenerator.clear(baseFrame);
        this.currentWeight = new YoFrameVector3D(prefix + "CurrentWeight", null, registry);
        this.feedbackControlCommand.set(elevator, bodyToControl);
        this.feedbackControlCommand.setPrimaryBase(baseBody);
        this.defaultControlFrame = controlFrame;
        this.bodyFrame = bodyToControl.getBodyFixedFrame();
        this.controlFrameOrientation = new FrameQuaternion(this.bodyFrame);
        this.previousControlFrameOrientation = new FrameQuaternion(this.bodyFrame);
        this.setDefaultControlFrame();
        this.streamTimestampOffset = new YoDouble(prefix + "StreamTimestampOffset", registry);
        this.streamTimestampOffset.setToNaN();
        this.streamTimestampSource = new YoDouble(prefix + "StreamTimestampSource", registry);
        this.streamTimestampSource.setToNaN();
    }

    public void setGains(PID3DGainsReadOnly gains) {
        this.gains = gains;
    }

    public void setWeights(Vector3DReadOnly weights) {
        this.defaultWeight = weights;
    }

    private void setDefaultControlFrame() {
        this.controlFrameOrientation.setFromReferenceFrame(this.defaultControlFrame);
        this.feedbackControlCommand.setBodyFixedOrientationToControl((FrameQuaternionReadOnly)this.controlFrameOrientation);
    }

    private void setControlFrameOrientation(Orientation3DReadOnly controlFrameOrientationInBodyFrame) {
        this.controlFrameOrientation.set(controlFrameOrientationInBodyFrame);
        this.feedbackControlCommand.setBodyFixedOrientationToControl((FrameQuaternionReadOnly)this.controlFrameOrientation);
    }

    public static void modifyControlFrame(FrameQuaternionBasics desiredOrientationToModify, QuaternionReadOnly previousControlFrameOrientation, QuaternionReadOnly newControlFrameOrientation) {
        desiredOrientationToModify.multiplyConjugateOther(previousControlFrameOrientation);
        desiredOrientationToModify.multiply(newControlFrameOrientation);
    }

    public void holdCurrent() {
        this.clear();
        this.desiredOrientation.setIncludingFrame((FrameQuaternionReadOnly)this.controlFrameOrientation);
        this.queueInitialPoint(this.desiredOrientation);
    }

    public void holdCurrentDesired() {
        this.getDesiredOrientation(this.desiredOrientation);
        this.previousControlFrameOrientation.set((FrameQuaternionReadOnly)this.controlFrameOrientation);
        this.clear();
        RigidBodyOrientationControlHelper.modifyControlFrame((FrameQuaternionBasics)this.desiredOrientation, (QuaternionReadOnly)this.previousControlFrameOrientation, (QuaternionReadOnly)this.controlFrameOrientation);
        this.queueInitialPoint(this.desiredOrientation);
    }

    public void goToOrientationFromCurrent(FrameQuaternionReadOnly orientation, double trajectoryTime) {
        this.holdCurrent();
        FrameSO3TrajectoryPoint trajectoryPoint = (FrameSO3TrajectoryPoint)this.pointQueue.addLast();
        trajectoryPoint.setToZero(this.trajectoryGenerator.getReferenceFrame());
        trajectoryPoint.setTime(trajectoryTime);
        this.desiredOrientation.setIncludingFrame(orientation);
        this.desiredOrientation.changeFrame(this.trajectoryGenerator.getReferenceFrame());
        trajectoryPoint.setOrientation((FrameQuaternionReadOnly)this.desiredOrientation);
    }

    public void goToOrientation(FrameQuaternionReadOnly orientation, double trajectoryTime) {
        this.holdCurrentDesired();
        FrameSO3TrajectoryPoint trajectoryPoint = (FrameSO3TrajectoryPoint)this.pointQueue.addLast();
        trajectoryPoint.setToZero(this.trajectoryGenerator.getReferenceFrame());
        trajectoryPoint.setTime(trajectoryTime);
        this.desiredOrientation.setIncludingFrame(orientation);
        this.desiredOrientation.changeFrame(this.trajectoryGenerator.getReferenceFrame());
        trajectoryPoint.setOrientation((FrameQuaternionReadOnly)this.desiredOrientation);
    }

    public void getDesiredOrientation(FrameQuaternion orientationToPack) {
        if (this.trajectoryGenerator.isEmpty()) {
            orientationToPack.setIncludingFrame((FrameQuaternionReadOnly)this.controlFrameOrientation);
            orientationToPack.changeFrame(this.trajectoryGenerator.getReferenceFrame());
        } else {
            orientationToPack.setIncludingFrame(this.trajectoryGenerator.getOrientation());
        }
    }

    public boolean doAction(double timeInTrajectory) {
        boolean done = false;
        if (this.trajectoryGenerator.isDone() || this.trajectoryGenerator.getLastWaypointTime() <= timeInTrajectory) {
            done = this.fillAndReinitializeTrajectories();
        }
        if (done) {
            this.streamTimestampOffset.setToNaN();
            this.streamTimestampSource.setToNaN();
        }
        this.trajectoryGenerator.compute(timeInTrajectory);
        this.trajectoryGenerator.getAngularData((FrameOrientation3DBasics)this.desiredOrientation, (FrameVector3DBasics)this.desiredVelocity, (FrameVector3DBasics)this.feedForwardAcceleration);
        this.desiredOrientation.changeFrame(ReferenceFrame.getWorldFrame());
        this.desiredVelocity.changeFrame(ReferenceFrame.getWorldFrame());
        this.feedForwardAcceleration.changeFrame(ReferenceFrame.getWorldFrame());
        this.feedbackControlCommand.setInverseDynamics((FrameQuaternionReadOnly)this.desiredOrientation, (FrameVector3DReadOnly)this.desiredVelocity, (FrameVector3DReadOnly)this.feedForwardAcceleration);
        this.feedbackControlCommand.setGains(this.gains);
        if (this.useBaseFrameForControl.getValue()) {
            this.feedbackControlCommand.setControlBaseFrame(this.trajectoryGenerator.getReferenceFrame());
        } else {
            this.feedbackControlCommand.resetControlBaseFrame();
        }
        this.defaultWeightMatrix.set((Tuple3DReadOnly)this.defaultWeight);
        this.defaultWeightMatrix.setWeightFrame(null);
        WeightMatrix3D weightMatrix = this.useWeightFromMessage.getValue() ? this.messageWeightMatrix : this.defaultWeightMatrix;
        this.currentWeight.set((Tuple3DReadOnly)weightMatrix);
        this.feedbackControlCommand.setWeightMatrix(weightMatrix);
        this.feedbackControlCommand.setSelectionMatrix(this.selectionMatrix);
        return done;
    }

    private boolean fillAndReinitializeTrajectories() {
        if (this.pointQueue.isEmpty()) {
            return true;
        }
        if (!this.trajectoryGenerator.isEmpty()) {
            this.trajectoryGenerator.clear();
            this.lastPointAdded.changeFrame(this.trajectoryGenerator.getReferenceFrame());
            this.trajectoryGenerator.appendWaypoint(this.lastPointAdded);
        }
        int currentNumberOfWaypoints = this.trajectoryGenerator.getCurrentNumberOfWaypoints();
        int pointsToAdd = 5 - currentNumberOfWaypoints;
        for (int pointIdx = 0; pointIdx < pointsToAdd && !this.pointQueue.isEmpty(); ++pointIdx) {
            FrameSO3TrajectoryPoint pointToAdd = (FrameSO3TrajectoryPoint)this.pointQueue.pollFirst();
            this.lastPointAdded.setIncludingFrame((FrameSO3TrajectoryPointBasics)pointToAdd);
            this.trajectoryGenerator.appendWaypoint(pointToAdd);
        }
        this.trajectoryGenerator.initialize();
        return false;
    }

    public boolean handleTrajectoryCommand(SO3TrajectoryControllerCommand command) {
        int i;
        double streamTimeOffset = 0.0;
        double streamTimestampOffset = this.streamTimestampOffset.getValue();
        double streamTimestampSource = this.streamTimestampSource.getValue();
        if (command.getExecutionMode() == ExecutionMode.STREAM) {
            if (command.getTimestamp() <= 0L) {
                streamTimestampOffset = Double.NaN;
                streamTimestampSource = Double.NaN;
            } else {
                double senderTime = Conversions.nanosecondsToSeconds((long)command.getTimestamp());
                if (!Double.isNaN(streamTimestampSource) && senderTime < streamTimestampSource) {
                    return true;
                }
                streamTimestampSource = senderTime;
                streamTimeOffset = this.time.getValue() - senderTime;
                streamTimestampOffset = Double.isNaN(streamTimestampOffset) ? streamTimeOffset : (Math.abs(streamTimeOffset - streamTimestampOffset) > 0.5 ? streamTimeOffset : Math.min(streamTimeOffset, streamTimestampOffset));
            }
        }
        if (command.getExecutionMode() != ExecutionMode.QUEUE || this.isEmpty()) {
            this.getDesiredOrientation(this.desiredOrientation);
            this.previousControlFrameOrientation.set((FrameQuaternionReadOnly)this.controlFrameOrientation);
            this.clear();
            if (command.useCustomControlFrame()) {
                this.setControlFrameOrientation((Orientation3DReadOnly)command.getControlFramePose().getRotation());
            }
            RigidBodyOrientationControlHelper.modifyControlFrame((FrameQuaternionBasics)this.desiredOrientation, (QuaternionReadOnly)this.previousControlFrameOrientation, (QuaternionReadOnly)this.controlFrameOrientation);
            this.trajectoryGenerator.changeFrame(command.getTrajectoryFrame());
            this.selectionMatrix.set(command.getSelectionMatrix());
            if (command.getTrajectoryPoint(0).getTime() > 0.05) {
                this.queueInitialPoint(this.desiredOrientation);
            }
            this.messageWeightMatrix.set(command.getWeightMatrix());
            boolean messageHasValidWeights = true;
            for (i = 0; i < 3; ++i) {
                double weight = this.messageWeightMatrix.getElement(i);
                messageHasValidWeights = messageHasValidWeights && !Double.isNaN(weight) && !(weight < 0.0);
            }
            this.messageWeightValid = messageHasValidWeights;
        } else {
            if (command.getTrajectoryFrame() != this.trajectoryGenerator.getReferenceFrame()) {
                LogTools.warn((String)(this.warningPrefix + "Was executing in " + this.trajectoryGenerator.getReferenceFrame() + " can not switch to " + command.getTrajectoryFrame() + " without override."));
                return false;
            }
            if (!this.selectionMatrix.equals((Object)command.getSelectionMatrix())) {
                LogTools.warn((String)(this.warningPrefix + "Received a change of selection matrix without an override. Was\n" + this.selectionMatrix + "\nRequested\n" + command.getSelectionMatrix()));
                return false;
            }
        }
        FrameSO3TrajectoryPointList trajectoryPoints = command.getTrajectoryPointList();
        trajectoryPoints.changeFrame(this.trajectoryGenerator.getReferenceFrame());
        if (command.getExecutionMode() == ExecutionMode.STREAM) {
            FrameSO3TrajectoryPoint integratedPoint;
            this.streamTimestampOffset.set(streamTimestampOffset);
            this.streamTimestampSource.set(streamTimestampSource);
            if (trajectoryPoints.getNumberOfTrajectoryPoints() != 1) {
                LogTools.warn((String)("When streaming, trajectories should contain only 1 trajectory point, was: " + trajectoryPoints.getNumberOfTrajectoryPoints()));
                return false;
            }
            FrameSO3TrajectoryPoint trajectoryPoint = trajectoryPoints.getTrajectoryPoint(0);
            if (trajectoryPoint.getTime() != 0.0) {
                LogTools.warn((String)("When streaming, the trajectory point should have a time of zero, was: " + trajectoryPoint.getTime()));
                return false;
            }
            FrameSO3TrajectoryPoint initialPoint = this.addPoint();
            if (initialPoint == null) {
                return false;
            }
            initialPoint.setIncludingFrame((FrameSO3TrajectoryPointBasics)trajectoryPoint);
            if (!Double.isNaN(streamTimestampOffset)) {
                initialPoint.setTime(streamTimestampOffset - streamTimeOffset);
            }
            if ((integratedPoint = this.addPoint()) == null) {
                return false;
            }
            integratedPoint.setIncludingFrame((FrameSO3TrajectoryPointBasics)initialPoint);
            this.integratedRotationVector.setAndScale(command.getStreamIntegrationDuration(), (Tuple3DReadOnly)integratedPoint.getAngularVelocity());
            this.integratedOrientation.setRotationVector((Vector3DReadOnly)this.integratedRotationVector);
            this.integratedOrientation.append((Orientation3DReadOnly)integratedPoint.getOrientation());
            integratedPoint.setOrientation((QuaternionReadOnly)this.integratedOrientation);
            integratedPoint.setTime(command.getStreamIntegrationDuration() + initialPoint.getTime());
        } else {
            for (i = 0; i < command.getNumberOfTrajectoryPoints(); ++i) {
                if (!this.checkTime(command.getTrajectoryPoint(i).getTime())) {
                    return false;
                }
                if (this.queuePoint(command.getTrajectoryPoint(i))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isMessageWeightValid() {
        return this.messageWeightValid;
    }

    public int getNumberOfPointsInQueue() {
        return this.pointQueue.size();
    }

    public int getNumberOfPointsInGenerator() {
        return this.trajectoryGenerator.getCurrentNumberOfWaypoints();
    }

    private void queueInitialPoint(FrameQuaternion initialOrientation) {
        initialOrientation.changeFrame(this.trajectoryGenerator.getReferenceFrame());
        FrameSO3TrajectoryPoint initialPoint = (FrameSO3TrajectoryPoint)this.pointQueue.addLast();
        initialPoint.setToZero(this.trajectoryGenerator.getReferenceFrame());
        initialPoint.setTime(0.0);
        initialPoint.setOrientation((FrameQuaternionReadOnly)initialOrientation);
    }

    private FrameSO3TrajectoryPoint addPoint() {
        if (this.pointQueue.size() >= 10000) {
            LogTools.warn((String)(this.warningPrefix + "Reached maximum capacity of " + 10000 + " can not execute trajectory."));
            return null;
        }
        return (FrameSO3TrajectoryPoint)this.pointQueue.addLast();
    }

    private boolean queuePoint(FrameSO3TrajectoryPoint trajectoryPoint) {
        FrameSO3TrajectoryPoint point = this.addPoint();
        if (point == null) {
            return false;
        }
        point.setIncludingFrame((FrameSO3TrajectoryPointBasics)trajectoryPoint);
        return true;
    }

    private boolean checkTime(double time) {
        if (time <= this.getLastTrajectoryPointTime()) {
            LogTools.warn((String)(this.warningPrefix + "Time in trajectory must be strictly increasing."));
            return false;
        }
        return true;
    }

    public OrientationFeedbackControlCommand getFeedbackControlCommand() {
        return this.feedbackControlCommand;
    }

    public void onExit() {
        this.clear();
    }

    public boolean isEmpty() {
        if (!this.pointQueue.isEmpty()) {
            return false;
        }
        return this.trajectoryGenerator.isDone();
    }

    public double getLastTrajectoryPointTime() {
        if (this.isEmpty()) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this.pointQueue.isEmpty()) {
            return this.trajectoryGenerator.getLastWaypointTime();
        }
        return ((FrameSO3TrajectoryPoint)this.pointQueue.peekLast()).getTime();
    }

    public void clear() {
        this.selectionMatrix.resetSelection();
        this.trajectoryGenerator.clear(this.baseFrame);
        this.setDefaultControlFrame();
        this.pointQueue.clear();
        this.streamTimestampOffset.setToNaN();
        this.streamTimestampSource.setToNaN();
    }

    public void disable() {
        this.clear();
        this.holdCurrentDesired();
        this.selectionMatrix.clearSelection();
    }
}

