/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.rigidBody;

import us.ihmc.commonWalkingControlModules.controlModules.rigidBody.RigidBodyControlMode;
import us.ihmc.commonWalkingControlModules.controlModules.rigidBody.RigidBodyControlState;
import us.ihmc.commonWalkingControlModules.controlModules.rigidBody.RigidBodyJointControlHelper;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommandList;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.SpatialFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommandList;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.PlaneContactStateCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.SpatialAccelerationCommand;
import us.ihmc.communication.controllerAPI.command.Command;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicVector;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.JointspaceTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.LoadBearingCommand;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.controllers.pidGains.PID3DGainsReadOnly;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.robotics.screwTheory.SelectionMatrix6D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class RigidBodyLoadBearingControlState
extends RigidBodyControlState {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final long NO_CONTACT_ID = 0L;
    private static final long IN_CONTACT_ID = 1L;
    private static final int dofs = 6;
    private static final FrameVector3D zeroInWorld = new FrameVector3D(worldFrame, 0.0, 0.0, 0.0);
    private final InverseDynamicsCommandList inverseDynamicsCommandList = new InverseDynamicsCommandList();
    private final FeedbackControlCommandList feedbackControlCommandList = new FeedbackControlCommandList();
    private final SpatialAccelerationCommand spatialAccelerationCommand = new SpatialAccelerationCommand();
    private final SpatialFeedbackControlCommand spatialFeedbackControlCommand = new SpatialFeedbackControlCommand();
    private final PlaneContactStateCommand planeContactStateCommand = new PlaneContactStateCommand();
    private final SelectionMatrix6D accelerationSelectionMatrix = new SelectionMatrix6D();
    private final SelectionMatrix6D feedbackSelectionMatrix = new SelectionMatrix6D();
    private final boolean[] isDirectionFeedbackControlled = new boolean[6];
    private final FramePose3D bodyFixedControlledPose = new FramePose3D();
    private final SpatialAcceleration bodyAcceleration;
    private final FramePoint3D previousContactPoint = new FramePoint3D();
    private final FrameVector3D previousContactNormal = new FrameVector3D();
    private double previousCoefficientOfFriction;
    private final YoFramePoint3D contactPoint;
    private final YoFramePoint3D contactPointInWorld;
    private final ReferenceFrame bodyFrame;
    private final ReferenceFrame elevatorFrame;
    private final PoseReferenceFrame desiredContactFrame;
    private final ContactablePlaneBody contactableBody;
    private final YoDouble coefficientOfFriction;
    private final YoFrameVector3D contactNormal;
    private final ReferenceFrame contactFrame;
    private final RigidBodyTransform bodyToJointTransform = new RigidBodyTransform();
    private final RigidBodyTransform contactToJointTransform = new RigidBodyTransform();
    private final FramePoint3D desiredContactPosition = new FramePoint3D(worldFrame);
    private final FrameQuaternion desiredContactOrientation = new FrameQuaternion(worldFrame);
    private final FramePoint3D currentContactPosition = new FramePoint3D(worldFrame);
    private final FrameQuaternion currentContactOrientation = new FrameQuaternion(worldFrame);
    private final YoBoolean hybridModeActive;
    private final RigidBodyJointControlHelper jointControlHelper;
    private PID3DGainsReadOnly taskspaceOrientationGains;
    private PID3DGainsReadOnly taskspacePositionGains;
    private Vector3DReadOnly taskspaceAngularWeight;
    private Vector3DReadOnly taskspaceLinearWeight;

    public RigidBodyLoadBearingControlState(RigidBodyBasics bodyToControl, ContactablePlaneBody contactableBody, RigidBodyBasics elevator, YoDouble yoTime, RigidBodyJointControlHelper jointControlHelper, YoGraphicsListRegistry graphicsListRegistry, YoRegistry parentRegistry) {
        super(RigidBodyControlMode.LOADBEARING, bodyToControl.getName(), yoTime, parentRegistry);
        this.bodyFrame = bodyToControl.getBodyFixedFrame();
        this.elevatorFrame = elevator.getBodyFixedFrame();
        this.contactFrame = contactableBody.getSoleFrame();
        this.contactableBody = contactableBody;
        this.bodyFrame.getTransformToDesiredFrame(this.bodyToJointTransform, (ReferenceFrame)bodyToControl.getParentJoint().getFrameAfterJoint());
        this.bodyAcceleration = new SpatialAcceleration(this.contactFrame, this.elevatorFrame, this.contactFrame);
        this.spatialAccelerationCommand.set(elevator, bodyToControl);
        this.spatialFeedbackControlCommand.set(elevator, bodyToControl);
        String bodyName = bodyToControl.getName();
        this.coefficientOfFriction = new YoDouble(bodyName + "CoefficientOfFriction", this.registry);
        this.contactNormal = new YoFrameVector3D(bodyName + "ContactNormal", worldFrame, parentRegistry);
        this.contactPoint = new YoFramePoint3D(bodyName + "ContactPoint", this.contactFrame, parentRegistry);
        this.contactPointInWorld = new YoFramePoint3D(bodyName + "ContactPointInWorld", worldFrame, parentRegistry);
        this.desiredContactFrame = new PoseReferenceFrame(bodyName + "DesiredContactFrame", worldFrame);
        this.planeContactStateCommand.setContactingRigidBody(bodyToControl);
        this.jointControlHelper = jointControlHelper;
        String prefix = bodyName + "Loadbearing";
        this.hybridModeActive = new YoBoolean(prefix + "HybridModeActive", this.registry);
        this.setupViz(graphicsListRegistry, bodyName);
    }

    private void setupViz(YoGraphicsListRegistry graphicsListRegistry, String bodyName) {
        if (graphicsListRegistry == null) {
            return;
        }
        String listName = this.getClass().getSimpleName();
        YoGraphicVector surfaceNormal = new YoGraphicVector(bodyName + "ContactNormal", this.contactPointInWorld, this.contactNormal, 0.1, YoAppearance.Black());
        graphicsListRegistry.registerYoGraphic(listName, (YoGraphic)surfaceNormal);
        this.graphics.add(surfaceNormal);
        YoGraphicPosition contactPoint = new YoGraphicPosition(bodyName + "ContactPoint", this.contactPointInWorld, 0.01, YoAppearance.Black());
        graphicsListRegistry.registerYoGraphic(listName, (YoGraphic)contactPoint);
        this.graphics.add(contactPoint);
        this.hideGraphics();
    }

    public void setWeights(Vector3DReadOnly taskspaceAngularWeight, Vector3DReadOnly taskspaceLinearWeight) {
        this.taskspaceAngularWeight = taskspaceAngularWeight;
        this.taskspaceLinearWeight = taskspaceLinearWeight;
    }

    public void setGains(PID3DGainsReadOnly taskspaceOrientationGains, PID3DGainsReadOnly taskspacePositionGains) {
        this.taskspaceOrientationGains = taskspaceOrientationGains;
        this.taskspacePositionGains = taskspacePositionGains;
    }

    public void setCoefficientOfFriction(double coefficientOfFriction) {
        this.coefficientOfFriction.set(coefficientOfFriction);
    }

    public void setContactNormalInWorldFrame(Vector3D contactNormalInWorldFrame) {
        this.contactNormal.set((Tuple3DReadOnly)contactNormalInWorldFrame);
    }

    public void setAndUpdateContactFrame(RigidBodyTransform bodyToContactFrame) {
        this.contactToJointTransform.set(this.bodyToJointTransform);
        this.contactToJointTransform.multiply((RigidBodyTransformReadOnly)bodyToContactFrame);
        this.contactableBody.setSoleFrameTransformFromParentJoint(this.contactToJointTransform);
        this.contactPoint.setToZero();
    }

    public void doAction(double timeInState) {
        this.updateInternal();
        this.planeContactStateCommand.clearContactPoints();
        this.planeContactStateCommand.setCoefficientOfFriction(this.coefficientOfFriction.getDoubleValue());
        this.planeContactStateCommand.setContactNormal((FrameVector3DReadOnly)this.contactNormal);
        this.planeContactStateCommand.addPointInContact((FramePoint3DReadOnly)this.contactPoint);
        this.planeContactStateCommand.setHasContactStateChanged(this.hasContactStateNotChanged());
        this.bodyAcceleration.setToZero(this.contactFrame, this.elevatorFrame, this.contactFrame);
        this.bodyAcceleration.setBodyFrame(this.bodyFrame);
        this.spatialAccelerationCommand.setSpatialAcceleration(this.contactFrame, (SpatialAccelerationReadOnly)this.bodyAcceleration);
        this.spatialAccelerationCommand.setSelectionMatrix(this.accelerationSelectionMatrix);
        this.bodyFixedControlledPose.setToZero(this.contactFrame);
        this.bodyFixedControlledPose.changeFrame(this.bodyFrame);
        this.spatialFeedbackControlCommand.setControlFrameFixedInEndEffector((FramePose3DReadOnly)this.bodyFixedControlledPose);
        this.spatialFeedbackControlCommand.setInverseDynamics((FrameQuaternionReadOnly)this.desiredContactOrientation, (FramePoint3DReadOnly)this.desiredContactPosition, (FrameVector3DReadOnly)zeroInWorld, (FrameVector3DReadOnly)zeroInWorld, (FrameVector3DReadOnly)zeroInWorld, (FrameVector3DReadOnly)zeroInWorld);
        this.spatialFeedbackControlCommand.setSelectionMatrix(this.feedbackSelectionMatrix);
        this.spatialFeedbackControlCommand.setOrientationGains(this.taskspaceOrientationGains);
        this.spatialFeedbackControlCommand.setPositionGains(this.taskspacePositionGains);
        this.spatialFeedbackControlCommand.setWeightsForSolver(this.taskspaceAngularWeight, this.taskspaceLinearWeight);
        if (this.hybridModeActive.getBooleanValue()) {
            double timeInTrajectory = this.getTimeInTrajectory();
            this.jointControlHelper.doAction(timeInTrajectory);
        }
        this.previousContactNormal.setIncludingFrame((FrameTuple3DReadOnly)this.contactNormal);
        this.previousContactPoint.setIncludingFrame((FrameTuple3DReadOnly)this.contactPoint);
        this.previousCoefficientOfFriction = this.coefficientOfFriction.getDoubleValue();
        this.updateGraphics();
    }

    private void updateInternal() {
        int i;
        this.currentContactPosition.setToZero(this.contactFrame);
        this.currentContactOrientation.setToZero(this.contactFrame);
        this.currentContactPosition.changeFrame(this.desiredContactPosition.getReferenceFrame());
        this.currentContactOrientation.changeFrame(this.desiredContactOrientation.getReferenceFrame());
        for (i = 0; i < 6; ++i) {
            this.isDirectionFeedbackControlled[i] = false;
        }
        this.isDirectionFeedbackControlled[0] = true;
        this.isDirectionFeedbackControlled[1] = true;
        this.isDirectionFeedbackControlled[2] = true;
        this.desiredContactPosition.setX(this.currentContactPosition.getX());
        this.desiredContactPosition.setY(this.currentContactPosition.getY());
        this.desiredContactPosition.setZ(this.currentContactPosition.getZ());
        this.desiredContactPosition.checkReferenceFrameMatch(this.desiredContactFrame.getParent());
        this.desiredContactOrientation.checkReferenceFrameMatch(this.desiredContactFrame.getParent());
        this.desiredContactFrame.setPoseAndUpdate((FramePoint3DReadOnly)this.desiredContactPosition, (FrameOrientation3DReadOnly)this.desiredContactOrientation);
        this.contactPointInWorld.setMatchingFrame((FrameTuple3DReadOnly)this.contactPoint);
        this.accelerationSelectionMatrix.resetSelection();
        this.feedbackSelectionMatrix.resetSelection();
        for (i = 5; i >= 0; --i) {
            if (this.isDirectionFeedbackControlled[i]) {
                this.accelerationSelectionMatrix.selectAxis(i, false);
                continue;
            }
            this.feedbackSelectionMatrix.selectAxis(i, false);
        }
    }

    public boolean handleLoadbearingCommand(LoadBearingCommand command) {
        this.setCoefficientOfFriction(command.getCoefficientOfFriction());
        this.setContactNormalInWorldFrame(command.getContactNormalInWorldFrame());
        this.setAndUpdateContactFrame(command.getBodyFrameToContactFrame());
        return true;
    }

    public boolean handleJointTrajectoryCommand(JointspaceTrajectoryCommand command, double[] initialJointPositions) {
        if (this.jointControlHelper == null) {
            LogTools.warn((String)(this.warningPrefix + "Can not use hybrid mode. Was not created with a jointspace helper."));
            return false;
        }
        if (!this.handleCommandInternal((Command<?, ?>)command)) {
            return false;
        }
        if (!this.jointControlHelper.handleTrajectoryCommand(command, initialJointPositions)) {
            return false;
        }
        this.hybridModeActive.set(true);
        return true;
    }

    public void onEntry() {
        this.desiredContactPosition.setToZero(this.contactFrame);
        this.desiredContactOrientation.setToZero(this.contactFrame);
        this.desiredContactPosition.changeFrame(worldFrame);
        this.desiredContactOrientation.changeFrame(worldFrame);
        this.previousContactPoint.setToZero(worldFrame);
        this.previousContactNormal.setToZero(worldFrame);
        this.previousCoefficientOfFriction = 0.0;
    }

    private boolean hasContactStateNotChanged() {
        boolean hasContactStateNotChanged = this.previousContactNormal.equals((FrameTuple3DReadOnly)this.contactNormal);
        hasContactStateNotChanged &= this.previousContactPoint.equals((FrameTuple3DReadOnly)this.contactPoint);
        return hasContactStateNotChanged &= this.previousCoefficientOfFriction == this.coefficientOfFriction.getDoubleValue();
    }

    public void onExit() {
        this.hideGraphics();
        this.hybridModeActive.set(false);
    }

    @Override
    public InverseDynamicsCommand<?> getInverseDynamicsCommand() {
        this.inverseDynamicsCommandList.clear();
        this.inverseDynamicsCommandList.addCommand(this.spatialAccelerationCommand);
        this.inverseDynamicsCommandList.addCommand(this.planeContactStateCommand);
        return this.inverseDynamicsCommandList;
    }

    @Override
    public FeedbackControlCommand<?> getFeedbackControlCommand() {
        if (this.hybridModeActive.getBooleanValue()) {
            this.feedbackControlCommandList.clear();
            this.feedbackControlCommandList.addCommand(this.spatialFeedbackControlCommand);
            this.feedbackControlCommandList.addCommand(this.jointControlHelper.getJointspaceCommand());
            return this.feedbackControlCommandList;
        }
        return this.spatialFeedbackControlCommand;
    }

    @Override
    public FeedbackControlCommand<?> createFeedbackControlTemplate() {
        this.feedbackControlCommandList.clear();
        this.feedbackControlCommandList.addCommand(this.spatialFeedbackControlCommand);
        this.feedbackControlCommandList.addCommand(this.jointControlHelper.getJointspaceCommand());
        return this.feedbackControlCommandList;
    }

    @Override
    public InverseDynamicsCommand<?> getTransitionOutOfStateCommand() {
        this.planeContactStateCommand.clearContactPoints();
        this.planeContactStateCommand.setHasContactStateChanged(true);
        return this.planeContactStateCommand;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public double getLastTrajectoryPointTime() {
        return 0.0;
    }
}

