/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.rigidBody;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import us.ihmc.commonWalkingControlModules.controlModules.ControllerCommandValidationTools;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.JointspaceFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.OneDoFJointFeedbackControlCommand;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.lists.RecyclingArrayDeque;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.communication.packets.ExecutionMode;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.JointspaceTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.OneDoFJointTrajectoryCommand;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.robotics.controllers.pidGains.PDGainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.PIDGainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.implementations.YoPIDGains;
import us.ihmc.robotics.math.trajectories.generators.MultipleWaypointsTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.trajectorypoints.OneDoFTrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.OneDoFTrajectoryPointBasics;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class RigidBodyJointControlHelper {
    public static final String shortName = "JointControlHelper";
    private final YoRegistry registry;
    private final String warningPrefix;
    private final YoBoolean trajectoryDone;
    private final List<MultipleWaypointsTrajectoryGenerator> jointTrajectoryGenerators = new ArrayList<MultipleWaypointsTrajectoryGenerator>();
    private final List<RecyclingArrayDeque<OneDoFTrajectoryPoint>> pointQueues = new ArrayList<RecyclingArrayDeque<OneDoFTrajectoryPoint>>();
    private final List<YoInteger> numberOfPointsInQueue = new ArrayList<YoInteger>();
    private final List<YoInteger> numberOfPointsInGenerator = new ArrayList<YoInteger>();
    private final List<YoInteger> numberOfPoints = new ArrayList<YoInteger>();
    private final YoDouble streamTimestampOffset;
    private final YoDouble streamTimestampSource;
    private final YoBoolean usingWeightFromMessage;
    private final List<DoubleProvider> defaultWeights = new ArrayList<DoubleProvider>();
    private final List<YoDouble> currentWeights = new ArrayList<YoDouble>();
    private final List<YoDouble> messageWeights = new ArrayList<YoDouble>();
    private final List<PIDGainsReadOnly> gains = new ArrayList<PIDGainsReadOnly>();
    private final YoBoolean hasWeights;
    private final YoBoolean hasGains;
    private final OneDoFTrajectoryPoint lastPointAdded = new OneDoFTrajectoryPoint();
    private final JointspaceFeedbackControlCommand feedbackControlCommand = new JointspaceFeedbackControlCommand();
    private final OneDoFJointBasics[] joints;
    private final int numberOfJoints;
    private final DoubleProvider time;

    public RigidBodyJointControlHelper(String bodyName, OneDoFJointBasics[] jointsToControl, DoubleProvider time, YoRegistry parentRegistry) {
        this.warningPrefix = "JointControlHelper for " + bodyName + ": ";
        this.registry = new YoRegistry(bodyName + shortName);
        this.trajectoryDone = new YoBoolean("JointControlHelperDone", this.registry);
        this.time = time;
        this.joints = jointsToControl;
        this.numberOfJoints = this.joints.length;
        String prefix = bodyName + "Jointspace";
        this.hasWeights = new YoBoolean(prefix + "HasWeights", this.registry);
        this.hasGains = new YoBoolean(prefix + "HasGains", this.registry);
        this.usingWeightFromMessage = new YoBoolean(prefix + "UsingWeightFromMessage", this.registry);
        for (int jointIdx = 0; jointIdx < jointsToControl.length; ++jointIdx) {
            OneDoFJointBasics joint = jointsToControl[jointIdx];
            String jointName = joint.getName();
            this.jointTrajectoryGenerators.add(new MultipleWaypointsTrajectoryGenerator(jointName, 5, this.registry));
            RecyclingArrayDeque pointQueue = new RecyclingArrayDeque(10000, OneDoFTrajectoryPoint.class, OneDoFTrajectoryPointBasics::set);
            pointQueue.clear();
            this.pointQueues.add((RecyclingArrayDeque<OneDoFTrajectoryPoint>)pointQueue);
            this.feedbackControlCommand.addJointCommand(joint);
            this.numberOfPointsInQueue.add(new YoInteger(prefix + "_" + jointName + "_numberOfPointsInQueue", this.registry));
            this.numberOfPointsInGenerator.add(new YoInteger(prefix + "_" + jointName + "_numberOfPointsInGenerator", this.registry));
            this.numberOfPoints.add(new YoInteger(prefix + "_" + jointName + "_numberOfPoints", this.registry));
            this.messageWeights.add(new YoDouble(prefix + "_" + jointName + "_messageWeight", this.registry));
            this.currentWeights.add(new YoDouble(prefix + "_" + jointName + "_currentWeight", this.registry));
        }
        this.streamTimestampOffset = new YoDouble(prefix + "StreamTimestampOffset", this.registry);
        this.streamTimestampOffset.setToNaN();
        this.streamTimestampSource = new YoDouble(prefix + "StreamTimestampSource", this.registry);
        this.streamTimestampSource.setToNaN();
        parentRegistry.addChild(this.registry);
    }

    public void setDefaultWeights(Map<String, DoubleProvider> weights) {
        this.hasWeights.set(true);
        this.defaultWeights.clear();
        for (int jointIdx = 0; jointIdx < this.numberOfJoints; ++jointIdx) {
            OneDoFJointBasics joint = this.joints[jointIdx];
            if (!weights.containsKey(joint.getName())) {
                this.defaultWeights.clear();
                this.hasWeights.set(false);
                return;
            }
            this.defaultWeights.add(weights.get(joint.getName()));
        }
        this.setWeightsToDefaults();
    }

    public void setDefaultWeight(DoubleProvider weight) {
        this.hasWeights.set(true);
        this.defaultWeights.clear();
        for (int jointIdx = 0; jointIdx < this.numberOfJoints; ++jointIdx) {
            this.defaultWeights.add(weight);
        }
        this.setWeightsToDefaults();
    }

    public void setGains(Map<String, PIDGainsReadOnly> gains) {
        this.hasGains.set(true);
        this.gains.clear();
        for (int jointIdx = 0; jointIdx < this.numberOfJoints; ++jointIdx) {
            OneDoFJointBasics joint = this.joints[jointIdx];
            if (!gains.containsKey(joint.getName())) {
                this.gains.clear();
                this.hasGains.set(false);
                return;
            }
            this.gains.add(gains.get(joint.getName()));
        }
    }

    public void setGains(YoPIDGains gains) {
        this.hasGains.set(true);
        this.gains.clear();
        for (int jointIdx = 0; jointIdx < this.numberOfJoints; ++jointIdx) {
            this.gains.add((PIDGainsReadOnly)gains);
        }
    }

    public void setWeightsToDefaults() {
        this.usingWeightFromMessage.set(false);
    }

    public boolean doAction(double timeInTrajectory) {
        if (!this.hasGains.getBooleanValue() || !this.hasWeights.getBooleanValue()) {
            LogTools.warn((String)(this.warningPrefix + "Can not send joint trajectory commands. Do not have all weights and gains set."));
            throw new RuntimeException(this.warningPrefix + "Has no gains or weights.");
        }
        boolean allDone = true;
        List<YoDouble> weights = this.usingWeightFromMessage.getBooleanValue() ? this.messageWeights : this.defaultWeights;
        this.feedbackControlCommand.clear();
        for (int jointIdx = 0; jointIdx < this.numberOfJoints; ++jointIdx) {
            boolean generatorDone;
            MultipleWaypointsTrajectoryGenerator generator = this.jointTrajectoryGenerators.get(jointIdx);
            boolean bl = generatorDone = generator.isDone() || generator.getLastWaypointTime() <= timeInTrajectory;
            allDone = !this.trajectoryDone.getBooleanValue() && generatorDone ? this.fillAndReinitializeTrajectories(jointIdx) && allDone : this.trajectoryDone.getBooleanValue();
            if (allDone) {
                this.streamTimestampOffset.setToNaN();
                this.streamTimestampSource.setToNaN();
            }
            generator.compute(timeInTrajectory);
            double desiredPosition = generator.getValue();
            double desiredVelocity = generator.getVelocity();
            double feedForwardAcceleration = generator.getAcceleration();
            OneDoFJointBasics joint = this.joints[jointIdx];
            PIDGainsReadOnly gain = this.gains.get(jointIdx);
            double weight = ((DoubleProvider)weights.get(jointIdx)).getValue();
            this.currentWeights.get(jointIdx).set(weight);
            if (weight > 0.0) {
                OneDoFJointFeedbackControlCommand jointCommand = this.feedbackControlCommand.addJointCommand(joint);
                jointCommand.setInverseDynamics(desiredPosition, desiredVelocity, feedForwardAcceleration);
                jointCommand.setGains((PDGainsReadOnly)gain);
                jointCommand.setWeightForSolver(weight);
            }
            YoInteger numberOfPointsInQueue = this.numberOfPointsInQueue.get(jointIdx);
            YoInteger numberOfPointsInGenerator = this.numberOfPointsInGenerator.get(jointIdx);
            YoInteger numberOfPoints = this.numberOfPoints.get(jointIdx);
            numberOfPointsInQueue.set(this.pointQueues.get(jointIdx).size());
            numberOfPointsInGenerator.set(generator.getCurrentNumberOfWaypoints());
            numberOfPoints.set(numberOfPointsInQueue.getIntegerValue() + numberOfPointsInGenerator.getIntegerValue());
        }
        this.trajectoryDone.set(allDone);
        return this.trajectoryDone.getBooleanValue();
    }

    private boolean fillAndReinitializeTrajectories(int jointIdx) {
        RecyclingArrayDeque<OneDoFTrajectoryPoint> pointQueue = this.pointQueues.get(jointIdx);
        if (pointQueue.isEmpty()) {
            return true;
        }
        MultipleWaypointsTrajectoryGenerator generator = this.jointTrajectoryGenerators.get(jointIdx);
        if (!generator.isEmpty()) {
            generator.getLastWaypoint((OneDoFTrajectoryPointBasics)this.lastPointAdded);
            generator.clear();
            generator.appendWaypoint((OneDoFTrajectoryPointBasics)this.lastPointAdded);
        }
        int currentNumberOfWaypoints = generator.getCurrentNumberOfWaypoints();
        int pointsToAdd = 5 - currentNumberOfWaypoints;
        for (int pointIdx = 0; pointIdx < pointsToAdd && !pointQueue.isEmpty(); ++pointIdx) {
            OneDoFTrajectoryPoint pointToAdd = (OneDoFTrajectoryPoint)pointQueue.pollFirst();
            generator.appendWaypoint((OneDoFTrajectoryPointBasics)pointToAdd);
        }
        generator.initialize();
        return false;
    }

    public boolean handleTrajectoryCommand(JointspaceTrajectoryCommand command, double[] initialJointPositions) {
        boolean override;
        if (!this.hasGains.getBooleanValue() || !this.hasWeights.getBooleanValue()) {
            LogTools.warn((String)(this.warningPrefix + "Can not send joint trajectory commands. Do not have all weights and gains set."));
            return false;
        }
        if (!ControllerCommandValidationTools.checkOneDoFJointTrajectoryCommandList(this.joints, (RecyclingArrayList<OneDoFJointTrajectoryCommand>)command.getTrajectoryPointLists())) {
            return false;
        }
        double streamTimeOffset = 0.0;
        double streamTimestampOffset = this.streamTimestampOffset.getValue();
        double streamTimestampSource = this.streamTimestampSource.getValue();
        if (command.getExecutionMode() == ExecutionMode.STREAM) {
            if (command.getTimestamp() <= 0L) {
                streamTimestampOffset = Double.NaN;
                streamTimestampSource = Double.NaN;
            } else {
                double senderTime = Conversions.nanosecondsToSeconds((long)command.getTimestamp());
                if (!Double.isNaN(streamTimestampSource) && senderTime < streamTimestampSource) {
                    return true;
                }
                streamTimestampSource = senderTime;
                streamTimeOffset = this.time.getValue() - senderTime;
                streamTimestampOffset = Double.isNaN(streamTimestampOffset) ? streamTimeOffset : (Math.abs(streamTimeOffset - streamTimestampOffset) > 0.5 ? streamTimeOffset : Math.min(streamTimeOffset, streamTimestampOffset));
            }
        }
        boolean bl = override = command.getExecutionMode() != ExecutionMode.QUEUE;
        if (override || this.isEmpty()) {
            this.overrideTrajectory();
            boolean messageHasValidWeights = true;
            for (int jointIdx = 0; jointIdx < this.numberOfJoints; ++jointIdx) {
                OneDoFJointTrajectoryCommand trajectoryPoints = command.getJointTrajectoryPointList(jointIdx);
                if (trajectoryPoints.getNumberOfTrajectoryPoints() > 0) {
                    OneDoFTrajectoryPoint trajectoryPoint = trajectoryPoints.getTrajectoryPoint(0);
                    if (trajectoryPoint.getTime() > 0.05) {
                        this.queueInitialPoint(initialJointPositions[jointIdx], jointIdx);
                    }
                } else {
                    this.queueInitialPoint(initialJointPositions[jointIdx], jointIdx);
                }
                double weight = trajectoryPoints.getWeight();
                this.messageWeights.get(jointIdx).set(weight);
                if (!Double.isNaN(weight) && !(weight < 0.0)) continue;
                messageHasValidWeights = false;
            }
            this.usingWeightFromMessage.set(messageHasValidWeights);
        }
        if (command.getExecutionMode() == ExecutionMode.STREAM) {
            this.streamTimestampOffset.set(streamTimestampOffset);
            this.streamTimestampSource.set(streamTimestampSource);
        }
        for (int jointIdx = 0; jointIdx < this.numberOfJoints; ++jointIdx) {
            OneDoFJointTrajectoryCommand trajectoryPoints = command.getJointTrajectoryPointList(jointIdx);
            if (command.getExecutionMode() == ExecutionMode.STREAM) {
                double qd0;
                if (trajectoryPoints.getNumberOfTrajectoryPoints() != 1) {
                    LogTools.warn((String)("When streaming, trajectories should contain only 1 trajectory point, was: " + trajectoryPoints.getNumberOfTrajectoryPoints()));
                    return false;
                }
                OneDoFTrajectoryPoint trajectoryPoint = trajectoryPoints.getTrajectoryPoint(0);
                if (trajectoryPoint.getTime() != 0.0) {
                    LogTools.warn((String)("When streaming, the trajectory point should have a time of zero, was: " + trajectoryPoint.getTime()));
                    return false;
                }
                double t0 = Double.isNaN(streamTimestampOffset) ? 0.0 : streamTimestampOffset - streamTimeOffset;
                double q0 = trajectoryPoint.getPosition();
                if (!this.queuePoint(q0, qd0 = trajectoryPoint.getVelocity(), t0, jointIdx)) {
                    return false;
                }
                double t1 = command.getStreamIntegrationDuration() + t0;
                double qd1 = trajectoryPoint.getVelocity();
                double q1 = trajectoryPoint.getPosition() + command.getStreamIntegrationDuration() * qd1;
                if (this.queuePoint(q1, qd1, t1, jointIdx)) continue;
                return false;
            }
            for (int pointIdx = 0; pointIdx < trajectoryPoints.getNumberOfTrajectoryPoints(); ++pointIdx) {
                OneDoFTrajectoryPoint trajectoryPoint = trajectoryPoints.getTrajectoryPoint(pointIdx);
                if (trajectoryPoint == null) continue;
                if (!this.checkTime(trajectoryPoint.getTime(), jointIdx)) {
                    return false;
                }
                if (this.queuePoint(trajectoryPoint, jointIdx)) continue;
                return false;
            }
        }
        this.trajectoryDone.set(false);
        return true;
    }

    public void queuePointsAtTimeWithZeroVelocity(double time, double[] jointPositions) {
        for (int jointIdx = 0; jointIdx < this.numberOfJoints; ++jointIdx) {
            this.queuePoint(jointPositions[jointIdx], 0.0, time, jointIdx);
        }
    }

    public void startTrajectoryExecution() {
        this.trajectoryDone.set(false);
    }

    private void queueInitialPoint(double initialPosition, int jointIdx) {
        RecyclingArrayDeque<OneDoFTrajectoryPoint> pointQueue = this.pointQueues.get(jointIdx);
        OneDoFTrajectoryPoint point = (OneDoFTrajectoryPoint)pointQueue.addLast();
        point.set(0.0, initialPosition, 0.0);
    }

    private boolean queuePoint(OneDoFTrajectoryPoint trajectoryPoint, int jointIdx) {
        RecyclingArrayDeque<OneDoFTrajectoryPoint> pointQueue = this.pointQueues.get(jointIdx);
        if (this.atCapacityLimit(pointQueue)) {
            return false;
        }
        OneDoFTrajectoryPoint point = (OneDoFTrajectoryPoint)pointQueue.addLast();
        point.set((OneDoFTrajectoryPointBasics)trajectoryPoint);
        return true;
    }

    private boolean queuePoint(double q, double qd, double t, int jointIdx) {
        RecyclingArrayDeque<OneDoFTrajectoryPoint> pointQueue = this.pointQueues.get(jointIdx);
        if (this.atCapacityLimit(pointQueue)) {
            return false;
        }
        OneDoFTrajectoryPoint point = (OneDoFTrajectoryPoint)pointQueue.addLast();
        point.set(t, q, qd);
        return true;
    }

    private boolean atCapacityLimit(RecyclingArrayDeque<OneDoFTrajectoryPoint> pointQueue) {
        if (pointQueue.size() >= 10000) {
            LogTools.info((String)(this.warningPrefix + "Reached maximum capacity of " + 10000 + " can not execute trajectory."));
            return true;
        }
        return false;
    }

    private boolean checkTime(double time, int jointIdx) {
        boolean timeValid;
        boolean bl = timeValid = time > this.getLastTrajectoryPointTime(jointIdx);
        if (!timeValid) {
            LogTools.warn((String)(this.warningPrefix + "Time in trajectory must be strictly increasing."));
        }
        return timeValid;
    }

    public double getLastTrajectoryPointTime() {
        double lastTrajectoryPointTime = Double.NEGATIVE_INFINITY;
        for (int jointIdx = 0; jointIdx < this.numberOfJoints; ++jointIdx) {
            double jointLastTime = this.getLastTrajectoryPointTime(jointIdx);
            lastTrajectoryPointTime = Math.max(lastTrajectoryPointTime, jointLastTime);
        }
        return lastTrajectoryPointTime;
    }

    private double getLastTrajectoryPointTime(int jointIdx) {
        if (this.isEmpty(jointIdx)) {
            return Double.NEGATIVE_INFINITY;
        }
        RecyclingArrayDeque<OneDoFTrajectoryPoint> pointQueue = this.pointQueues.get(jointIdx);
        MultipleWaypointsTrajectoryGenerator generator = this.jointTrajectoryGenerators.get(jointIdx);
        if (pointQueue.isEmpty()) {
            return generator.getLastWaypointTime();
        }
        return ((OneDoFTrajectoryPoint)pointQueue.peekLast()).getTime();
    }

    public void overrideTrajectory() {
        for (int jointIdx = 0; jointIdx < this.numberOfJoints; ++jointIdx) {
            this.overrideTrajectory(jointIdx);
        }
        this.streamTimestampOffset.setToNaN();
        this.streamTimestampSource.setToNaN();
    }

    private void overrideTrajectory(int jointIdx) {
        this.jointTrajectoryGenerators.get(jointIdx).clear();
        this.pointQueues.get(jointIdx).clear();
    }

    public boolean isEmpty() {
        for (int jointIdx = 0; jointIdx < this.numberOfJoints; ++jointIdx) {
            if (this.isEmpty(jointIdx)) continue;
            return false;
        }
        return true;
    }

    private boolean isEmpty(int jointIdx) {
        RecyclingArrayDeque<OneDoFTrajectoryPoint> pointQueue = this.pointQueues.get(jointIdx);
        MultipleWaypointsTrajectoryGenerator generator = this.jointTrajectoryGenerators.get(jointIdx);
        return pointQueue.isEmpty() && generator.isDone();
    }

    public double getJointDesiredPosition(int jointIdx) {
        return this.jointTrajectoryGenerators.get(jointIdx).getValue();
    }

    public void queueInitialPointsAtCurrentDesired() {
        for (int jointIdx = 0; jointIdx < this.numberOfJoints; ++jointIdx) {
            this.queueInitialPoint(this.getJointDesiredPosition(jointIdx), jointIdx);
        }
    }

    public double getJointDesiredVelocity(int jointIdx) {
        return this.jointTrajectoryGenerators.get(jointIdx).getVelocity();
    }

    public JointspaceFeedbackControlCommand getJointspaceCommand() {
        return this.feedbackControlCommand;
    }

    public void queueInitialPointsAtCurrent() {
        for (int jointIdx = 0; jointIdx < this.numberOfJoints; ++jointIdx) {
            OneDoFJointBasics joint = this.joints[jointIdx];
            this.queueInitialPoint(joint.getQ(), jointIdx);
        }
    }
}

