/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.rigidBody;

import gnu.trove.map.hash.TObjectDoubleHashMap;
import java.util.Map;
import us.ihmc.commonWalkingControlModules.controlModules.rigidBody.RigidBodyControlMode;
import us.ihmc.commonWalkingControlModules.controlModules.rigidBody.RigidBodyControlState;
import us.ihmc.commonWalkingControlModules.controlModules.rigidBody.RigidBodyExternalWrenchManager;
import us.ihmc.commonWalkingControlModules.controlModules.rigidBody.RigidBodyJointControlHelper;
import us.ihmc.commonWalkingControlModules.controlModules.rigidBody.RigidBodyJointspaceControlState;
import us.ihmc.commonWalkingControlModules.controlModules.rigidBody.RigidBodyLoadBearingControlState;
import us.ihmc.commonWalkingControlModules.controlModules.rigidBody.RigidBodyOrientationController;
import us.ihmc.commonWalkingControlModules.controlModules.rigidBody.RigidBodyPoseController;
import us.ihmc.commonWalkingControlModules.controlModules.rigidBody.RigidBodyPositionController;
import us.ihmc.commonWalkingControlModules.controlModules.rigidBody.RigidBodyTaskspaceControlState;
import us.ihmc.commonWalkingControlModules.controlModules.rigidBody.RigidBodyUserControlState;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommandList;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommandList;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.DesiredAccelerationsCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.JointspaceTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.LoadBearingCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.SE3TrajectoryControllerCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.SO3TrajectoryControllerCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.StopAllTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.WrenchTrajectoryControllerCommand;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.controllers.pidGains.PID3DGainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.PIDGainsReadOnly;
import us.ihmc.robotics.stateMachine.core.State;
import us.ihmc.robotics.stateMachine.core.StateMachine;
import us.ihmc.robotics.stateMachine.factories.StateMachineFactory;
import us.ihmc.yoVariables.parameters.EnumParameter;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;

public class RigidBodyControlManager {
    public static final double INITIAL_GO_HOME_TIME = 2.0;
    private final String bodyName;
    private final YoRegistry registry;
    private final StateMachine<RigidBodyControlMode, RigidBodyControlState> stateMachine;
    private final YoEnum<RigidBodyControlMode> requestedState;
    private final EnumParameter<RigidBodyControlMode> defaultControlMode;
    private final RigidBodyJointspaceControlState jointspaceControlState;
    private final RigidBodyTaskspaceControlState taskspaceControlState;
    private final RigidBodyUserControlState userControlState;
    private final RigidBodyLoadBearingControlState loadBearingControlState;
    private final RigidBodyExternalWrenchManager externalWrenchManager;
    private final double[] initialJointPositions;
    private final FramePose3D homePose;
    private final OneDoFJointBasics[] jointsToControl;
    private final InverseDynamicsCommandList inverseDynamicsCommandList = new InverseDynamicsCommandList();
    private final YoBoolean stateSwitched;
    private final YoBoolean doPrepareForLocomotion;

    public RigidBodyControlManager(RigidBodyBasics bodyToControl, RigidBodyBasics baseBody, RigidBodyBasics elevator, TObjectDoubleHashMap<String> homeConfiguration, Pose3D homePose, ReferenceFrame controlFrame, ReferenceFrame baseFrame, Vector3DReadOnly taskspaceAngularWeight, Vector3DReadOnly taskspaceLinearWeight, PID3DGainsReadOnly taskspaceOrientationGains, PID3DGainsReadOnly taskspacePositionGains, ContactablePlaneBody contactableBody, RigidBodyControlMode defaultControlMode, YoDouble yoTime, YoGraphicsListRegistry graphicsListRegistry, YoRegistry parentRegistry) {
        RigidBodyTaskspaceControlState taskspaceControlState;
        this.bodyName = bodyToControl.getName();
        String namePrefix = this.bodyName + "Manager";
        this.registry = new YoRegistry(namePrefix);
        this.requestedState = new YoEnum(namePrefix + "RequestedControlMode", this.registry, RigidBodyControlMode.class, true);
        this.stateSwitched = new YoBoolean(namePrefix + "StateSwitched", this.registry);
        this.doPrepareForLocomotion = new YoBoolean(namePrefix + "DoPrepareForLocomotion", this.registry);
        this.jointsToControl = MultiBodySystemTools.createOneDoFJointPath((RigidBodyBasics)baseBody, (RigidBodyBasics)bodyToControl);
        this.initialJointPositions = new double[this.jointsToControl.length];
        RigidBodyJointControlHelper jointControlHelper = new RigidBodyJointControlHelper(this.bodyName, this.jointsToControl, (DoubleProvider)yoTime, parentRegistry);
        this.jointspaceControlState = new RigidBodyJointspaceControlState(this.bodyName, this.jointsToControl, homeConfiguration, yoTime, jointControlHelper, this.registry);
        if (taskspaceAngularWeight != null && taskspaceLinearWeight == null) {
            taskspaceControlState = new RigidBodyOrientationController(bodyToControl, baseBody, elevator, baseFrame, yoTime, jointControlHelper, parentRegistry);
            if (taskspaceOrientationGains == null) {
                throw new RuntimeException("Can not create orientation control manager with null gains for " + this.bodyName);
            }
            ((RigidBodyOrientationController)taskspaceControlState).setGains(taskspaceOrientationGains);
            ((RigidBodyOrientationController)taskspaceControlState).setWeights(taskspaceAngularWeight);
            this.taskspaceControlState = taskspaceControlState;
            LogTools.info((String)("Creating manager for " + this.bodyName + " with orientation controller."));
        } else if (taskspaceAngularWeight == null && taskspaceLinearWeight != null) {
            taskspaceControlState = new RigidBodyPositionController(bodyToControl, baseBody, elevator, controlFrame, baseFrame, yoTime, parentRegistry, graphicsListRegistry);
            if (taskspacePositionGains == null) {
                throw new RuntimeException("Can not create position control manager with null gains for " + this.bodyName);
            }
            ((RigidBodyPositionController)taskspaceControlState).setGains(taskspacePositionGains);
            ((RigidBodyPositionController)taskspaceControlState).setWeights(taskspaceLinearWeight);
            this.taskspaceControlState = taskspaceControlState;
            LogTools.info((String)("Creating manager for " + this.bodyName + " with position controller."));
        } else if (taskspaceAngularWeight != null && taskspaceLinearWeight != null) {
            taskspaceControlState = new RigidBodyPoseController(bodyToControl, baseBody, elevator, controlFrame, baseFrame, yoTime, jointControlHelper, graphicsListRegistry, this.registry);
            if (taskspaceOrientationGains == null || taskspacePositionGains == null) {
                System.out.println("Orientation gains exist: " + (taskspaceOrientationGains != null));
                System.out.println("Position gains exist: " + (taskspacePositionGains != null));
                throw new RuntimeException("Can not create pose control manager with null gains for " + this.bodyName);
            }
            ((RigidBodyPoseController)taskspaceControlState).setGains(taskspaceOrientationGains, taskspacePositionGains);
            ((RigidBodyPoseController)taskspaceControlState).setWeights(taskspaceAngularWeight, taskspaceLinearWeight);
            this.taskspaceControlState = taskspaceControlState;
            LogTools.info((String)("Creating manager for " + this.bodyName + " with pose controller."));
        } else {
            throw new RuntimeException("No gains or weights for " + this.bodyName);
        }
        this.userControlState = new RigidBodyUserControlState(this.bodyName, this.jointsToControl, yoTime, this.registry);
        if (contactableBody != null) {
            this.loadBearingControlState = new RigidBodyLoadBearingControlState(bodyToControl, contactableBody, elevator, yoTime, jointControlHelper, graphicsListRegistry, this.registry);
            this.loadBearingControlState.setGains(taskspaceOrientationGains, taskspacePositionGains);
            this.loadBearingControlState.setWeights(taskspaceAngularWeight, taskspaceLinearWeight);
        } else {
            this.loadBearingControlState = null;
        }
        this.homePose = homePose != null ? new FramePose3D(baseFrame, (Pose3DReadOnly)homePose) : null;
        this.externalWrenchManager = new RigidBodyExternalWrenchManager(bodyToControl, baseBody, controlFrame, yoTime, graphicsListRegistry, this.registry);
        defaultControlMode = defaultControlMode == null ? RigidBodyControlMode.JOINTSPACE : defaultControlMode;
        RigidBodyControlManager.checkDefaultControlMode(defaultControlMode, this.homePose, this.bodyName);
        String description = "WARNING: only " + (Object)((Object)RigidBodyControlMode.JOINTSPACE) + " or " + (Object)((Object)RigidBodyControlMode.TASKSPACE) + " possible!";
        this.defaultControlMode = new EnumParameter(namePrefix + "DefaultControlMode", description, this.registry, RigidBodyControlMode.class, false, (Enum)defaultControlMode);
        this.defaultControlMode.addListener(parameter -> RigidBodyControlManager.checkDefaultControlMode((RigidBodyControlMode)this.defaultControlMode.getValue(), this.homePose, this.bodyName));
        this.stateMachine = this.setupStateMachine(namePrefix, (DoubleProvider)yoTime);
        parentRegistry.addChild(this.registry);
    }

    private StateMachine<RigidBodyControlMode, RigidBodyControlState> setupStateMachine(String namePrefix, DoubleProvider timeProvider) {
        StateMachineFactory factory = new StateMachineFactory(RigidBodyControlMode.class);
        factory.setNamePrefix(namePrefix).setRegistry(this.registry).buildYoClock(timeProvider);
        factory.addState((Enum)RigidBodyControlMode.JOINTSPACE, (State)this.jointspaceControlState);
        factory.addState((Enum)RigidBodyControlMode.TASKSPACE, (State)this.taskspaceControlState);
        factory.addState((Enum)RigidBodyControlMode.USER, (State)this.userControlState);
        if (this.loadBearingControlState != null) {
            factory.addState((Enum)RigidBodyControlMode.LOADBEARING, (State)this.loadBearingControlState);
        }
        for (RigidBodyControlMode from : factory.getRegisteredStateKeys()) {
            for (RigidBodyControlMode to : factory.getRegisteredStateKeys()) {
                factory.addRequestedTransition((Enum)from, (Enum)to, this.requestedState);
            }
        }
        return factory.build((Enum)RigidBodyControlMode.JOINTSPACE);
    }

    public void setWeights(Map<String, DoubleProvider> jointspaceWeights, Map<String, DoubleProvider> userModeWeights) {
        this.jointspaceControlState.setDefaultWeights(jointspaceWeights);
        this.userControlState.setWeights(userModeWeights);
    }

    public void setGains(Map<String, PIDGainsReadOnly> jointspaceGains) {
        this.jointspaceControlState.setGains(jointspaceGains);
    }

    public void setDoPrepareForLocomotion(boolean value) {
        this.doPrepareForLocomotion.set(value);
    }

    private static void checkDefaultControlMode(RigidBodyControlMode defaultControlMode, FramePose3D homePose, String bodyName) {
        if (defaultControlMode == null) {
            throw new RuntimeException("Default control mode can not be null for body " + bodyName + ".");
        }
        if (defaultControlMode == RigidBodyControlMode.TASKSPACE && homePose == null) {
            throw new RuntimeException("Need to define home pose if default control mode for body " + bodyName + " is set to TASKSPACE.");
        }
        if (defaultControlMode != RigidBodyControlMode.TASKSPACE && defaultControlMode != RigidBodyControlMode.JOINTSPACE) {
            throw new RuntimeException("Only JOINTSPACE or TASKSPACE control modes are allowed as default modes for body " + bodyName + ".");
        }
    }

    public void initialize() {
        this.stateMachine.resetToInitialState();
        this.goToHomeFromCurrent(2.0);
    }

    public void compute() {
        if (((RigidBodyControlState)this.stateMachine.getCurrentState()).abortState()) {
            this.hold();
        }
        this.stateSwitched.set(this.stateMachine.doTransitions());
        this.stateMachine.doAction();
        this.externalWrenchManager.doAction(Double.NaN);
    }

    public void handleStopAllTrajectoryCommand(StopAllTrajectoryCommand command) {
        if (command.isStopAllTrajectory()) {
            this.holdCurrentDesired();
            this.externalWrenchManager.clear();
        }
    }

    public void handleTaskspaceTrajectoryCommand(SO3TrajectoryControllerCommand command) {
        if (this.taskspaceControlState.handleTrajectoryCommand(command)) {
            this.requestState(this.taskspaceControlState.getControlMode());
        } else {
            LogTools.warn((String)(this.getClass().getSimpleName() + " for " + this.bodyName + " received invalid orientation trajectory command."));
            this.hold();
        }
    }

    public void handleTaskspaceTrajectoryCommand(SE3TrajectoryControllerCommand command) {
        if (this.taskspaceControlState.handleTrajectoryCommand(command)) {
            this.requestState(this.taskspaceControlState.getControlMode());
        } else {
            LogTools.warn((String)(this.getClass().getSimpleName() + " for " + this.bodyName + " received invalid pose trajectory command."));
            this.hold();
        }
    }

    public void handleJointspaceTrajectoryCommand(JointspaceTrajectoryCommand command) {
        this.computeDesiredJointPositions(this.initialJointPositions);
        if (this.jointspaceControlState.handleTrajectoryCommand(command, this.initialJointPositions)) {
            this.requestState(this.jointspaceControlState.getControlMode());
        } else {
            LogTools.warn((String)(this.getClass().getSimpleName() + " for " + this.bodyName + " received invalid jointspace trajectory command."));
            this.hold();
        }
    }

    public void handleHybridTrajectoryCommand(SE3TrajectoryControllerCommand taskspaceCommand, JointspaceTrajectoryCommand jointSpaceCommand) {
        this.computeDesiredJointPositions(this.initialJointPositions);
        if (this.taskspaceControlState.handleHybridTrajectoryCommand(taskspaceCommand, jointSpaceCommand, this.initialJointPositions)) {
            this.requestState(this.taskspaceControlState.getControlMode());
        } else {
            LogTools.warn((String)(this.getClass().getSimpleName() + " for " + this.bodyName + " received invalid hybrid SE3 trajectory command."));
            this.hold();
        }
    }

    public void handleHybridTrajectoryCommand(SO3TrajectoryControllerCommand taskspaceCommand, JointspaceTrajectoryCommand jointSpaceCommand) {
        this.computeDesiredJointPositions(this.initialJointPositions);
        if (this.taskspaceControlState.handleHybridTrajectoryCommand(taskspaceCommand, jointSpaceCommand, this.initialJointPositions)) {
            this.requestState(this.taskspaceControlState.getControlMode());
        } else {
            LogTools.warn((String)(this.getClass().getSimpleName() + " for " + this.bodyName + " received invalid hybrid SO3 trajectory command."));
            this.hold();
        }
    }

    public void handleDesiredAccelerationsCommand(DesiredAccelerationsCommand command) {
        if (this.userControlState.handleDesiredAccelerationsCommand(command)) {
            this.requestState(this.userControlState.getControlMode());
        } else {
            LogTools.warn((String)(this.getClass().getSimpleName() + " for " + this.bodyName + " received invalid desired accelerations command."));
            this.hold();
        }
    }

    public void handleWrenchTrajectoryCommand(WrenchTrajectoryControllerCommand command) {
        if (!this.externalWrenchManager.handleWrenchTrajectoryCommand(command)) {
            this.externalWrenchManager.clear();
        }
    }

    public void prepareForLocomotion() {
        if (this.doPrepareForLocomotion.getValue()) {
            this.holdInJointspace();
        }
    }

    public void holdInJointspace() {
        this.jointspaceControlState.holdCurrent();
        this.requestState(this.jointspaceControlState.getControlMode());
    }

    public void holdCurrentDesiredInJointspace() {
        if (this.getActiveControlMode() == this.jointspaceControlState.getControlMode()) {
            this.jointspaceControlState.holdCurrentDesired();
            this.requestState(this.jointspaceControlState.getControlMode());
        } else {
            this.holdInJointspace();
        }
    }

    public void holdInTaskspace() {
        this.taskspaceControlState.holdCurrent();
        this.requestState(this.taskspaceControlState.getControlMode());
    }

    public void holdCurrentDesiredInTaskspace() {
        if (this.getActiveControlMode() == this.taskspaceControlState.getControlMode()) {
            this.taskspaceControlState.holdCurrentDesired();
            this.requestState(this.taskspaceControlState.getControlMode());
        } else {
            this.holdInTaskspace();
        }
    }

    public void hold() {
        switch ((RigidBodyControlMode)this.defaultControlMode.getValue()) {
            case JOINTSPACE: {
                this.holdInJointspace();
                break;
            }
            case TASKSPACE: {
                this.holdInTaskspace();
                break;
            }
            default: {
                throw new RuntimeException("Default control mode " + this.defaultControlMode.getValue() + " is not an implemented option.");
            }
        }
    }

    public void holdCurrentDesired() {
        switch ((RigidBodyControlMode)this.defaultControlMode.getValue()) {
            case JOINTSPACE: {
                this.holdCurrentDesiredInJointspace();
                break;
            }
            case TASKSPACE: {
                this.holdCurrentDesiredInTaskspace();
                break;
            }
            default: {
                throw new RuntimeException("Default control mode " + this.defaultControlMode.getValue() + " is not an implemented option.");
            }
        }
    }

    public void goToHomeFromCurrent(double trajectoryTime) {
        switch ((RigidBodyControlMode)this.defaultControlMode.getValue()) {
            case JOINTSPACE: {
                this.jointspaceControlState.goHomeFromCurrent(trajectoryTime);
                this.requestState(this.jointspaceControlState.getControlMode());
                break;
            }
            case TASKSPACE: {
                this.taskspaceControlState.goToPoseFromCurrent((FramePose3DReadOnly)this.homePose, trajectoryTime);
                this.requestState(this.taskspaceControlState.getControlMode());
                break;
            }
            default: {
                throw new RuntimeException("Default control mode " + this.defaultControlMode.getValue() + " is not an implemented option.");
            }
        }
    }

    public void goHome(double trajectoryTime) {
        switch ((RigidBodyControlMode)this.defaultControlMode.getValue()) {
            case JOINTSPACE: {
                this.computeDesiredJointPositions(this.initialJointPositions);
                this.jointspaceControlState.goHome(trajectoryTime, this.initialJointPositions);
                this.requestState(this.jointspaceControlState.getControlMode());
                break;
            }
            case TASKSPACE: {
                this.taskspaceControlState.goToPose((FramePose3DReadOnly)this.homePose, trajectoryTime);
                this.requestState(this.taskspaceControlState.getControlMode());
                break;
            }
            default: {
                throw new RuntimeException("Default control mode " + this.defaultControlMode.getValue() + " is not an implemented option.");
            }
        }
    }

    public void handleLoadBearingCommand(LoadBearingCommand command, JointspaceTrajectoryCommand jointspaceCommand) {
        if (this.loadBearingControlState == null) {
            LogTools.warn((String)(this.getClass().getSimpleName() + " for " + this.bodyName + " can not go to load bearing."));
            return;
        }
        if (!command.getLoad()) {
            this.hold();
            return;
        }
        if (jointspaceCommand != null) {
            this.computeDesiredJointPositions(this.initialJointPositions);
            if (!this.loadBearingControlState.handleJointTrajectoryCommand(jointspaceCommand, this.initialJointPositions)) {
                return;
            }
        }
        if (this.loadBearingControlState.handleLoadbearingCommand(command)) {
            this.requestState(this.loadBearingControlState.getControlMode());
        }
    }

    public boolean isLoadBearing() {
        if (this.loadBearingControlState == null) {
            return false;
        }
        return this.stateMachine.getCurrentStateKey() == this.loadBearingControlState.getControlMode();
    }

    public void resetJointIntegrators() {
    }

    private void computeDesiredJointPositions(double[] desiredJointPositionsToPack) {
        if (this.stateMachine.getCurrentStateKey() == this.jointspaceControlState.getControlMode()) {
            for (int i = 0; i < this.jointsToControl.length; ++i) {
                desiredJointPositionsToPack[i] = this.jointspaceControlState.getJointDesiredPosition(i);
            }
        } else {
            for (int i = 0; i < this.jointsToControl.length; ++i) {
                desiredJointPositionsToPack[i] = this.jointsToControl[i].getQ();
            }
        }
    }

    private void requestState(RigidBodyControlMode state) {
        if (this.stateMachine.getCurrentStateKey() != state) {
            this.requestedState.set((Enum)state);
        }
    }

    public RigidBodyControlMode getActiveControlMode() {
        return (RigidBodyControlMode)this.stateMachine.getCurrentStateKey();
    }

    public InverseDynamicsCommand<?> getInverseDynamicsCommand() {
        this.inverseDynamicsCommandList.clear();
        this.inverseDynamicsCommandList.addCommand(((RigidBodyControlState)this.stateMachine.getCurrentState()).getInverseDynamicsCommand());
        this.inverseDynamicsCommandList.addCommand(this.externalWrenchManager.getInverseDynamicsCommand());
        if (this.stateSwitched.getBooleanValue()) {
            RigidBodyControlState previousState = (RigidBodyControlState)this.stateMachine.getPreviousState();
            InverseDynamicsCommand<?> transitionOutOfStateCommand = previousState.getTransitionOutOfStateCommand();
            this.inverseDynamicsCommandList.addCommand(transitionOutOfStateCommand);
        }
        return this.inverseDynamicsCommandList;
    }

    public FeedbackControlCommand<?> getFeedbackControlCommand() {
        return ((RigidBodyControlState)this.stateMachine.getCurrentState()).getFeedbackControlCommand();
    }

    public FeedbackControlCommandList createFeedbackControlTemplate() {
        FeedbackControlCommandList ret = new FeedbackControlCommandList();
        for (RigidBodyControlMode mode : RigidBodyControlMode.values()) {
            RigidBodyControlState state = (RigidBodyControlState)this.stateMachine.getState((Enum)mode);
            if (state == null || state.createFeedbackControlTemplate() == null) continue;
            ret.addCommand(state.createFeedbackControlTemplate());
        }
        return ret;
    }

    public OneDoFJointBasics[] getControlledJoints() {
        return this.jointsToControl;
    }

    public Object pollStatusToReport() {
        return ((RigidBodyControlState)this.stateMachine.getCurrentState()).pollStatusToReport();
    }
}

