/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.pelvis;

import controller_msgs.msg.dds.TaskspaceTrajectoryStatusMessage;
import us.ihmc.commonWalkingControlModules.controlModules.pelvis.PelvisOrientationControlState;
import us.ihmc.commonWalkingControlModules.controlModules.rigidBody.RigidBodyOrientationController;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.momentumBasedController.HighLevelHumanoidControllerToolbox;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.PelvisOrientationTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.SO3TrajectoryControllerCommand;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotics.controllers.pidGains.PID3DGainsReadOnly;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class UserPelvisOrientationManager
implements PelvisOrientationControlState {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final RigidBodyOrientationController orientationController;
    private final ReferenceFrame baseFrame;
    private final FrameQuaternion homeOrientation;

    public UserPelvisOrientationManager(PID3DGainsReadOnly gains, HighLevelHumanoidControllerToolbox controllerToolbox, YoRegistry parentRegistry) {
        RigidBodyBasics pelvis = controllerToolbox.getFullRobotModel().getPelvis();
        RigidBodyBasics elevator = controllerToolbox.getFullRobotModel().getElevator();
        this.baseFrame = controllerToolbox.getReferenceFrames().getMidFootZUpGroundFrame();
        YoDouble yoTime = controllerToolbox.getYoTime();
        this.orientationController = new RigidBodyOrientationController(pelvis, elevator, elevator, this.baseFrame, yoTime, null, this.registry);
        this.orientationController.setGains(gains);
        this.homeOrientation = new FrameQuaternion(this.baseFrame);
        parentRegistry.addChild(this.registry);
    }

    public void setWeights(Vector3DReadOnly angularWeight) {
        this.orientationController.setWeights(angularWeight);
    }

    public void doAction(double timeInState) {
        this.orientationController.doAction(timeInState);
    }

    public boolean handlePelvisOrientationTrajectoryCommands(PelvisOrientationTrajectoryCommand command) {
        SO3TrajectoryControllerCommand so3Trajectory = command.getSO3Trajectory();
        so3Trajectory.setSequenceId(command.getSequenceId());
        return this.orientationController.handleTrajectoryCommand(so3Trajectory);
    }

    @Override
    public void goToHomeFromCurrentDesired(double trajectoryTime) {
        this.orientationController.goToOrientation((FrameQuaternionReadOnly)this.homeOrientation, trajectoryTime);
    }

    @Override
    public FeedbackControlCommand<?> getFeedbackControlCommand() {
        return this.orientationController.getFeedbackControlCommand();
    }

    @Override
    public void onEntry() {
        this.orientationController.onEntry();
    }

    public void onExit(double timeInState) {
        this.orientationController.onExit(timeInState);
    }

    public FrameQuaternionReadOnly getDesiredOrientation() {
        return this.orientationController.getDesiredOrientation();
    }

    public TaskspaceTrajectoryStatusMessage pollStatusToReport() {
        return this.orientationController.pollStatusToReport();
    }
}

