/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.pelvis;

import us.ihmc.commonWalkingControlModules.configurations.PelvisOffsetWhileWalkingParameters;
import us.ihmc.commonWalkingControlModules.momentumBasedController.HighLevelHumanoidControllerToolbox;
import us.ihmc.commons.InterpolationTools;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.humanoidRobotics.footstep.Footstep;
import us.ihmc.robotics.math.filters.RateLimitedYoFrameQuaternion;
import us.ihmc.robotics.referenceFrames.ZUpFrame;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.sensorProcessing.frames.CommonHumanoidReferenceFrames;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameYawPitchRoll;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class PelvisOffsetTrajectoryWhileWalking {
    private static final double maxOrientationRate = 0.8;
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoBoolean isStanding = new YoBoolean("pelvisIsStanding", this.registry);
    private final YoBoolean isInTransfer = new YoBoolean("pelvisInInTransfer", this.registry);
    private final YoBoolean addPelvisOffsetsBasedOnStep = new YoBoolean("addPelvisOffsetsBasedOnStep", this.registry);
    private final YoDouble previousSwingDuration = new YoDouble("pelvisPreviousSwingDuration", this.registry);
    private final YoDouble transferDuration = new YoDouble("pelvisTransferDuration", this.registry);
    private final YoDouble swingDuration = new YoDouble("pelvisSwingDuration", this.registry);
    private final YoDouble nextTransferDuration = new YoDouble("pelvisNextTransferDuration", this.registry);
    private final YoDouble nextSwingDuration = new YoDouble("pelvisNextSwingDuration", this.registry);
    private final YoDouble pelvisYawSineFrequency = new YoDouble("pelvisYawSineFrequency", this.registry);
    private final YoDouble pelvisYawSineMagnitude = new YoDouble("pelvisYawSineMagnitude", this.registry);
    private final YoDouble pelvisYawAngleRatio = new YoDouble("pelvisYawAngleRatio", this.registry);
    private final YoDouble pelvisYawStepLengthThreshold = new YoDouble("pelvisYawStepLengthThreshold", this.registry);
    private final YoDouble pelvisPitchAngleRatio = new YoDouble("pelvisPitchAngleRatio", this.registry);
    private final YoDouble fractionOfSwingPitchingFromUpcomingLeg = new YoDouble("pelvisFractionOfSwingPitchingFromUpcomingLeg", this.registry);
    private final YoDouble fractionOfSwingPitchingFromSwingLeg = new YoDouble("pelvisFractionOfSwingPitchingFromSwingLeg", this.registry);
    private final YoDouble yoTime;
    private final YoDouble timeInState = new YoDouble("pelvisOrientationTimeInState", this.registry);
    private final YoDouble leadingLegAngle = new YoDouble("pelvisPitchLeadingLegAngle", this.registry);
    private final YoDouble trailingLegAngle = new YoDouble("pelvisPitchTrailingLegAngle", this.registry);
    private final YoDouble interpolatedLegAngle = new YoDouble("pelvisPitchInterpolatedLegAngle", this.registry);
    private final YoFrameYawPitchRoll desiredWalkingPelvisOffsetOrientation = new YoFrameYawPitchRoll("desiredWalkingPelvisOffset", worldFrame, this.registry);
    private final RateLimitedYoFrameQuaternion limitedDesiredWalkingPelvisOffsetOrientation;
    private final SideDependentList<? extends ReferenceFrame> soleZUpFrames;
    private final ReferenceFrame nextSoleZUpFrame;
    private final ReferenceFrame nextSoleFrame;
    private final ReferenceFrame pelvisFrame;
    private RobotSide supportSide;
    private Footstep nextFootstep;
    private double initialTime;
    private final FramePoint3D tmpPoint = new FramePoint3D();
    private final FramePoint3D tempPoint = new FramePoint3D();

    public PelvisOffsetTrajectoryWhileWalking(HighLevelHumanoidControllerToolbox controllerToolbox, PelvisOffsetWhileWalkingParameters pelvisOffsetWhileWalkingParameters, YoRegistry parentRegistry) {
        this(controllerToolbox.getYoTime(), controllerToolbox.getReferenceFrames(), pelvisOffsetWhileWalkingParameters, controllerToolbox.getControlDT(), parentRegistry);
    }

    public PelvisOffsetTrajectoryWhileWalking(YoDouble yoTime, CommonHumanoidReferenceFrames referenceFrames, PelvisOffsetWhileWalkingParameters pelvisOffsetWhileWalkingParameters, double controlDT, YoRegistry parentRegistry) {
        this(yoTime, (SideDependentList<? extends ReferenceFrame>)referenceFrames.getSoleZUpFrames(), (ReferenceFrame)referenceFrames.getPelvisFrame(), pelvisOffsetWhileWalkingParameters, controlDT, parentRegistry);
    }

    public PelvisOffsetTrajectoryWhileWalking(YoDouble yoTime, SideDependentList<? extends ReferenceFrame> soleZUpFrames, ReferenceFrame pelvisFrame, PelvisOffsetWhileWalkingParameters pelvisOffsetWhileWalkingParameters, double controlDT, YoRegistry parentRegistry) {
        this.yoTime = yoTime;
        this.soleZUpFrames = soleZUpFrames;
        this.pelvisFrame = pelvisFrame;
        this.nextSoleFrame = new ReferenceFrame("nextSoleFrame", worldFrame){

            protected void updateTransformToParent(RigidBodyTransform transformToParent) {
                PelvisOffsetTrajectoryWhileWalking.this.nextFootstep.getSoleReferenceFrame().getTransformToDesiredFrame(transformToParent, this.getParent());
            }
        };
        this.nextSoleZUpFrame = new ZUpFrame(worldFrame, this.nextSoleFrame, "nextAnkleZUp");
        this.addPelvisOffsetsBasedOnStep.set(pelvisOffsetWhileWalkingParameters.addPelvisOrientationOffsetsFromWalkingMotion());
        this.pelvisPitchAngleRatio.set(pelvisOffsetWhileWalkingParameters.getPelvisPitchRatioOfLegAngle());
        this.pelvisYawAngleRatio.set(pelvisOffsetWhileWalkingParameters.getPelvisYawRatioOfStepAngle());
        this.pelvisYawStepLengthThreshold.set(pelvisOffsetWhileWalkingParameters.getStepLengthToAddYawingMotion());
        this.fractionOfSwingPitchingFromSwingLeg.set(pelvisOffsetWhileWalkingParameters.getFractionOfSwingPitchingFromSwingLeg());
        this.fractionOfSwingPitchingFromUpcomingLeg.set(pelvisOffsetWhileWalkingParameters.getFractionOfSwingPitchingFromUpcomingLeg());
        YoDouble maxPelvisOrientationRate = new YoDouble("pelvisMaxOrientationRate", this.registry);
        maxPelvisOrientationRate.set(0.8);
        this.limitedDesiredWalkingPelvisOffsetOrientation = new RateLimitedYoFrameQuaternion("desiredWalkingPelvisOffset", "Limited", this.registry, (DoubleProvider)maxPelvisOrientationRate, controlDT, this.desiredWalkingPelvisOffsetOrientation.getReferenceFrame());
        parentRegistry.addChild(this.registry);
    }

    public void setUpcomingFootstep(Footstep upcomingFootstep) {
        this.nextFootstep = upcomingFootstep;
        this.supportSide = upcomingFootstep.getRobotSide().getOppositeSide();
        this.updateFrames();
    }

    public void initializeStanding() {
        this.isStanding.set(true);
        this.isInTransfer.set(false);
        this.reset();
    }

    public void initializeTransfer(RobotSide transferToSide, double transferDuration, double swingDuration) {
        this.supportSide = transferToSide;
        this.transferDuration.set(transferDuration);
        this.previousSwingDuration.set(this.swingDuration.getDoubleValue());
        this.swingDuration.set(swingDuration);
        this.initialTime = this.yoTime.getDoubleValue();
        this.tmpPoint.setToZero((ReferenceFrame)this.soleZUpFrames.get((Enum)transferToSide));
        this.tmpPoint.changeFrame((ReferenceFrame)this.soleZUpFrames.get((Enum)transferToSide.getOppositeSide()));
        double stepAngle = this.computeStepAngle(this.tmpPoint, transferToSide);
        double pelvisYawSineMagnitude = this.pelvisYawAngleRatio.getDoubleValue() * stepAngle;
        double initialPelvisDesiredYaw = this.desiredWalkingPelvisOffsetOrientation.getYaw();
        double pelvisYawSineFrequency = 0.0;
        if (pelvisYawSineMagnitude != initialPelvisDesiredYaw) {
            pelvisYawSineFrequency = 1.0 / (Math.PI * 2 * transferDuration) * Math.asin(-initialPelvisDesiredYaw / pelvisYawSineMagnitude);
        }
        this.pelvisYawSineMagnitude.set(pelvisYawSineMagnitude);
        this.pelvisYawSineFrequency.set(pelvisYawSineFrequency);
        this.isStanding.set(false);
        this.isInTransfer.set(true);
    }

    public void initializeSwing(RobotSide supportSide, double currentSwingDuration, double nextTransferDuration, double nextSwingDuration) {
        this.supportSide = supportSide;
        this.swingDuration.set(currentSwingDuration);
        this.nextTransferDuration.set(nextTransferDuration);
        this.nextSwingDuration.set(nextSwingDuration);
        this.initialTime = this.yoTime.getDoubleValue();
        this.tmpPoint.setToZero(this.nextSoleFrame);
        this.tmpPoint.changeFrame((ReferenceFrame)this.soleZUpFrames.get((Enum)supportSide));
        double stepAngle = this.computeStepAngle(this.tmpPoint, supportSide);
        double pelvisYawSineMagnitude = this.pelvisYawAngleRatio.getDoubleValue() * stepAngle;
        double stepDuration = this.transferDuration.getDoubleValue() + currentSwingDuration;
        double pelvisYawSineFrequency = 1.0 / (2.0 * stepDuration);
        this.pelvisYawSineMagnitude.set(pelvisYawSineMagnitude);
        this.pelvisYawSineFrequency.set(pelvisYawSineFrequency);
        this.isStanding.set(false);
        this.isInTransfer.set(false);
    }

    public void update() {
        if (this.isStanding.getBooleanValue() || !this.addPelvisOffsetsBasedOnStep.getBooleanValue()) {
            this.desiredWalkingPelvisOffsetOrientation.setToZero();
        } else {
            this.timeInState.set(this.yoTime.getDoubleValue() - this.initialTime);
            if (this.isInTransfer.getBooleanValue()) {
                this.updatePelvisPitchOffsetInTransfer(this.supportSide);
            } else {
                this.updateFrames();
                this.updatePelvisPitchOffsetInSwing(this.supportSide);
            }
            this.updatePelvisYaw();
        }
        this.limitedDesiredWalkingPelvisOffsetOrientation.update((FrameOrientation3DReadOnly)this.desiredWalkingPelvisOffsetOrientation);
    }

    public void addAngularOffset(FrameQuaternion orientationToPack) {
        orientationToPack.preMultiply((FrameQuaternionReadOnly)this.limitedDesiredWalkingPelvisOffsetOrientation);
    }

    private void updateFrames() {
        this.nextSoleFrame.update();
        this.nextSoleZUpFrame.update();
    }

    private void reset() {
        this.swingDuration.set(0.0);
        this.transferDuration.set(0.0);
        this.nextTransferDuration.set(0.0);
    }

    private double computeStepAngle(FramePoint3D footLocation, RobotSide supportSide) {
        double stepAngle = 0.0;
        if (Math.abs(footLocation.getX()) > this.pelvisYawStepLengthThreshold.getDoubleValue()) {
            stepAngle = Math.atan2(footLocation.getX(), Math.abs(footLocation.getY()));
        }
        return supportSide.negateIfRightSide(stepAngle);
    }

    private void updatePelvisPitchOffsetInTransfer(RobotSide transferToSide) {
        double leadingLegAngle = this.computeAngleFromSoleToPelvis((ReferenceFrame)this.soleZUpFrames.get((Enum)transferToSide));
        this.leadingLegAngle.set(leadingLegAngle);
        double trailingLegAngle = this.computeAngleFromSoleToPelvis((ReferenceFrame)this.soleZUpFrames.get((Enum)transferToSide.getOppositeSide()));
        this.trailingLegAngle.set(trailingLegAngle);
        double timeSpentOnPreviousSwing = this.fractionOfSwingPitchingFromUpcomingLeg.getDoubleValue() * this.previousSwingDuration.getDoubleValue();
        double timeSpentOnNextSwing = this.fractionOfSwingPitchingFromSwingLeg.getDoubleValue() * this.swingDuration.getDoubleValue();
        double timeInInterpolation = this.timeInState.getDoubleValue() + timeSpentOnPreviousSwing;
        double totalInterpolationTime = timeSpentOnPreviousSwing + this.transferDuration.getDoubleValue() + timeSpentOnNextSwing;
        double ratioInInterpolation = timeInInterpolation / totalInterpolationTime;
        double interpolatedLegAngle = InterpolationTools.hermiteInterpolate((double)trailingLegAngle, (double)leadingLegAngle, (double)ratioInInterpolation);
        this.interpolatedLegAngle.set(interpolatedLegAngle);
        double desiredPitch = this.pelvisPitchAngleRatio.getDoubleValue() * interpolatedLegAngle;
        this.desiredWalkingPelvisOffsetOrientation.setPitch(desiredPitch);
    }

    private void updatePelvisPitchOffsetInSwing(RobotSide supportSide) {
        double interpolatedLegAngle;
        double swingLegAngle;
        double trailingLegAngle = this.computeAngleFromSoleToPelvis((ReferenceFrame)this.soleZUpFrames.get((Enum)supportSide));
        this.trailingLegAngle.set(trailingLegAngle);
        double ratioInState = this.timeInState.getDoubleValue() / this.swingDuration.getDoubleValue();
        if (ratioInState < this.fractionOfSwingPitchingFromSwingLeg.getDoubleValue()) {
            double timeSpentOnPreviousSwing = this.fractionOfSwingPitchingFromUpcomingLeg.getDoubleValue() * this.previousSwingDuration.getDoubleValue();
            double timeSpentOnCurrentSwing = this.fractionOfSwingPitchingFromSwingLeg.getDoubleValue() * this.swingDuration.getDoubleValue();
            double timeInInterpolation = this.timeInState.getDoubleValue() + timeSpentOnPreviousSwing + this.transferDuration.getDoubleValue();
            double totalInterpolationTime = timeSpentOnPreviousSwing + this.transferDuration.getDoubleValue() + timeSpentOnCurrentSwing;
            double ratioInInterpolation = timeInInterpolation / totalInterpolationTime;
            swingLegAngle = this.computeAngleFromSoleToPelvis((ReferenceFrame)this.soleZUpFrames.get((Enum)supportSide.getOppositeSide()));
            interpolatedLegAngle = InterpolationTools.hermiteInterpolate((double)swingLegAngle, (double)trailingLegAngle, (double)ratioInInterpolation);
        } else if (ratioInState > 1.0 - this.fractionOfSwingPitchingFromUpcomingLeg.getDoubleValue()) {
            double timeSpentOnCurrentSwing = this.fractionOfSwingPitchingFromUpcomingLeg.getDoubleValue() * this.swingDuration.getDoubleValue();
            double timeSpentOnNextSwing = this.fractionOfSwingPitchingFromSwingLeg.getDoubleValue() * this.nextSwingDuration.getDoubleValue();
            double timeInInterpolation = this.timeInState.getDoubleValue() - (this.swingDuration.getDoubleValue() - timeSpentOnCurrentSwing);
            double totalInterpolationTime = timeSpentOnCurrentSwing + this.nextTransferDuration.getDoubleValue() + timeSpentOnNextSwing;
            double ratioInInterpolation = timeInInterpolation / totalInterpolationTime;
            swingLegAngle = this.computeAngleFromSoleToPelvis(this.nextSoleZUpFrame);
            interpolatedLegAngle = InterpolationTools.hermiteInterpolate((double)trailingLegAngle, (double)swingLegAngle, (double)ratioInInterpolation);
        } else {
            swingLegAngle = 0.0;
            interpolatedLegAngle = trailingLegAngle;
        }
        double desiredPitch = this.pelvisPitchAngleRatio.getDoubleValue() * interpolatedLegAngle;
        this.interpolatedLegAngle.set(interpolatedLegAngle);
        this.leadingLegAngle.set(swingLegAngle);
        this.desiredWalkingPelvisOffsetOrientation.setPitch(desiredPitch);
    }

    private double computeAngleFromSoleToPelvis(ReferenceFrame soleFrame) {
        this.tempPoint.setToZero(this.pelvisFrame);
        this.tempPoint.changeFrame(soleFrame);
        double distanceFromSupportFoot = this.tempPoint.getX();
        double heightFromSupportFoot = this.tempPoint.getZ();
        return Math.atan2(distanceFromSupportFoot, heightFromSupportFoot);
    }

    private void updatePelvisYaw() {
        double timeInSine = this.timeInState.getDoubleValue();
        if (this.isInTransfer.getBooleanValue()) {
            timeInSine -= this.transferDuration.getDoubleValue();
        }
        double radiansPerSecond = this.pelvisYawSineFrequency.getDoubleValue() * Math.PI * 2.0;
        double desiredYaw = this.pelvisYawSineMagnitude.getDoubleValue() * Math.sin(timeInSine * radiansPerSecond);
        this.desiredWalkingPelvisOffsetOrientation.setYaw(desiredYaw);
    }
}

