/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.pelvis;

import controller_msgs.msg.dds.TaskspaceTrajectoryStatusMessage;
import us.ihmc.commonWalkingControlModules.controlModules.TaskspaceTrajectoryStatusMessageHelper;
import us.ihmc.commonWalkingControlModules.controlModules.foot.FeetManager;
import us.ihmc.commonWalkingControlModules.controlModules.pelvis.PelvisAndCenterOfMassHeightControlState;
import us.ihmc.commonWalkingControlModules.controlModules.rigidBody.RigidBodyPositionController;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.PointFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.momentumBasedController.HighLevelHumanoidControllerToolbox;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.EuclideanTrajectoryControllerCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.PelvisHeightTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.PelvisTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.SE3TrajectoryControllerCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.StopAllTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.converter.CommandConversionTools;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.controllers.pidGains.PID3DGainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.PIDGainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.implementations.SymmetricPID3DGains;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.screwTheory.SelectionMatrix3D;
import us.ihmc.sensorProcessing.frames.CommonHumanoidReferenceFrames;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class PelvisHeightControlState
implements PelvisAndCenterOfMassHeightControlState {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final SelectionMatrix3D temp3DSelection = new SelectionMatrix3D();
    private final EuclideanTrajectoryControllerCommand euclideanCommand = new EuclideanTrajectoryControllerCommand();
    private final RigidBodyPositionController positionController;
    private final RigidBodyBasics pelvis;
    private final MovingReferenceFrame pelvisFrame;
    private final ReferenceFrame baseFrame;
    private final DoubleProvider defaultHeight;
    private final DoubleProvider minHeight;
    private final DoubleProvider offset;
    private final DoubleProvider offsetTrajectoryTime;
    private double previousOffset = 0.0;
    private final FramePoint3D tempPosition = new FramePoint3D();
    private final SymmetricPID3DGains symmetric3DGains = new SymmetricPID3DGains();
    private final SideDependentList<MovingReferenceFrame> ankleFrames;
    private final DoubleProvider maxDistanceAnklePelvis;
    private final YoBoolean adjustedDesiredForSingularity;
    private final YoDouble adjustmentAmount;
    private final FramePoint3D pelvisPosition = new FramePoint3D();
    private final FramePoint3D anklePosition = new FramePoint3D();
    private final Vector3D ankleToPelvis = new Vector3D();
    private final Vector3D zAxis = new Vector3D(0.0, 0.0, 1.0);
    private RobotSide swingSide = null;
    private double toeOffHeight = 0.0;
    private final EuclideanTrajectoryControllerCommand command = new EuclideanTrajectoryControllerCommand();
    private final Vector3D zeroVelocity = new Vector3D();
    private final Point3D trajectoryPoint = new Point3D();
    private final FramePoint3D statusDesiredPosition = new FramePoint3D();
    private final FramePoint3D statusActualPosition = new FramePoint3D();
    private final TaskspaceTrajectoryStatusMessageHelper statusHelper = new TaskspaceTrajectoryStatusMessageHelper("pelvisHeight");
    private final FrameVector3D feedForwardLinearAcceleration = new FrameVector3D();

    public PelvisHeightControlState(HighLevelHumanoidControllerToolbox controllerToolbox, YoRegistry parentRegistry) {
        FullHumanoidRobotModel fullRobotModel = controllerToolbox.getFullRobotModel();
        RigidBodyBasics elevator = fullRobotModel.getElevator();
        CommonHumanoidReferenceFrames referenceFrames = controllerToolbox.getReferenceFrames();
        this.pelvis = fullRobotModel.getPelvis();
        this.pelvisFrame = referenceFrames.getPelvisFrame();
        this.baseFrame = elevator.getBodyFixedFrame();
        YoDouble yoTime = controllerToolbox.getYoTime();
        YoGraphicsListRegistry graphicsListRegistry = controllerToolbox.getYoGraphicsListRegistry();
        this.positionController = new RigidBodyPositionController(this.pelvis, elevator, elevator, (ReferenceFrame)this.pelvisFrame, this.baseFrame, yoTime, this.registry, graphicsListRegistry);
        this.defaultHeight = new DoubleParameter(this.getClass().getSimpleName() + "DefaultHeight", this.registry);
        this.minHeight = new DoubleParameter(this.getClass().getSimpleName() + "MinHeight", this.registry, 0.0);
        this.maxDistanceAnklePelvis = new DoubleParameter(this.getClass().getSimpleName() + "MaxDistanceAnklePelvis", this.registry, Double.POSITIVE_INFINITY);
        this.offset = new DoubleParameter(this.getClass().getSimpleName() + "Offset", this.registry, 0.0);
        this.offsetTrajectoryTime = new DoubleParameter(this.getClass().getSimpleName() + "OffsetTrajectoryTime", this.registry, 0.5);
        this.ankleFrames = controllerToolbox.getReferenceFrames().getAnkleZUpReferenceFrames();
        this.adjustedDesiredForSingularity = new YoBoolean("AdjustedDesiredForSingularity", this.registry);
        this.adjustmentAmount = new YoDouble("AdjustmentAmount", this.registry);
        parentRegistry.addChild(this.registry);
    }

    @Override
    public void initialize() {
    }

    public void setGains(PIDGainsReadOnly gains) {
        this.symmetric3DGains.setGains(gains);
        this.positionController.setGains((PID3DGainsReadOnly)this.symmetric3DGains);
    }

    public void step(Point3DReadOnly stanceFootPosition, Point3DReadOnly touchdownPosition, double swingTime, RobotSide swingSide, double toeOffHeight) {
        this.swingSide = swingSide;
        this.toeOffHeight = toeOffHeight;
        double r = this.defaultHeight.getValue();
        double x_incl = 0.5 * stanceFootPosition.distance(touchdownPosition);
        double z_incl = Math.sqrt(r * r - x_incl * x_incl);
        double stepLength = stanceFootPosition.distanceXY(touchdownPosition);
        double zTouchdown = touchdownPosition.getZ();
        double stepHeight = zTouchdown - stanceFootPosition.getZ();
        double inclination = Math.atan2(stepHeight, stepLength);
        double x = Math.cos(inclination) * x_incl - Math.sin(inclination) * z_incl;
        double z = Math.sin(inclination) * x_incl + Math.cos(inclination) * z_incl + toeOffHeight;
        MathTools.clamp((double)z, (double)this.minHeight.getValue(), (double)Double.POSITIVE_INFINITY);
        double alpha = x / stanceFootPosition.distanceXY(touchdownPosition);
        alpha = MathTools.clamp((double)alpha, (double)0.0, (double)1.0);
        double zInWorld = stanceFootPosition.getZ() + z;
        zInWorld = MathTools.clamp((double)zInWorld, (double)(zTouchdown + this.minHeight.getValue()), (double)Double.POSITIVE_INFINITY);
        this.goToHeight(zInWorld, swingTime);
    }

    public void transfer(Point3DReadOnly transferPosition, double transferTime, RobotSide swingSide, double toeOffHeight) {
        this.swingSide = swingSide;
        this.toeOffHeight = toeOffHeight;
        double desiredHeight = transferPosition.getZ() + this.defaultHeight.getValue();
        this.goToHeight(desiredHeight, transferTime);
    }

    private void goToHeight(double desiredHeight, double time) {
        double offsetDesiredHeight = desiredHeight + this.offset.getValue();
        double adjustedDesiredHeight = this.avoidSingularities(offsetDesiredHeight);
        this.command.clear();
        this.trajectoryPoint.setToZero();
        this.trajectoryPoint.setZ(adjustedDesiredHeight);
        this.command.addTrajectoryPoint(time, (Point3DReadOnly)this.trajectoryPoint, (Vector3DReadOnly)this.zeroVelocity);
        this.positionController.handleTrajectoryCommand(this.command);
    }

    private double avoidSingularities(double height) {
        this.pelvisPosition.setToZero((ReferenceFrame)this.pelvisFrame);
        this.pelvisPosition.changeFrame(ReferenceFrame.getWorldFrame());
        this.pelvisPosition.setZ(height);
        boolean heightWasAdjusted = false;
        double adjustment = 0.0;
        for (int sideIdx = 0; sideIdx < RobotSide.values.length; ++sideIdx) {
            double distanceAnkleDesiredPelvis;
            double adjustmentAlongLeg;
            RobotSide side = RobotSide.values[sideIdx];
            this.anklePosition.setToZero((ReferenceFrame)this.ankleFrames.get((Enum)side));
            this.anklePosition.changeFrame(ReferenceFrame.getWorldFrame());
            double maxDistance = this.maxDistanceAnklePelvis.getValue();
            if (side == this.swingSide) {
                maxDistance += this.toeOffHeight;
            }
            if (!((adjustmentAlongLeg = (distanceAnkleDesiredPelvis = this.anklePosition.distance((FramePoint3DReadOnly)this.pelvisPosition)) - maxDistance) > 0.0)) continue;
            this.ankleToPelvis.sub((Tuple3DReadOnly)this.pelvisPosition, (Tuple3DReadOnly)this.anklePosition);
            double adjustmentAlongZ = adjustmentAlongLeg / Math.abs(Math.cos(this.ankleToPelvis.dot((Vector3DReadOnly)this.zAxis)));
            adjustment = Math.max(adjustment, adjustmentAlongZ);
            heightWasAdjusted = true;
        }
        this.adjustmentAmount.set(adjustment);
        this.adjustedDesiredForSingularity.set(heightWasAdjusted);
        return this.pelvisPosition.getZ() - adjustment;
    }

    public void setWeights(Vector3DReadOnly linearWeight) {
        this.positionController.setWeights(linearWeight);
    }

    public void doAction(double timeInState) {
        if (this.offset.getValue() != this.previousOffset) {
            double desiredZInworld = this.positionController.getFeedbackControlCommand().getReferencePosition().getZ();
            double currentDesired = desiredZInworld + this.adjustmentAmount.getValue();
            this.goToHeight(currentDesired - this.previousOffset, this.offsetTrajectoryTime.getValue());
        }
        this.previousOffset = this.offset.getValue();
        this.positionController.doAction(Double.NaN);
        this.statusHelper.updateWithTimeInTrajectory(this.positionController.getTimeInTrajectory());
    }

    public void onExit(double timeInState) {
        this.positionController.onExit();
    }

    public boolean handlePelvisHeightTrajectoryCommand(PelvisHeightTrajectoryCommand command) {
        EuclideanTrajectoryControllerCommand euclideanTrajectory = command.getEuclideanTrajectory();
        if (this.positionController.handleTrajectoryCommand(euclideanTrajectory)) {
            euclideanTrajectory.setSequenceId(command.getSequenceId());
            this.statusHelper.registerNewTrajectory(euclideanTrajectory);
            return true;
        }
        this.initializeDesiredHeightToCurrent();
        return false;
    }

    public boolean handlePelvisTrajectoryCommand(PelvisTrajectoryCommand command) {
        CommandConversionTools.convertToEuclidean((SE3TrajectoryControllerCommand)command.getSE3Trajectory(), (EuclideanTrajectoryControllerCommand)this.euclideanCommand);
        ReferenceFrame selectionFrame = this.euclideanCommand.getSelectionMatrix().getSelectionFrame();
        if (selectionFrame != null && !selectionFrame.isZupFrame()) {
            LogTools.warn((String)"Pelvis linear selection matrix must be z-up!");
            return false;
        }
        this.euclideanCommand.getSelectionMatrix().selectXAxis(false);
        this.euclideanCommand.getSelectionMatrix().selectYAxis(false);
        this.euclideanCommand.getSelectionMatrix().setSelectionFrame(ReferenceFrame.getWorldFrame());
        ReferenceFrame weightFrame = this.euclideanCommand.getWeightMatrix().getWeightFrame();
        if (weightFrame != null && !weightFrame.isZupFrame()) {
            LogTools.warn((String)"Pelvis linear weight matrix must be z-up!");
            return false;
        }
        this.euclideanCommand.getWeightMatrix().setXAxisWeight(0.0);
        this.euclideanCommand.getWeightMatrix().setYAxisWeight(0.0);
        this.euclideanCommand.getWeightMatrix().setWeightFrame(ReferenceFrame.getWorldFrame());
        if (this.positionController.handleTrajectoryCommand(this.euclideanCommand)) {
            this.euclideanCommand.setSequenceId(command.getSequenceId());
            this.statusHelper.registerNewTrajectory(this.euclideanCommand);
            return true;
        }
        this.initializeDesiredHeightToCurrent();
        return false;
    }

    @Override
    public void initializeDesiredHeightToCurrent() {
        this.positionController.holdCurrent();
    }

    @Override
    public void goHome(double trajectoryTime) {
        this.tempPosition.setToZero(this.baseFrame);
        this.tempPosition.setZ(this.defaultHeight.getValue());
        this.positionController.goToPositionFromCurrent((FramePoint3DReadOnly)this.tempPosition, trajectoryTime);
    }

    @Override
    public void handleStopAllTrajectoryCommand(StopAllTrajectoryCommand command) {
        if (command.isStopAllTrajectory()) {
            this.initializeDesiredHeightToCurrent();
        }
    }

    public PointFeedbackControlCommand getFeedbackControlCommand() {
        PointFeedbackControlCommand feedbackCommand = this.positionController.getFeedbackControlCommand();
        this.feedForwardLinearAcceleration.setIncludingFrame((FrameTuple3DReadOnly)feedbackCommand.getReferenceLinearAcceleration());
        this.feedForwardLinearAcceleration.setX(0.0);
        this.feedForwardLinearAcceleration.setY(0.0);
        feedbackCommand.getReferenceLinearAcceleration().set((FrameTuple3DReadOnly)this.feedForwardLinearAcceleration);
        this.temp3DSelection.clearSelection();
        this.temp3DSelection.setSelectionFrame(ReferenceFrame.getWorldFrame());
        this.temp3DSelection.selectZAxis(true);
        feedbackCommand.setSelectionMatrix(this.temp3DSelection);
        return feedbackCommand;
    }

    @Override
    public void computeCoMHeightCommand(FrameVector2DReadOnly desiredICPVelocity, FrameVector2DReadOnly desiredCoMVelocity, boolean isInDoubleSupport, double omega0, boolean isRecoveringFromPush, FeetManager feetManager) {
    }

    @Override
    public TaskspaceTrajectoryStatusMessage pollStatusToReport() {
        this.statusDesiredPosition.setIncludingFrame((FrameTuple3DReadOnly)this.positionController.getFeedbackControlCommand().getReferencePosition());
        this.statusDesiredPosition.setX(Double.NaN);
        this.statusDesiredPosition.setY(Double.NaN);
        this.statusActualPosition.setIncludingFrame((FrameTuple3DReadOnly)this.positionController.getFeedbackControlCommand().getBodyFixedPointToControl());
        this.statusActualPosition.changeFrame(ReferenceFrame.getWorldFrame());
        this.statusActualPosition.setX(Double.NaN);
        this.statusActualPosition.setY(Double.NaN);
        return this.statusHelper.pollStatusMessage((FramePoint3DReadOnly)this.statusDesiredPosition, (FramePoint3DReadOnly)this.statusActualPosition);
    }

    @Override
    public FeedbackControlCommand<?> getHeightControlCommand() {
        return this.positionController.getFeedbackControlCommand();
    }

    @Override
    public boolean getControlHeightWithMomentum() {
        return false;
    }
}

