/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.pelvis;

import controller_msgs.msg.dds.TaskspaceTrajectoryStatusMessage;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.controlModules.TaskspaceTrajectoryStatusMessageHelper;
import us.ihmc.commonWalkingControlModules.controlModules.foot.FeetManager;
import us.ihmc.commonWalkingControlModules.controlModules.pelvis.PelvisAndCenterOfMassHeightControlState;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.CenterOfMassFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.PointFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.desiredFootStep.TransferToAndNextFootstepsData;
import us.ihmc.commonWalkingControlModules.heightPlanning.CoMHeightPartialDerivativesDataBasics;
import us.ihmc.commonWalkingControlModules.heightPlanning.CoMHeightTimeDerivativesCalculator;
import us.ihmc.commonWalkingControlModules.heightPlanning.CoMHeightTimeDerivativesSmoother;
import us.ihmc.commonWalkingControlModules.heightPlanning.LookAheadCoMHeightTrajectoryGenerator;
import us.ihmc.commonWalkingControlModules.heightPlanning.YoCoMHeightPartialDerivativesData;
import us.ihmc.commonWalkingControlModules.heightPlanning.YoCoMHeightTimeDerivativesData;
import us.ihmc.commonWalkingControlModules.momentumBasedController.HighLevelHumanoidControllerToolbox;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.EuclideanTrajectoryControllerCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.PelvisHeightTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.PelvisTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.SE3TrajectoryControllerCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.StopAllTrajectoryCommand;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.algorithms.CenterOfMassJacobian;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.TwistBasics;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.controllers.pidGains.PDGainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.PID3DGains;
import us.ihmc.robotics.controllers.pidGains.PID3DGainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.implementations.DefaultPID3DGains;
import us.ihmc.robotics.partNames.LegJointName;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.screwTheory.SelectionMatrix3D;
import us.ihmc.sensorProcessing.frames.CommonHumanoidReferenceFrames;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class CenterOfMassHeightControlState
implements PelvisAndCenterOfMassHeightControlState {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoBoolean controlPelvisHeightInsteadOfCoMHeight = new YoBoolean("controlPelvisHeightInsteadOfCoMHeight", this.registry);
    private final YoBoolean controlHeightWithMomentum = new YoBoolean("controlHeightWithMomentum", this.registry);
    private final CoMHeightTimeDerivativesSmoother comHeightTimeDerivativesSmoother;
    private final YoDouble desiredCoMHeightFromTrajectory = new YoDouble("desiredCoMHeightFromTrajectory", this.registry);
    private final YoDouble desiredCoMHeightVelocityFromTrajectory = new YoDouble("desiredCoMHeightVelocityFromTrajectory", this.registry);
    private final YoDouble desiredCoMHeightAccelerationFromTrajectory = new YoDouble("desiredCoMHeightAccelerationFromTrajectory", this.registry);
    private final YoDouble desiredCoMHeightJerkFromTrajectory = new YoDouble("desiredCoMHeightJerkFromTrajectory", this.registry);
    private final YoDouble desiredCoMHeightCorrected = new YoDouble("desiredCoMHeightCorrected", this.registry);
    private final YoDouble desiredCoMHeightVelocityCorrected = new YoDouble("desiredCoMHeightVelocityCorrected", this.registry);
    private final YoDouble desiredCoMHeightAccelerationCorrected = new YoDouble("desiredCoMHeightAccelerationCorrected", this.registry);
    private final YoDouble desiredCoMHeightAfterSmoothing = new YoDouble("desiredCoMHeightAfterSmoothing", this.registry);
    private final YoDouble desiredCoMHeightVelocityAfterSmoothing = new YoDouble("desiredCoMHeightVelocityAfterSmoothing", this.registry);
    private final YoDouble desiredCoMHeightAccelerationAfterSmoothing = new YoDouble("desiredCoMHeightAccelerationAfterSmoothing", this.registry);
    private final YoDouble desiredCoMHeightJerkAfterSmoothing = new YoDouble("desiredCoMHeightJerkAfterSmoothing", this.registry);
    private final DoubleProvider currentTime;
    private final YoDouble transitionDurationToFall = new YoDouble("comHeightTransitionDurationToFall", this.registry);
    private final YoDouble transitionToFallStartTime = new YoDouble("comHeightTransitionToFallStartTime", this.registry);
    private final YoDouble fallActivationRatio = new YoDouble("comHeightFallActivationRatio", this.registry);
    private final DoubleProvider fallAccelerationMagnitude = new DoubleParameter("comHeightFallAccelerationMagnitude", this.registry, 5.0);
    private final ReferenceFrame centerOfMassFrame;
    private final CenterOfMassJacobian centerOfMassJacobian;
    private final MovingReferenceFrame pelvisFrame;
    private final LookAheadCoMHeightTrajectoryGenerator centerOfMassTrajectoryGenerator;
    private final FramePoint3D statusDesiredPosition = new FramePoint3D();
    private final FramePoint3D statusActualPosition = new FramePoint3D();
    private final TaskspaceTrajectoryStatusMessageHelper statusHelper = new TaskspaceTrajectoryStatusMessageHelper("pelvisHeight");
    private final PointFeedbackControlCommand pelvisHeightControlCommand = new PointFeedbackControlCommand();
    private final CenterOfMassFeedbackControlCommand comHeightControlCommand = new CenterOfMassFeedbackControlCommand();
    private Vector3DReadOnly pelvisTaskpaceFeedbackWeight;
    private final FramePoint3D desiredPosition = new FramePoint3D();
    private final FrameVector3D desiredVelocity = new FrameVector3D();
    private final FrameVector3D desiredAcceleration = new FrameVector3D();
    private PDGainsReadOnly gains;
    private final CoMHeightPartialDerivativesDataBasics comHeightPartialDerivatives = new YoCoMHeightPartialDerivativesData(this.registry);
    private final FramePoint3D comPosition = new FramePoint3D();
    private final FrameVector3D comVelocity = new FrameVector3D(worldFrame);
    private final FrameVector2D comXYVelocity = new FrameVector2D();
    private final FrameVector2D desiredComAcceleration = new FrameVector2D();
    private final YoCoMHeightTimeDerivativesData comHeightDataBeforeSmoothing = new YoCoMHeightTimeDerivativesData("beforeSmoothing", this.registry);
    private final YoCoMHeightTimeDerivativesData comHeightDataAfterSmoothing = new YoCoMHeightTimeDerivativesData("afterSmoothing", this.registry);
    private final YoCoMHeightTimeDerivativesData comHeightDataAfterSingularityAvoidance = new YoCoMHeightTimeDerivativesData("afterSingularityAvoidance", this.registry);
    private final YoCoMHeightTimeDerivativesData comHeightDataAfterUnreachableFootstep = new YoCoMHeightTimeDerivativesData("afterUnreachableFootstep", this.registry);
    private final YoCoMHeightTimeDerivativesData finalComHeightData = new YoCoMHeightTimeDerivativesData("finalComHeightData", this.registry);
    private final FramePoint3D desiredCenterOfMassHeightPoint = new FramePoint3D(worldFrame);
    private final FramePoint3D pelvisPosition = new FramePoint3D();
    private final Twist currentPelvisTwist = new Twist();
    private boolean desiredCMPcontainedNaN = false;
    private final DefaultPID3DGains gainsTemp = new DefaultPID3DGains();

    public CenterOfMassHeightControlState(HighLevelHumanoidControllerToolbox controllerToolbox, WalkingControllerParameters walkingControllerParameters, YoRegistry parentRegistry) {
        CommonHumanoidReferenceFrames referenceFrames = controllerToolbox.getReferenceFrames();
        FullHumanoidRobotModel fullRobotModel = controllerToolbox.getFullRobotModel();
        this.centerOfMassFrame = referenceFrames.getCenterOfMassFrame();
        this.centerOfMassJacobian = controllerToolbox.getCenterOfMassJacobian();
        this.pelvisFrame = referenceFrames.getPelvisFrame();
        this.centerOfMassTrajectoryGenerator = this.createTrajectoryGenerator(controllerToolbox, walkingControllerParameters, referenceFrames);
        this.controlPelvisHeightInsteadOfCoMHeight.set(walkingControllerParameters.controlPelvisHeightInsteadOfCoMHeight());
        this.controlHeightWithMomentum.set(walkingControllerParameters.controlHeightWithMomentum());
        double controlDT = controllerToolbox.getControlDT();
        this.comHeightTimeDerivativesSmoother = new CoMHeightTimeDerivativesSmoother(controlDT, this.registry);
        this.currentTime = controllerToolbox.getYoTime();
        SelectionMatrix3D selectionMatrix = new SelectionMatrix3D(worldFrame, false, false, true);
        this.pelvisHeightControlCommand.set(fullRobotModel.getElevator(), fullRobotModel.getPelvis());
        FramePoint3D pelvisPoint = new FramePoint3D((ReferenceFrame)this.pelvisFrame);
        pelvisPoint.changeFrame((ReferenceFrame)fullRobotModel.getPelvis().getBodyFixedFrame());
        this.pelvisHeightControlCommand.setBodyFixedPointToControl((FramePoint3DReadOnly)pelvisPoint);
        this.pelvisHeightControlCommand.setSelectionMatrix(selectionMatrix);
        this.comHeightControlCommand.setSelectionMatrix(selectionMatrix);
        parentRegistry.addChild(this.registry);
    }

    public LookAheadCoMHeightTrajectoryGenerator createTrajectoryGenerator(HighLevelHumanoidControllerToolbox controllerToolbox, WalkingControllerParameters walkingControllerParameters, CommonHumanoidReferenceFrames referenceFrames) {
        double ankleToGround = Double.NEGATIVE_INFINITY;
        for (RobotSide robotSide : RobotSide.values) {
            RigidBodyBasics foot = controllerToolbox.getFullRobotModel().getFoot((Enum)robotSide);
            MovingReferenceFrame ankleFrame = foot.getParentJoint().getFrameAfterJoint();
            MovingReferenceFrame soleFrame = referenceFrames.getSoleFrame((Enum)robotSide);
            RigidBodyTransform ankleToSole = new RigidBodyTransform();
            ankleFrame.getTransformToDesiredFrame(ankleToSole, (ReferenceFrame)soleFrame);
            ankleToGround = Math.max(ankleToGround, Math.abs(ankleToSole.getTranslationZ()));
        }
        FramePoint3D leftHipPitch = new FramePoint3D((ReferenceFrame)controllerToolbox.getFullRobotModel().getLegJoint((Enum)RobotSide.LEFT, LegJointName.HIP_PITCH).getFrameAfterJoint());
        FramePoint3D rightHipPitch = new FramePoint3D((ReferenceFrame)controllerToolbox.getFullRobotModel().getLegJoint((Enum)RobotSide.RIGHT, LegJointName.HIP_PITCH).getFrameAfterJoint());
        leftHipPitch.changeFrame(controllerToolbox.getPelvisZUpFrame());
        rightHipPitch.changeFrame(controllerToolbox.getPelvisZUpFrame());
        double hipWidth = leftHipPitch.getY() - rightHipPitch.getY();
        double minimumHeightAboveGround = walkingControllerParameters.minimumHeightAboveAnkle() + ankleToGround;
        double nominalHeightAboveGround = walkingControllerParameters.nominalHeightAboveAnkle() + ankleToGround;
        double maximumHeightAboveGround = walkingControllerParameters.maximumHeightAboveAnkle() + ankleToGround;
        double defaultOffsetHeightAboveGround = walkingControllerParameters.defaultOffsetHeightAboveAnkle();
        double doubleSupportPercentageIn = 0.3;
        return new LookAheadCoMHeightTrajectoryGenerator(minimumHeightAboveGround, nominalHeightAboveGround, maximumHeightAboveGround, defaultOffsetHeightAboveGround, doubleSupportPercentageIn, hipWidth, this.centerOfMassFrame, (ReferenceFrame)this.pelvisFrame, (SideDependentList<? extends ReferenceFrame>)referenceFrames.getSoleZUpFrames(), (DoubleProvider)controllerToolbox.getYoTime(), controllerToolbox.getYoGraphicsListRegistry(), this.registry);
    }

    @Override
    public void initialize() {
        this.centerOfMassTrajectoryGenerator.reset();
        this.comHeightTimeDerivativesSmoother.reset();
        this.transitionToFallStartTime.setToNaN();
    }

    @Override
    public void initializeDesiredHeightToCurrent() {
        this.centerOfMassTrajectoryGenerator.initializeDesiredHeightToCurrent();
        this.comHeightTimeDerivativesSmoother.reset();
        this.transitionToFallStartTime.setToNaN();
    }

    public void initializeToNominalDesiredHeight() {
        this.centerOfMassTrajectoryGenerator.initializeToNominalHeight();
    }

    public void initialize(TransferToAndNextFootstepsData transferToAndNextFootstepsData, double extraToeOffHeight) {
        if (!this.transitionToFallStartTime.isNaN()) {
            this.initialize();
        }
        this.centerOfMassTrajectoryGenerator.initialize(transferToAndNextFootstepsData, extraToeOffHeight);
    }

    public void initializeTransitionToFall(double transitionDuration) {
        if (this.transitionToFallStartTime.isNaN()) {
            this.transitionToFallStartTime.set(this.currentTime.getValue());
            this.transitionDurationToFall.set(transitionDuration);
        }
    }

    public void handlePelvisTrajectoryCommand(PelvisTrajectoryCommand command) {
        if (this.centerOfMassTrajectoryGenerator.handlePelvisTrajectoryCommand(command)) {
            SE3TrajectoryControllerCommand se3Trajectory = command.getSE3Trajectory();
            se3Trajectory.setSequenceId(command.getSequenceId());
            this.statusHelper.registerNewTrajectory(se3Trajectory);
        }
    }

    public void handlePelvisHeightTrajectoryCommand(PelvisHeightTrajectoryCommand command) {
        if (this.centerOfMassTrajectoryGenerator.handlePelvisHeightTrajectoryCommand(command)) {
            EuclideanTrajectoryControllerCommand euclideanTrajectory = command.getEuclideanTrajectory();
            euclideanTrajectory.setSequenceId(command.getSequenceId());
            this.statusHelper.registerNewTrajectory(euclideanTrajectory);
        }
    }

    public void setWeights(Vector3DReadOnly weight) {
        this.pelvisTaskpaceFeedbackWeight = weight;
    }

    @Override
    public void goHome(double trajectoryTime) {
        this.centerOfMassTrajectoryGenerator.goHome(trajectoryTime);
    }

    @Override
    public void handleStopAllTrajectoryCommand(StopAllTrajectoryCommand command) {
        this.centerOfMassTrajectoryGenerator.handleStopAllTrajectoryCommand(command);
    }

    public void setSupportLeg(RobotSide supportLeg) {
        this.centerOfMassTrajectoryGenerator.setSupportLeg(supportLeg);
    }

    private void solve(CoMHeightPartialDerivativesDataBasics comHeightPartialDerivativesToPack, boolean isInDoubleSupport) {
        this.centerOfMassTrajectoryGenerator.solve(comHeightPartialDerivativesToPack, isInDoubleSupport);
    }

    @Override
    public void computeCoMHeightCommand(FrameVector2DReadOnly desiredICPVelocity, FrameVector2DReadOnly desiredCoMVelocity, boolean isInDoubleSupport, double omega0, boolean isRecoveringFromPush, FeetManager feetManager) {
        this.solve(this.comHeightPartialDerivatives, isInDoubleSupport);
        this.statusHelper.updateWithTimeInTrajectory(this.centerOfMassTrajectoryGenerator.getOffsetHeightTimeInTrajectory());
        this.comPosition.setToZero(this.centerOfMassFrame);
        this.comVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.centerOfMassJacobian.getCenterOfMassVelocity());
        this.comPosition.changeFrame(worldFrame);
        this.comVelocity.changeFrame(worldFrame);
        double zCurrent = this.comPosition.getZ();
        if (this.controlPelvisHeightInsteadOfCoMHeight.getBooleanValue()) {
            this.pelvisPosition.setToZero((ReferenceFrame)this.pelvisFrame);
            this.pelvisPosition.changeFrame(worldFrame);
            zCurrent = this.pelvisPosition.getZ();
            this.pelvisFrame.getTwistOfFrame((TwistBasics)this.currentPelvisTwist);
            this.currentPelvisTwist.changeFrame(worldFrame);
        }
        this.comXYVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.comVelocity);
        if (desiredCoMVelocity.containsNaN()) {
            if (!this.desiredCMPcontainedNaN) {
                LogTools.error((String)"Desired CMP containes NaN, setting it to the ICP - only showing this error once");
            }
            this.desiredComAcceleration.setToZero(desiredICPVelocity.getReferenceFrame());
            this.desiredCMPcontainedNaN = true;
        } else {
            this.desiredComAcceleration.setIncludingFrame((FrameTuple2DReadOnly)desiredICPVelocity);
            this.desiredCMPcontainedNaN = false;
        }
        this.desiredComAcceleration.sub((FrameTuple2DReadOnly)desiredCoMVelocity);
        this.desiredComAcceleration.scale(omega0);
        CoMHeightTimeDerivativesCalculator.computeCoMHeightTimeDerivatives(this.comHeightDataBeforeSmoothing, desiredCoMVelocity, (FrameVector2DReadOnly)this.desiredComAcceleration, this.comHeightPartialDerivatives);
        this.comHeightDataBeforeSmoothing.getComHeight((FramePoint3DBasics)this.desiredCenterOfMassHeightPoint);
        this.desiredCoMHeightFromTrajectory.set(this.desiredCenterOfMassHeightPoint.getZ());
        this.desiredCoMHeightVelocityFromTrajectory.set(this.comHeightDataBeforeSmoothing.getComHeightVelocity());
        this.desiredCoMHeightAccelerationFromTrajectory.set(this.comHeightDataBeforeSmoothing.getComHeightAcceleration());
        this.desiredCoMHeightJerkFromTrajectory.set(this.comHeightDataBeforeSmoothing.getComHeightJerk());
        this.comHeightTimeDerivativesSmoother.smooth(this.comHeightDataAfterSmoothing, this.comHeightDataBeforeSmoothing);
        this.comHeightDataAfterSmoothing.getComHeight((FramePoint3DBasics)this.desiredCenterOfMassHeightPoint);
        this.desiredCoMHeightAfterSmoothing.set(this.desiredCenterOfMassHeightPoint.getZ());
        this.desiredCoMHeightVelocityAfterSmoothing.set(this.comHeightDataAfterSmoothing.getComHeightVelocity());
        this.desiredCoMHeightAccelerationAfterSmoothing.set(this.comHeightDataAfterSmoothing.getComHeightAcceleration());
        this.desiredCoMHeightJerkAfterSmoothing.set(this.comHeightDataBeforeSmoothing.getComHeightJerk());
        if (feetManager != null) {
            this.comHeightDataAfterSingularityAvoidance.set(this.comHeightDataAfterSmoothing);
            feetManager.correctCoMHeightForSupportSingularityAvoidance(zCurrent, this.comHeightDataAfterSingularityAvoidance);
            this.comHeightDataAfterUnreachableFootstep.set(this.comHeightDataAfterSingularityAvoidance);
            feetManager.correctCoMHeightForUnreachableFootstep(this.comHeightDataAfterUnreachableFootstep);
            this.finalComHeightData.set(this.comHeightDataAfterUnreachableFootstep);
        } else {
            this.finalComHeightData.set(this.comHeightDataAfterSmoothing);
        }
        this.finalComHeightData.getComHeight((FramePoint3DBasics)this.desiredCenterOfMassHeightPoint);
        this.desiredCoMHeightCorrected.set(this.desiredCenterOfMassHeightPoint.getZ());
        this.desiredCoMHeightVelocityCorrected.set(this.finalComHeightData.getComHeightVelocity());
        this.desiredCoMHeightAccelerationCorrected.set(this.finalComHeightData.getComHeightAcceleration());
        double zDesired = this.desiredCenterOfMassHeightPoint.getZ();
        double zdDesired = this.finalComHeightData.getComHeightVelocity();
        double zddFeedForward = this.finalComHeightData.getComHeightAcceleration();
        double gainScaleFactor = 1.0;
        if (!this.transitionToFallStartTime.isNaN()) {
            double ratio = (this.currentTime.getValue() - this.transitionToFallStartTime.getValue()) / this.transitionDurationToFall.getValue();
            this.fallActivationRatio.set(MathTools.clamp((double)ratio, (double)0.0, (double)1.0));
            zddFeedForward = EuclidCoreTools.interpolate((double)zddFeedForward, (double)(-this.fallAccelerationMagnitude.getValue()), (double)this.fallActivationRatio.getValue());
            gainScaleFactor = 1.0 - this.fallActivationRatio.getValue();
        }
        this.desiredPosition.set(0.0, 0.0, zDesired);
        this.desiredVelocity.set(0.0, 0.0, zdDesired);
        this.desiredAcceleration.set(0.0, 0.0, zddFeedForward);
        this.updateGains(gainScaleFactor);
        this.pelvisHeightControlCommand.setInverseDynamics((FramePoint3DReadOnly)this.desiredPosition, (FrameVector3DReadOnly)this.desiredVelocity, (FrameVector3DReadOnly)this.desiredAcceleration);
        this.comHeightControlCommand.setInverseDynamics((FramePoint3DReadOnly)this.desiredPosition, (FrameVector3DReadOnly)this.desiredVelocity, (FrameVector3DReadOnly)this.desiredAcceleration);
    }

    @Override
    public FeedbackControlCommand<?> getFeedbackControlCommand() {
        if (this.controlHeightWithMomentum.getValue() || !this.controlPelvisHeightInsteadOfCoMHeight.getValue()) {
            return null;
        }
        return this.pelvisHeightControlCommand;
    }

    @Override
    public FeedbackControlCommand<?> getHeightControlCommand() {
        if (this.controlPelvisHeightInsteadOfCoMHeight.getBooleanValue()) {
            return this.pelvisHeightControlCommand;
        }
        return this.comHeightControlCommand;
    }

    @Override
    public boolean getControlHeightWithMomentum() {
        return this.controlHeightWithMomentum.getValue();
    }

    public void doAction(double timeInState) {
    }

    public void setGains(PDGainsReadOnly gains, DoubleProvider maximumComVelocity) {
        this.gains = gains;
        this.comHeightTimeDerivativesSmoother.setGains(gains, maximumComVelocity);
    }

    public void updateGains(double gainScaleFactor) {
        this.gainsTemp.setProportionalGains(0.0, 0.0, gainScaleFactor * this.gains.getKp());
        this.gainsTemp.setDerivativeGains(0.0, 0.0, gainScaleFactor * this.gains.getKd());
        this.gainsTemp.setMaxFeedbackAndFeedbackRate(this.gains.getMaximumFeedback(), this.gains.getMaximumFeedbackRate());
        this.comHeightControlCommand.setGains((PID3DGains)this.gainsTemp);
        this.pelvisHeightControlCommand.setGains((PID3DGainsReadOnly)this.gainsTemp);
        this.pelvisHeightControlCommand.getGains().setMaxFeedbackAndFeedbackRate(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.pelvisHeightControlCommand.getSpatialAccelerationCommand().getWeightMatrix().setWeightFrames(null, worldFrame);
        this.pelvisHeightControlCommand.getSpatialAccelerationCommand().getWeightMatrix().setAngularWeights(0.0, 0.0, 0.0);
        this.pelvisHeightControlCommand.getSpatialAccelerationCommand().getWeightMatrix().getLinearPart().set((Tuple3DReadOnly)this.pelvisTaskpaceFeedbackWeight);
    }

    @Override
    public TaskspaceTrajectoryStatusMessage pollStatusToReport() {
        this.centerOfMassTrajectoryGenerator.getCurrentDesiredHeight(this.statusDesiredPosition);
        this.statusDesiredPosition.changeFrame(ReferenceFrame.getWorldFrame());
        this.statusDesiredPosition.setX(Double.NaN);
        this.statusDesiredPosition.setY(Double.NaN);
        if (this.controlPelvisHeightInsteadOfCoMHeight.getValue()) {
            this.statusActualPosition.setIncludingFrame((FrameTuple3DReadOnly)this.pelvisPosition);
        } else {
            this.statusActualPosition.setIncludingFrame((FrameTuple3DReadOnly)this.comPosition);
        }
        this.statusActualPosition.setX(Double.NaN);
        this.statusActualPosition.setY(Double.NaN);
        return this.statusHelper.pollStatusMessage((FramePoint3DReadOnly)this.statusDesiredPosition, (FramePoint3DReadOnly)this.statusActualPosition);
    }
}

