/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.legConfiguration;

import us.ihmc.commons.MathTools;

public class TriangleTools {
    public static double computeSideLength(double sideALength, double sideBLength, double interiorAngle) {
        double lengthSquared = MathTools.square((double)sideALength) + MathTools.square((double)sideBLength) - 2.0 * sideALength * sideBLength * Math.cos(interiorAngle);
        return Math.sqrt(lengthSquared);
    }

    public static double computeSideLengthVelocity(double sideALength, double sideBLength, double interiorAngle, double interiorAngleVelocity) {
        double sideLength = TriangleTools.computeSideLength(sideALength, sideBLength, interiorAngle);
        return TriangleTools.computeSideLengthVelocity(sideALength, sideBLength, sideLength, interiorAngle, interiorAngleVelocity);
    }

    public static double computeSideLengthVelocity(double sideALength, double sideBLength, double farSideLength, double interiorAngle, double interiorAngleVelocity) {
        return sideALength * sideBLength / farSideLength * interiorAngleVelocity * Math.sin(interiorAngle);
    }

    public static double computeSideLengthAcceleration(double sideALength, double sideBLength, double interiorAngle, double interiorAngleVelocity, double interiorAngleAcceleration) {
        double sideLength = TriangleTools.computeSideLength(sideALength, sideBLength, interiorAngle);
        double sideLengthVelocity = TriangleTools.computeSideLengthVelocity(sideALength, sideBLength, sideLength, interiorAngle, interiorAngleVelocity);
        return TriangleTools.computeSideLengthAcceleration(sideALength, sideBLength, sideLength, sideLengthVelocity, interiorAngle, interiorAngleVelocity, interiorAngleAcceleration);
    }

    public static double computeSideLengthAcceleration(double sideALength, double sideBLength, double farSideLength, double farSideLengthVelocity, double interiorAngle, double interiorAngleVelocity, double interiorAngleAcceleration) {
        double sideLengthAcceleration = interiorAngleAcceleration * Math.sin(interiorAngle) + MathTools.square((double)interiorAngleVelocity) * Math.cos(interiorAngle);
        sideLengthAcceleration *= sideALength * sideBLength / farSideLength;
        return sideLengthAcceleration -= MathTools.square((double)farSideLengthVelocity) / farSideLength;
    }

    public static double computeInteriorAngle(double sideALength, double sideBLength, double farSideLength) {
        double delta = MathTools.square((double)farSideLength) - MathTools.square((double)sideALength) - MathTools.square((double)sideBLength);
        return Math.acos(-delta / (2.0 * sideALength * sideBLength));
    }

    public static double computeInteriorAngleVelocity(double sideALength, double sideBLength, double farSideLength, double farSideVelocity) {
        double interiorAngle = TriangleTools.computeInteriorAngle(sideALength, sideBLength, farSideLength);
        return TriangleTools.computeInteriorAngleVelocity(sideALength, sideBLength, farSideLength, farSideVelocity, interiorAngle);
    }

    public static double computeInteriorAngleVelocity(double sideALength, double sideBLength, double farSideLength, double farSideVelocity, double interiorAngle) {
        return farSideLength * farSideVelocity / (sideALength * sideBLength * Math.sin(interiorAngle));
    }

    public static double computeInteriorAngleAcceleration(double sideALength, double sideBLength, double farSideLength, double farSideVelocity, double farSideAcceleration) {
        double interiorAngle = TriangleTools.computeInteriorAngle(sideALength, sideBLength, farSideLength);
        double interiorAngleVelocity = TriangleTools.computeInteriorAngleVelocity(sideALength, sideBLength, farSideLength, farSideVelocity, interiorAngle);
        return TriangleTools.computeInteriorAngleAcceleration(sideALength, sideBLength, farSideLength, farSideVelocity, farSideAcceleration, interiorAngle, interiorAngleVelocity);
    }

    public static double computeInteriorAngleAcceleration(double sideALength, double sideBLength, double farSideLength, double farSideVelocity, double farSideAcceleration, double interiorAngle, double interiorAngleVelocity) {
        double interiorAngleAcceleration = MathTools.square((double)farSideVelocity) + farSideLength * farSideAcceleration;
        interiorAngleAcceleration /= sideALength * sideBLength * Math.sin(interiorAngle);
        return interiorAngleAcceleration -= MathTools.square((double)interiorAngleVelocity) / Math.tan(interiorAngle);
    }

    public static double computeSideLengthFromSideSideAngle(double sideALength, double sideBLength, double angleB, boolean isAngleAObtuse) {
        if (angleB >= 1.5707963267948966) {
            if (sideALength >= sideBLength) {
                return Double.NaN;
            }
        } else if (sideALength > sideBLength) {
            double height = sideALength * Math.sin(angleB);
            if (sideBLength < height) {
                return Double.NaN;
            }
            if (sideBLength > height) {
                double lawSinesB = Math.sin(angleB) / sideBLength;
                double angleA = isAngleAObtuse ? Math.PI - Math.asin(lawSinesB * sideALength) : Math.asin(lawSinesB * sideALength);
                double angleC = Math.PI - angleA - angleB;
                return Math.sin(angleC) / lawSinesB;
            }
        }
        double lawSinesB = Math.sin(angleB) / sideBLength;
        double angleA = Math.asin(lawSinesB * sideALength);
        double angleC = Math.PI - angleA - angleB;
        return Math.sin(angleC) / lawSinesB;
    }
}

