/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.legConfiguration;

import us.ihmc.commonWalkingControlModules.configurations.LegConfigurationParameters;
import us.ihmc.commonWalkingControlModules.controlModules.legConfiguration.LegConfigurationGains;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.PrivilegedJointSpaceCommand;
import us.ihmc.commonWalkingControlModules.momentumBasedController.HighLevelHumanoidControllerToolbox;
import us.ihmc.commons.InterpolationTools;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.partNames.LegJointName;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.stateMachine.core.State;
import us.ihmc.robotics.stateMachine.core.StateMachine;
import us.ihmc.robotics.stateMachine.factories.StateMachineFactory;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;

public class LegConfigurationControlModule {
    private static final double minimumDampingScale = 0.2;
    private static final boolean scaleDamping = false;
    private static final boolean ONLY_MOVE_PRIV_POS_IF_NOT_BENDING = true;
    private final YoRegistry registry;
    private final PrivilegedJointSpaceCommand privilegedAccelerationCommand = new PrivilegedJointSpaceCommand();
    private final YoEnum<LegConfigurationType> requestedState;
    private final YoEnum<LegControlWeight> legControlWeight;
    private final StateMachine<LegConfigurationType, State> stateMachine;
    private final YoDouble highPrivilegedWeight;
    private final YoDouble mediumPrivilegedWeight;
    private final YoDouble lowPrivilegedWeight;
    private final YoDouble straightJointSpacePositionGain;
    private final YoDouble straightJointSpaceVelocityGain;
    private final YoDouble straightActuatorSpacePositionGain;
    private final YoDouble straightActuatorSpaceVelocityGain;
    private final YoDouble bentJointSpacePositionGain;
    private final YoDouble bentJointSpaceVelocityGain;
    private final YoDouble bentActuatorSpaceVelocityGain;
    private final YoDouble bentActuatorSpacePositionGain;
    private final YoDouble kneePitchPrivilegedConfiguration;
    private final YoDouble kneePitchPrivilegedError;
    private final YoDouble jointSpacePAction;
    private final YoDouble jointSpaceDAction;
    private final YoDouble jointSpaceAction;
    private final YoDouble actuatorSpacePAction;
    private final YoDouble actuatorSpaceDAction;
    private final YoDouble actuatorSpaceAction;
    private final YoDouble privilegedMaxAcceleration;
    private final YoBoolean useFullyExtendedLeg;
    private final YoBoolean useBracingAngle;
    private final YoDouble desiredAngle;
    private final YoDouble desiredAngleWhenStraight;
    private final YoDouble desiredAngleWhenExtended;
    private final YoDouble desiredAngleWhenBracing;
    private final YoDouble desiredFractionOfMidRangeForCollapsed;
    private final YoDouble straighteningAcceleration;
    private final YoDouble collapsingDuration;
    private final YoDouble collapsingDurationFractionOfStep;
    private final YoDouble desiredVirtualActuatorLength;
    private final YoDouble currentVirtualActuatorLength;
    private final YoDouble currentVirtualActuatorVelocity;
    private final OneDoFJointBasics kneePitchJoint;
    private final YoDouble dampingActionScaleFactor;
    private static final int hipPitchJointIndex = 0;
    private static final int kneePitchJointIndex = 1;
    private static final int anklePitchJointIndex = 2;
    private double jointSpaceConfigurationGain;
    private double jointSpaceVelocityGain;
    private double actuatorSpaceConfigurationGain;
    private double actuatorSpaceVelocityGain;
    private final double kneeRangeOfMotion;
    private final double kneeSquareRangeOfMotion;
    private final double kneeMidRangeOfMotion;
    private final double thighLength;
    private final double shinLength;

    public LegConfigurationControlModule(RobotSide robotSide, HighLevelHumanoidControllerToolbox controllerToolbox, LegConfigurationParameters legConfigurationParameters, YoRegistry parentRegistry) {
        double kneeLimitLower;
        String sidePrefix = robotSide.getCamelCaseNameForStartOfExpression();
        String namePrefix = sidePrefix + "Leg";
        this.registry = new YoRegistry(sidePrefix + this.getClass().getSimpleName());
        this.kneePitchJoint = controllerToolbox.getFullRobotModel().getLegJoint((Enum)robotSide, LegJointName.KNEE_PITCH);
        double kneeLimitUpper = this.kneePitchJoint.getJointLimitUpper();
        if (Double.isNaN(kneeLimitUpper) || Double.isInfinite(kneeLimitUpper)) {
            kneeLimitUpper = Math.PI;
        }
        if (Double.isNaN(kneeLimitLower = this.kneePitchJoint.getJointLimitLower()) || Double.isInfinite(kneeLimitLower)) {
            kneeLimitLower = -Math.PI;
        }
        this.kneeSquareRangeOfMotion = MathTools.square((double)(kneeLimitUpper - kneeLimitLower));
        this.kneeRangeOfMotion = kneeLimitUpper - kneeLimitLower;
        this.kneeMidRangeOfMotion = 0.5 * (kneeLimitUpper + kneeLimitLower);
        OneDoFJointBasics hipPitchJoint = controllerToolbox.getFullRobotModel().getLegJoint((Enum)robotSide, LegJointName.HIP_PITCH);
        OneDoFJointBasics anklePitchJoint = controllerToolbox.getFullRobotModel().getLegJoint((Enum)robotSide, LegJointName.ANKLE_PITCH);
        this.privilegedAccelerationCommand.addJoint(hipPitchJoint, Double.NaN);
        this.privilegedAccelerationCommand.addJoint(this.kneePitchJoint, Double.NaN);
        this.privilegedAccelerationCommand.addJoint(anklePitchJoint, Double.NaN);
        this.highPrivilegedWeight = new YoDouble(sidePrefix + "HighPrivilegedWeight", this.registry);
        this.mediumPrivilegedWeight = new YoDouble(sidePrefix + "MediumPrivilegedWeight", this.registry);
        this.lowPrivilegedWeight = new YoDouble(sidePrefix + "LowPrivilegedWeight", this.registry);
        this.straightJointSpacePositionGain = new YoDouble(sidePrefix + "StraightLegJointSpaceKp", this.registry);
        this.straightJointSpaceVelocityGain = new YoDouble(sidePrefix + "StraightLegJointSpaceKv", this.registry);
        this.straightActuatorSpacePositionGain = new YoDouble(sidePrefix + "StraightLegActuatorSpaceKp", this.registry);
        this.straightActuatorSpaceVelocityGain = new YoDouble(sidePrefix + "StraightLegActuatorSpaceKv", this.registry);
        this.bentJointSpacePositionGain = new YoDouble(sidePrefix + "BentLegJointSpaceKp", this.registry);
        this.bentJointSpaceVelocityGain = new YoDouble(sidePrefix + "BentLegJointSpaceKv", this.registry);
        this.bentActuatorSpacePositionGain = new YoDouble(sidePrefix + "BentLegActuatorSpaceKp", this.registry);
        this.bentActuatorSpaceVelocityGain = new YoDouble(sidePrefix + "BentLegActuatorSpaceKv", this.registry);
        this.kneePitchPrivilegedConfiguration = new YoDouble(sidePrefix + "KneePitchPrivilegedConfiguration", this.registry);
        this.privilegedMaxAcceleration = new YoDouble(sidePrefix + "LegPrivilegedMaxAcceleration", this.registry);
        this.kneePitchPrivilegedError = new YoDouble(sidePrefix + "KneePitchPrivilegedError", this.registry);
        this.jointSpacePAction = new YoDouble(sidePrefix + "KneePrivilegedJointSpacePAction", this.registry);
        this.jointSpaceDAction = new YoDouble(sidePrefix + "KneePrivilegedJointSpaceDAction", this.registry);
        this.jointSpaceAction = new YoDouble(sidePrefix + "KneePrivilegedJointSpaceAction", this.registry);
        this.actuatorSpacePAction = new YoDouble(sidePrefix + "KneePrivilegedActuatorSpacePAction", this.registry);
        this.actuatorSpaceDAction = new YoDouble(sidePrefix + "KneePrivilegedActuatorSpaceDAction", this.registry);
        this.actuatorSpaceAction = new YoDouble(sidePrefix + "KneePrivilegedActuatorSpaceAction", this.registry);
        this.highPrivilegedWeight.set(legConfigurationParameters.getLegPrivilegedHighWeight());
        this.mediumPrivilegedWeight.set(legConfigurationParameters.getLegPrivilegedMediumWeight());
        this.lowPrivilegedWeight.set(legConfigurationParameters.getLegPrivilegedLowWeight());
        LegConfigurationGains straightLegGains = legConfigurationParameters.getStraightLegGains();
        LegConfigurationGains bentLegGains = legConfigurationParameters.getBentLegGains();
        this.straightJointSpacePositionGain.set(straightLegGains.getJointSpaceKp());
        this.straightJointSpaceVelocityGain.set(straightLegGains.getJointSpaceKd());
        this.straightActuatorSpacePositionGain.set(straightLegGains.getActuatorSpaceKp());
        this.straightActuatorSpaceVelocityGain.set(straightLegGains.getActuatorSpaceKd());
        this.bentJointSpacePositionGain.set(bentLegGains.getJointSpaceKp());
        this.bentJointSpaceVelocityGain.set(bentLegGains.getJointSpaceKd());
        this.bentActuatorSpacePositionGain.set(bentLegGains.getActuatorSpaceKp());
        this.bentActuatorSpaceVelocityGain.set(bentLegGains.getActuatorSpaceKd());
        this.privilegedMaxAcceleration.set(legConfigurationParameters.getPrivilegedMaxAcceleration());
        this.dampingActionScaleFactor = new YoDouble(namePrefix + "DampingActionScaleFactor", this.registry);
        this.useFullyExtendedLeg = new YoBoolean(namePrefix + "UseFullyExtendedLeg", this.registry);
        this.useBracingAngle = new YoBoolean(namePrefix + "UseBracingLeg", this.registry);
        this.desiredAngle = new YoDouble(namePrefix + "DesiredAngle", this.registry);
        this.desiredAngleWhenStraight = new YoDouble(namePrefix + "DesiredAngleWhenStraight", this.registry);
        this.desiredAngleWhenExtended = new YoDouble(namePrefix + "DesiredAngleWhenExtended", this.registry);
        this.desiredAngleWhenBracing = new YoDouble(namePrefix + "DesiredAngleWhenBracing", this.registry);
        this.desiredAngleWhenStraight.set(legConfigurationParameters.getKneeAngleWhenStraight());
        this.desiredAngleWhenExtended.set(legConfigurationParameters.getKneeAngleWhenExtended());
        this.desiredAngleWhenBracing.set(legConfigurationParameters.getKneeAngleWhenBracing());
        this.desiredFractionOfMidRangeForCollapsed = new YoDouble(namePrefix + "DesiredFractionOfMidRangeForCollapsed", this.registry);
        this.desiredFractionOfMidRangeForCollapsed.set(legConfigurationParameters.getDesiredFractionOfMidrangeForCollapsedAngle());
        this.straighteningAcceleration = new YoDouble(namePrefix + "SupportKneeStraighteningAcceleration", this.registry);
        this.straighteningAcceleration.set(legConfigurationParameters.getAccelerationForSupportKneeStraightening());
        this.collapsingDuration = new YoDouble(namePrefix + "SupportKneeCollapsingDuration", this.registry);
        this.collapsingDurationFractionOfStep = new YoDouble(namePrefix + "SupportKneeCollapsingDurationFractionOfStep", this.registry);
        this.collapsingDurationFractionOfStep.set(legConfigurationParameters.getSupportKneeCollapsingDurationFractionOfStep());
        this.desiredVirtualActuatorLength = new YoDouble(namePrefix + "DesiredVirtualActuatorLength", this.registry);
        this.currentVirtualActuatorLength = new YoDouble(namePrefix + "CurrentVirtualActuatorLength", this.registry);
        this.currentVirtualActuatorVelocity = new YoDouble(namePrefix + "CurrentVirtualActuatorVelocity", this.registry);
        YoDouble time = controllerToolbox.getYoTime();
        this.requestedState = new YoEnum(namePrefix + "RequestedState", "", this.registry, LegConfigurationType.class, true);
        this.requestedState.set(null);
        this.legControlWeight = new YoEnum(namePrefix + "LegControlWeight", "", this.registry, LegControlWeight.class, false);
        FullHumanoidRobotModel fullRobotModel = controllerToolbox.getFullRobotModel();
        MovingReferenceFrame hipPitchFrame = fullRobotModel.getLegJoint((Enum)RobotSide.LEFT, LegJointName.HIP_PITCH).getFrameAfterJoint();
        FramePoint3D hipPoint = new FramePoint3D((ReferenceFrame)hipPitchFrame);
        FramePoint3D kneePoint = new FramePoint3D((ReferenceFrame)fullRobotModel.getLegJoint((Enum)RobotSide.LEFT, LegJointName.KNEE_PITCH).getFrameBeforeJoint());
        kneePoint.changeFrame((ReferenceFrame)hipPitchFrame);
        this.thighLength = hipPoint.distance((FramePoint3DReadOnly)kneePoint);
        MovingReferenceFrame kneePitchFrame = fullRobotModel.getLegJoint((Enum)RobotSide.LEFT, LegJointName.KNEE_PITCH).getFrameAfterJoint();
        kneePoint.setToZero((ReferenceFrame)kneePitchFrame);
        FramePoint3D anklePoint = new FramePoint3D((ReferenceFrame)fullRobotModel.getLegJoint((Enum)RobotSide.LEFT, LegJointName.ANKLE_PITCH).getFrameBeforeJoint());
        anklePoint.changeFrame((ReferenceFrame)kneePitchFrame);
        this.shinLength = kneePoint.distance((FramePoint3DReadOnly)anklePoint);
        this.stateMachine = this.setupStateMachine(namePrefix, legConfigurationParameters.attemptToStraightenLegs(), (DoubleProvider)time);
        parentRegistry.addChild(this.registry);
    }

    private StateMachine<LegConfigurationType, State> setupStateMachine(String namePrefix, boolean attemptToStraightenLegs, DoubleProvider timeProvider) {
        StateMachineFactory factory = new StateMachineFactory(LegConfigurationType.class);
        factory.setNamePrefix(namePrefix).setRegistry(this.registry).buildYoClock(timeProvider);
        factory.addStateAndDoneTransition((Enum)LegConfigurationType.STRAIGHTEN, (State)new StraighteningKneeControlState(this.straighteningAcceleration), (Enum)LegConfigurationType.STRAIGHT);
        factory.addState((Enum)LegConfigurationType.STRAIGHT, (State)new StraightKneeControlState());
        factory.addState((Enum)LegConfigurationType.BENT, (State)new BentKneeControlState());
        factory.addState((Enum)LegConfigurationType.COLLAPSE, (State)new CollapseKneeControlState());
        for (LegConfigurationType from : LegConfigurationType.values()) {
            factory.addRequestedTransition((Enum)from, this.requestedState);
            factory.addRequestedTransition((Enum)from, (Enum)from, this.requestedState);
        }
        return factory.build((Enum)(attemptToStraightenLegs ? LegConfigurationType.STRAIGHT : LegConfigurationType.BENT));
    }

    public void initialize() {
    }

    public void doControl() {
        if (this.useBracingAngle.getBooleanValue()) {
            this.desiredAngle.set(this.desiredAngleWhenBracing.getDoubleValue());
        } else if (this.useFullyExtendedLeg.getBooleanValue()) {
            this.desiredAngle.set(this.desiredAngleWhenExtended.getDoubleValue());
        } else {
            this.desiredAngle.set(this.desiredAngleWhenStraight.getDoubleValue());
        }
        this.stateMachine.doActionAndTransition();
        double kneePitchPrivilegedConfigurationWeight = this.legControlWeight.getEnumValue() == LegControlWeight.LOW ? this.lowPrivilegedWeight.getDoubleValue() : (this.legControlWeight.getEnumValue() == LegControlWeight.MEDIUM ? this.mediumPrivilegedWeight.getDoubleValue() : this.highPrivilegedWeight.getDoubleValue());
        double privilegedKneeAcceleration = this.computeKneeAcceleration();
        double privilegedHipPitchAcceleration = -0.5 * privilegedKneeAcceleration;
        double privilegedAnklePitchAcceleration = -0.5 * privilegedKneeAcceleration;
        this.privilegedAccelerationCommand.setOneDoFJoint(0, privilegedHipPitchAcceleration);
        this.privilegedAccelerationCommand.setOneDoFJoint(1, privilegedKneeAcceleration);
        this.privilegedAccelerationCommand.setOneDoFJoint(2, privilegedAnklePitchAcceleration);
        this.privilegedAccelerationCommand.setWeight(0, kneePitchPrivilegedConfigurationWeight);
        this.privilegedAccelerationCommand.setWeight(1, kneePitchPrivilegedConfigurationWeight);
        this.privilegedAccelerationCommand.setWeight(2, kneePitchPrivilegedConfigurationWeight);
    }

    public void setStepDuration(double stepDuration) {
        this.collapsingDuration.set(this.collapsingDurationFractionOfStep.getDoubleValue() * stepDuration);
    }

    public void setFullyExtendLeg(boolean fullyExtendLeg) {
        this.useFullyExtendedLeg.set(fullyExtendLeg);
    }

    public void prepareForLegBracing() {
        this.useBracingAngle.set(true);
    }

    public void doNotBrace() {
        this.useBracingAngle.set(false);
    }

    public void setLegControlWeight(LegControlWeight legControlWeight) {
        this.legControlWeight.set((Enum)legControlWeight);
    }

    private double computeKneeAcceleration() {
        double currentPosition = this.kneePitchJoint.getQ();
        double jointError = this.kneePitchPrivilegedConfiguration.getDoubleValue() - currentPosition;
        this.kneePitchPrivilegedError.set(jointError);
        double percentError = Math.abs(jointError) / (0.5 * this.kneeRangeOfMotion);
        double dampingActionScaleFactor = 1.0;
        this.dampingActionScaleFactor.set(dampingActionScaleFactor);
        double jointSpaceAction = this.computeJointSpaceAction(dampingActionScaleFactor);
        double actuatorSpaceAction = this.computeActuatorSpaceAction(dampingActionScaleFactor);
        double desiredAcceleration = jointSpaceAction + actuatorSpaceAction;
        return MathTools.clamp((double)desiredAcceleration, (double)this.privilegedMaxAcceleration.getDoubleValue());
    }

    private double computeJointSpaceAction(double dampingActionScaleFactor) {
        double jointError = this.kneePitchPrivilegedConfiguration.getDoubleValue() - this.kneePitchJoint.getQ();
        double jointSpaceKp = 2.0 * this.jointSpaceConfigurationGain / this.kneeSquareRangeOfMotion;
        double jointSpacePAction = Double.isNaN(jointSpaceKp) ? 0.0 : jointSpaceKp * jointError;
        double jointSpaceDAction = Double.isNaN(this.jointSpaceVelocityGain) ? 0.0 : dampingActionScaleFactor * this.jointSpaceVelocityGain * -this.kneePitchJoint.getQd();
        this.jointSpacePAction.set(jointSpacePAction);
        this.jointSpaceDAction.set(jointSpaceDAction);
        this.jointSpaceAction.set(jointSpacePAction + jointSpaceDAction);
        return jointSpacePAction + jointSpaceDAction;
    }

    private double computeActuatorSpaceAction(double dampingActionScaleFactor) {
        double currentPosition = this.kneePitchJoint.getQ();
        double desiredVirtualLength = this.computeVirtualActuatorLength(this.kneePitchPrivilegedConfiguration.getDoubleValue());
        double currentVirtualLength = this.computeVirtualActuatorLength(currentPosition);
        this.desiredVirtualActuatorLength.set(desiredVirtualLength);
        this.currentVirtualActuatorLength.set(currentVirtualLength);
        double currentVirtualVelocity = this.computeVirtualActuatorVelocity(currentPosition, this.kneePitchJoint.getQd());
        this.currentVirtualActuatorVelocity.set(currentVirtualVelocity);
        double virtualError = desiredVirtualLength - currentVirtualLength;
        double actuatorSpacePAction = Double.isNaN(this.actuatorSpaceConfigurationGain) ? 0.0 : this.actuatorSpaceConfigurationGain * virtualError;
        double actuatorSpaceDAction = Double.isNaN(this.actuatorSpaceVelocityGain) ? 0.0 : -dampingActionScaleFactor * this.actuatorSpaceVelocityGain * currentVirtualVelocity;
        this.actuatorSpacePAction.set(actuatorSpacePAction);
        this.actuatorSpaceDAction.set(actuatorSpaceDAction);
        double actuatorSpaceAcceleration = actuatorSpacePAction + actuatorSpaceDAction;
        double acceleration = this.computeJointAccelerationFromActuatorAcceleration(currentPosition, this.kneePitchJoint.getQd(), actuatorSpaceAcceleration);
        this.actuatorSpaceAction.set(acceleration);
        return acceleration;
    }

    private double computeVirtualActuatorLength(double kneePitchAngle) {
        double length = Math.pow(this.thighLength, 2.0) + Math.pow(this.shinLength, 2.0) + 2.0 * this.thighLength * this.shinLength * Math.cos(kneePitchAngle);
        return Math.sqrt(length);
    }

    private double computeVirtualActuatorVelocity(double kneePitchAngle, double kneePitchVelocity) {
        double virtualLength = this.computeVirtualActuatorLength(kneePitchAngle);
        return -this.thighLength * this.shinLength / virtualLength * kneePitchVelocity * Math.sin(kneePitchAngle);
    }

    private double computeJointAccelerationFromActuatorAcceleration(double kneePitchAngle, double kneePitchVelocity, double actuatorAcceleration) {
        double actuatorLength = this.computeVirtualActuatorLength(kneePitchAngle);
        double actuatorVelocity = this.computeVirtualActuatorVelocity(kneePitchAngle, kneePitchVelocity);
        double coriolisAcceleration = this.thighLength * this.shinLength / actuatorLength * Math.pow(kneePitchVelocity, 2.0) * Math.cos(kneePitchAngle);
        double centripetalAcceleration = -Math.pow(actuatorVelocity, 2.0) / actuatorLength;
        double regularAcceleration = -this.thighLength * this.shinLength / actuatorLength * actuatorAcceleration * Math.sin(kneePitchAngle);
        return regularAcceleration + coriolisAcceleration + centripetalAcceleration;
    }

    public void setKneeAngleState(LegConfigurationType controlType) {
        this.requestedState.set((Enum)controlType);
    }

    public LegConfigurationType getCurrentKneeControlState() {
        return (LegConfigurationType)this.stateMachine.getCurrentStateKey();
    }

    public InverseDynamicsCommand<?> getInverseDynamicsCommand() {
        return this.privilegedAccelerationCommand;
    }

    public static enum LegConfigurationType {
        STRAIGHTEN,
        STRAIGHT,
        COLLAPSE,
        BENT;

    }

    public static enum LegControlWeight {
        HIGH,
        MEDIUM,
        LOW;

    }

    private class StraighteningKneeControlState
    implements State {
        private final YoDouble yoStraighteningAcceleration;
        private double startingPosition;
        private double previousKneePitchAngle;
        private double timeUntilStraight;
        private double straighteningVelocity;
        private double straighteningAcceleration;
        private double dwellTime;
        private double desiredPrivilegedPosition;
        private double previousTime;

        public StraighteningKneeControlState(YoDouble straighteningAcceleration) {
            this.yoStraighteningAcceleration = straighteningAcceleration;
        }

        public boolean isDone(double timeInState) {
            return timeInState > this.timeUntilStraight + this.dwellTime;
        }

        public void doAction(double timeInState) {
            double estimatedDT = this.estimateDT(timeInState);
            double currentPosition = LegConfigurationControlModule.this.kneePitchJoint.getQ();
            if (currentPosition > this.previousKneePitchAngle && currentPosition > this.startingPosition) {
                this.dwellTime += estimatedDT;
            } else {
                this.straighteningVelocity += estimatedDT * this.straighteningAcceleration;
                this.desiredPrivilegedPosition -= estimatedDT * this.straighteningVelocity;
            }
            this.desiredPrivilegedPosition = Math.max(LegConfigurationControlModule.this.desiredAngle.getDoubleValue(), this.desiredPrivilegedPosition);
            LegConfigurationControlModule.this.kneePitchPrivilegedConfiguration.set(this.desiredPrivilegedPosition);
            LegConfigurationControlModule.this.jointSpaceConfigurationGain = LegConfigurationControlModule.this.straightJointSpacePositionGain.getDoubleValue();
            LegConfigurationControlModule.this.jointSpaceVelocityGain = LegConfigurationControlModule.this.straightJointSpaceVelocityGain.getDoubleValue();
            LegConfigurationControlModule.this.actuatorSpaceConfigurationGain = LegConfigurationControlModule.this.straightActuatorSpacePositionGain.getDoubleValue();
            LegConfigurationControlModule.this.actuatorSpaceVelocityGain = LegConfigurationControlModule.this.straightActuatorSpaceVelocityGain.getDoubleValue();
            this.previousKneePitchAngle = currentPosition;
        }

        public void onEntry() {
            this.startingPosition = LegConfigurationControlModule.this.kneePitchJoint.getQ();
            this.previousKneePitchAngle = LegConfigurationControlModule.this.kneePitchJoint.getQ();
            this.straighteningVelocity = 0.0;
            this.straighteningAcceleration = this.yoStraighteningAcceleration.getDoubleValue();
            this.timeUntilStraight = Math.sqrt(2.0 * (this.startingPosition - LegConfigurationControlModule.this.desiredAngle.getDoubleValue()) / this.straighteningAcceleration);
            this.timeUntilStraight = Math.max(this.timeUntilStraight, 0.0);
            this.desiredPrivilegedPosition = this.startingPosition;
            this.previousTime = 0.0;
            this.dwellTime = 0.0;
            if (LegConfigurationControlModule.this.useBracingAngle.getBooleanValue()) {
                LegConfigurationControlModule.this.legControlWeight.set((Enum)LegControlWeight.MEDIUM);
            }
        }

        public void onExit() {
        }

        private double estimateDT(double timeInState) {
            double estimatedDT = timeInState - this.previousTime;
            this.previousTime = timeInState;
            return estimatedDT;
        }
    }

    private class StraightKneeControlState
    implements State {
        private StraightKneeControlState() {
        }

        public boolean isDone(double timeInState) {
            return false;
        }

        public void doAction(double timeInState) {
            LegConfigurationControlModule.this.kneePitchPrivilegedConfiguration.set(LegConfigurationControlModule.this.desiredAngle.getDoubleValue());
            LegConfigurationControlModule.this.jointSpaceConfigurationGain = LegConfigurationControlModule.this.straightJointSpacePositionGain.getDoubleValue();
            LegConfigurationControlModule.this.jointSpaceVelocityGain = LegConfigurationControlModule.this.straightJointSpaceVelocityGain.getDoubleValue();
            LegConfigurationControlModule.this.actuatorSpaceConfigurationGain = LegConfigurationControlModule.this.straightActuatorSpacePositionGain.getDoubleValue();
            LegConfigurationControlModule.this.actuatorSpaceVelocityGain = LegConfigurationControlModule.this.straightActuatorSpaceVelocityGain.getDoubleValue();
        }

        public void onEntry() {
        }

        public void onExit() {
        }
    }

    private class BentKneeControlState
    implements State {
        private BentKneeControlState() {
        }

        public boolean isDone(double timeInState) {
            return false;
        }

        public void doAction(double timeInState) {
            LegConfigurationControlModule.this.kneePitchPrivilegedConfiguration.set(LegConfigurationControlModule.this.kneeMidRangeOfMotion);
            LegConfigurationControlModule.this.jointSpaceConfigurationGain = LegConfigurationControlModule.this.bentJointSpacePositionGain.getDoubleValue();
            LegConfigurationControlModule.this.jointSpaceVelocityGain = LegConfigurationControlModule.this.bentJointSpaceVelocityGain.getDoubleValue();
            LegConfigurationControlModule.this.actuatorSpaceConfigurationGain = LegConfigurationControlModule.this.bentActuatorSpacePositionGain.getDoubleValue();
            LegConfigurationControlModule.this.actuatorSpaceVelocityGain = LegConfigurationControlModule.this.bentActuatorSpaceVelocityGain.getDoubleValue();
        }

        public void onEntry() {
            LegConfigurationControlModule.this.legControlWeight.set((Enum)LegControlWeight.LOW);
        }

        public void onExit() {
        }
    }

    private class CollapseKneeControlState
    implements State {
        private CollapseKneeControlState() {
        }

        public boolean isDone(double timeInState) {
            return false;
        }

        public void doAction(double timeInState) {
            double collapsedAngle = LegConfigurationControlModule.this.desiredFractionOfMidRangeForCollapsed.getDoubleValue() * LegConfigurationControlModule.this.kneeMidRangeOfMotion;
            double alpha = this.computeQuadraticCollapseFactor(timeInState, LegConfigurationControlModule.this.collapsingDuration.getDoubleValue());
            double desiredKneePosition = InterpolationTools.linearInterpolate((double)LegConfigurationControlModule.this.desiredAngle.getDoubleValue(), (double)collapsedAngle, (double)alpha);
            desiredKneePosition = Math.max(desiredKneePosition, LegConfigurationControlModule.this.desiredAngleWhenStraight.getDoubleValue());
            LegConfigurationControlModule.this.kneePitchPrivilegedConfiguration.set(desiredKneePosition);
            LegConfigurationControlModule.this.jointSpaceConfigurationGain = LegConfigurationControlModule.this.straightJointSpacePositionGain.getDoubleValue();
            LegConfigurationControlModule.this.jointSpaceVelocityGain = LegConfigurationControlModule.this.straightJointSpaceVelocityGain.getDoubleValue();
            LegConfigurationControlModule.this.actuatorSpaceConfigurationGain = LegConfigurationControlModule.this.straightActuatorSpacePositionGain.getDoubleValue();
            LegConfigurationControlModule.this.actuatorSpaceVelocityGain = LegConfigurationControlModule.this.straightActuatorSpaceVelocityGain.getDoubleValue();
        }

        private double computeConstantCollapseFactor(double timeInState, double duration) {
            return Math.max(timeInState / duration, 0.0);
        }

        private double computeQuadraticCollapseFactor(double timeInState, double duration) {
            return MathTools.clamp((double)Math.pow(timeInState / duration, 2.0), (double)0.0, (double)1.0);
        }

        public void onEntry() {
            LegConfigurationControlModule.this.legControlWeight.set((Enum)LegControlWeight.MEDIUM);
        }

        public void onExit() {
        }
    }
}

