/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.foot.toeOffCalculator;

import java.util.List;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.YoContactPoint;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.YoPlaneContactState;
import us.ihmc.commonWalkingControlModules.controlModules.foot.toeOffCalculator.ToeOffCalculator;
import us.ihmc.commonWalkingControlModules.controlModules.foot.toeOffCalculator.ToeOffEnum;
import us.ihmc.euclid.geometry.LineSegment2D;
import us.ihmc.euclid.geometry.interfaces.LineSegment2DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLineSegment2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;

public class ICPPlanToeOffCalculator
implements ToeOffCalculator {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private static final String namePrefix = "icpProj";
    private final SideDependentList<List<YoContactPoint>> contactPoints = new SideDependentList();
    private final FramePoint3D exitCMP = new FramePoint3D();
    private final FramePoint2D exitCMP2d = new FramePoint2D();
    private final FramePoint2D toeOffContactPoint2d = new FramePoint2D();
    private final LineSegment2D toeOffContactLine2d = new LineSegment2D();
    private final SideDependentList<ReferenceFrame> soleFrames = new SideDependentList();
    private final YoBoolean hasComputedToeOffContactPoint;
    private final YoBoolean hasComputedToeOffContactLine;

    public ICPPlanToeOffCalculator(SideDependentList<YoPlaneContactState> contactStates, SideDependentList<? extends ContactablePlaneBody> feet, YoRegistry parentRegistry) {
        for (RobotSide robotSide : RobotSide.values) {
            ReferenceFrame soleFrame = ((ContactablePlaneBody)feet.get((Enum)robotSide)).getSoleFrame();
            this.soleFrames.put((Enum)robotSide, (Object)soleFrame);
            this.contactPoints.put((Enum)robotSide, ((YoPlaneContactState)contactStates.get((Enum)robotSide)).getContactPoints());
        }
        this.hasComputedToeOffContactPoint = new YoBoolean("icpProjHasComputedToeOffContactPoint", this.registry);
        this.hasComputedToeOffContactLine = new YoBoolean("icpProjHasComputedToeOffContactLine", this.registry);
        parentRegistry.addChild(this.registry);
    }

    @Override
    public ToeOffEnum getEnum() {
        return ToeOffEnum.ICP_PLAN;
    }

    @Override
    public void clear() {
        this.exitCMP2d.setToNaN();
        this.hasComputedToeOffContactPoint.set(false);
    }

    @Override
    public void setExitCMP(FramePoint3DReadOnly exitCMP, RobotSide trailingLeg) {
        ReferenceFrame soleFrame = (ReferenceFrame)this.soleFrames.get((Enum)trailingLeg);
        this.exitCMP.setIncludingFrame((FrameTuple3DReadOnly)exitCMP);
        this.exitCMP.changeFrame(soleFrame);
        this.exitCMP2d.setToZero(soleFrame);
        this.exitCMP2d.setIncludingFrame((FrameTuple3DReadOnly)this.exitCMP);
    }

    @Override
    public void computeToeOffContactPoint(FramePoint2DReadOnly desiredCMP, RobotSide trailingLeg) {
        this.hasComputedToeOffContactPoint.set(true);
    }

    @Override
    public void getToeOffContactPoint(FramePoint2DBasics contactPointToPack, RobotSide trailingLeg) {
        if (!this.hasComputedToeOffContactPoint.getBooleanValue()) {
            this.computeToeOffContactPoint(null, trailingLeg);
        }
        contactPointToPack.set((FrameTuple2DReadOnly)this.toeOffContactPoint2d);
    }

    @Override
    public void computeToeOffContactLine(FramePoint2DReadOnly desiredCMP, RobotSide trailingLeg) {
        this.hasComputedToeOffContactLine.set(true);
    }

    @Override
    public void getToeOffContactLine(FrameLineSegment2DBasics contactLineToPack, RobotSide trailingLeg) {
        if (!this.hasComputedToeOffContactLine.getBooleanValue()) {
            this.computeToeOffContactLine(null, trailingLeg);
        }
        contactLineToPack.set((LineSegment2DReadOnly)this.toeOffContactLine2d);
    }
}

