/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold;

import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.FootRotationDetector;
import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.FootholdRotationParameters;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.robotics.math.filters.AlphaFilteredYoVariable;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class VelocityFootRotationDetector
implements FootRotationDetector {
    private final double dt;
    private final MovingReferenceFrame soleFrame;
    private final YoDouble integratedRotationAngle;
    private final YoDouble absoluteFootOmega;
    private final YoBoolean isRotating;
    private final DoubleProvider omegaThresholdForEstimation;
    private final DoubleProvider decayBreakFrequency;
    private final DoubleProvider rotationThreshold;

    public VelocityFootRotationDetector(RobotSide side, MovingReferenceFrame soleFrame, FootholdRotationParameters parameters, double dt, YoRegistry parentRegistry) {
        this.soleFrame = soleFrame;
        this.dt = dt;
        String namePrefix = side.getLowerCaseName() + "Velocity";
        YoRegistry registry = new YoRegistry(this.getClass().getSimpleName() + side.getPascalCaseName());
        parentRegistry.addChild(registry);
        this.omegaThresholdForEstimation = parameters.getOmegaMagnitudeThresholdForEstimation();
        this.decayBreakFrequency = parameters.getVelocityRotationAngleDecayBreakFrequency();
        this.rotationThreshold = parameters.getVelocityRotationAngleThreshold();
        this.integratedRotationAngle = new YoDouble(namePrefix + "IntegratedRotationAngle", registry);
        this.absoluteFootOmega = new YoDouble(namePrefix + "AbsoluteFootOmega", registry);
        this.isRotating = new YoBoolean(namePrefix + "IsRotating", registry);
        this.reset();
    }

    @Override
    public void reset() {
        this.integratedRotationAngle.set(0.0);
        this.absoluteFootOmega.set(0.0);
        this.isRotating.set(false);
    }

    @Override
    public boolean compute() {
        TwistReadOnly soleFrameTwist = this.soleFrame.getTwistOfFrame();
        this.absoluteFootOmega.set(soleFrameTwist.getAngularPart().length());
        if (this.absoluteFootOmega.getValue() > this.omegaThresholdForEstimation.getValue()) {
            this.integratedRotationAngle.add(this.dt * this.absoluteFootOmega.getValue());
        }
        this.isRotating.set(this.integratedRotationAngle.getValue() > this.rotationThreshold.getValue());
        this.integratedRotationAngle.mul(AlphaFilteredYoVariable.computeAlphaGivenBreakFrequencyProperly((double)this.decayBreakFrequency.getValue(), (double)this.dt));
        return this.isRotating.getValue();
    }

    @Override
    public boolean isRotating() {
        return this.isRotating.getBooleanValue();
    }
}

