/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold;

import java.util.List;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.YoPlaneContactState;
import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.CombinedFootRotationDetector;
import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.CombinedRotationEdgeCalculator;
import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.CropVerifier;
import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.FootRotationDetector;
import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.FootholdCropper;
import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.FootholdRotationParameters;
import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.RotationEdgeCalculator;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;

public class PartialFootholdCropperModule {
    private final FootholdCropper footholdCropper;
    private final CropVerifier cropVerifier;
    private final YoBoolean shouldShrinkFoothold;
    private final FootRotationDetector rotationDetector;
    private final RotationEdgeCalculator edgeCalculator;

    public PartialFootholdCropperModule(RobotSide side, MovingReferenceFrame soleFrame, List<? extends FramePoint2DReadOnly> defaultContactPoints, FootholdRotationParameters rotationParameters, double dt, YoRegistry parentRegistry, YoGraphicsListRegistry graphicsRegistry) {
        YoRegistry registry = new YoRegistry(this.getClass().getSimpleName() + side.getPascalCaseName());
        parentRegistry.addChild(registry);
        this.shouldShrinkFoothold = new YoBoolean(side.getLowerCaseName() + "ShouldShrinkFoothold", registry);
        this.rotationDetector = new CombinedFootRotationDetector(side, soleFrame, rotationParameters, dt, registry);
        this.edgeCalculator = new CombinedRotationEdgeCalculator(side, soleFrame, rotationParameters, dt, registry, graphicsRegistry);
        this.cropVerifier = new CropVerifier(side.getLowerCaseName(), (ReferenceFrame)soleFrame, 0.005, rotationParameters, registry, null);
        this.footholdCropper = new FootholdCropper(side.getLowerCaseName(), (ReferenceFrame)soleFrame, defaultContactPoints, rotationParameters, dt, registry, graphicsRegistry);
        this.reset();
    }

    public void compute(FramePoint2DReadOnly measuredCoP, FramePoint2DReadOnly desiredCoP) {
        boolean isRotating = this.rotationDetector.compute();
        this.shouldShrinkFoothold.set(false);
        this.cropVerifier.update(desiredCoP);
        this.footholdCropper.update(measuredCoP);
        if (!isRotating) {
            this.edgeCalculator.reset();
            return;
        }
        boolean isEdgeTrusted = this.edgeCalculator.compute(measuredCoP);
        FrameLine2DReadOnly lineOfRotation = this.edgeCalculator.getLineOfRotation();
        RobotSide sideToCrop = this.footholdCropper.computeSideToCrop(lineOfRotation);
        if (isEdgeTrusted && sideToCrop != null) {
            this.shouldShrinkFoothold.set(this.cropVerifier.verifyFootholdCrop(desiredCoP, sideToCrop, lineOfRotation));
            if (this.shouldShrinkFoothold.getBooleanValue()) {
                this.footholdCropper.computeShrunkenFoothold(lineOfRotation, sideToCrop);
            }
        }
    }

    public boolean isRotating() {
        return this.rotationDetector.compute();
    }

    public boolean applyShrunkenFoothold(YoPlaneContactState contactStateToModify) {
        if (!this.shouldApplyShrunkenFoothold()) {
            return false;
        }
        return this.footholdCropper.applyShrunkenFoothold(contactStateToModify);
    }

    boolean shouldApplyShrunkenFoothold() {
        if (!this.shouldShrinkFoothold.getBooleanValue()) {
            return false;
        }
        return this.footholdCropper.shouldApplyShrunkenFoothold();
    }

    public FrameConvexPolygon2DReadOnly getShrunkenFootPolygon() {
        return this.footholdCropper.getShrunkenFootPolygon();
    }

    public FrameLine2DReadOnly getLineOfRotation() {
        return this.edgeCalculator.getLineOfRotation();
    }

    public void initialize(FrameConvexPolygon2DReadOnly footPolygon) {
        this.cropVerifier.initialize();
        this.footholdCropper.reset(footPolygon);
    }

    public void reset() {
        this.rotationDetector.reset();
        this.edgeCalculator.reset();
        this.cropVerifier.reset();
        this.footholdCropper.reset();
    }
}

