/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold;

import java.awt.Color;
import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.EdgeVelocityStabilityEvaluator;
import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.EdgeVisualizer;
import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.FootholdRotationParameters;
import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.RotationEdgeCalculator;
import us.ihmc.euclid.geometry.interfaces.Line2DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameLine2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.statistics.Line2DStatisticsCalculator;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameLine2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class GeometricRotationEdgeCalculator
implements RotationEdgeCalculator {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final MovingReferenceFrame soleFrame;
    private final FrameVector3D lineOfContact = new FrameVector3D();
    private final FrameVector3D footNormal = new FrameVector3D();
    private final YoFrameVector3D groundPlaneNormal;
    private final FrameLine2D lineOfRotationInWorldFrame = new FrameLine2D();
    private final YoFrameLine2D lineOfRotationInSole;
    private final Line2DStatisticsCalculator lineOfRotationStandardDeviation;
    private final EdgeVisualizer edgeVisualizer;
    private final EdgeVelocityStabilityEvaluator stabilityEvaluator;
    private final FramePoint3D tempPointOfRotation = new FramePoint3D();

    public GeometricRotationEdgeCalculator(RobotSide side, MovingReferenceFrame soleFrame, FootholdRotationParameters rotationParameters, double dt, YoRegistry parentRegistry, YoGraphicsListRegistry graphicsListRegistry) {
        this.soleFrame = soleFrame;
        String namePrefix = side.getLowerCaseName() + "Geometric";
        YoRegistry registry = new YoRegistry(namePrefix + this.getClass().getSimpleName());
        YoFramePoint2D point = new YoFramePoint2D(namePrefix + "PointOfRotation", (ReferenceFrame)soleFrame, registry);
        YoFrameVector2D direction = new YoFrameVector2D(namePrefix + "AxisOfRotation", (ReferenceFrame)soleFrame, registry);
        this.lineOfRotationInSole = new YoFrameLine2D(point, direction);
        this.groundPlaneNormal = new YoFrameVector3D(namePrefix + "PlaneNormal", worldFrame, registry);
        this.groundPlaneNormal.setZ(1.0);
        this.lineOfRotationStandardDeviation = new Line2DStatisticsCalculator(namePrefix + "LineOfRotation", (Line2DReadOnly)this.lineOfRotationInSole, registry);
        this.edgeVisualizer = graphicsListRegistry != null ? new EdgeVisualizer(namePrefix, Color.GREEN, registry, graphicsListRegistry) : null;
        this.stabilityEvaluator = new EdgeVelocityStabilityEvaluator(namePrefix, (FrameLine2DReadOnly)this.lineOfRotationInSole, rotationParameters.getStableRotationDirectionThreshold(), rotationParameters.getStableRotationPositionThreshold(), rotationParameters.getStableEdgeWindowSize(), dt, registry);
        this.reset();
        parentRegistry.addChild(registry);
    }

    @Override
    public void reset() {
        if (this.edgeVisualizer != null) {
            this.edgeVisualizer.reset();
        }
        this.lineOfRotationInSole.setToZero();
        this.lineOfRotationStandardDeviation.reset();
    }

    @Override
    public boolean compute(FramePoint2DReadOnly measuredCoP) {
        this.footNormal.setIncludingFrame((ReferenceFrame)this.soleFrame, 0.0, 0.0, 1.0);
        this.footNormal.changeFrame(worldFrame);
        this.lineOfContact.cross((FrameVector3DReadOnly)this.groundPlaneNormal, (FrameVector3DReadOnly)this.footNormal);
        this.tempPointOfRotation.setIncludingFrame((FrameTuple2DReadOnly)measuredCoP, 0.0);
        this.lineOfRotationInWorldFrame.setToZero(worldFrame);
        this.lineOfRotationInWorldFrame.set((FramePoint3DReadOnly)this.tempPointOfRotation, (FrameVector3DReadOnly)this.lineOfContact);
        this.lineOfRotationInSole.setMatchingFrame((FrameLine2DReadOnly)this.lineOfRotationInWorldFrame);
        this.stabilityEvaluator.update();
        if (this.edgeVisualizer != null) {
            this.edgeVisualizer.visualize(this.stabilityEvaluator.isEdgeVelocityStable());
            this.edgeVisualizer.updateGraphics((FrameLine2DReadOnly)this.lineOfRotationInSole);
        }
        return this.isRotationEdgeTrusted();
    }

    @Override
    public FrameLine2DReadOnly getLineOfRotation() {
        return this.lineOfRotationInSole;
    }

    @Override
    public boolean isRotationEdgeTrusted() {
        return this.stabilityEvaluator.isEdgeVelocityStable();
    }
}

