/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold;

import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.FootRotationDetector;
import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.FootholdRotationParameters;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class GeometricRotationDetector
implements FootRotationDetector {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoFrameVector3D groundPlaneNormal;
    private final FrameVector3D footNormal = new FrameVector3D();
    private final YoDouble angleFootGround;
    private final DoubleProvider angleThreshold;
    private final YoBoolean isRotating;
    private final ReferenceFrame soleFrame;

    public GeometricRotationDetector(RobotSide side, ReferenceFrame soleFrame, FootholdRotationParameters explorationParameters, YoRegistry parentRegistry) {
        this.soleFrame = soleFrame;
        String namePrefix = side.getLowerCaseName() + "Geometric";
        YoRegistry registry = new YoRegistry(namePrefix + this.getClass().getSimpleName());
        this.groundPlaneNormal = new YoFrameVector3D(namePrefix + "PlaneNormal", worldFrame, registry);
        this.groundPlaneNormal.setZ(1.0);
        this.angleFootGround = new YoDouble(namePrefix + "AngleToGround", registry);
        this.angleThreshold = explorationParameters.getGeometricDetectionAngleThreshold();
        this.isRotating = new YoBoolean(namePrefix + "IsRotating", registry);
        parentRegistry.addChild(registry);
    }

    @Override
    public void reset() {
        this.isRotating.set(false);
        this.angleFootGround.setToNaN();
    }

    @Override
    public boolean compute() {
        this.footNormal.setIncludingFrame(this.soleFrame, 0.0, 0.0, 1.0);
        this.footNormal.changeFrame(worldFrame);
        double cosAlpha = Math.abs(this.groundPlaneNormal.dot((FrameVector3DReadOnly)this.footNormal));
        double alpha = Math.acos(cosAlpha);
        this.angleFootGround.set(alpha);
        this.isRotating.set(this.angleFootGround.getDoubleValue() > this.angleThreshold.getValue());
        return this.isRotating.getBooleanValue();
    }

    @Override
    public boolean isRotating() {
        return this.isRotating.getBooleanValue();
    }
}

