/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold;

import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.FootholdRotationParameters;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine2DReadOnly;
import us.ihmc.robotics.occupancyGrid.OccupancyGrid;
import us.ihmc.robotics.occupancyGrid.OccupancyGridTools;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.providers.IntegerProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoInteger;

public class FootCoPOccupancyCalculator {
    private final YoBoolean leftSideIsOccupied;
    private final YoBoolean rightSideIsOccupied;
    private final YoInteger numberOfOccupiedCellsOnLeft;
    private final YoInteger numberOfOccupiedCellsOnRight;
    private final IntegerProvider thresholdForCoPRegionOccupancy;
    private final DoubleProvider distanceFromLineOfRotationToComputeCoPOccupancy;
    private final OccupancyGrid occupancyGrid;
    private final YoEnum<RobotSide> sideOfFootToCrop;

    public FootCoPOccupancyCalculator(String namePrefix, OccupancyGrid occupancyGrid, FootholdRotationParameters explorationParameters, YoRegistry parentRegistry) {
        this.occupancyGrid = occupancyGrid;
        String name = this.getClass().getSimpleName();
        YoRegistry registry = new YoRegistry(namePrefix + name);
        this.sideOfFootToCrop = new YoEnum(namePrefix + "OccupancySideOfFootToCrop", registry, RobotSide.class, true);
        this.thresholdForCoPRegionOccupancy = explorationParameters.getThresholdForCoPRegionOccupancy();
        this.distanceFromLineOfRotationToComputeCoPOccupancy = explorationParameters.getDistanceFromLineOfRotationToComputeCoPOccupancy();
        this.numberOfOccupiedCellsOnRight = new YoInteger(namePrefix + "NumberOfCellsOccupiedOnRightSideOfLine", registry);
        this.numberOfOccupiedCellsOnLeft = new YoInteger(namePrefix + "NumberOfCellsOccupiedOnLeftSideOfLine", registry);
        this.leftSideIsOccupied = new YoBoolean(namePrefix + "FootLeftSideOfLineIsOccupied", registry);
        this.rightSideIsOccupied = new YoBoolean(namePrefix + "FootRightSideOfLineIsOccupied", registry);
        this.reset();
        parentRegistry.addChild(registry);
    }

    public RobotSide computeSideOfFootholdToCrop(FrameLine2DReadOnly lineOfRotation) {
        this.numberOfOccupiedCellsOnLeft.set(OccupancyGridTools.computeNumberOfCellsOccupiedOnSideOfLine((OccupancyGrid)this.occupancyGrid, (FrameLine2DReadOnly)lineOfRotation, (RobotSide)RobotSide.LEFT, (double)this.distanceFromLineOfRotationToComputeCoPOccupancy.getValue()));
        this.numberOfOccupiedCellsOnRight.set(OccupancyGridTools.computeNumberOfCellsOccupiedOnSideOfLine((OccupancyGrid)this.occupancyGrid, (FrameLine2DReadOnly)lineOfRotation, (RobotSide)RobotSide.RIGHT, (double)this.distanceFromLineOfRotationToComputeCoPOccupancy.getValue()));
        this.leftSideIsOccupied.set(this.numberOfOccupiedCellsOnLeft.getIntegerValue() >= this.thresholdForCoPRegionOccupancy.getValue());
        this.rightSideIsOccupied.set(this.numberOfOccupiedCellsOnRight.getIntegerValue() >= this.thresholdForCoPRegionOccupancy.getValue());
        if (this.leftSideIsOccupied.getBooleanValue() && this.rightSideIsOccupied.getBooleanValue()) {
            this.sideOfFootToCrop.set(null);
        } else if (this.leftSideIsOccupied.getBooleanValue()) {
            this.sideOfFootToCrop.set((Enum)RobotSide.RIGHT);
        } else if (this.rightSideIsOccupied.getBooleanValue()) {
            this.sideOfFootToCrop.set((Enum)RobotSide.LEFT);
        } else {
            this.sideOfFootToCrop.set(null);
        }
        return (RobotSide)this.sideOfFootToCrop.getEnumValue();
    }

    public void reset() {
        this.leftSideIsOccupied.set(false);
        this.rightSideIsOccupied.set(false);
        this.numberOfOccupiedCellsOnLeft.set(-1);
        this.numberOfOccupiedCellsOnRight.set(-1);
        this.sideOfFootToCrop.set(null);
    }
}

