/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold;

import us.ihmc.euclid.referenceFrame.interfaces.FrameLine2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameUnitVector2DReadOnly;
import us.ihmc.robotics.math.filters.FilteredVelocityYoFrameVector2d;
import us.ihmc.robotics.math.filters.FilteredVelocityYoVariable;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.providers.IntegerProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class EdgeVelocityStabilityEvaluator {
    private final FilteredVelocityYoFrameVector2d centerOfRotationVelocity;
    private final YoDouble centerOfRotationTransverseVelocity;
    private final IntegerProvider stableWindowWize;
    private final YoDouble angleOfLineOfRotation;
    private final FilteredVelocityYoVariable lineOfRotationAngularVelocity;
    private final DoubleProvider centerOfRotationStableVelocityThreshold;
    private final YoBoolean isCenterOfRotationStable;
    private final DoubleProvider lineOfRotationStableVelocityThreshold;
    private final YoBoolean isLineOfRotationStable;
    private final YoBoolean isEdgeStable;
    private final YoInteger stableCounter;
    private final FrameLine2DReadOnly lineOfRotation;

    public EdgeVelocityStabilityEvaluator(String namePrefix, FrameLine2DReadOnly lineOfRotation, DoubleProvider lineOfRotationStableVelocityThreshold, DoubleProvider centerOfRotationStableVelocityThreshold, IntegerProvider stableWindowWize, double dt, YoRegistry registry) {
        this.lineOfRotation = lineOfRotation;
        this.lineOfRotationStableVelocityThreshold = lineOfRotationStableVelocityThreshold;
        this.centerOfRotationStableVelocityThreshold = centerOfRotationStableVelocityThreshold;
        this.stableWindowWize = stableWindowWize;
        YoDouble centerOfRotationVelocityAlphaFilter = new YoDouble(namePrefix + "CenterOfRotationVelocityAlphaFilter", registry);
        this.centerOfRotationVelocity = new FilteredVelocityYoFrameVector2d(namePrefix + "CenterOfRotationVelocity", "", (DoubleProvider)centerOfRotationVelocityAlphaFilter, dt, registry, (FrameTuple2DReadOnly)lineOfRotation.getPoint());
        this.centerOfRotationTransverseVelocity = new YoDouble(namePrefix + "CenterOfRotationTransverseVelocity", registry);
        this.angleOfLineOfRotation = new YoDouble(namePrefix + "AngleOfLineOfRotation", registry);
        YoDouble lineOfRotationAngularVelocityAlphaFilter = new YoDouble(namePrefix + "LineOfRotationAngularVelocityAlphaFilter", registry);
        this.lineOfRotationAngularVelocity = new FilteredVelocityYoVariable(namePrefix + "LineOfRotationAngularVelocityFiltered", "", (DoubleProvider)lineOfRotationAngularVelocityAlphaFilter, this.angleOfLineOfRotation, dt, registry);
        this.isLineOfRotationStable = new YoBoolean(namePrefix + "IsLineOfRotationStable", registry);
        this.isCenterOfRotationStable = new YoBoolean(namePrefix + "IsCenterOfRotationStable", registry);
        this.isEdgeStable = new YoBoolean(namePrefix + "IsEdgeStable", registry);
        this.stableCounter = new YoInteger(namePrefix + "IsEdgeStableCount", registry);
    }

    public void reset() {
        this.centerOfRotationVelocity.reset();
        this.centerOfRotationVelocity.setToNaN();
        this.angleOfLineOfRotation.set(0.0);
        this.lineOfRotationAngularVelocity.set(Double.NaN);
        this.lineOfRotationAngularVelocity.reset();
        this.stableCounter.set(0);
        this.isLineOfRotationStable.set(false);
        this.isCenterOfRotationStable.set(false);
        this.isEdgeStable.set(false);
    }

    public void update() {
        this.centerOfRotationVelocity.update();
        FrameUnitVector2DReadOnly directionOfRotation = this.lineOfRotation.getDirection();
        this.centerOfRotationTransverseVelocity.set(this.centerOfRotationVelocity.cross((FrameTuple2DReadOnly)directionOfRotation) / directionOfRotation.length());
        this.angleOfLineOfRotation.set(Math.atan2(directionOfRotation.getY(), directionOfRotation.getX()));
        this.lineOfRotationAngularVelocity.updateForAngles();
        this.isLineOfRotationStable.set(Math.abs(this.lineOfRotationAngularVelocity.getDoubleValue()) < this.lineOfRotationStableVelocityThreshold.getValue());
        this.isCenterOfRotationStable.set(Math.abs(this.centerOfRotationTransverseVelocity.getDoubleValue()) < this.centerOfRotationStableVelocityThreshold.getValue());
        this.updateStableCount(this.isLineOfRotationStable.getBooleanValue(), this.isCenterOfRotationStable.getBooleanValue());
    }

    private void updateStableCount(boolean isLineOfRotationStable, boolean isCenterOfRotationStable) {
        boolean isStable;
        boolean bl = isStable = isLineOfRotationStable && isCenterOfRotationStable;
        if (this.isEdgeStable.getBooleanValue()) {
            if (!isCenterOfRotationStable) {
                this.isEdgeStable.set(false);
                this.stableCounter.set(0);
                return;
            }
            if (!isLineOfRotationStable) {
                this.stableCounter.increment();
            } else {
                this.stableCounter.decrement();
                if (this.stableCounter.getIntegerValue() < 0) {
                    this.stableCounter.set(0);
                }
            }
        } else if (isStable) {
            this.stableCounter.increment();
        } else {
            this.stableCounter.decrement();
            if (this.stableCounter.getIntegerValue() < 0) {
                this.stableCounter.set(0);
            }
        }
        if (this.stableCounter.getIntegerValue() > this.stableWindowWize.getValue() - 1) {
            this.isEdgeStable.set(isStable);
            this.stableCounter.set(0);
        }
    }

    public boolean isEdgeVelocityStable() {
        return this.isEdgeStable.getBooleanValue();
    }
}

