/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold;

import java.awt.Color;
import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.CoPAndVelocityRotationEdgeCalculator;
import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.CoPHistoryRotationEdgeCalculator;
import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.EdgeVisualizer;
import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.FootholdRotationParameters;
import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.RotationEdgeCalculator;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;

public class CombinedRotationEdgeCalculator
implements RotationEdgeCalculator {
    private final RotationEdgeCalculator copHistoryEdgeCalculator;
    private final CoPAndVelocityRotationEdgeCalculator copAndVelocityEdgeCalculator;
    private final EdgeVisualizer edgeVisualizer;
    private final YoBoolean isEdgeStable;

    public CombinedRotationEdgeCalculator(RobotSide side, MovingReferenceFrame soleFrame, FootholdRotationParameters rotationParameters, double dt, YoRegistry registry, YoGraphicsListRegistry graphicsRegistry) {
        this.copHistoryEdgeCalculator = new CoPHistoryRotationEdgeCalculator(side, (ReferenceFrame)soleFrame, rotationParameters, dt, registry, Color.BLUE, graphicsRegistry);
        this.copAndVelocityEdgeCalculator = new CoPAndVelocityRotationEdgeCalculator(side, soleFrame, rotationParameters, dt, registry, Color.GRAY, graphicsRegistry);
        this.isEdgeStable = new YoBoolean(side.getLowerCaseName() + "IsEdgeStable", registry);
        this.edgeVisualizer = null;
    }

    @Override
    public void reset() {
        this.isEdgeStable.set(false);
        if (this.edgeVisualizer != null) {
            this.edgeVisualizer.visualize(false);
            this.edgeVisualizer.reset();
        }
        this.copAndVelocityEdgeCalculator.reset();
        this.copHistoryEdgeCalculator.reset();
    }

    @Override
    public boolean compute(FramePoint2DReadOnly measuredCoP) {
        FrameLine2DReadOnly lineOfRotation = this.computeLineOfRotation(measuredCoP);
        this.isEdgeStable.set(lineOfRotation != null);
        if (!this.isEdgeStable.getBooleanValue()) {
            return false;
        }
        if (this.edgeVisualizer != null) {
            this.edgeVisualizer.visualize(true);
            this.edgeVisualizer.updateGraphics(lineOfRotation);
        }
        return this.isRotationEdgeTrusted();
    }

    @Override
    public FrameLine2DReadOnly getLineOfRotation() {
        if (this.copHistoryEdgeCalculator.isRotationEdgeTrusted()) {
            return this.copHistoryEdgeCalculator.getLineOfRotation();
        }
        return this.copAndVelocityEdgeCalculator.getLineOfRotation();
    }

    @Override
    public boolean isRotationEdgeTrusted() {
        return this.isEdgeStable.getBooleanValue();
    }

    private FrameLine2DReadOnly computeLineOfRotation(FramePoint2DReadOnly measuredCoP) {
        this.copHistoryEdgeCalculator.compute(measuredCoP);
        this.copAndVelocityEdgeCalculator.compute(measuredCoP);
        return this.getLineOfRotation();
    }
}

