/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold;

import java.awt.Color;
import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.EdgeVelocityStabilityEvaluator;
import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.EdgeVisualizer;
import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.FootholdRotationParameters;
import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.RotationEdgeCalculator;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.robotics.functionApproximation.OnlineLine2DLinearRegression;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameLine2D;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.providers.IntegerProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;

public class CoPHistoryRotationEdgeCalculator
implements RotationEdgeCalculator {
    private final OnlineLine2DLinearRegression lineCalculator;
    private final YoFrameLine2D lineOfRotationInSole;
    private final EdgeVelocityStabilityEvaluator stabilityEvaluator;
    private final EdgeVisualizer edgeVisualizer;
    private final DoubleProvider inlineStdDevThreshold;
    private final DoubleProvider transverseStdDevThreshold;
    private final YoBoolean statisticsStable;
    private final YoBoolean lineStable;

    public CoPHistoryRotationEdgeCalculator(RobotSide side, ReferenceFrame soleFrame, FootholdRotationParameters rotationParameters, double dt, YoRegistry parentRegistry, Color color, YoGraphicsListRegistry graphicsListRegistry) {
        this(side, soleFrame, rotationParameters.getStableRotationDirectionThreshold(), rotationParameters.getStableRotationPositionThreshold(), rotationParameters.getStableEdgeWindowSize(), rotationParameters.getInlineCoPHistoryStdDev(), rotationParameters.getTransverseCoPHistoryStdDev(), dt, parentRegistry, color, graphicsListRegistry);
    }

    public CoPHistoryRotationEdgeCalculator(RobotSide side, ReferenceFrame soleFrame, DoubleProvider stableRotationDirectionThreshold, DoubleProvider stableRotationPositionThreshold, IntegerProvider stableEdgeWindowSize, DoubleProvider inlineStdDevThreshold, DoubleProvider transverseStdDevThreshold, double dt, YoRegistry parentRegistry, Color color, YoGraphicsListRegistry graphicsListRegistry) {
        String namePrefix = side.getLowerCaseName() + "CoPHistory";
        YoRegistry registry = new YoRegistry(namePrefix + this.getClass().getSimpleName());
        this.lineStable = new YoBoolean(namePrefix + "IsStable", registry);
        this.statisticsStable = new YoBoolean(namePrefix + "StatisticsStable", registry);
        this.inlineStdDevThreshold = inlineStdDevThreshold;
        this.transverseStdDevThreshold = transverseStdDevThreshold;
        this.lineCalculator = new OnlineLine2DLinearRegression(namePrefix + "FootRotation", registry);
        this.lineOfRotationInSole = new YoFrameLine2D(namePrefix + "LineOfRotation", "", soleFrame, registry);
        this.stabilityEvaluator = new EdgeVelocityStabilityEvaluator(namePrefix, (FrameLine2DReadOnly)this.lineOfRotationInSole, stableRotationDirectionThreshold, stableRotationPositionThreshold, stableEdgeWindowSize, dt, registry);
        this.edgeVisualizer = graphicsListRegistry != null ? new EdgeVisualizer(namePrefix, color, registry, graphicsListRegistry) : null;
        parentRegistry.addChild(registry);
    }

    @Override
    public void reset() {
        if (this.edgeVisualizer != null) {
            this.edgeVisualizer.reset();
        }
        this.stabilityEvaluator.reset();
        this.lineCalculator.reset();
    }

    @Override
    public boolean compute(FramePoint2DReadOnly measuredCoP) {
        this.lineCalculator.update((Point2DReadOnly)measuredCoP);
        this.lineOfRotationInSole.set(this.lineCalculator.getMeanLine());
        this.stabilityEvaluator.update();
        this.statisticsStable.set(this.lineCalculator.getTransverseStandardDeviation() < this.transverseStdDevThreshold.getValue() && this.lineCalculator.getInlineStandardDeviation() > this.inlineStdDevThreshold.getValue());
        this.lineStable.set(this.statisticsStable.getBooleanValue() && this.stabilityEvaluator.isEdgeVelocityStable());
        if (this.edgeVisualizer != null) {
            this.edgeVisualizer.visualize(true);
            this.edgeVisualizer.updateGraphics((FrameLine2DReadOnly)this.lineOfRotationInSole);
        }
        return this.isRotationEdgeTrusted();
    }

    @Override
    public FrameLine2DReadOnly getLineOfRotation() {
        return this.lineOfRotationInSole;
    }

    @Override
    public boolean isRotationEdgeTrusted() {
        return this.lineStable.getBooleanValue();
    }
}

