/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold;

import java.awt.Color;
import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.EdgeVelocityStabilityEvaluator;
import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.EdgeVisualizer;
import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.FootholdRotationParameters;
import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.RotationEdgeCalculator;
import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.VelocityRotationEdgeCalculator;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameLine2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.robotics.math.filters.AlphaFilteredYoFramePoint2d;
import us.ihmc.robotics.math.filters.AlphaFilteredYoVariable;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameLine2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector2D;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.providers.IntegerProvider;
import us.ihmc.yoVariables.registry.YoRegistry;

public class CoPAndVelocityRotationEdgeCalculator
implements RotationEdgeCalculator {
    private final RotationEdgeCalculator velocityEdgeCalculator;
    private final AlphaFilteredYoFramePoint2d pointOfRotation;
    private final YoFrameVector2D axisOfRotation;
    private final FixedFrameLine2DBasics lineOfRotationInSole;
    private final EdgeVelocityStabilityEvaluator stabilityEvaluator;
    private final EdgeVisualizer edgeVisualizer;

    public CoPAndVelocityRotationEdgeCalculator(RobotSide side, MovingReferenceFrame soleFrame, FootholdRotationParameters rotationParameters, double dt, YoRegistry parentRegistry, Color color, YoGraphicsListRegistry graphicsListRegistry) {
        this(side, soleFrame, rotationParameters.getVelocityEdgeFilterBreakFrequency(), rotationParameters.getCopHistoryBreakFrequency(), rotationParameters.getStableRotationDirectionThreshold(), rotationParameters.getStableRotationPositionThreshold(), rotationParameters.getStableEdgeWindowSize(), dt, parentRegistry, color, graphicsListRegistry);
    }

    public CoPAndVelocityRotationEdgeCalculator(RobotSide side, MovingReferenceFrame soleFrame, DoubleProvider velocityEdgeFilterBreakFrequency, DoubleProvider copHistoryBreakFrequency, DoubleProvider stableRotationDirectionThreshold, DoubleProvider stableRotationPositionThreshold, IntegerProvider stableEdgeWindowSize, double dt, YoRegistry parentRegistry, Color color, YoGraphicsListRegistry graphicsListRegistry) {
        this(side, (ReferenceFrame)soleFrame, new VelocityRotationEdgeCalculator(side, soleFrame, velocityEdgeFilterBreakFrequency, stableRotationDirectionThreshold, stableRotationPositionThreshold, stableEdgeWindowSize, dt, parentRegistry, null), copHistoryBreakFrequency, stableRotationDirectionThreshold, stableRotationPositionThreshold, stableEdgeWindowSize, dt, parentRegistry, color, graphicsListRegistry);
    }

    public CoPAndVelocityRotationEdgeCalculator(RobotSide side, ReferenceFrame soleFrame, RotationEdgeCalculator velocityEdgeCalculator, DoubleProvider copHistoryBreakFrequency, DoubleProvider stableRotationDirectionThreshold, DoubleProvider stableRotationPositionThreshold, IntegerProvider stableEdgeWindowSize, double dt, YoRegistry parentRegistry, Color color, YoGraphicsListRegistry graphicsListRegistry) {
        this.velocityEdgeCalculator = velocityEdgeCalculator;
        String namePrefix = side.getLowerCaseName() + "CoPAndVelocity";
        YoRegistry registry = new YoRegistry(namePrefix + this.getClass().getSimpleName());
        DoubleProvider alpha = () -> AlphaFilteredYoVariable.computeAlphaGivenBreakFrequencyProperly((double)copHistoryBreakFrequency.getValue(), (double)dt);
        this.pointOfRotation = new AlphaFilteredYoFramePoint2d(namePrefix + "PointOfRotation", "", registry, alpha, soleFrame);
        this.axisOfRotation = new YoFrameVector2D(namePrefix + "AxisOfRotation", soleFrame, registry);
        this.lineOfRotationInSole = new YoFrameLine2D((YoFramePoint2D)this.pointOfRotation, this.axisOfRotation);
        this.stabilityEvaluator = new EdgeVelocityStabilityEvaluator(namePrefix, (FrameLine2DReadOnly)this.lineOfRotationInSole, stableRotationDirectionThreshold, stableRotationPositionThreshold, stableEdgeWindowSize, dt, registry);
        this.edgeVisualizer = graphicsListRegistry != null ? new EdgeVisualizer(namePrefix, color, registry, graphicsListRegistry) : null;
        this.reset();
        parentRegistry.addChild(registry);
    }

    @Override
    public boolean compute(FramePoint2DReadOnly measuredCoP) {
        if (!measuredCoP.containsNaN()) {
            this.pointOfRotation.update((FrameTuple2DReadOnly)measuredCoP);
        }
        if (this.pointOfRotation.containsNaN()) {
            this.pointOfRotation.set((FrameTuple2DReadOnly)measuredCoP);
        }
        this.velocityEdgeCalculator.compute(measuredCoP);
        this.axisOfRotation.set((FrameTuple2DReadOnly)this.velocityEdgeCalculator.getLineOfRotation().getDirection());
        this.stabilityEvaluator.update();
        if (this.edgeVisualizer != null) {
            this.edgeVisualizer.visualize(true);
            this.edgeVisualizer.updateGraphics((FrameLine2DReadOnly)this.lineOfRotationInSole);
        }
        return this.isRotationEdgeTrusted();
    }

    @Override
    public void reset() {
        this.velocityEdgeCalculator.reset();
        this.pointOfRotation.setToNaN();
        this.axisOfRotation.setToNaN();
        this.lineOfRotationInSole.setToNaN();
        this.stabilityEvaluator.reset();
        if (this.edgeVisualizer != null) {
            this.edgeVisualizer.visualize(false);
            this.edgeVisualizer.reset();
        }
    }

    @Override
    public FrameLine2DReadOnly getLineOfRotation() {
        return this.lineOfRotationInSole;
    }

    @Override
    public boolean isRotationEdgeTrusted() {
        return this.stabilityEvaluator.isEdgeVelocityStable();
    }
}

