/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.foot;

import us.ihmc.commonWalkingControlModules.configurations.SwingTrajectoryParameters;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.controlModules.foot.FootControlModule;
import us.ihmc.commonWalkingControlModules.controlModules.foot.WorkspaceLimiterParameters;
import us.ihmc.commonWalkingControlModules.heightPlanning.CoMHeightTimeDerivativesDataBasics;
import us.ihmc.commonWalkingControlModules.momentumBasedController.HighLevelHumanoidControllerToolbox;
import us.ihmc.commons.InterpolationTools;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector2DBasics;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicReferenceFrame;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicVector;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.TwistBasics;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.math.filters.AlphaFilteredYoVariable;
import us.ihmc.robotics.partNames.LegJointName;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.parameters.BooleanParameter;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class WorkspaceLimiterControlModule {
    private static final double epsilon = 0.005;
    private boolean visualize = true;
    private boolean moreVisualizers = true;
    private static final boolean USE_UNREACHABLE_FOOTSTEP_CORRECTION = true;
    private final BooleanParameter useSingularityAvoidanceInSwing;
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final ReferenceFrame endEffectorFrame;
    private final ReferenceFrame virtualLegTangentialFrameHipCentered;
    private final ReferenceFrame virtualLegTangentialFrameAnkleCentered;
    private final YoRegistry registry;
    private final YoBoolean checkVelocityForSwingSingularityAvoidance;
    private final YoDouble alphaSwingSingularityAvoidanceForFoot;
    private final YoDouble alphaSwingSingularityAvoidanceForHeight;
    private final YoDouble maximumLegLength;
    private final DoubleProvider percentOfLegLengthMarginToEnableSingularityAvoidanceForFoot;
    private final DoubleProvider percentOfLegLengthMarginToEnableSingularityAvoidanceForHeight;
    private final DoubleProvider maxPercentOfLegLengthForSingularityAvoidanceInSwingForFoot;
    private final DoubleProvider maxPercentOfLegLengthForSingularityAvoidanceInSwingForHeight;
    private final DoubleProvider minPercentOfLegLengthForSingularityAvoidanceInSwing;
    private final DoubleProvider velocityDifferenceForLengthening;
    private final YoDouble desiredPercentOfLegLength;
    private final YoDouble currentPercentOfLegLength;
    private final YoDouble desiredLegLength;
    private final YoDouble currentLegLength;
    private final RigidBodyBasics pelvis;
    private final FrameVector3D tempVector = new FrameVector3D();
    private final YoFrameVector3D unachievedSwingTranslation;
    private final YoFrameVector3D unachievedSwingVelocity;
    private final YoFrameVector3D unachievedSwingAcceleration;
    private final FramePoint3D desiredCenterOfMassHeightPoint = new FramePoint3D(worldFrame);
    private final FramePoint3D anklePosition = new FramePoint3D(worldFrame);
    private final ReferenceFrame frameBeforeHipPitchJoint;
    private final Twist pelvisTwist = new Twist();
    private final FrameVector3D pelvisLinearVelocity = new FrameVector3D();
    private final FramePoint3D desiredFootPosition = new FramePoint3D();
    private final FrameVector3D desiredFootLinearVelocity = new FrameVector3D();
    private final FrameVector3D desiredFootLinearAcceleration = new FrameVector3D();
    private final YoFramePoint3D yoCurrentFootPosition;
    private final YoFramePoint3D yoDesiredFootPosition;
    private final YoFramePoint3D yoCorrectedDesiredFootPosition;
    private final YoFrameVector3D yoDesiredFootLinearVelocity;
    private final YoFrameVector3D yoCorrectedDesiredFootLinearVelocity;
    private final YoFrameVector3D yoDesiredFootLinearAcceleration;
    private final YoFrameVector3D yoCorrectedDesiredFootLinearAcceleration;
    private final YoGraphicReferenceFrame virtualLegTangentialFrameHipCenteredGraphics;
    private final YoGraphicReferenceFrame virtualLegTangentialFrameAnkleCenteredGraphics;
    private final YoGraphicPosition yoDesiredFootPositionGraphic;
    private final YoGraphicPosition yoCorrectedDesiredFootPositionGraphic;
    private final YoGraphicVector yoDesiredFootLinearVelocityGraphic;
    private final YoGraphicVector yoCorrectedDesiredFootLinearVelocityGraphic;
    private final YoBoolean isSwingSingularityAvoidanceUsed;
    private final YoBoolean isSwingSingularityAvoidanceUsedOnHeight;
    private final YoBoolean isUnreachableFootstepCompensated;
    private final DoubleProvider timeToCorrectForUnachievedSwingTranslation;
    private final AlphaFilteredYoVariable unachievedSwingTranslationFiltered;
    private final AlphaFilteredYoVariable unachievedSwingVelocityFiltered;
    private final AlphaFilteredYoVariable unachievedSwingAccelerationFiltered;
    private final YoBoolean doSmoothTransitionOutOfSingularityAvoidance;
    private final YoBoolean doSmoothTransitionOutOfUnreachableStep;
    private final YoDouble alphaSupportSingularityAvoidance;
    private final BooleanParameter useSingularityAvoidanceInSupport;
    private final YoBoolean isSupportSingularityAvoidanceUsed;
    private final DoubleProvider percentOfLegLengthMarginToDisableSingularityAvoidance;
    private final DoubleProvider percentOfLegLengthMarginToAbortSingularityAvoidance;
    private final DoubleProvider maxPercentOfLegLengthForSingularityAvoidanceInSupport;
    private final FrameVector3D equivalentDesiredHipPitchHeightTranslation = new FrameVector3D();
    private final FrameVector3D equivalentDesiredHipVelocity = new FrameVector3D();
    private final FrameVector3D equivalentDesiredHipPitchAcceleration = new FrameVector3D();
    private final AlphaFilteredYoVariable heightCorrectedFilteredForSingularityAvoidance;
    private final AlphaFilteredYoVariable heightVelocityCorrectedFilteredForSingularityAvoidance;
    private final AlphaFilteredYoVariable heightAccelerationCorrectedFilteredForSingularityAvoidance;
    private final FrameVector2DBasics comVelocity = new FrameVector2D();

    public WorkspaceLimiterControlModule(String namePrefix, ContactablePlaneBody contactablePlaneBody, RobotSide robotSide, WorkspaceLimiterParameters workspaceLimiterParameters, WalkingControllerParameters walkingControllerParameters, HighLevelHumanoidControllerToolbox controllerToolbox, YoRegistry parentRegistry) {
        this.registry = new YoRegistry(namePrefix + this.getClass().getSimpleName());
        parentRegistry.addChild(this.registry);
        this.unachievedSwingTranslation = new YoFrameVector3D(namePrefix + "UnachievedSwingTranslation", worldFrame, this.registry);
        this.unachievedSwingVelocity = new YoFrameVector3D(namePrefix + "UnachievedSwingVelocity", worldFrame, this.registry);
        this.unachievedSwingAcceleration = new YoFrameVector3D(namePrefix + "UnachievedSwingAcceleration", worldFrame, this.registry);
        this.maximumLegLength = new YoDouble(namePrefix + "MaxLegLength", this.registry);
        this.maximumLegLength.set(walkingControllerParameters.getMaximumLegLengthForSingularityAvoidance());
        FullHumanoidRobotModel fullRobotModel = controllerToolbox.getFullRobotModel();
        this.pelvis = fullRobotModel.getPelvis();
        this.frameBeforeHipPitchJoint = fullRobotModel.getLegJoint((Enum)robotSide, LegJointName.HIP_PITCH).getFrameBeforeJoint();
        this.endEffectorFrame = contactablePlaneBody.getFrameAfterParentJoint();
        this.checkVelocityForSwingSingularityAvoidance = new YoBoolean(namePrefix + "CheckVelocityForSwingSingularityAvoidance", this.registry);
        this.alphaSwingSingularityAvoidanceForFoot = new YoDouble(namePrefix + "AlphaSwingSingularityAvoidanceForFoot", this.registry);
        this.alphaSwingSingularityAvoidanceForHeight = new YoDouble(namePrefix + "AlphaSwingSingularityAvoidanceForHeight", this.registry);
        DoubleProvider alphaUnreachableFootstep = workspaceLimiterParameters.getAlphaUnreachableFootstep();
        this.timeToCorrectForUnachievedSwingTranslation = workspaceLimiterParameters.getTimeToCorrectForUnachievedSwingTranslation();
        this.unachievedSwingTranslationFiltered = new AlphaFilteredYoVariable(namePrefix + "UnachievedSwingTranslationFiltered", this.registry, alphaUnreachableFootstep);
        this.unachievedSwingVelocityFiltered = new AlphaFilteredYoVariable(namePrefix + "UnachievedSwingVelocityFiltered", this.registry, alphaUnreachableFootstep);
        this.unachievedSwingAccelerationFiltered = new AlphaFilteredYoVariable(namePrefix + "UnachievedSwingAccelerationFiltered", this.registry, alphaUnreachableFootstep);
        this.maxPercentOfLegLengthForSingularityAvoidanceInSupport = workspaceLimiterParameters.getMaxPercentOfLegLengthForSingularityAvoidanceInSupport();
        this.maxPercentOfLegLengthForSingularityAvoidanceInSwingForFoot = workspaceLimiterParameters.getMaxPercentOfLegLengthForSingularityAvoidanceInSwingForFoot();
        this.maxPercentOfLegLengthForSingularityAvoidanceInSwingForHeight = workspaceLimiterParameters.getMaxPercentOfLegLengthForSingularityAvoidanceInSwingForHeight();
        this.minPercentOfLegLengthForSingularityAvoidanceInSwing = workspaceLimiterParameters.getMinPercentOfLegLengthForSingularityAvoidanceInSwing();
        this.percentOfLegLengthMarginToEnableSingularityAvoidanceForFoot = workspaceLimiterParameters.getPercentOfLegLengthMarginToEnableSingularityAvoidanceForFoot();
        this.percentOfLegLengthMarginToEnableSingularityAvoidanceForHeight = workspaceLimiterParameters.getPercentOfLegLengthMarginToEnableSingularityAvoidanceForHeight();
        this.percentOfLegLengthMarginToDisableSingularityAvoidance = workspaceLimiterParameters.getPercentOfLegLengthMarginToDisableSingularityAvoidance();
        this.percentOfLegLengthMarginToAbortSingularityAvoidance = workspaceLimiterParameters.getPercentOfLegLengthMarginToAbortSingularityAvoidance();
        SwingTrajectoryParameters swingTrajectoryParameters = walkingControllerParameters.getSwingTrajectoryParameters();
        this.useSingularityAvoidanceInSwing = new BooleanParameter(namePrefix + "UseSingularityAvoidanceInSwing", this.registry, swingTrajectoryParameters.useSingularityAvoidanceInSwing());
        this.desiredPercentOfLegLength = new YoDouble(namePrefix + "DesiredPercentOfLegLength", this.registry);
        this.currentPercentOfLegLength = new YoDouble(namePrefix + "CurrentPercentOfLegLength", this.registry);
        this.velocityDifferenceForLengthening = workspaceLimiterParameters.getVelocityDifferenceForLengthening();
        this.desiredLegLength = new YoDouble(namePrefix + "DesiredLegLength", this.registry);
        this.currentLegLength = new YoDouble(namePrefix + "CurrentLegLength", this.registry);
        this.isSwingSingularityAvoidanceUsed = new YoBoolean(namePrefix + "IsSwingSingularityAvoidanceUsed", this.registry);
        this.isSwingSingularityAvoidanceUsedOnHeight = new YoBoolean(namePrefix + "IsSwingSingularityAvoidanceUsedOnHeight", this.registry);
        this.isUnreachableFootstepCompensated = new YoBoolean(namePrefix + "IsUnreachableFootstepCompensated", this.registry);
        MovingReferenceFrame pelvisFrame = this.pelvis.getParentJoint().getFrameAfterJoint();
        this.virtualLegTangentialFrameHipCentered = new ReferenceFrame(namePrefix + "VirtualLegTangentialFrameHipCentered", (ReferenceFrame)pelvisFrame){
            private final AxisAngle hipPitchRotationToParentFrame;
            private final FramePoint3D tempPoint;
            private final FrameVector3D footToHipAxis;
            private final FramePoint3D hipPitchPosition;
            {
                this.hipPitchRotationToParentFrame = new AxisAngle();
                this.tempPoint = new FramePoint3D();
                this.footToHipAxis = new FrameVector3D();
                this.hipPitchPosition = new FramePoint3D();
            }

            protected void updateTransformToParent(RigidBodyTransform transformToParent) {
                this.tempPoint.setToZero(WorkspaceLimiterControlModule.this.frameBeforeHipPitchJoint);
                this.tempPoint.changeFrame(WorkspaceLimiterControlModule.this.endEffectorFrame);
                this.footToHipAxis.setIncludingFrame((FrameTuple3DReadOnly)this.tempPoint);
                this.footToHipAxis.changeFrame(this.getParent());
                EuclidGeometryTools.orientation3DFromZUpToVector3D((Vector3DReadOnly)this.footToHipAxis, (Orientation3DBasics)this.hipPitchRotationToParentFrame);
                this.hipPitchPosition.setToZero(WorkspaceLimiterControlModule.this.frameBeforeHipPitchJoint);
                this.hipPitchPosition.changeFrame(this.getParent());
                transformToParent.getRotation().set((Orientation3DReadOnly)this.hipPitchRotationToParentFrame);
                transformToParent.getTranslation().set((Tuple3DReadOnly)this.hipPitchPosition);
            }
        };
        this.virtualLegTangentialFrameAnkleCentered = new ReferenceFrame(namePrefix + "VirtualLegTangentialFrameAnkleCentered", (ReferenceFrame)pelvisFrame){
            private final AxisAngle anklePitchRotationToParentFrame;
            private final FramePoint3D tempPoint;
            private final FrameVector3D footToHipAxis;
            private final FramePoint3D anklePitchPosition;
            {
                this.anklePitchRotationToParentFrame = new AxisAngle();
                this.tempPoint = new FramePoint3D();
                this.footToHipAxis = new FrameVector3D();
                this.anklePitchPosition = new FramePoint3D();
            }

            protected void updateTransformToParent(RigidBodyTransform transformToParent) {
                this.tempPoint.setToZero(WorkspaceLimiterControlModule.this.frameBeforeHipPitchJoint);
                this.tempPoint.changeFrame(WorkspaceLimiterControlModule.this.endEffectorFrame);
                this.footToHipAxis.setIncludingFrame((FrameTuple3DReadOnly)this.tempPoint);
                this.footToHipAxis.changeFrame(this.getParent());
                EuclidGeometryTools.orientation3DFromZUpToVector3D((Vector3DReadOnly)this.footToHipAxis, (Orientation3DBasics)this.anklePitchRotationToParentFrame);
                this.anklePitchPosition.setToZero(WorkspaceLimiterControlModule.this.endEffectorFrame);
                this.anklePitchPosition.changeFrame(this.getParent());
                transformToParent.getRotation().set((Orientation3DReadOnly)this.anklePitchRotationToParentFrame);
                transformToParent.getTranslation().set((Tuple3DReadOnly)this.anklePitchPosition);
            }
        };
        YoGraphicsListRegistry yoGraphicsListRegistry = controllerToolbox.getYoGraphicsListRegistry();
        this.visualize = this.visualize && yoGraphicsListRegistry != null;
        this.moreVisualizers = this.visualize && this.moreVisualizers;
        this.yoCurrentFootPosition = new YoFramePoint3D(namePrefix + "CurrentFootPosition", worldFrame, this.registry);
        this.yoDesiredFootPosition = new YoFramePoint3D(namePrefix + "DesiredFootPosition", worldFrame, this.registry);
        this.yoCorrectedDesiredFootPosition = new YoFramePoint3D(namePrefix + "CorrectedDesiredFootPosition", worldFrame, this.registry);
        this.yoDesiredFootLinearVelocity = new YoFrameVector3D(namePrefix + "DesiredFootLinearVelocity", worldFrame, this.registry);
        this.yoDesiredFootLinearAcceleration = new YoFrameVector3D(namePrefix + "DesiredFootLinearAcceleration", worldFrame, this.registry);
        this.yoCorrectedDesiredFootLinearVelocity = new YoFrameVector3D(namePrefix + "CorrectedDesiredFootLinearVelocity", worldFrame, this.registry);
        this.yoCorrectedDesiredFootLinearAcceleration = new YoFrameVector3D(namePrefix + "CorrectedDesiredFootLinearAcceleration", worldFrame, this.registry);
        this.yoDesiredFootPosition.setToNaN();
        this.yoCorrectedDesiredFootPosition.setToNaN();
        this.yoDesiredFootLinearVelocity.setToNaN();
        this.yoCorrectedDesiredFootLinearVelocity.setToNaN();
        this.alphaSupportSingularityAvoidance = new YoDouble(namePrefix + "AlphaSupportSingularityAvoidance", this.registry);
        this.doSmoothTransitionOutOfSingularityAvoidance = new YoBoolean(namePrefix + "DoSmoothTransitionSingularityAvoidance", this.registry);
        this.doSmoothTransitionOutOfUnreachableStep = new YoBoolean(namePrefix + "DoSmoothTransitionUnreachableStep", this.registry);
        this.isSupportSingularityAvoidanceUsed = new YoBoolean(namePrefix + "IsSupportSingularityAvoidanceUsed", this.registry);
        this.useSingularityAvoidanceInSupport = new BooleanParameter(namePrefix + "UseSingularityAvoidanceInSupport", this.registry, swingTrajectoryParameters.useSingularityAvoidanceInSupport());
        DoubleProvider correctionAlphaFilter = workspaceLimiterParameters.getCorrectionAlphaFilter();
        this.heightCorrectedFilteredForSingularityAvoidance = new AlphaFilteredYoVariable(namePrefix + "HeightCorrectedFilteredForSingularityAvoidance", this.registry, correctionAlphaFilter);
        this.heightVelocityCorrectedFilteredForSingularityAvoidance = new AlphaFilteredYoVariable(namePrefix + "HeightVelocityCorrectedFilteredForSingularityAvoidance", this.registry, correctionAlphaFilter);
        this.heightAccelerationCorrectedFilteredForSingularityAvoidance = new AlphaFilteredYoVariable(namePrefix + "HeightAccelerationCorrectedFilteredForSingularityAvoidance", this.registry, correctionAlphaFilter);
        if (this.visualize) {
            this.yoDesiredFootPositionGraphic = new YoGraphicPosition(namePrefix + "DesiredFootPosition", this.yoDesiredFootPosition, 0.025, YoAppearance.Red(), YoGraphicPosition.GraphicType.BALL);
            yoGraphicsListRegistry.registerYoGraphic("SingularityCollapseAvoidance", (YoGraphic)this.yoDesiredFootPositionGraphic);
            this.yoCorrectedDesiredFootPositionGraphic = new YoGraphicPosition(namePrefix + "CorrectedDesiredFootPosition", this.yoCorrectedDesiredFootPosition, 0.025, YoAppearance.Green(), YoGraphicPosition.GraphicType.BALL);
            yoGraphicsListRegistry.registerYoGraphic("SingularityCollapseAvoidance", (YoGraphic)this.yoCorrectedDesiredFootPositionGraphic);
        } else {
            this.yoDesiredFootPositionGraphic = null;
            this.yoCorrectedDesiredFootPositionGraphic = null;
        }
        if (this.moreVisualizers) {
            this.virtualLegTangentialFrameHipCenteredGraphics = new YoGraphicReferenceFrame(this.virtualLegTangentialFrameHipCentered, this.registry, false, 0.1);
            this.virtualLegTangentialFrameAnkleCenteredGraphics = new YoGraphicReferenceFrame(this.virtualLegTangentialFrameAnkleCentered, this.registry, false, 0.1);
            yoGraphicsListRegistry.registerYoGraphic("SingularityCollapseAvoidance", (YoGraphic)this.virtualLegTangentialFrameHipCenteredGraphics);
            yoGraphicsListRegistry.registerYoGraphic("SingularityCollapseAvoidance", (YoGraphic)this.virtualLegTangentialFrameAnkleCenteredGraphics);
            this.yoDesiredFootLinearVelocityGraphic = new YoGraphicVector(namePrefix + "DesiredFootLinearVelocity", this.yoCurrentFootPosition, this.yoDesiredFootLinearVelocity, 0.2, YoAppearance.Red());
            yoGraphicsListRegistry.registerYoGraphic("SingularityCollapseAvoidance", (YoGraphic)this.yoDesiredFootLinearVelocityGraphic);
            this.yoCorrectedDesiredFootLinearVelocityGraphic = new YoGraphicVector(namePrefix + "CorrectedDesiredFootLinearVelocity", this.yoCurrentFootPosition, this.yoCorrectedDesiredFootLinearVelocity, 0.2, YoAppearance.Green());
            yoGraphicsListRegistry.registerYoGraphic("SingularityCollapseAvoidance", (YoGraphic)this.yoCorrectedDesiredFootLinearVelocityGraphic);
        } else {
            this.virtualLegTangentialFrameHipCenteredGraphics = null;
            this.virtualLegTangentialFrameAnkleCenteredGraphics = null;
            this.yoDesiredFootLinearVelocityGraphic = null;
            this.yoCorrectedDesiredFootLinearVelocityGraphic = null;
        }
    }

    public void update() {
        this.virtualLegTangentialFrameHipCentered.update();
        this.virtualLegTangentialFrameAnkleCentered.update();
        this.anklePosition.setToZero(this.endEffectorFrame);
        this.yoCurrentFootPosition.setMatchingFrame((FrameTuple3DReadOnly)this.anklePosition);
        this.anklePosition.changeFrame(this.virtualLegTangentialFrameHipCentered);
        this.currentLegLength.set(-this.anklePosition.getZ());
        this.currentPercentOfLegLength.set(this.currentLegLength.getDoubleValue() / this.maximumLegLength.getDoubleValue());
    }

    public void resetHeightCorrectionParameters() {
        this.doSmoothTransitionOutOfSingularityAvoidance.set(false);
        this.isSupportSingularityAvoidanceUsed.set(false);
    }

    public void resetSwingParameters() {
        this.yoDesiredFootPosition.setToNaN();
        this.yoCorrectedDesiredFootPosition.setToNaN();
        this.yoDesiredFootLinearVelocity.setToNaN();
        this.yoCorrectedDesiredFootLinearVelocity.setToNaN();
        if (this.visualize) {
            this.yoDesiredFootPositionGraphic.hideGraphicObject();
            this.yoCorrectedDesiredFootPositionGraphic.hideGraphicObject();
            if (this.moreVisualizers) {
                this.virtualLegTangentialFrameHipCenteredGraphics.update();
                this.virtualLegTangentialFrameAnkleCenteredGraphics.update();
                this.yoDesiredFootLinearVelocityGraphic.hideGraphicObject();
                this.yoCorrectedDesiredFootLinearVelocityGraphic.hideGraphicObject();
            }
        }
        this.alphaSwingSingularityAvoidanceForFoot.set(0.0);
        this.alphaSwingSingularityAvoidanceForHeight.set(0.0);
        this.unachievedSwingTranslation.setToZero();
        this.unachievedSwingVelocity.setToZero();
        this.unachievedSwingAcceleration.setToZero();
    }

    public void setCheckVelocityForSwingSingularityAvoidance(boolean value) {
        this.checkVelocityForSwingSingularityAvoidance.set(value);
    }

    public void correctSwingFootTrajectory(FixedFramePoint3DBasics desiredFootPositionToCorrect, FixedFrameVector3DBasics desiredFootLinearVelocityToCorrect, FixedFrameVector3DBasics desiredFootLinearAccelerationToCorrect) {
        this.isSwingSingularityAvoidanceUsed.set(false);
        this.isSwingSingularityAvoidanceUsedOnHeight.set(false);
        this.alphaSwingSingularityAvoidanceForFoot.set(0.0);
        this.alphaSwingSingularityAvoidanceForHeight.set(0.0);
        this.yoDesiredFootPosition.set((FrameTuple3DReadOnly)desiredFootPositionToCorrect);
        this.yoDesiredFootLinearVelocity.set((FrameTuple3DReadOnly)desiredFootLinearVelocityToCorrect);
        this.yoDesiredFootLinearAcceleration.set((FrameTuple3DReadOnly)desiredFootLinearAccelerationToCorrect);
        this.desiredFootPosition.setIncludingFrame((FrameTuple3DReadOnly)desiredFootPositionToCorrect);
        this.desiredFootLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)desiredFootLinearVelocityToCorrect);
        this.desiredFootLinearAcceleration.setIncludingFrame((FrameTuple3DReadOnly)desiredFootLinearAccelerationToCorrect);
        this.desiredFootPosition.changeFrame(this.virtualLegTangentialFrameHipCentered);
        this.desiredFootLinearVelocity.changeFrame(this.virtualLegTangentialFrameHipCentered);
        this.desiredFootLinearAcceleration.changeFrame(this.virtualLegTangentialFrameHipCentered);
        this.desiredLegLength.set(-this.desiredFootPosition.getZ());
        this.desiredPercentOfLegLength.set(this.desiredLegLength.getDoubleValue() / this.maximumLegLength.getDoubleValue());
        this.currentPercentOfLegLength.set(this.currentLegLength.getDoubleValue() / this.maximumLegLength.getDoubleValue());
        if (this.useSingularityAvoidanceInSwing.getValue()) {
            this.desiredFootLinearVelocity.changeFrame(this.virtualLegTangentialFrameAnkleCentered);
            this.pelvis.getBodyFixedFrame().getTwistOfFrame((TwistBasics)this.pelvisTwist);
            this.pelvisLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.pelvisTwist.getLinearPart());
            this.pelvisLinearVelocity.changeFrame(this.virtualLegTangentialFrameAnkleCentered);
            double upperBoundToStartHeightCorrection = this.maxPercentOfLegLengthForSingularityAvoidanceInSwingForHeight.getValue() - this.percentOfLegLengthMarginToEnableSingularityAvoidanceForHeight.getValue();
            if (this.desiredPercentOfLegLength.getDoubleValue() > upperBoundToStartHeightCorrection) {
                this.correctHeightForOverExtensionForSingularityAvoidance();
            }
            double upperBoundToStartFootCorrection = this.maxPercentOfLegLengthForSingularityAvoidanceInSwingForFoot.getValue() - this.percentOfLegLengthMarginToEnableSingularityAvoidanceForFoot.getValue();
            double lowerBoundToStartFootCorrection = this.minPercentOfLegLengthForSingularityAvoidanceInSwing.getValue() + this.percentOfLegLengthMarginToEnableSingularityAvoidanceForFoot.getValue();
            if (this.desiredPercentOfLegLength.getDoubleValue() > upperBoundToStartFootCorrection) {
                this.correctSwingFootTrajectoryOverExtensionForSingularityAvoidance(desiredFootPositionToCorrect, desiredFootLinearVelocityToCorrect, desiredFootLinearAccelerationToCorrect);
            } else if (this.desiredPercentOfLegLength.getDoubleValue() < lowerBoundToStartFootCorrection) {
                this.correctSwingFootTrajectoryUnderExtensionForSingularityAvoidance(desiredFootPositionToCorrect, desiredFootLinearVelocityToCorrect, desiredFootLinearAccelerationToCorrect);
            }
        }
    }

    private void correctHeightForOverExtensionForSingularityAvoidance() {
        if (this.checkVelocityForSwingSingularityAvoidance.getBooleanValue() && this.isLegShortening()) {
            return;
        }
        this.isSwingSingularityAvoidanceUsedOnHeight.set(true);
        this.updateFractionOfSingularityAvoidanceToUse(this.alphaSwingSingularityAvoidanceForHeight, this.maxPercentOfLegLengthForSingularityAvoidanceInSwingForHeight.getValue(), this.percentOfLegLengthMarginToEnableSingularityAvoidanceForHeight.getValue());
        double desiredFootPositionInAxisFrame = -Math.min(this.desiredLegLength.getDoubleValue(), this.maxPercentOfLegLengthForSingularityAvoidanceInSwingForHeight.getValue() * this.maximumLegLength.getDoubleValue());
        double desiredLinearVelocityZ = InterpolationTools.linearInterpolate((double)this.desiredFootLinearVelocity.getZ(), (double)this.pelvisLinearVelocity.getZ(), (double)this.alphaSwingSingularityAvoidanceForHeight.getDoubleValue());
        double unachievedHeightTranslation = this.desiredFootPosition.getZ() - desiredFootPositionInAxisFrame;
        double unachievedHeightVelocity = this.desiredFootLinearVelocity.getZ() - desiredLinearVelocityZ;
        double unachievedHeightAcceleration = this.alphaSwingSingularityAvoidanceForHeight.getDoubleValue() * this.desiredFootLinearAcceleration.getZ();
        this.tempVector.setIncludingFrame(this.desiredFootPosition.getReferenceFrame(), 0.0, 0.0, unachievedHeightTranslation);
        this.unachievedSwingTranslation.setMatchingFrame((FrameTuple3DReadOnly)this.tempVector);
        this.tempVector.setIncludingFrame(this.desiredFootLinearVelocity.getReferenceFrame(), 0.0, 0.0, unachievedHeightVelocity);
        this.unachievedSwingVelocity.setMatchingFrame((FrameTuple3DReadOnly)this.tempVector);
        this.tempVector.setIncludingFrame(this.desiredFootLinearVelocity.getReferenceFrame(), 0.0, 0.0, unachievedHeightAcceleration);
        this.unachievedSwingAcceleration.setMatchingFrame((FrameTuple3DReadOnly)this.tempVector);
    }

    private void correctSwingFootTrajectoryOverExtensionForSingularityAvoidance(FixedFramePoint3DBasics desiredFootPositionToCorrect, FixedFrameVector3DBasics desiredFootLinearVelocityToCorrect, FixedFrameVector3DBasics desiredFootLinearAccelerationToCorrect) {
        if (this.checkVelocityForSwingSingularityAvoidance.getBooleanValue() && this.isLegShortening()) {
            return;
        }
        this.checkVelocityForSwingSingularityAvoidance.set(false);
        this.isSwingSingularityAvoidanceUsed.set(true);
        this.updateFractionOfSingularityAvoidanceToUse(this.alphaSwingSingularityAvoidanceForFoot, this.maxPercentOfLegLengthForSingularityAvoidanceInSwingForFoot.getValue(), this.percentOfLegLengthMarginToEnableSingularityAvoidanceForFoot.getValue());
        double desiredFootPositionInAxisFrame = -Math.min(this.desiredLegLength.getDoubleValue(), this.maxPercentOfLegLengthForSingularityAvoidanceInSwingForFoot.getValue() * this.maximumLegLength.getDoubleValue());
        this.correctFootDesiredsWithScaleFactor(desiredFootPositionInAxisFrame, desiredFootPositionToCorrect, desiredFootLinearVelocityToCorrect, desiredFootLinearAccelerationToCorrect);
    }

    private void correctSwingFootTrajectoryUnderExtensionForSingularityAvoidance(FixedFramePoint3DBasics desiredFootPositionToCorrect, FixedFrameVector3DBasics desiredFootLinearVelocityToCorrect, FixedFrameVector3DBasics desiredFootLinearAccelerationToCorrect) {
        if (this.checkVelocityForSwingSingularityAvoidance.getBooleanValue() && this.isLegLengthening()) {
            return;
        }
        this.checkVelocityForSwingSingularityAvoidance.set(false);
        this.isSwingSingularityAvoidanceUsed.set(true);
        double alpha = (this.desiredPercentOfLegLength.getDoubleValue() - this.minPercentOfLegLengthForSingularityAvoidanceInSwing.getValue()) / this.percentOfLegLengthMarginToEnableSingularityAvoidanceForFoot.getValue();
        this.alphaSwingSingularityAvoidanceForFoot.set(1.0 - MathTools.clamp((double)alpha, (double)0.0, (double)1.0));
        double desiredFootPositionInAxisFrame = -Math.max(this.desiredLegLength.getDoubleValue(), this.minPercentOfLegLengthForSingularityAvoidanceInSwing.getValue() * this.maximumLegLength.getDoubleValue());
        this.correctFootDesiredsWithScaleFactor(desiredFootPositionInAxisFrame, desiredFootPositionToCorrect, desiredFootLinearVelocityToCorrect, desiredFootLinearAccelerationToCorrect);
    }

    private void correctFootDesiredsWithScaleFactor(double desiredFootPositionInAxisFrame, FixedFramePoint3DBasics desiredFootPositionToCorrect, FixedFrameVector3DBasics desiredFootLinearVelocityToCorrect, FixedFrameVector3DBasics desiredFootLinearAccelerationToCorrect) {
        double desiredLinearVelocityX = this.desiredFootLinearVelocity.getX();
        double desiredLinearVelocityY = this.desiredFootLinearVelocity.getY();
        double desiredLinearVelocityZ = InterpolationTools.linearInterpolate((double)this.desiredFootLinearVelocity.getZ(), (double)this.pelvisLinearVelocity.getZ(), (double)this.alphaSwingSingularityAvoidanceForFoot.getDoubleValue());
        double desiredLinearAccelerationZ = InterpolationTools.linearInterpolate((double)this.desiredFootLinearAcceleration.getZ(), (double)0.0, (double)this.alphaSwingSingularityAvoidanceForFoot.getDoubleValue());
        this.desiredFootPosition.setZ(desiredFootPositionInAxisFrame);
        this.desiredFootLinearVelocity.setIncludingFrame(this.virtualLegTangentialFrameAnkleCentered, desiredLinearVelocityX, desiredLinearVelocityY, desiredLinearVelocityZ);
        this.desiredFootLinearAcceleration.setZ(desiredLinearAccelerationZ);
        desiredFootPositionToCorrect.setMatchingFrame((FrameTuple3DReadOnly)this.desiredFootPosition);
        desiredFootLinearVelocityToCorrect.setMatchingFrame((FrameTuple3DReadOnly)this.desiredFootLinearVelocity);
        desiredFootLinearAccelerationToCorrect.setMatchingFrame((FrameTuple3DReadOnly)this.desiredFootLinearAcceleration);
        this.yoCorrectedDesiredFootPosition.set((FrameTuple3DReadOnly)desiredFootPositionToCorrect);
        this.yoCorrectedDesiredFootLinearVelocity.set((FrameTuple3DReadOnly)desiredFootLinearVelocityToCorrect);
        this.yoCorrectedDesiredFootLinearAcceleration.set((FrameTuple3DReadOnly)desiredFootLinearAccelerationToCorrect);
        if (this.visualize) {
            this.yoDesiredFootPositionGraphic.showGraphicObject();
            this.yoCorrectedDesiredFootPositionGraphic.showGraphicObject();
            if (this.moreVisualizers) {
                this.yoDesiredFootLinearVelocityGraphic.showGraphicObject();
                this.yoCorrectedDesiredFootLinearVelocityGraphic.showGraphicObject();
            }
        }
    }

    private boolean isLegLengthening() {
        return this.pelvisLinearVelocity.getZ() - this.desiredFootLinearVelocity.getZ() > this.velocityDifferenceForLengthening.getValue();
    }

    private boolean isLegShortening() {
        return this.desiredFootLinearVelocity.getZ() - this.pelvisLinearVelocity.getZ() > this.velocityDifferenceForLengthening.getValue();
    }

    public boolean correctCoMHeightTrajectoryForUnreachableFootStep(CoMHeightTimeDerivativesDataBasics comHeightDataToCorrect, FootControlModule.ConstraintType constraintType) {
        this.isUnreachableFootstepCompensated.set(false);
        if (constraintType.isLoadBearing()) {
            return this.smoothTransitionOutOfHeightCorrectionInSwing(comHeightDataToCorrect, constraintType);
        }
        this.doSmoothTransitionOutOfUnreachableStep.set(false);
        comHeightDataToCorrect.getComHeight((FramePoint3DBasics)this.desiredCenterOfMassHeightPoint);
        this.desiredCenterOfMassHeightPoint.changeFrame(worldFrame);
        if (this.unachievedSwingTranslation.getZ() < 0.0) {
            this.isUnreachableFootstepCompensated.set(true);
            this.unachievedSwingTranslationFiltered.update(this.unachievedSwingTranslation.getZ());
            this.desiredCenterOfMassHeightPoint.addZ(this.unachievedSwingTranslationFiltered.getDoubleValue());
            comHeightDataToCorrect.setComHeight(worldFrame, this.desiredCenterOfMassHeightPoint.getZ());
            this.unachievedSwingVelocityFiltered.update(this.unachievedSwingTranslationFiltered.getDoubleValue() / this.timeToCorrectForUnachievedSwingTranslation.getValue());
            this.unachievedSwingAccelerationFiltered.update(this.unachievedSwingVelocityFiltered.getDoubleValue() / this.timeToCorrectForUnachievedSwingTranslation.getValue());
            comHeightDataToCorrect.setComHeightVelocity(comHeightDataToCorrect.getComHeightVelocity() + this.unachievedSwingVelocityFiltered.getDoubleValue());
            comHeightDataToCorrect.setComHeightAcceleration(comHeightDataToCorrect.getComHeightAcceleration() + this.unachievedSwingAccelerationFiltered.getDoubleValue());
            return true;
        }
        this.unachievedSwingTranslationFiltered.set(0.0);
        this.unachievedSwingVelocityFiltered.set(0.0);
        this.unachievedSwingAccelerationFiltered.set(0.0);
        return false;
    }

    public boolean correctCoMHeightTrajectoryForSingularityAvoidanceInSupport(CoMHeightTimeDerivativesDataBasics comHeightDataToCorrect, double zCurrentInWorld, ReferenceFrame pelvisZUpFrame, FootControlModule.ConstraintType constraintType) {
        boolean legDoesNotNeedSingularityAvoidance;
        if (!this.useSingularityAvoidanceInSupport.getValue()) {
            this.alphaSupportSingularityAvoidance.set(0.0);
            this.isSupportSingularityAvoidanceUsed.set(false);
            this.doSmoothTransitionOutOfSingularityAvoidance.set(false);
            return false;
        }
        comHeightDataToCorrect.getComHeight((FramePoint3DBasics)this.desiredCenterOfMassHeightPoint);
        this.desiredCenterOfMassHeightPoint.changeFrame(worldFrame);
        double heightErrorInWorld = this.desiredCenterOfMassHeightPoint.getZ() - zCurrentInWorld;
        this.equivalentDesiredHipPitchHeightTranslation.setIncludingFrame(worldFrame, 0.0, 0.0, heightErrorInWorld);
        this.equivalentDesiredHipPitchHeightTranslation.changeFrame(this.virtualLegTangentialFrameAnkleCentered);
        this.desiredLegLength.set(this.equivalentDesiredHipPitchHeightTranslation.getZ() + this.currentLegLength.getDoubleValue());
        this.desiredPercentOfLegLength.set(this.desiredLegLength.getDoubleValue() / this.maximumLegLength.getDoubleValue());
        if (constraintType != FootControlModule.ConstraintType.FULL) {
            this.alphaSupportSingularityAvoidance.set(0.0);
            this.doSmoothTransitionOutOfSingularityAvoidance.set(this.isSupportSingularityAvoidanceUsed.getBooleanValue());
            if (!this.isSupportSingularityAvoidanceUsed.getBooleanValue()) {
                return false;
            }
        }
        double maxPercent = this.maxPercentOfLegLengthForSingularityAvoidanceInSwingForFoot.getValue();
        boolean singularityAvoidanceShouldBeDisabled = this.desiredPercentOfLegLength.getDoubleValue() < maxPercent - this.percentOfLegLengthMarginToDisableSingularityAvoidance.getValue();
        boolean bl = legDoesNotNeedSingularityAvoidance = this.desiredPercentOfLegLength.getDoubleValue() < maxPercent - this.percentOfLegLengthMarginToEnableSingularityAvoidanceForHeight.getValue();
        if (this.isSupportSingularityAvoidanceUsed.getBooleanValue() && singularityAvoidanceShouldBeDisabled && !this.doSmoothTransitionOutOfSingularityAvoidance.getBooleanValue()) {
            this.alphaSupportSingularityAvoidance.set(0.0);
            this.doSmoothTransitionOutOfSingularityAvoidance.set(true);
        }
        if (legDoesNotNeedSingularityAvoidance) {
            if (!this.isSupportSingularityAvoidanceUsed.getBooleanValue() && !this.doSmoothTransitionOutOfSingularityAvoidance.getBooleanValue()) {
                return false;
            }
        } else if (!this.isSupportSingularityAvoidanceUsed.getBooleanValue()) {
            this.isSupportSingularityAvoidanceUsed.set(true);
            this.doSmoothTransitionOutOfSingularityAvoidance.set(false);
            this.heightCorrectedFilteredForSingularityAvoidance.reset();
            this.heightVelocityCorrectedFilteredForSingularityAvoidance.reset();
            this.heightAccelerationCorrectedFilteredForSingularityAvoidance.reset();
            this.heightCorrectedFilteredForSingularityAvoidance.update(this.desiredCenterOfMassHeightPoint.getZ());
            this.heightVelocityCorrectedFilteredForSingularityAvoidance.update(comHeightDataToCorrect.getComHeightVelocity());
            this.heightAccelerationCorrectedFilteredForSingularityAvoidance.update(comHeightDataToCorrect.getComHeightAcceleration());
        }
        if (this.doSmoothTransitionOutOfSingularityAvoidance.getBooleanValue()) {
            this.smoothTransitionOutOfSingularityAvoidanceInSupport(comHeightDataToCorrect);
        } else {
            this.applySingularityAvoidanceInSupport(comHeightDataToCorrect, zCurrentInWorld, pelvisZUpFrame);
        }
        return true;
    }

    private void updateFractionOfSingularityAvoidanceToUse(YoDouble alphaToUpdate, double percentForMaximum, double percentMargin) {
        double percentToStart = percentForMaximum - percentMargin;
        double alpha = (this.desiredPercentOfLegLength.getDoubleValue() - percentToStart) / percentMargin;
        alphaToUpdate.set(MathTools.clamp((double)alpha, (double)0.0, (double)1.0));
    }

    private void smoothTransitionOutOfSingularityAvoidanceInSupport(CoMHeightTimeDerivativesDataBasics comHeightDataToCorrect) {
        this.heightCorrectedFilteredForSingularityAvoidance.update(this.desiredCenterOfMassHeightPoint.getZ());
        this.heightVelocityCorrectedFilteredForSingularityAvoidance.update(comHeightDataToCorrect.getComHeightVelocity());
        this.heightAccelerationCorrectedFilteredForSingularityAvoidance.update(comHeightDataToCorrect.getComHeightAcceleration());
        comHeightDataToCorrect.setComHeight(this.desiredCenterOfMassHeightPoint.getReferenceFrame(), this.heightCorrectedFilteredForSingularityAvoidance.getDoubleValue());
        comHeightDataToCorrect.setComHeightVelocity(this.heightVelocityCorrectedFilteredForSingularityAvoidance.getDoubleValue());
        comHeightDataToCorrect.setComHeightAcceleration(this.heightAccelerationCorrectedFilteredForSingularityAvoidance.getDoubleValue());
        if (MathTools.epsilonEquals((double)this.desiredCenterOfMassHeightPoint.getZ(), (double)this.heightCorrectedFilteredForSingularityAvoidance.getDoubleValue(), (double)0.005)) {
            this.alphaSupportSingularityAvoidance.set(0.0);
            this.isSupportSingularityAvoidanceUsed.set(false);
            this.doSmoothTransitionOutOfSingularityAvoidance.set(false);
        } else if (this.desiredCenterOfMassHeightPoint.getZ() <= this.heightCorrectedFilteredForSingularityAvoidance.getDoubleValue() && this.desiredPercentOfLegLength.getDoubleValue() < this.maxPercentOfLegLengthForSingularityAvoidanceInSupport.getValue() - this.percentOfLegLengthMarginToDisableSingularityAvoidance.getValue()) {
            this.heightCorrectedFilteredForSingularityAvoidance.update(this.desiredCenterOfMassHeightPoint.getZ());
            this.heightCorrectedFilteredForSingularityAvoidance.update(this.desiredCenterOfMassHeightPoint.getZ());
            if (this.desiredPercentOfLegLength.getDoubleValue() < this.maxPercentOfLegLengthForSingularityAvoidanceInSupport.getValue() - this.percentOfLegLengthMarginToAbortSingularityAvoidance.getValue()) {
                this.alphaSupportSingularityAvoidance.set(0.0);
                this.isSupportSingularityAvoidanceUsed.set(false);
                this.doSmoothTransitionOutOfSingularityAvoidance.set(false);
            }
        }
    }

    private void applySingularityAvoidanceInSupport(CoMHeightTimeDerivativesDataBasics comHeightDataToCorrect, double zCurrent, ReferenceFrame pelvisZUpFrame) {
        this.updateFractionOfSingularityAvoidanceToUse(this.alphaSupportSingularityAvoidance, this.maxPercentOfLegLengthForSingularityAvoidanceInSupport.getValue(), this.percentOfLegLengthMarginToEnableSingularityAvoidanceForHeight.getValue());
        double desiredOrMaxLegLength = Math.min(this.desiredLegLength.getDoubleValue(), this.maxPercentOfLegLengthForSingularityAvoidanceInSupport.getValue() * this.maximumLegLength.getDoubleValue());
        double correctedDesiredTranslationZ = desiredOrMaxLegLength - this.currentLegLength.getDoubleValue();
        this.equivalentDesiredHipPitchHeightTranslation.setZ(correctedDesiredTranslationZ);
        this.equivalentDesiredHipPitchHeightTranslation.changeFrame(worldFrame);
        this.desiredCenterOfMassHeightPoint.setZ(zCurrent + this.equivalentDesiredHipPitchHeightTranslation.getZ());
        this.heightCorrectedFilteredForSingularityAvoidance.update(this.desiredCenterOfMassHeightPoint.getZ());
        comHeightDataToCorrect.setComHeight(this.desiredCenterOfMassHeightPoint.getReferenceFrame(), this.heightCorrectedFilteredForSingularityAvoidance.getDoubleValue());
        this.equivalentDesiredHipVelocity.setIncludingFrame(worldFrame, 0.0, 0.0, comHeightDataToCorrect.getComHeightVelocity());
        this.equivalentDesiredHipVelocity.changeFrame(pelvisZUpFrame);
        this.comVelocity.setIncludingFrame((FrameTuple2DReadOnly)this.comVelocity);
        this.comVelocity.changeFrame(pelvisZUpFrame);
        this.equivalentDesiredHipVelocity.setX(this.comVelocity.getX());
        this.equivalentDesiredHipVelocity.changeFrame(this.virtualLegTangentialFrameAnkleCentered);
        double scaledHipVelocity = InterpolationTools.linearInterpolate((double)this.equivalentDesiredHipVelocity.getZ(), (double)0.0, (double)this.alphaSupportSingularityAvoidance.getDoubleValue());
        this.equivalentDesiredHipVelocity.setZ(scaledHipVelocity);
        this.equivalentDesiredHipVelocity.changeFrame(pelvisZUpFrame);
        if (Math.abs(this.comVelocity.getX()) > 0.001 && Math.abs(this.equivalentDesiredHipVelocity.getX()) > 0.001) {
            this.equivalentDesiredHipVelocity.scale(this.comVelocity.getX() / this.equivalentDesiredHipVelocity.getX());
        }
        this.equivalentDesiredHipVelocity.changeFrame(worldFrame);
        this.heightVelocityCorrectedFilteredForSingularityAvoidance.update(this.equivalentDesiredHipVelocity.getZ());
        comHeightDataToCorrect.setComHeightVelocity(this.heightVelocityCorrectedFilteredForSingularityAvoidance.getDoubleValue());
        this.equivalentDesiredHipPitchAcceleration.setIncludingFrame(worldFrame, 0.0, 0.0, comHeightDataToCorrect.getComHeightAcceleration());
        this.equivalentDesiredHipPitchAcceleration.changeFrame(this.virtualLegTangentialFrameAnkleCentered);
        double scaledHipAcceleration = InterpolationTools.linearInterpolate((double)this.equivalentDesiredHipPitchAcceleration.getZ(), (double)0.0, (double)this.alphaSupportSingularityAvoidance.getDoubleValue());
        this.equivalentDesiredHipPitchAcceleration.setZ(scaledHipAcceleration);
        this.equivalentDesiredHipPitchAcceleration.changeFrame(worldFrame);
        this.heightAccelerationCorrectedFilteredForSingularityAvoidance.update(this.equivalentDesiredHipPitchAcceleration.getZ());
        comHeightDataToCorrect.setComHeightAcceleration(this.heightAccelerationCorrectedFilteredForSingularityAvoidance.getDoubleValue());
    }

    private boolean smoothTransitionOutOfHeightCorrectionInSwing(CoMHeightTimeDerivativesDataBasics comHeightDataToCorrect, FootControlModule.ConstraintType constraintType) {
        if (constraintType != FootControlModule.ConstraintType.FULL) {
            return false;
        }
        this.unachievedSwingTranslationFiltered.update(0.0);
        this.unachievedSwingVelocityFiltered.update(this.unachievedSwingTranslationFiltered.getDoubleValue() / this.timeToCorrectForUnachievedSwingTranslation.getValue());
        this.unachievedSwingAccelerationFiltered.update(this.unachievedSwingVelocityFiltered.getDoubleValue() / this.timeToCorrectForUnachievedSwingTranslation.getValue());
        if (MathTools.epsilonEquals((double)this.unachievedSwingVelocityFiltered.getDoubleValue(), (double)0.0, (double)0.005)) {
            this.doSmoothTransitionOutOfUnreachableStep.set(false);
            return false;
        }
        this.doSmoothTransitionOutOfUnreachableStep.set(true);
        comHeightDataToCorrect.getComHeight((FramePoint3DBasics)this.desiredCenterOfMassHeightPoint);
        this.desiredCenterOfMassHeightPoint.changeFrame(worldFrame);
        this.desiredCenterOfMassHeightPoint.addZ(this.unachievedSwingTranslationFiltered.getDoubleValue());
        comHeightDataToCorrect.setComHeight(worldFrame, this.desiredCenterOfMassHeightPoint.getZ());
        comHeightDataToCorrect.setComHeightVelocity(comHeightDataToCorrect.getComHeightVelocity() + this.unachievedSwingVelocityFiltered.getDoubleValue());
        comHeightDataToCorrect.setComHeightAcceleration(comHeightDataToCorrect.getComHeightAcceleration() + this.unachievedSwingAccelerationFiltered.getDoubleValue());
        return true;
    }
}

