/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.foot;

import java.awt.Color;
import java.util.List;
import us.ihmc.commonWalkingControlModules.controlModules.foot.ExplorationParameters;
import us.ihmc.commonWalkingControlModules.controlModules.foot.FootRotationCalculator;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FrameLine2D;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex2DSupplier;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.graphicsDescription.yoGraphics.plotting.YoArtifactLineSegment2d;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.TwistBasics;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.geometry.algorithms.FrameConvexPolygonWithLineIntersector2d;
import us.ihmc.robotics.math.filters.AlphaFilteredYoFramePoint2d;
import us.ihmc.robotics.math.filters.AlphaFilteredYoFrameVector2d;
import us.ihmc.robotics.math.filters.AlphaFilteredYoVariable;
import us.ihmc.robotics.math.filters.FilteredVelocityYoFrameVector2d;
import us.ihmc.robotics.math.filters.FilteredVelocityYoVariable;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameLineSegment2D;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class VelocityFootRotationCalculator
implements FootRotationCalculator {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoDouble angularVelocityFilterBreakFrequency;
    private final YoDouble angularVelocityAlphaFilter;
    private final double controllerDt;
    private final AlphaFilteredYoFrameVector2d footAngularVelocityFiltered;
    private final YoDouble angularVelocityAroundLineOfRotation;
    private final YoDouble yoCenterOfRotationPositionAlphaFilter;
    private final AlphaFilteredYoFramePoint2d centerOfRotationFiltered;
    private final YoDouble yoCenterOfRotationVelocityAlphaFilter;
    private final FilteredVelocityYoFrameVector2d centerOfRotationVelocityFiltered;
    private final YoDouble centerOfRotationTransverseVelocity;
    private final YoFrameLineSegment2D lineSegmentOfRotation;
    private final YoDouble angleOfLineOfRotation;
    private final YoDouble lineOfRotationAngularVelocityAlphaFilter;
    private final FilteredVelocityYoVariable lineOfRotationAngularVelocityFiltered;
    private final YoDouble footDropOrLift;
    private final YoDouble stableLoRAngularVelocityThreshold;
    private final YoBoolean isLineOfRotationStable;
    private final YoDouble stableCoRLinearVelocityThreshold;
    private final YoBoolean isCenterOfRotationStable;
    private final YoDouble angularVelocityAroundLoRThreshold;
    private final YoBoolean isAngularVelocityAroundLoRPastThreshold;
    private final YoDouble footDropThreshold;
    private final YoBoolean isFootDropPastThreshold;
    private final YoBoolean isFootRotating;
    private final YoBoolean hasBeenInitialized;
    private final FrameVector2D angularVelocity = new FrameVector2D();
    private final FrameVector2D footAngularVelocityUnitVector = new FrameVector2D();
    private final FrameLine2D lineOfRotationInSoleFrame = new FrameLine2D();
    private final FrameLine2D lineOfRotationInWorldFrame = new FrameLine2D();
    private final FrameVector3D pointingBackwardVector = new FrameVector3D();
    private final ContactablePlaneBody rotatingBody;
    private final ReferenceFrame soleFrame;
    private final Twist bodyTwist = new Twist();
    private final FrameConvexPolygon2D footPolygonInSoleFrame = new FrameConvexPolygon2D();
    private final FrameConvexPolygon2D footPolygonInWorld = new FrameConvexPolygon2D();
    private final FrameConvexPolygonWithLineIntersector2d frameConvexPolygonWithLineIntersector2d = new FrameConvexPolygonWithLineIntersector2d();

    public VelocityFootRotationCalculator(String namePrefix, double dt, ContactablePlaneBody rotatingFoot, ExplorationParameters explorationParameters, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry parentRegistry) {
        this.rotatingBody = rotatingFoot;
        this.soleFrame = rotatingFoot.getSoleFrame();
        this.controllerDt = dt;
        this.footPolygonInSoleFrame.setIncludingFrame(FrameVertex2DSupplier.asFrameVertex2DSupplier((List)rotatingFoot.getContactPoints2d()));
        String name = this.getClass().getSimpleName();
        YoRegistry registry = new YoRegistry(namePrefix + name);
        parentRegistry.addChild(registry);
        this.angularVelocityAlphaFilter = new YoDouble(namePrefix + name + "AngularVelocityAlphaFilter", registry);
        this.angularVelocityFilterBreakFrequency = explorationParameters.getAngularVelocityFilterBreakFrequency();
        this.angularVelocityFilterBreakFrequency.addListener(v -> {
            double freq = this.angularVelocityFilterBreakFrequency.getDoubleValue();
            this.angularVelocityAlphaFilter.set(AlphaFilteredYoVariable.computeAlphaGivenBreakFrequencyProperly((double)freq, (double)this.controllerDt));
        });
        double freq = this.angularVelocityFilterBreakFrequency.getDoubleValue();
        this.angularVelocityAlphaFilter.set(AlphaFilteredYoVariable.computeAlphaGivenBreakFrequencyProperly((double)freq, (double)this.controllerDt));
        this.footAngularVelocityFiltered = new AlphaFilteredYoFrameVector2d(namePrefix + "AngularVelocityFiltered", "", registry, (DoubleProvider)this.angularVelocityAlphaFilter, this.soleFrame);
        this.yoCenterOfRotationPositionAlphaFilter = new YoDouble(namePrefix + "CoRPositionAlphaFilter", registry);
        this.centerOfRotationFiltered = new AlphaFilteredYoFramePoint2d(namePrefix + "CoRFiltered", "", registry, (DoubleProvider)this.yoCenterOfRotationPositionAlphaFilter, this.soleFrame);
        this.yoCenterOfRotationVelocityAlphaFilter = new YoDouble(namePrefix + "CoRVelocityAlphaFilter", registry);
        this.centerOfRotationTransverseVelocity = new YoDouble(namePrefix + "CoRTransversalVelocity", registry);
        this.centerOfRotationVelocityFiltered = new FilteredVelocityYoFrameVector2d(namePrefix + "CoRVelocity", "", (DoubleProvider)this.yoCenterOfRotationVelocityAlphaFilter, dt, registry, (FrameTuple2DReadOnly)this.centerOfRotationFiltered);
        this.lineSegmentOfRotation = new YoFrameLineSegment2D(namePrefix + "LoRPosition", worldFrame, registry);
        this.angleOfLineOfRotation = new YoDouble(namePrefix + "AngleOfLoR", registry);
        this.lineOfRotationAngularVelocityAlphaFilter = new YoDouble(namePrefix + "LoRAngularVelocityAlphaFilter", registry);
        this.lineOfRotationAngularVelocityFiltered = new FilteredVelocityYoVariable(namePrefix + "LoRAngularVelocityFiltered", "", (DoubleProvider)this.lineOfRotationAngularVelocityAlphaFilter, this.angleOfLineOfRotation, dt, registry);
        this.angularVelocityAroundLineOfRotation = new YoDouble(namePrefix + "AngularVelocityAroundLoR", registry);
        this.footDropOrLift = new YoDouble(namePrefix + "FootDropOrLift", registry);
        this.stableLoRAngularVelocityThreshold = explorationParameters.getStableLoRAngularVelocityThreshold();
        this.isLineOfRotationStable = new YoBoolean(namePrefix + "IsLoRStable", registry);
        this.stableCoRLinearVelocityThreshold = explorationParameters.getStableCoRLinearVelocityThreshold();
        this.isCenterOfRotationStable = new YoBoolean(namePrefix + "IsCoRStable", registry);
        this.angularVelocityAroundLoRThreshold = explorationParameters.getAngularVelocityAroundLoRThreshold();
        this.isAngularVelocityAroundLoRPastThreshold = new YoBoolean(namePrefix + "IsAngularVelocityAroundLoRPastThreshold", registry);
        this.footDropThreshold = explorationParameters.getFootDropThreshold();
        this.isFootDropPastThreshold = new YoBoolean(namePrefix + "IsFootDropPastThreshold", registry);
        this.isFootRotating = new YoBoolean(namePrefix + "RotatingVelocity", registry);
        this.hasBeenInitialized = new YoBoolean(namePrefix + "HasBeenInitialized", registry);
        this.angularVelocity.setToZero(this.soleFrame);
        this.lineOfRotationInSoleFrame.setIncludingFrame(this.soleFrame, 0.0, 0.0, 1.0, 0.0);
        if (yoGraphicsListRegistry != null) {
            YoArtifactLineSegment2d lineOfRotationArtifact = new YoArtifactLineSegment2d(namePrefix + "LineOfRotation", this.lineSegmentOfRotation, Color.ORANGE, 0.005, 0.01);
            lineOfRotationArtifact.setVisible(false);
            yoGraphicsListRegistry.registerArtifact(this.getClass().getSimpleName(), (Artifact)lineOfRotationArtifact);
        }
    }

    @Override
    public void compute(FramePoint2DReadOnly desiredCoP, FramePoint2DReadOnly centerOfPressure) {
        this.rotatingBody.getRigidBody().getBodyFixedFrame().getTwistOfFrame((TwistBasics)this.bodyTwist);
        this.angularVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.bodyTwist.getAngularPart());
        this.angularVelocity.changeFrameAndProjectToXYPlane(this.soleFrame);
        this.footAngularVelocityFiltered.update((FrameTuple2DReadOnly)this.angularVelocity);
        this.angleOfLineOfRotation.set(Math.atan2(this.footAngularVelocityFiltered.getY(), this.footAngularVelocityFiltered.getX()));
        this.lineOfRotationAngularVelocityFiltered.updateForAngles();
        this.footAngularVelocityUnitVector.setIncludingFrame((FrameTuple2DReadOnly)this.footAngularVelocityFiltered);
        this.footAngularVelocityUnitVector.normalize();
        this.centerOfRotationFiltered.update((FrameTuple2DReadOnly)centerOfPressure);
        this.centerOfRotationVelocityFiltered.update();
        this.centerOfRotationTransverseVelocity.set(this.centerOfRotationVelocityFiltered.cross((FrameTuple2DReadOnly)this.footAngularVelocityUnitVector));
        if (!this.hasBeenInitialized.getBooleanValue()) {
            this.hasBeenInitialized.set(true);
            return;
        }
        this.pointingBackwardVector.setIncludingFrame(this.soleFrame, this.footAngularVelocityUnitVector.getY(), -this.footAngularVelocityUnitVector.getX(), 0.0);
        this.pointingBackwardVector.normalize();
        this.pointingBackwardVector.scale(0.15);
        this.pointingBackwardVector.changeFrame(worldFrame);
        this.footDropOrLift.set(this.pointingBackwardVector.getZ());
        this.angularVelocityAroundLineOfRotation.set(this.footAngularVelocityFiltered.length());
        this.updateFootRotationEstimate();
        if (this.isFootRotating.getBooleanValue()) {
            this.lineOfRotationInSoleFrame.set((FramePoint2DReadOnly)this.centerOfRotationFiltered, (FrameVector2DReadOnly)this.footAngularVelocityFiltered);
            this.lineOfRotationInWorldFrame.setIncludingFrame((FrameLine2DReadOnly)this.lineOfRotationInSoleFrame);
            this.lineOfRotationInWorldFrame.changeFrameAndProjectToXYPlane(worldFrame);
            this.intersectLineOfRotationWithFootPolygon();
        } else {
            this.lineSegmentOfRotation.setToNaN();
        }
    }

    private void updateFootRotationEstimate() {
        this.isFootDropPastThreshold.set(this.footDropOrLift.getDoubleValue() < this.footDropThreshold.getDoubleValue());
        this.isLineOfRotationStable.set(Math.abs(this.lineOfRotationAngularVelocityFiltered.getDoubleValue()) < this.stableLoRAngularVelocityThreshold.getDoubleValue());
        this.isCenterOfRotationStable.set(Math.abs(this.centerOfRotationTransverseVelocity.getDoubleValue()) < this.stableCoRLinearVelocityThreshold.getDoubleValue());
        this.isAngularVelocityAroundLoRPastThreshold.set(this.angularVelocityAroundLineOfRotation.getDoubleValue() > this.angularVelocityAroundLoRThreshold.getDoubleValue());
        this.isFootRotating.set(this.isLineOfRotationStable.getBooleanValue() && this.isCenterOfRotationStable.getBooleanValue() && this.isAngularVelocityAroundLoRPastThreshold.getBooleanValue() && this.isFootDropPastThreshold.getBooleanValue());
    }

    private void intersectLineOfRotationWithFootPolygon() {
        this.footPolygonInWorld.setIncludingFrame((FrameVertex2DSupplier)this.footPolygonInSoleFrame);
        this.footPolygonInWorld.changeFrameAndProjectToXYPlane(worldFrame);
        this.frameConvexPolygonWithLineIntersector2d.intersectWithLine((FrameConvexPolygon2DReadOnly)this.footPolygonInWorld, (FrameLine2DReadOnly)this.lineOfRotationInWorldFrame);
        if (FootRotationCalculator.isIntersectionValid(this.frameConvexPolygonWithLineIntersector2d)) {
            this.lineSegmentOfRotation.set((FramePoint2DReadOnly)this.frameConvexPolygonWithLineIntersector2d.getIntersectionPointOne(), (FramePoint2DReadOnly)this.frameConvexPolygonWithLineIntersector2d.getIntersectionPointTwo());
        } else {
            this.lineSegmentOfRotation.setToNaN();
        }
    }

    @Override
    public boolean isFootRotating() {
        return this.isFootRotating.getBooleanValue();
    }

    @Override
    public void getLineOfRotation(FrameLine2DBasics lineOfRotationToPack) {
        lineOfRotationToPack.setIncludingFrame((FrameLine2DReadOnly)this.lineOfRotationInSoleFrame);
        lineOfRotationToPack.changeFrameAndProjectToXYPlane(this.soleFrame);
    }

    @Override
    public void reset() {
        this.lineSegmentOfRotation.setToNaN();
        this.footAngularVelocityFiltered.reset();
        this.footAngularVelocityFiltered.setToNaN();
        this.centerOfRotationFiltered.reset();
        this.centerOfRotationFiltered.setToNaN();
        this.centerOfRotationVelocityFiltered.reset();
        this.centerOfRotationVelocityFiltered.setToNaN();
        this.angleOfLineOfRotation.set(0.0);
        this.lineOfRotationAngularVelocityFiltered.set(Double.NaN);
        this.lineOfRotationAngularVelocityFiltered.reset();
        this.angularVelocityAroundLineOfRotation.set(Double.NaN);
        this.isLineOfRotationStable.set(false);
        this.isCenterOfRotationStable.set(false);
        this.isFootRotating.set(false);
        this.hasBeenInitialized.set(false);
    }

    public void setAlphaFilter(double alpha) {
        this.angularVelocityAlphaFilter.set(alpha);
    }

    public void setFootAngularVelocityThreshold(double threshold) {
        this.angularVelocityAroundLoRThreshold.set(threshold);
    }

    public void setStableAngularVelocityThreshold(double threshold) {
        this.stableLoRAngularVelocityThreshold.set(threshold);
    }
}

