/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.foot;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.YoContactPoint;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.YoPlaneContactState;
import us.ihmc.commonWalkingControlModules.controlModules.foot.AbstractFootControlState;
import us.ihmc.commonWalkingControlModules.controlModules.foot.FootControlHelper;
import us.ihmc.commonWalkingControlModules.controlModules.foot.contactPoints.ContactStateRhoRamping;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.SpatialFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.SpatialAccelerationCommand;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.MomentumOptimizationSettings;
import us.ihmc.euclid.referenceFrame.FrameLineSegment3D;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.robotics.controllers.pidGains.PIDSE3GainsReadOnly;
import us.ihmc.robotics.math.trajectories.HermiteCurveBasedOrientationTrajectoryGenerator;
import us.ihmc.robotics.referenceFrames.TranslationReferenceFrame;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.screwTheory.SelectionMatrix6D;
import us.ihmc.robotics.sensors.FootSwitchInterface;
import us.ihmc.tools.lists.ListSorter;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameQuaternion;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;

public class TouchDownState
extends AbstractFootControlState {
    private final String name = this.getClass().getSimpleName();
    private final YoRegistry registry;
    private final SpatialFeedbackControlCommand feedbackControlCommand = new SpatialFeedbackControlCommand();
    private final SpatialAccelerationCommand zeroAccelerationCommand = new SpatialAccelerationCommand();
    private final SelectionMatrix6D footAccelerationSelectionMatrix = new SelectionMatrix6D();
    private final SelectionMatrix6D feedbackControlSelectionMatrix = new SelectionMatrix6D();
    private final HermiteCurveBasedOrientationTrajectoryGenerator orientationTrajectory;
    private final ContactStateRhoRamping<RobotSide> footContactRhoRamper;
    private final FrameLineSegment3D contactLine = new FrameLineSegment3D();
    private final YoEnum<LineContactActivationMethod> lineContactActivationMethod;
    private final YoFrameQuaternion initialOrientation;
    private final YoFrameVector3D initialAngularVelocity;
    private final YoFrameQuaternion finalOrientation;
    private final YoFrameVector3D finalAngularVelocity;
    private final FramePoint3D contactPointPosition = new FramePoint3D();
    private final YoPlaneContactState contactState = this.controllerToolbox.getFootContactState(this.robotSide);
    private final List<YoContactPoint> contactPoints = new ArrayList<YoContactPoint>(this.contactState.getContactPoints());
    private final YoDouble timeInContact;
    private final YoDouble desiredTouchdownDuration;
    private final TranslationReferenceFrame groundContactFrame;
    private final FootSwitchInterface footSwitch;
    private final FramePoint2D sensedCoP = new FramePoint2D();
    private final ReferenceFrame soleFrame;
    private final ReferenceFrame controlFrame;
    private final MovingReferenceFrame footBodyFixedFrame;
    private final FramePose3D controlFramePose = new FramePose3D();
    private final YoContactPointDistanceComparator copDistanceComparator = new YoContactPointDistanceComparator();
    private final YoContactLowestPointDistanceComparator zHeightDistanceComparator = new YoContactLowestPointDistanceComparator();
    private Vector3DReadOnly angularWeight;
    private Vector3DReadOnly linearWeight;
    private final PIDSE3GainsReadOnly gains;

    public TouchDownState(FootControlHelper footControlHelper, PIDSE3GainsReadOnly swingFootControlGains, YoRegistry parentRegistry) {
        super(footControlHelper);
        this.gains = swingFootControlGains;
        MomentumOptimizationSettings momentumOptimizationSettings = footControlHelper.getWalkingControllerParameters().getMomentumOptimizationSettings();
        SideDependentList<FootSwitchInterface> footSwitches = this.controllerToolbox.getFootSwitches();
        this.footSwitch = (FootSwitchInterface)footSwitches.get((Enum)this.robotSide);
        this.soleFrame = this.contactableFoot.getSoleFrame();
        String namePrefix = footControlHelper.getRobotSide().getCamelCaseNameForStartOfExpression();
        this.registry = new YoRegistry(namePrefix + this.name);
        double rhoWeight = momentumOptimizationSettings.getRhoWeight();
        this.lineContactActivationMethod = new YoEnum("lineContactActivationMethod", this.registry, LineContactActivationMethod.class);
        this.lineContactActivationMethod.set((Enum)LineContactActivationMethod.FOOT_ORIENTATION);
        this.footContactRhoRamper = new ContactStateRhoRamping<RobotSide>(this.robotSide, this.contactState, rhoWeight, this.registry);
        this.orientationTrajectory = new HermiteCurveBasedOrientationTrajectoryGenerator(namePrefix + "OrientationTrajectory", worldFrame, this.registry);
        this.initialOrientation = new YoFrameQuaternion(namePrefix + "initialOrientation", worldFrame, this.registry);
        this.initialAngularVelocity = new YoFrameVector3D(namePrefix + "initialAngularVelocity", worldFrame, this.registry);
        this.finalOrientation = new YoFrameQuaternion(namePrefix + "finalOrientation", worldFrame, this.registry);
        this.finalAngularVelocity = new YoFrameVector3D(namePrefix + "finalAngularVelocity", worldFrame, this.registry);
        this.timeInContact = new YoDouble(namePrefix + "TimeInContact", this.registry);
        this.desiredTouchdownDuration = new YoDouble(namePrefix + "DesiredTouchdownDuration", this.registry);
        this.footBodyFixedFrame = this.contactableFoot.getRigidBody().getBodyFixedFrame();
        this.groundContactFrame = new TranslationReferenceFrame(namePrefix + "groundContactFrame", (ReferenceFrame)this.footBodyFixedFrame);
        this.controlFrame = this.footBodyFixedFrame;
        this.feedbackControlCommand.setWeightForSolver(10.0);
        this.feedbackControlCommand.set(this.rootBody, this.contactableFoot.getRigidBody());
        this.feedbackControlCommand.setPrimaryBase(this.pelvis);
        this.controlFramePose.setToZero(this.controlFrame);
        this.controlFramePose.changeFrame((ReferenceFrame)this.footBodyFixedFrame);
        this.feedbackControlCommand.setControlBaseFrame((ReferenceFrame)this.footBodyFixedFrame);
        this.feedbackControlCommand.setControlFrameFixedInEndEffector((FramePose3DReadOnly)this.controlFramePose);
        this.feedbackControlSelectionMatrix.setToAngularSelectionOnly();
        this.feedbackControlCommand.setSelectionMatrix(this.feedbackControlSelectionMatrix);
        this.zeroAccelerationCommand.setWeight(10.0);
        this.zeroAccelerationCommand.set(this.rootBody, this.contactableFoot.getRigidBody());
        this.zeroAccelerationCommand.setPrimaryBase(this.pelvis);
        this.footAccelerationSelectionMatrix.setToLinearSelectionOnly();
        this.footAccelerationSelectionMatrix.setSelectionFrame(worldFrame);
        this.zeroAccelerationCommand.setSelectionMatrix(this.footAccelerationSelectionMatrix);
        parentRegistry.addChild(this.registry);
    }

    @Override
    public void doSpecificAction(double timeInState) {
        this.timeInContact.set(timeInState);
        this.footContactRhoRamper.update(timeInState);
        this.orientationTrajectory.compute(timeInState);
        this.orientationTrajectory.getAngularData((FrameOrientation3DBasics)this.desiredOrientation, (FrameVector3DBasics)this.desiredAngularVelocity, (FrameVector3DBasics)this.desiredAngularAcceleration);
        this.feedbackControlCommand.setInverseDynamics((FrameQuaternionReadOnly)this.desiredOrientation, (FrameVector3DReadOnly)this.desiredAngularVelocity, (FrameVector3DReadOnly)this.desiredAngularAcceleration);
        this.feedbackControlCommand.setWeightsForSolver(this.angularWeight, this.linearWeight);
        this.feedbackControlCommand.setGains(this.gains);
    }

    public void setTouchdownDuration(double touchdownDuration) {
        this.desiredTouchdownDuration.set(touchdownDuration);
    }

    public void initialize(FramePose3D initialFootPose, FrameVector3D initialFootLinearVelocity, FrameVector3D initialFootAngularVelocity) {
        initialFootPose.changeFrame(worldFrame);
        this.desiredOrientation.changeFrame(worldFrame);
        this.desiredOrientation.setYawPitchRoll(initialFootPose.getYaw(), 0.0, 0.0);
        this.initialize(initialFootPose, initialFootLinearVelocity, initialFootAngularVelocity, this.desiredOrientation);
    }

    public void initialize(FramePose3D initialFootPose, FrameVector3D initialFootLinearVelocity, FrameVector3D initialFootAngularVelocity, FrameQuaternion finalFootOrientation) {
        initialFootPose.changeFrame(worldFrame);
        initialFootAngularVelocity.changeFrame(worldFrame);
        finalFootOrientation.changeFrame(worldFrame);
        this.initialOrientation.set((FrameQuaternionReadOnly)initialFootPose.getOrientation());
        this.initialAngularVelocity.set((FrameTuple3DReadOnly)initialFootAngularVelocity);
        this.finalOrientation.set((FrameQuaternionReadOnly)finalFootOrientation);
    }

    @Override
    public void onEntry() {
        super.onEntry();
        this.enableLineContactAndSetTheGroundContactFrame(this.contactPointPosition, this.groundContactFrame);
        this.footContactRhoRamper.initialize(this.desiredTouchdownDuration.getDoubleValue());
        this.zeroAccelerationCommand.setSpatialAccelerationToZero((ReferenceFrame)this.groundContactFrame);
        this.feedbackControlCommand.setControlFrameFixedInEndEffector((FramePoint3DReadOnly)this.contactPointPosition);
        this.orientationTrajectory.setInitialConditions((FrameQuaternionReadOnly)this.initialOrientation, (FrameVector3DReadOnly)this.initialAngularVelocity);
        this.orientationTrajectory.setFinalConditions((FrameQuaternionReadOnly)this.finalOrientation, (FrameVector3DReadOnly)this.finalAngularVelocity);
        this.orientationTrajectory.setNumberOfRevolutions(0);
        this.orientationTrajectory.setTrajectoryTime(this.desiredTouchdownDuration.getDoubleValue());
        this.orientationTrajectory.initialize();
    }

    @Override
    public void onExit() {
        super.onExit();
        this.footContactRhoRamper.resetContactState();
    }

    private void enableLineContactAndSetTheGroundContactFrame(FramePoint3D contactPointPositionToPack, TranslationReferenceFrame groundContactFrameToUpdate) {
        Comparator<YoContactPoint> contactPointComparator = this.zHeightDistanceComparator;
        if (this.lineContactActivationMethod.getEnumValue() == LineContactActivationMethod.SENSED_COP) {
            contactPointComparator = this.getComparatorBasedOnCoPPosition();
        }
        this.updateUsingLineContact(this.contactState, this.contactPoints, this.contactLine, contactPointComparator);
        MovingReferenceFrame footFixedFrame = this.contactableFoot.getRigidBody().getBodyFixedFrame();
        this.contactLine.changeFrame((ReferenceFrame)footFixedFrame);
        contactPointPositionToPack.setToNaN((ReferenceFrame)footFixedFrame);
        this.contactLine.midpoint((FramePoint3DBasics)contactPointPositionToPack);
        groundContactFrameToUpdate.updateTranslation((FrameTuple3DReadOnly)contactPointPositionToPack);
    }

    private Comparator<YoContactPoint> getComparatorBasedOnCoPPosition() {
        this.footSwitch.computeAndPackCoP(this.sensedCoP);
        this.sensedCoP.changeFrame(this.soleFrame);
        this.copDistanceComparator.setCoP((FrameTuple2DReadOnly)this.sensedCoP);
        return this.copDistanceComparator;
    }

    private void updateUsingLineContact(YoPlaneContactState contactState, List<YoContactPoint> contactPoints, FrameLineSegment3D contactLineToPack, Comparator<YoContactPoint> contactPointComparator) {
        ListSorter.sort(contactPoints, contactPointComparator);
        YoContactPoint yoContactPointA = contactPoints.get(0);
        yoContactPointA.setInContact(true);
        YoContactPoint yoContactPointB = contactPoints.get(1);
        yoContactPointB.setInContact(true);
        contactState.updateInContact();
        contactLineToPack.setIncludingFrame((FramePoint3DReadOnly)yoContactPointA, (FramePoint3DReadOnly)yoContactPointB);
        contactState.setContactNormalVector((FrameVector3DReadOnly)this.footControlHelper.getFullyConstrainedNormalContactVector());
    }

    public void setWeights(Vector3DReadOnly angularWeight, Vector3DReadOnly linearWeight) {
        this.angularWeight = angularWeight;
        this.linearWeight = linearWeight;
    }

    @Override
    public InverseDynamicsCommand<?> getInverseDynamicsCommand() {
        return this.zeroAccelerationCommand;
    }

    @Override
    public SpatialFeedbackControlCommand getFeedbackControlCommand() {
        return this.feedbackControlCommand;
    }

    @Override
    public boolean isDone(double timeInState) {
        return timeInState > this.desiredTouchdownDuration.getDoubleValue();
    }

    private class YoContactPointDistanceComparator
    implements Comparator<YoContactPoint> {
        private final FrameVector2D cop = new FrameVector2D();
        private final FrameVector2D cp1 = new FrameVector2D();
        private final FrameVector2D cp2 = new FrameVector2D();

        private YoContactPointDistanceComparator() {
        }

        public void setCoP(FrameTuple2DReadOnly cop) {
            this.cop.setIncludingFrame(cop);
        }

        @Override
        public int compare(YoContactPoint o1, YoContactPoint o2) {
            this.cp1.setIncludingFrame((FrameTuple3DReadOnly)o1);
            this.cp2.setIncludingFrame((FrameTuple3DReadOnly)o2);
            this.cp1.sub((FrameTuple2DReadOnly)this.cop);
            this.cp2.sub((FrameTuple2DReadOnly)this.cop);
            double cp1Distance = this.cp1.lengthSquared();
            double cp2Distance = this.cp2.lengthSquared();
            if (cp1Distance < cp2Distance) {
                return -1;
            }
            if (cp1Distance > cp2Distance) {
                return 1;
            }
            return 0;
        }
    }

    private class YoContactLowestPointDistanceComparator
    implements Comparator<YoContactPoint> {
        private final FramePoint3D cp1 = new FramePoint3D();
        private final FramePoint3D cp2 = new FramePoint3D();

        private YoContactLowestPointDistanceComparator() {
        }

        @Override
        public int compare(YoContactPoint o1, YoContactPoint o2) {
            this.cp1.setIncludingFrame((FrameTuple3DReadOnly)o1);
            this.cp2.setIncludingFrame((FrameTuple3DReadOnly)o2);
            this.cp1.changeFrame(AbstractFootControlState.worldFrame);
            this.cp2.changeFrame(AbstractFootControlState.worldFrame);
            if (this.cp1.getZ() < this.cp2.getZ()) {
                return -1;
            }
            if (this.cp1.getZ() > this.cp2.getZ()) {
                return 1;
            }
            return 0;
        }
    }

    private static enum LineContactActivationMethod {
        SENSED_COP,
        FOOT_ORIENTATION;

    }
}

