/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.foot;

import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.PlaneContactState;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.YoContactPoint;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.YoPlaneContactState;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.controlModules.foot.AbstractFootControlState;
import us.ihmc.commonWalkingControlModules.controlModules.foot.ExplorationHelper;
import us.ihmc.commonWalkingControlModules.controlModules.foot.ExplorationParameters;
import us.ihmc.commonWalkingControlModules.controlModules.foot.FeetManager;
import us.ihmc.commonWalkingControlModules.controlModules.foot.FootControlHelper;
import us.ihmc.commonWalkingControlModules.controlModules.foot.PartialFootholdControlModule;
import us.ihmc.commonWalkingControlModules.controlModules.foot.SupportStateParameters;
import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.PartialFootholdCropperModule;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.SpatialFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommandList;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.SpatialAccelerationCommand;
import us.ihmc.commonWalkingControlModules.momentumBasedController.ParameterProvider;
import us.ihmc.commons.InterpolationTools;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicReferenceFrame;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.controllers.pidGains.PID3DGains;
import us.ihmc.robotics.controllers.pidGains.PID3DGainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.PIDSE3Gains;
import us.ihmc.robotics.controllers.pidGains.PIDSE3GainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.implementations.DefaultPIDSE3Gains;
import us.ihmc.robotics.math.trajectories.yoVariables.YoPolynomial;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.robotics.screwTheory.SelectionMatrix6D;
import us.ihmc.robotics.sensors.FootSwitchInterface;
import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class SupportState
extends AbstractFootControlState {
    private static final int dofs = 6;
    private final YoRegistry registry;
    private final FrameConvexPolygon2D footPolygon = new FrameConvexPolygon2D();
    private final YoBoolean footBarelyLoaded;
    private final YoBoolean copOnEdge;
    private final boolean[] isDirectionFeedbackControlled = new boolean[6];
    private final FootSwitchInterface footSwitch;
    private final PoseReferenceFrame controlFrame;
    private final PoseReferenceFrame desiredSoleFrame;
    private final YoGraphicReferenceFrame frameViz;
    private final InverseDynamicsCommandList inverseDynamicsCommandsList = new InverseDynamicsCommandList();
    private final SpatialAccelerationCommand spatialAccelerationCommand = new SpatialAccelerationCommand();
    private final SpatialFeedbackControlCommand spatialFeedbackControlCommand = new SpatialFeedbackControlCommand();
    private final SelectionMatrix6D accelerationSelectionMatrix = new SelectionMatrix6D();
    private final SelectionMatrix6D feedbackSelectionMatrix = new SelectionMatrix6D();
    private final FramePoint2D cop2d = new FramePoint2D();
    private final FramePoint3D framePosition = new FramePoint3D();
    private final FrameQuaternion frameOrientation = new FrameQuaternion();
    private final FramePose3D bodyFixedControlledPose = new FramePose3D();
    private final FramePoint3D desiredCopPosition = new FramePoint3D();
    private final FramePoint2D desiredCoP = new FramePoint2D();
    private final FramePoint3D footPosition = new FramePoint3D();
    private final FrameQuaternion footOrientation = new FrameQuaternion();
    private final ExplorationHelper explorationHelper;
    private final PartialFootholdControlModule partialFootholdControlModule;
    private final YoBoolean requestFootholdExploration;
    private final YoDouble recoverTime;
    private final YoDouble timeBeforeExploring;
    private final RigidBodyBasics pelvis;
    private final SupportStateParameters supportStateParameters;
    private Vector3DReadOnly angularWeight;
    private Vector3DReadOnly linearWeight;
    private final PIDSE3GainsReadOnly gains;
    private final BooleanProvider dampFootRotations;
    private final DoubleProvider footDamping;
    private final PIDSE3Gains localGains = new DefaultPIDSE3Gains();
    private final PartialFootholdCropperModule footRotationCalculationModule;
    private final YoBoolean liftOff;
    private final YoBoolean touchDown;
    private final YoPolynomial pitchTrajectory;
    private final YoDouble pitchTrajectoryEndTime;
    private final YoDouble desiredPitch;

    public SupportState(FootControlHelper footControlHelper, PIDSE3GainsReadOnly holdPositionGains, YoRegistry parentRegistry) {
        super(footControlHelper);
        this.gains = holdPositionGains;
        String prefix = footControlHelper.getRobotSide().getLowerCaseName() + "Foot";
        this.registry = new YoRegistry(prefix + this.getClass().getSimpleName());
        parentRegistry.addChild(this.registry);
        this.footSwitch = (FootSwitchInterface)footControlHelper.getHighLevelHumanoidControllerToolbox().getFootSwitches().get((Enum)this.robotSide);
        this.controlFrame = new PoseReferenceFrame(prefix + "HoldPositionFrame", this.contactableFoot.getSoleFrame());
        this.desiredSoleFrame = new PoseReferenceFrame(prefix + "DesiredSoleFrame", worldFrame);
        this.footBarelyLoaded = new YoBoolean(prefix + "BarelyLoaded", this.registry);
        this.copOnEdge = new YoBoolean(prefix + "CopOnEdge", this.registry);
        WalkingControllerParameters walkingControllerParameters = footControlHelper.getWalkingControllerParameters();
        this.supportStateParameters = footControlHelper.getSupportStateParameters();
        FullHumanoidRobotModel fullRobotModel = footControlHelper.getHighLevelHumanoidControllerToolbox().getFullRobotModel();
        this.pelvis = fullRobotModel.getPelvis();
        this.spatialAccelerationCommand.setWeight(50.0);
        this.spatialAccelerationCommand.set(this.rootBody, this.contactableFoot.getRigidBody());
        this.spatialAccelerationCommand.setPrimaryBase(this.pelvis);
        this.spatialFeedbackControlCommand.setWeightForSolver(50.0);
        this.spatialFeedbackControlCommand.set(this.rootBody, this.contactableFoot.getRigidBody());
        this.spatialFeedbackControlCommand.setPrimaryBase(this.pelvis);
        this.desiredLinearVelocity.setToZero(worldFrame);
        this.desiredAngularVelocity.setToZero(worldFrame);
        this.desiredLinearAcceleration.setToZero(worldFrame);
        this.desiredAngularAcceleration.setToZero(worldFrame);
        this.explorationHelper = new ExplorationHelper(this.contactableFoot, footControlHelper, prefix, this.registry);
        this.partialFootholdControlModule = footControlHelper.getPartialFootholdControlModule();
        this.requestFootholdExploration = new YoBoolean(prefix + "RequestFootholdExploration", this.registry);
        ExplorationParameters explorationParameters = footControlHelper.getExplorationParameters();
        if (walkingControllerParameters.createFootholdExplorationTools() && explorationParameters != null) {
            this.recoverTime = explorationParameters.getRecoverTime();
            this.timeBeforeExploring = explorationParameters.getTimeBeforeExploring();
        } else {
            this.recoverTime = new YoDouble(prefix + "RecoverTime", this.registry);
            this.timeBeforeExploring = new YoDouble(prefix + "TimeBeforeExploring", this.registry);
        }
        YoGraphicsListRegistry graphicsListRegistry = footControlHelper.getHighLevelHumanoidControllerToolbox().getYoGraphicsListRegistry();
        if (graphicsListRegistry != null) {
            this.frameViz = new YoGraphicReferenceFrame((ReferenceFrame)this.controlFrame, this.registry, false, 0.2);
            graphicsListRegistry.registerYoGraphic(prefix + this.getClass().getSimpleName(), (YoGraphic)this.frameViz);
        } else {
            this.frameViz = null;
        }
        MovingReferenceFrame soleFrame = fullRobotModel.getSoleFrame((Enum)this.robotSide);
        double dt = this.controllerToolbox.getControlDT();
        this.footRotationCalculationModule = new PartialFootholdCropperModule(this.robotSide, soleFrame, footControlHelper.getContactableFoot().getContactPoints2d(), footControlHelper.getFootholdRotationParameters(), dt, this.registry, graphicsListRegistry);
        String feetManagerName = FeetManager.class.getSimpleName();
        String paramRegistryName = this.getClass().getSimpleName() + "Parameters";
        this.dampFootRotations = ParameterProvider.getOrCreateParameter(feetManagerName, paramRegistryName, "dampFootRotations", this.registry, false);
        this.footDamping = ParameterProvider.getOrCreateParameter(feetManagerName, paramRegistryName, "footDamping", this.registry, 0.0);
        this.liftOff = new YoBoolean(prefix + "LiftOff", this.registry);
        this.touchDown = new YoBoolean(prefix + "TouchDown", this.registry);
        this.pitchTrajectory = new YoPolynomial(prefix + "PitchTrajectory", 4, this.registry);
        this.pitchTrajectoryEndTime = new YoDouble(prefix + "PitchTrajectoryEndTime", this.registry);
        this.desiredPitch = new YoDouble(prefix + "DesiredPitch", this.registry);
    }

    @Override
    public void onEntry() {
        super.onEntry();
        FrameVector3D fullyConstrainedNormalContactVector = this.footControlHelper.getFullyConstrainedNormalContactVector();
        this.controllerToolbox.setFootContactStateNormalContactVector(this.robotSide, fullyConstrainedNormalContactVector);
        for (int i = 0; i < 6; ++i) {
            this.isDirectionFeedbackControlled[i] = false;
        }
        this.computeFootPolygon();
        this.footRotationCalculationModule.initialize((FrameConvexPolygon2DReadOnly)this.footPolygon);
        this.footBarelyLoaded.set(false);
        this.copOnEdge.set(false);
        this.liftOff.set(false);
        this.updateHoldPositionSetpoints();
    }

    @Override
    public void onExit() {
        super.onExit();
        this.footBarelyLoaded.set(false);
        this.copOnEdge.set(false);
        if (this.frameViz != null) {
            this.frameViz.hide();
        }
        this.explorationHelper.stopExploring();
        this.footRotationCalculationModule.reset();
        this.liftOff.set(false);
        this.touchDown.set(false);
        this.desiredAngularVelocity.setToZero(worldFrame);
        this.desiredAngularAcceleration.setToZero(worldFrame);
    }

    @Override
    public void doSpecificAction(double timeInState) {
        int i;
        boolean timeBeforeExploringHasPassed;
        this.computeFootPolygon();
        this.controllerToolbox.getDesiredCenterOfPressure((ContactablePlaneBody)this.contactableFoot, this.desiredCoP);
        this.footSwitch.computeAndPackCoP(this.cop2d);
        if (this.cop2d.containsNaN()) {
            this.cop2d.setToZero(this.contactableFoot.getSoleFrame());
        }
        boolean recoverTimeHasPassed = timeInState > this.recoverTime.getDoubleValue();
        boolean contactStateHasChanged = false;
        if (this.partialFootholdControlModule != null && recoverTimeHasPassed) {
            this.partialFootholdControlModule.compute(this.desiredCoP, this.cop2d);
            YoPlaneContactState contactState = this.controllerToolbox.getFootContactState(this.robotSide);
            contactStateHasChanged = this.partialFootholdControlModule.applyShrunkPolygon(contactState);
            if (contactStateHasChanged) {
                contactState.notifyContactStateHasChanged();
            }
        }
        boolean bl = timeBeforeExploringHasPassed = timeInState > this.timeBeforeExploring.getDoubleValue();
        if (this.requestFootholdExploration.getBooleanValue() && timeBeforeExploringHasPassed) {
            this.explorationHelper.startExploring();
            this.requestFootholdExploration.set(false);
        }
        if (this.partialFootholdControlModule != null && !timeBeforeExploringHasPassed) {
            this.partialFootholdControlModule.clearCoPGrid();
        }
        this.explorationHelper.compute(timeInState, contactStateHasChanged);
        if (this.supportStateParameters.rampUpAllowableToeLoadAfterContact() && timeInState < this.supportStateParameters.getToeLoadingDuration()) {
            double maxContactPointX = this.footPolygon.getMaxX();
            double minContactPointX = this.footPolygon.getMinX();
            double phaseInLoading = timeInState / this.supportStateParameters.getToeLoadingDuration();
            double leadingToeMagnitude = InterpolationTools.linearInterpolate((double)0.0, (double)this.supportStateParameters.getFullyLoadedMagnitude(), (double)phaseInLoading);
            YoPlaneContactState planeContactState = this.controllerToolbox.getFootContactState(this.robotSide);
            for (int i2 = 0; i2 < planeContactState.getTotalNumberOfContactPoints(); ++i2) {
                YoContactPoint contactPoint = planeContactState.getContactPoints().get(i2);
                double percentAlongFoot = (contactPoint.getX() - minContactPointX) / (maxContactPointX - minContactPointX);
                double contactPointMagnitude = InterpolationTools.linearInterpolate((double)this.supportStateParameters.getFullyLoadedMagnitude(), (double)leadingToeMagnitude, (double)percentAlongFoot);
                planeContactState.setMaxContactPointNormalForce(contactPoint, contactPointMagnitude);
            }
        } else {
            YoPlaneContactState planeContactState = this.controllerToolbox.getFootContactState(this.robotSide);
            for (int i3 = 0; i3 < planeContactState.getTotalNumberOfContactPoints(); ++i3) {
                YoContactPoint contactPoint = planeContactState.getContactPoints().get(i3);
                planeContactState.setMaxContactPointNormalForce(contactPoint, Double.POSITIVE_INFINITY);
            }
        }
        this.copOnEdge.set(this.footControlHelper.isCoPOnEdge() && !this.isInLiftOffOrTouchDown());
        this.footBarelyLoaded.set(this.footSwitch.computeFootLoadPercentage() < this.supportStateParameters.getFootLoadThreshold());
        if (this.supportStateParameters.assumeCopOnEdge()) {
            this.copOnEdge.set(true);
        }
        if (this.supportStateParameters.assumeFootBarelyLoaded()) {
            this.footBarelyLoaded.set(true);
        }
        if (this.supportStateParameters.neverHoldRotation()) {
            this.copOnEdge.set(false);
        }
        if (this.supportStateParameters.neverHoldPosition()) {
            this.footBarelyLoaded.set(false);
        }
        this.updateHoldPositionSetpoints();
        this.localGains.set(this.gains);
        boolean dampingRotations = false;
        this.footRotationCalculationModule.compute((FramePoint2DReadOnly)this.cop2d, (FramePoint2DReadOnly)this.desiredCoP);
        YoPlaneContactState contactState = this.controllerToolbox.getFootContactState(this.robotSide);
        if (this.footRotationCalculationModule.applyShrunkenFoothold(contactState)) {
            contactState.notifyContactStateHasChanged();
        }
        if (this.footRotationCalculationModule.isRotating() && this.dampFootRotations.getValue()) {
            PID3DGainsReadOnly orientationGains = this.gains.getOrientationGains();
            PID3DGains localOrientationGains = this.localGains.getOrientationGains();
            localOrientationGains.setProportionalGains(0.0, 0.0, orientationGains.getProportionalGains()[2]);
            localOrientationGains.setDerivativeGains(this.footDamping.getValue(), this.footDamping.getValue(), orientationGains.getDerivativeGains()[2]);
            dampingRotations = true;
        }
        this.framePosition.setIncludingFrame((FrameTuple2DReadOnly)this.cop2d, 0.0);
        this.frameOrientation.setToZero(this.contactableFoot.getSoleFrame());
        this.controlFrame.setPoseAndUpdate((FramePoint3DReadOnly)this.framePosition, (FrameOrientation3DReadOnly)this.frameOrientation);
        MovingReferenceFrame bodyFixedFrame = this.contactableFoot.getRigidBody().getBodyFixedFrame();
        this.footAcceleration.setToZero((ReferenceFrame)bodyFixedFrame, (ReferenceFrame)this.rootBody.getBodyFixedFrame(), (ReferenceFrame)this.controlFrame);
        this.footAcceleration.setBodyFrame((ReferenceFrame)bodyFixedFrame);
        this.spatialAccelerationCommand.setSpatialAcceleration((ReferenceFrame)this.controlFrame, (SpatialAccelerationReadOnly)this.footAcceleration);
        this.spatialAccelerationCommand.setWeights((Tuple3DReadOnly)this.angularWeight, (Tuple3DReadOnly)this.linearWeight);
        this.bodyFixedControlledPose.setToZero((ReferenceFrame)this.controlFrame);
        this.bodyFixedControlledPose.changeFrame((ReferenceFrame)this.contactableFoot.getRigidBody().getBodyFixedFrame());
        this.desiredCopPosition.setIncludingFrame((FrameTuple2DReadOnly)this.cop2d, 0.0);
        this.desiredCopPosition.setReferenceFrame((ReferenceFrame)this.desiredSoleFrame);
        this.desiredCopPosition.changeFrame(worldFrame);
        this.spatialFeedbackControlCommand.setControlFrameFixedInEndEffector((FramePose3DReadOnly)this.bodyFixedControlledPose);
        this.spatialFeedbackControlCommand.setInverseDynamics((FrameQuaternionReadOnly)this.desiredOrientation, (FramePoint3DReadOnly)this.desiredCopPosition, (FrameVector3DReadOnly)this.desiredAngularVelocity, (FrameVector3DReadOnly)this.desiredLinearVelocity, (FrameVector3DReadOnly)this.desiredAngularAcceleration, (FrameVector3DReadOnly)this.desiredLinearAcceleration);
        this.spatialFeedbackControlCommand.setWeightsForSolver(this.angularWeight, this.linearWeight);
        this.spatialFeedbackControlCommand.setGains((PIDSE3GainsReadOnly)this.localGains);
        MovingReferenceFrame soleZUpFrame = this.controllerToolbox.getReferenceFrames().getSoleZUpFrame((Enum)this.robotSide);
        this.accelerationSelectionMatrix.resetSelection();
        this.accelerationSelectionMatrix.setSelectionFrame((ReferenceFrame)soleZUpFrame);
        this.feedbackSelectionMatrix.resetSelection();
        this.feedbackSelectionMatrix.setSelectionFrame((ReferenceFrame)soleZUpFrame);
        for (i = 0; i < 6; ++i) {
            this.isDirectionFeedbackControlled[i] = false;
        }
        if (this.footBarelyLoaded.getBooleanValue()) {
            this.isDirectionFeedbackControlled[3] = true;
            this.isDirectionFeedbackControlled[4] = true;
            this.isDirectionFeedbackControlled[2] = true;
        }
        if (this.copOnEdge.getBooleanValue() || dampingRotations) {
            this.isDirectionFeedbackControlled[0] = true;
            this.isDirectionFeedbackControlled[1] = true;
        }
        if (this.liftOff.getValue() || this.touchDown.getValue()) {
            this.isDirectionFeedbackControlled[1] = true;
        }
        for (i = 5; i >= 0; --i) {
            if (this.isDirectionFeedbackControlled[i]) {
                this.accelerationSelectionMatrix.selectAxis(i, false);
                continue;
            }
            this.feedbackSelectionMatrix.selectAxis(i, false);
        }
        this.spatialAccelerationCommand.setSelectionMatrix(this.accelerationSelectionMatrix);
        this.spatialFeedbackControlCommand.setSelectionMatrix(this.feedbackSelectionMatrix);
        if (this.frameViz != null) {
            this.frameViz.setToReferenceFrame((ReferenceFrame)this.controlFrame);
        }
    }

    private void computeFootPolygon() {
        ReferenceFrame soleFrame = this.contactableFoot.getSoleFrame();
        this.footPolygon.clear(soleFrame);
        for (int i = 0; i < this.contactableFoot.getTotalNumberOfContactPoints(); ++i) {
            this.footPolygon.addVertex((FramePoint2DReadOnly)this.contactableFoot.getContactPoints2d().get(i));
        }
        this.footPolygon.update();
    }

    private void updateHoldPositionSetpoints() {
        this.footPosition.setToZero(this.contactableFoot.getSoleFrame());
        this.footOrientation.setToZero(this.contactableFoot.getSoleFrame());
        MovingReferenceFrame soleZUpFrame = this.controllerToolbox.getReferenceFrames().getSoleZUpFrame((Enum)this.robotSide);
        this.footPosition.changeFrame((ReferenceFrame)soleZUpFrame);
        this.footOrientation.changeFrame((ReferenceFrame)soleZUpFrame);
        this.desiredPosition.changeFrame((ReferenceFrame)soleZUpFrame);
        this.desiredOrientation.changeFrame((ReferenceFrame)soleZUpFrame);
        if (this.footBarelyLoaded.getBooleanValue() && this.copOnEdge.getBooleanValue()) {
            this.desiredPosition.setZ(this.footPosition.getZ());
        } else if (this.footBarelyLoaded.getBooleanValue()) {
            this.desiredPosition.setZ(this.footPosition.getZ());
            this.desiredOrientation.setYawPitchRoll(this.desiredOrientation.getYaw(), this.footOrientation.getPitch(), this.footOrientation.getRoll());
        } else if (this.copOnEdge.getBooleanValue()) {
            this.desiredPosition.set(this.footPosition);
            this.desiredOrientation.setYawPitchRoll(this.footOrientation.getYaw(), this.desiredOrientation.getPitch(), this.desiredOrientation.getRoll());
        } else {
            this.desiredPosition.set(this.footPosition);
            this.desiredOrientation.set(this.footOrientation);
        }
        if (this.supportStateParameters.holdFootOrientationFlat()) {
            this.desiredOrientation.setYawPitchRoll(this.desiredOrientation.getYaw(), 0.0, 0.0);
        }
        double currentTime = this.controllerToolbox.getYoTime().getValue();
        if (this.liftOff.getValue() && currentTime < this.pitchTrajectoryEndTime.getValue()) {
            this.pitchTrajectory.compute(currentTime);
            this.desiredPitch.set(this.pitchTrajectory.getValue());
            this.desiredOrientation.setYawPitchRoll(this.desiredOrientation.getYaw(), this.pitchTrajectory.getValue(), this.desiredOrientation.getRoll());
            this.desiredAngularVelocity.setIncludingFrame((ReferenceFrame)soleZUpFrame, 0.0, this.pitchTrajectory.getVelocity(), 0.0);
            this.desiredAngularAcceleration.setIncludingFrame((ReferenceFrame)soleZUpFrame, 0.0, this.pitchTrajectory.getAcceleration(), 0.0);
        }
        if (this.touchDown.getValue()) {
            if (currentTime >= this.pitchTrajectoryEndTime.getValue()) {
                PlaneContactState.enableAllContacts(this.controllerToolbox.getFootContactState(this.robotSide));
                this.desiredAngularVelocity.setToZero(worldFrame);
                this.touchDown.set(false);
            } else {
                this.pitchTrajectory.compute(currentTime);
                this.desiredPitch.set(this.pitchTrajectory.getValue());
                this.desiredOrientation.setYawPitchRoll(this.desiredOrientation.getYaw(), this.pitchTrajectory.getValue(), this.desiredOrientation.getRoll());
                this.desiredAngularVelocity.setIncludingFrame((ReferenceFrame)soleZUpFrame, 0.0, this.pitchTrajectory.getVelocity(), 0.0);
                this.desiredAngularAcceleration.setIncludingFrame((ReferenceFrame)soleZUpFrame, 0.0, this.pitchTrajectory.getAcceleration(), 0.0);
            }
        }
        this.desiredPosition.changeFrame(worldFrame);
        this.desiredOrientation.changeFrame(worldFrame);
        this.desiredAngularVelocity.changeFrame(worldFrame);
        this.desiredAngularAcceleration.changeFrame(worldFrame);
        this.desiredSoleFrame.setPoseAndUpdate((FramePoint3DReadOnly)this.desiredPosition, (FrameOrientation3DReadOnly)this.desiredOrientation);
    }

    public void liftOff(double finalPitchInSoleZUp, double finalPitchVelocityInSoleZUp, double duration) {
        double currentPitch = this.computeCurrentFootPitchInSoleZUp();
        if (!this.initializePitchTrajectory(currentPitch, 0.0, finalPitchInSoleZUp, finalPitchVelocityInSoleZUp, duration)) {
            return;
        }
        if (finalPitchInSoleZUp > currentPitch) {
            PlaneContactState.enableToeContacts(this.controllerToolbox.getFootContactState(this.robotSide));
        } else {
            PlaneContactState.enableHeelContacts(this.controllerToolbox.getFootContactState(this.robotSide));
        }
        this.liftOff.set(true);
    }

    public void touchDown(double initialPitchInSoleZUp, double initialPitchVelocityInSoleZUp, double finalPitchInSoleZUp, double duration) {
        if (!this.initializePitchTrajectory(initialPitchInSoleZUp, initialPitchVelocityInSoleZUp, finalPitchInSoleZUp, 0.0, duration)) {
            return;
        }
        if (finalPitchInSoleZUp < initialPitchInSoleZUp) {
            PlaneContactState.enableToeContacts(this.controllerToolbox.getFootContactState(this.robotSide));
        } else {
            PlaneContactState.enableHeelContacts(this.controllerToolbox.getFootContactState(this.robotSide));
        }
        this.touchDown.set(true);
    }

    private boolean isInLiftOffOrTouchDown() {
        return this.liftOff.getValue() || this.touchDown.getValue();
    }

    private boolean initializePitchTrajectory(double currrentPutch, double currentPitchVelocity, double finalPitch, double finalPitchVelocity, double duration) {
        if (this.isInLiftOffOrTouchDown()) {
            return false;
        }
        if (Double.isNaN(duration) || duration <= 0.0) {
            return false;
        }
        if (MathTools.epsilonEquals((double)finalPitch, (double)currrentPutch, (double)Math.toRadians(5.0))) {
            return false;
        }
        double currentTime = this.controllerToolbox.getYoTime().getValue();
        this.pitchTrajectoryEndTime.set(currentTime + duration);
        this.pitchTrajectory.setCubic(currentTime, this.pitchTrajectoryEndTime.getValue(), currrentPutch, currentPitchVelocity, finalPitch, finalPitchVelocity);
        return true;
    }

    private double computeCurrentFootPitchInSoleZUp() {
        this.footOrientation.setToZero(this.contactableFoot.getSoleFrame());
        MovingReferenceFrame soleZUpFrame = this.controllerToolbox.getReferenceFrames().getSoleZUpFrame((Enum)this.robotSide);
        this.footOrientation.changeFrame((ReferenceFrame)soleZUpFrame);
        return this.footOrientation.getPitch();
    }

    public void requestFootholdExploration() {
        this.requestFootholdExploration.set(true);
        if (this.partialFootholdControlModule != null) {
            this.partialFootholdControlModule.turnOnCropping();
        }
    }

    @Override
    public InverseDynamicsCommand<?> getInverseDynamicsCommand() {
        this.inverseDynamicsCommandsList.clear();
        this.inverseDynamicsCommandsList.addCommand(this.spatialAccelerationCommand);
        this.inverseDynamicsCommandsList.addCommand(this.explorationHelper.getCommand());
        return this.inverseDynamicsCommandsList;
    }

    @Override
    public SpatialFeedbackControlCommand getFeedbackControlCommand() {
        return this.spatialFeedbackControlCommand;
    }

    public void setWeights(Vector3DReadOnly angularWeight, Vector3DReadOnly linearWeight) {
        this.angularWeight = angularWeight;
        this.linearWeight = linearWeight;
    }
}

