/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.foot;

import us.ihmc.commonWalkingControlModules.controlModules.foot.ExplorationParameters;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector2D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class RotationVerificator {
    private final String name = this.getClass().getSimpleName();
    private final YoRegistry registry;
    private final ReferenceFrame soleFrame;
    private final YoFrameVector2D copError;
    private final YoDouble perpendicularCopError;
    private final YoDouble perpendicularCopErrorThreshold;
    private final YoBoolean perpendicularCopErrorAboveThreshold;
    private final YoDouble angleBetweenCopErrorAndLine;
    private final YoDouble angleThreshold;
    private final YoBoolean angleOkay;
    private final YoBoolean desiredCopOnCorrectSide;

    public RotationVerificator(String namePrefix, ReferenceFrame soleFrame, ExplorationParameters explorationParameters, YoRegistry parentRegistry) {
        this.soleFrame = soleFrame;
        this.registry = new YoRegistry(namePrefix + this.name);
        parentRegistry.addChild(this.registry);
        this.copError = new YoFrameVector2D(namePrefix + "CopError", "", soleFrame, this.registry);
        this.perpendicularCopError = new YoDouble(namePrefix + "PerpendicularCopError", this.registry);
        this.perpendicularCopErrorThreshold = explorationParameters.getPerpendicluarCopErrorThreshold();
        this.perpendicularCopErrorAboveThreshold = new YoBoolean(namePrefix + "PerpendicularCopErrorAboveThreshold", this.registry);
        this.angleBetweenCopErrorAndLine = new YoDouble(namePrefix + "AngleBetweenCopErrorAndLine", this.registry);
        this.angleThreshold = explorationParameters.getCopAllowedAreaOpeningAngle();
        this.angleOkay = new YoBoolean(namePrefix + "AngleOkay", this.registry);
        this.desiredCopOnCorrectSide = new YoBoolean(namePrefix + "DesiredCopOnCorrectSide", this.registry);
    }

    public boolean isRotating(FramePoint2DReadOnly measuredCoP, FramePoint2DReadOnly desiredCop, FrameLine2DReadOnly lineOfRotation) {
        lineOfRotation.checkReferenceFrameMatch(this.soleFrame);
        if (!lineOfRotation.isPointOnLine(measuredCoP)) {
            return false;
        }
        this.copError.sub((FrameTuple2DReadOnly)desiredCop, (FrameTuple2DReadOnly)measuredCoP);
        this.perpendicularCopError.set(lineOfRotation.distance(desiredCop));
        boolean errorAboveThreshold = this.perpendicularCopError.getDoubleValue() >= this.perpendicularCopErrorThreshold.getDoubleValue();
        this.perpendicularCopErrorAboveThreshold.set(errorAboveThreshold);
        double acos = this.perpendicularCopError.getDoubleValue() / this.copError.length();
        this.angleBetweenCopErrorAndLine.set(Math.acos(Math.abs(acos)));
        boolean angleInBounds = this.angleBetweenCopErrorAndLine.getDoubleValue() <= this.angleThreshold.getDoubleValue();
        this.angleOkay.set(angleInBounds);
        boolean correctSide = lineOfRotation.isPointOnRightSideOfLine(desiredCop);
        this.desiredCopOnCorrectSide.set(correctSide);
        return errorAboveThreshold && angleInBounds && correctSide;
    }
}

