/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.foot;

import java.awt.Color;
import java.util.EnumMap;
import java.util.List;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.YoContactPoint;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.YoPlaneContactState;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.controlModules.foot.ExplorationParameters;
import us.ihmc.commonWalkingControlModules.controlModules.foot.FootCoPOccupancyGrid;
import us.ihmc.commonWalkingControlModules.controlModules.foot.FootRotationCalculator;
import us.ihmc.commonWalkingControlModules.controlModules.foot.GeometricFootRotationCalculator;
import us.ihmc.commonWalkingControlModules.controlModules.foot.RotationVerificator;
import us.ihmc.commonWalkingControlModules.controlModules.foot.VelocityFootRotationCalculator;
import us.ihmc.commonWalkingControlModules.momentumBasedController.HighLevelHumanoidControllerToolbox;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FrameLine2D;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameConvexPolygon2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex2DSupplier;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.graphicsDescription.yoGraphics.plotting.YoArtifactPolygon;
import us.ihmc.humanoidRobotics.bipedSupportPolygons.ContactableFoot;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.geometry.ConvexPolygonTools;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameConvexPolygon2D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoInteger;

public class PartialFootholdControlModule {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final String name = this.getClass().getSimpleName();
    private final YoRegistry registry;
    private final YoEnum<PartialFootholdState> footholdState;
    private final EnumMap<RotationCalculatorType, FootRotationCalculator> rotationCalculators = new EnumMap(RotationCalculatorType.class);
    private final EnumMap<RotationCalculatorType, FrameLine2D> lineOfRotations = new EnumMap(RotationCalculatorType.class);
    private final YoEnum<RotationCalculatorType> rotationCalculatorType;
    private final RotationVerificator rotationVerificator;
    private final FootCoPOccupancyGrid footCoPOccupancyGrid;
    private final ReferenceFrame soleFrame;
    private final FrameConvexPolygon2D defaultFootPolygon;
    private final FrameConvexPolygon2D shrunkFootPolygon;
    private final FrameConvexPolygon2D shrunkFootPolygonInWorld;
    private final YoFrameConvexPolygon2D yoShrunkFootPolygon;
    private final FrameConvexPolygon2D controllerFootPolygon;
    private final FrameConvexPolygon2D controllerFootPolygonInWorld;
    private final FrameConvexPolygon2D backupFootPolygon;
    private final FrameConvexPolygon2D unsafePolygon;
    private final YoFrameConvexPolygon2D yoUnsafePolygon;
    private final FrameConvexPolygon2D fullSupportAfterShrinking = new FrameConvexPolygon2D();
    private final YoFrameConvexPolygon2D yoFullSupportAfterShrinking;
    private final YoInteger shrinkMaxLimit;
    private final YoInteger shrinkCounter;
    private final YoInteger numberOfCellsOccupiedOnSideOfLine;
    private final YoInteger thresholdForCoPRegionOccupancy;
    private final YoDouble distanceFromLineOfRotationToComputeCoPOccupancy;
    private final YoBoolean doPartialFootholdDetection;
    private final FrameLine2D lineOfRotation;
    private final YoBoolean useCoPOccupancyGrid;
    private final YoBoolean cropToConvexHullOfCoPs;
    private final YoBoolean fitLineToCoPs;
    private final int footCornerPoints;
    private final HighLevelHumanoidControllerToolbox controllerToolbox;
    private final FramePoint2D capturePoint = new FramePoint2D();
    private RobotSide robotSide;
    private final YoDouble unsafeArea;
    private final YoDouble minAreaToConsider;
    private final YoBoolean unsafeAreaAboveThreshold;
    private final YoBoolean expectingLineContact;
    private final FramePoint2D dummyDesiredCop = new FramePoint2D();
    private final ConvexPolygonTools convexPolygonTools = new ConvexPolygonTools();
    private final FramePoint3D tempPosition = new FramePoint3D();
    private final FrameLine2D line = new FrameLine2D();
    private final FrameLine2D lineL = new FrameLine2D();
    private final FrameLine2D lineR = new FrameLine2D();
    private static final double width = 0.01;

    public PartialFootholdControlModule(RobotSide robotSide, HighLevelHumanoidControllerToolbox controllerToolbox, WalkingControllerParameters walkingControllerParameters, ExplorationParameters explorationParameters, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        ContactableFoot contactableFoot = (ContactableFoot)controllerToolbox.getContactableFeet().get((Enum)robotSide);
        String namePrefix = contactableFoot.getRigidBody().getName();
        this.controllerToolbox = controllerToolbox;
        this.robotSide = robotSide;
        this.footCornerPoints = contactableFoot.getTotalNumberOfContactPoints();
        this.soleFrame = contactableFoot.getSoleFrame();
        this.defaultFootPolygon = new FrameConvexPolygon2D(FrameVertex2DSupplier.asFrameVertex2DSupplier((List)contactableFoot.getContactPoints2d()));
        this.shrunkFootPolygon = new FrameConvexPolygon2D((FrameVertex2DSupplier)this.defaultFootPolygon);
        this.shrunkFootPolygonInWorld = new FrameConvexPolygon2D((FrameVertex2DSupplier)this.defaultFootPolygon);
        this.controllerFootPolygon = new FrameConvexPolygon2D((FrameVertex2DSupplier)this.defaultFootPolygon);
        this.controllerFootPolygonInWorld = new FrameConvexPolygon2D((FrameVertex2DSupplier)this.defaultFootPolygon);
        this.backupFootPolygon = new FrameConvexPolygon2D((FrameVertex2DSupplier)this.defaultFootPolygon);
        this.unsafePolygon = new FrameConvexPolygon2D((FrameVertex2DSupplier)this.defaultFootPolygon);
        this.lineOfRotation = new FrameLine2D(this.soleFrame);
        this.registry = new YoRegistry(namePrefix + this.name);
        parentRegistry.addChild(this.registry);
        this.footholdState = new YoEnum(namePrefix + "PartialFootHoldState", this.registry, PartialFootholdState.class, true);
        this.yoUnsafePolygon = new YoFrameConvexPolygon2D(namePrefix + "UnsafeFootPolygon", "", worldFrame, 10, this.registry);
        this.yoShrunkFootPolygon = new YoFrameConvexPolygon2D(namePrefix + "ShrunkFootPolygon", "", worldFrame, 20, this.registry);
        this.yoFullSupportAfterShrinking = new YoFrameConvexPolygon2D(namePrefix + "FullSupportAfterShrinking", "", worldFrame, 20, this.registry);
        this.shrinkCounter = new YoInteger(namePrefix + "ShrinkCounter", this.registry);
        this.numberOfCellsOccupiedOnSideOfLine = new YoInteger(namePrefix + "NumberOfCellsOccupiedOnSideOfLine", this.registry);
        if (yoGraphicsListRegistry != null) {
            String listName = this.getClass().getSimpleName();
            YoArtifactPolygon yoGraphicPolygon = new YoArtifactPolygon(namePrefix + "UnsafeRegion", this.yoUnsafePolygon, Color.RED, false);
            yoGraphicPolygon.setVisible(false);
            yoGraphicsListRegistry.registerArtifact(listName, (Artifact)yoGraphicPolygon);
            YoArtifactPolygon yoShrunkPolygon = new YoArtifactPolygon(namePrefix + "ShrunkPolygon", this.yoShrunkFootPolygon, Color.CYAN, false);
            yoShrunkPolygon.setVisible(false);
            yoGraphicsListRegistry.registerArtifact(listName, (Artifact)yoShrunkPolygon);
        }
        this.footCoPOccupancyGrid = new FootCoPOccupancyGrid(namePrefix, this.soleFrame, 40, 20, walkingControllerParameters, explorationParameters, yoGraphicsListRegistry, this.registry);
        this.shrinkMaxLimit = explorationParameters.getShrinkMaxLimit();
        this.thresholdForCoPRegionOccupancy = explorationParameters.getThresholdForCoPRegionOccupancy();
        this.distanceFromLineOfRotationToComputeCoPOccupancy = explorationParameters.getDistanceFromLineOfRotationToComputeCoPOccupancy();
        this.useCoPOccupancyGrid = explorationParameters.getUseCopOccupancyGrid();
        this.rotationCalculatorType = explorationParameters.getRotationCalculatorType();
        this.minAreaToConsider = explorationParameters.getMinAreaToConsider();
        this.doPartialFootholdDetection = new YoBoolean(namePrefix + "DoPartialFootholdDetection", this.registry);
        this.doPartialFootholdDetection.set(false);
        this.cropToConvexHullOfCoPs = new YoBoolean(namePrefix + "CropToConvexHullOfCoPs", this.registry);
        this.cropToConvexHullOfCoPs.set(false);
        this.fitLineToCoPs = new YoBoolean(namePrefix + "FitLineToCoPs", this.registry);
        this.fitLineToCoPs.set(false);
        this.expectingLineContact = new YoBoolean(namePrefix + "ExpectingLineContact", this.registry);
        this.expectingLineContact.set(false);
        double dt = controllerToolbox.getControlDT();
        VelocityFootRotationCalculator velocityFootRotationCalculator = new VelocityFootRotationCalculator(namePrefix, dt, (ContactablePlaneBody)contactableFoot, explorationParameters, yoGraphicsListRegistry, this.registry);
        GeometricFootRotationCalculator geometricFootRotationCalculator = new GeometricFootRotationCalculator(namePrefix, (ContactablePlaneBody)contactableFoot, explorationParameters, yoGraphicsListRegistry, this.registry);
        this.rotationCalculators.put(RotationCalculatorType.VELOCITY, velocityFootRotationCalculator);
        this.rotationCalculators.put(RotationCalculatorType.GEOMETRY, geometricFootRotationCalculator);
        this.lineOfRotations.put(RotationCalculatorType.VELOCITY, new FrameLine2D(this.soleFrame));
        this.lineOfRotations.put(RotationCalculatorType.GEOMETRY, new FrameLine2D(this.soleFrame));
        this.rotationVerificator = new RotationVerificator(namePrefix, contactableFoot.getSoleFrame(), explorationParameters, this.registry);
        this.unsafeArea = new YoDouble(namePrefix + "UnsafeArea", this.registry);
        this.unsafeAreaAboveThreshold = new YoBoolean(namePrefix + "UnsafeAreaAboveThreshold", this.registry);
    }

    public void compute(FramePoint2D desiredCenterOfPressure, FramePoint2D centerOfPressure) {
        boolean triggerCutting;
        this.footCoPOccupancyGrid.update();
        if (desiredCenterOfPressure.containsNaN() || centerOfPressure.containsNaN()) {
            this.doNothing();
            return;
        }
        this.unsafePolygon.setIncludingFrame((FrameVertex2DSupplier)this.shrunkFootPolygon);
        this.footCoPOccupancyGrid.registerCenterOfPressureLocation((FramePoint2DReadOnly)centerOfPressure);
        boolean atLeastOneTriggered = false;
        for (RotationCalculatorType calculatorType : RotationCalculatorType.values) {
            if (!this.rotationCalculators.containsKey((Object)calculatorType)) continue;
            this.rotationCalculators.get((Object)calculatorType).compute((FramePoint2DReadOnly)desiredCenterOfPressure, (FramePoint2DReadOnly)centerOfPressure);
            this.rotationCalculators.get((Object)calculatorType).getLineOfRotation((FrameLine2DBasics)this.lineOfRotations.get((Object)calculatorType));
            if (!this.rotationCalculators.get((Object)calculatorType).isFootRotating()) continue;
            boolean verified = this.rotationVerificator.isRotating((FramePoint2DReadOnly)centerOfPressure, (FramePoint2DReadOnly)desiredCenterOfPressure, (FrameLine2DReadOnly)this.lineOfRotations.get((Object)calculatorType));
            boolean bl = atLeastOneTriggered = atLeastOneTriggered || verified;
            if (!verified) continue;
            this.lineOfRotation.setIncludingFrame((FrameLine2DReadOnly)this.lineOfRotations.get((Object)calculatorType));
        }
        if (this.rotationCalculatorType.getEnumValue() == RotationCalculatorType.BOTH) {
            triggerCutting = atLeastOneTriggered;
        } else {
            FootRotationCalculator activeCalculator = this.rotationCalculators.get(this.rotationCalculatorType.getEnumValue());
            activeCalculator.getLineOfRotation((FrameLine2DBasics)this.lineOfRotation);
            boolean verified = this.rotationVerificator.isRotating((FramePoint2DReadOnly)centerOfPressure, (FramePoint2DReadOnly)desiredCenterOfPressure, (FrameLine2DReadOnly)this.lineOfRotation);
            boolean bl = triggerCutting = activeCalculator.isFootRotating() && verified;
        }
        if (triggerCutting) {
            this.footholdState.set((Enum)PartialFootholdState.PARTIAL);
            this.computeShrunkFoothold(desiredCenterOfPressure);
            if (this.expectingLineContact.getBooleanValue()) {
                this.lineOfRotation.shiftToLeft(0.01);
                this.lineOfRotation.getDirection().negate();
                this.dummyDesiredCop.setToNaN(this.unsafePolygon.getReferenceFrame());
                this.computeShrunkFoothold(this.dummyDesiredCop);
            }
        } else {
            this.doNothing();
        }
    }

    public void getShrunkPolygonCentroid(FramePoint2D centroidToPack) {
        centroidToPack.setIncludingFrame((FrameTuple2DReadOnly)this.shrunkFootPolygon.getCentroid());
    }

    private void doNothing() {
        this.footholdState.set((Enum)PartialFootholdState.FULL);
        this.yoUnsafePolygon.clear();
        this.shrunkFootPolygonInWorld.setIncludingFrame((FrameVertex2DSupplier)this.shrunkFootPolygon);
        this.shrunkFootPolygonInWorld.changeFrameAndProjectToXYPlane(worldFrame);
        this.yoShrunkFootPolygon.set((FrameVertex2DSupplier)this.shrunkFootPolygonInWorld);
        this.unsafeArea.set(0.0);
    }

    private void computeShrunkFoothold(FramePoint2D desiredCenterOfPressure) {
        boolean desiredCopInPolygon;
        boolean wasCoPInThatRegion = false;
        if (this.useCoPOccupancyGrid.getBooleanValue()) {
            this.numberOfCellsOccupiedOnSideOfLine.set(this.footCoPOccupancyGrid.computeNumberOfCellsOccupiedOnSideOfLine((FrameLine2DReadOnly)this.lineOfRotation, RobotSide.RIGHT, this.distanceFromLineOfRotationToComputeCoPOccupancy.getDoubleValue()));
            wasCoPInThatRegion = this.numberOfCellsOccupiedOnSideOfLine.getIntegerValue() >= this.thresholdForCoPRegionOccupancy.getIntegerValue();
        }
        this.unsafeArea.set(this.unsafePolygon.getArea());
        boolean areaBigEnough = this.unsafeArea.getDoubleValue() >= this.minAreaToConsider.getDoubleValue();
        this.unsafeAreaAboveThreshold.set(areaBigEnough);
        boolean bl = desiredCopInPolygon = desiredCenterOfPressure.containsNaN() || this.unsafePolygon.isPointInside((FramePoint2DReadOnly)desiredCenterOfPressure, 0.0);
        if (desiredCopInPolygon && !wasCoPInThatRegion && areaBigEnough) {
            this.backupFootPolygon.set(this.shrunkFootPolygon);
            this.convexPolygonTools.cutPolygonWithLine((FrameLine2DReadOnly)this.lineOfRotation, (FixedFrameConvexPolygon2DBasics)this.shrunkFootPolygon, RobotSide.RIGHT);
            this.unsafePolygon.changeFrameAndProjectToXYPlane(worldFrame);
            this.yoUnsafePolygon.set((FrameVertex2DSupplier)this.unsafePolygon);
            this.shrunkFootPolygonInWorld.setIncludingFrame((FrameVertex2DSupplier)this.shrunkFootPolygon);
            this.shrunkFootPolygonInWorld.changeFrameAndProjectToXYPlane(worldFrame);
            this.yoShrunkFootPolygon.set((FrameVertex2DSupplier)this.shrunkFootPolygonInWorld);
        } else {
            this.doNothing();
        }
    }

    public boolean applyShrunkPolygon(YoPlaneContactState contactStateToModify) {
        int i;
        if (this.cropToConvexHullOfCoPs.getBooleanValue()) {
            this.footCoPOccupancyGrid.computeConvexHull(this.shrunkFootPolygon);
            this.cropToConvexHullOfCoPs.set(false);
        } else if (this.fitLineToCoPs.getBooleanValue()) {
            this.fitLine();
            this.fitLineToCoPs.set(false);
        } else {
            if (!this.doPartialFootholdDetection.getBooleanValue()) {
                this.shrunkFootPolygon.set(this.backupFootPolygon);
                return false;
            }
            if (this.footholdState.getEnumValue() == PartialFootholdState.FULL) {
                this.shrunkFootPolygon.set(this.backupFootPolygon);
                return false;
            }
            if (this.shrinkCounter.getIntegerValue() >= this.shrinkMaxLimit.getIntegerValue()) {
                this.shrunkFootPolygon.set(this.backupFootPolygon);
                return false;
            }
        }
        this.controllerFootPolygon.setIncludingFrame((FrameVertex2DSupplier)this.shrunkFootPolygon);
        ConvexPolygonTools.limitVerticesConservative((FixedFrameConvexPolygon2DBasics)this.controllerFootPolygon, (int)this.footCornerPoints);
        this.controllerFootPolygonInWorld.setIncludingFrame((FrameVertex2DSupplier)this.controllerFootPolygon);
        this.controllerFootPolygonInWorld.changeFrameAndProjectToXYPlane(worldFrame);
        FrameConvexPolygon2DReadOnly oppositeFootPolygon = this.controllerToolbox.getBipedSupportPolygons().getFootPolygonInWorldFrame(this.robotSide.getOppositeSide());
        this.fullSupportAfterShrinking.setIncludingFrame((FrameVertex2DSupplier)oppositeFootPolygon);
        this.fullSupportAfterShrinking.changeFrameAndProjectToXYPlane(worldFrame);
        this.fullSupportAfterShrinking.addVertices((FrameVertex2DSupplier)this.controllerFootPolygonInWorld);
        this.fullSupportAfterShrinking.update();
        this.controllerToolbox.getCapturePoint((FixedFramePoint2DBasics)this.capturePoint);
        this.yoFullSupportAfterShrinking.set((FrameVertex2DSupplier)this.fullSupportAfterShrinking);
        List<YoContactPoint> contactPoints = contactStateToModify.getContactPoints();
        for (i = 0; i < this.controllerFootPolygon.getNumberOfVertices(); ++i) {
            this.tempPosition.setIncludingFrame((FrameTuple2DReadOnly)this.controllerFootPolygon.getVertex(i), 0.0);
            YoContactPoint contactPoint = contactPoints.get(i);
            contactPoint.setMatchingFrame((FrameTuple3DReadOnly)this.tempPosition);
            contactPoint.setInContact(true);
        }
        for (i = this.controllerFootPolygon.getNumberOfVertices(); i < contactPoints.size(); ++i) {
            contactPoints.get(i).setInContact(false);
        }
        this.backupFootPolygon.set(this.shrunkFootPolygon);
        this.shrinkCounter.increment();
        return true;
    }

    private void fitLine() {
        if (!this.footCoPOccupancyGrid.fitLineToData(this.line)) {
            return;
        }
        this.lineL.setIncludingFrame((FrameLine2DReadOnly)this.line);
        this.lineL.shiftToLeft(0.005);
        this.lineR.setIncludingFrame((FrameLine2DReadOnly)this.line);
        this.lineR.shiftToRight(0.005);
        this.backupFootPolygon.set(this.shrunkFootPolygon);
        this.shrunkFootPolygon.clear();
        this.shrunkFootPolygon.addVertices(FrameVertex2DSupplier.asFrameVertex2DSupplier((FramePoint2DReadOnly[])this.defaultFootPolygon.intersectionWith((FrameLine2DReadOnly)this.lineL)));
        this.shrunkFootPolygon.addVertices(FrameVertex2DSupplier.asFrameVertex2DSupplier((FramePoint2DReadOnly[])this.defaultFootPolygon.intersectionWith((FrameLine2DReadOnly)this.lineR)));
        this.shrunkFootPolygon.update();
    }

    public void requestLineFit() {
        this.fitLineToCoPs.set(true);
    }

    public void reset() {
        this.shrinkCounter.set(0);
        this.footholdState.set(null);
        this.yoUnsafePolygon.clear();
        this.yoShrunkFootPolygon.clear();
        this.yoFullSupportAfterShrinking.clear();
        for (RotationCalculatorType calculatorType : RotationCalculatorType.values) {
            if (!this.rotationCalculators.containsKey((Object)calculatorType)) continue;
            this.rotationCalculators.get((Object)calculatorType).reset();
        }
        this.footCoPOccupancyGrid.reset();
        this.shrunkFootPolygon.setIncludingFrame((FrameVertex2DSupplier)this.defaultFootPolygon);
        this.backupFootPolygon.setIncludingFrame((FrameVertex2DSupplier)this.defaultFootPolygon);
    }

    public void projectOntoShrunkenPolygon(FramePoint2D pointToProject) {
        this.shrunkFootPolygon.orthogonalProjection((FramePoint2DBasics)pointToProject);
    }

    public void getSupportPolygon(FrameConvexPolygon2D polygonToPack) {
        polygonToPack.setIncludingFrame((FrameVertex2DSupplier)this.shrunkFootPolygon);
    }

    public void clearCoPGrid() {
        this.footCoPOccupancyGrid.reset();
    }

    public void turnOffCropping() {
        this.doPartialFootholdDetection.set(false);
    }

    public void turnOnCropping() {
        this.doPartialFootholdDetection.set(true);
    }

    public void informExplorationDone() {
        if (this.expectingLineContact.getBooleanValue()) {
            this.requestLineFit();
            this.turnOffCropping();
        }
    }

    public static enum RotationCalculatorType {
        VELOCITY,
        GEOMETRY,
        BOTH;

        public static RotationCalculatorType[] values;

        static {
            values = RotationCalculatorType.values();
        }
    }

    public static enum PartialFootholdState {
        FULL,
        PARTIAL;

    }
}

