/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.foot;

import us.ihmc.commonWalkingControlModules.configurations.SwingTrajectoryParameters;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.controlModules.foot.FootControlModule;
import us.ihmc.commonWalkingControlModules.heightPlanning.YoCoMHeightTimeDerivativesData;
import us.ihmc.commonWalkingControlModules.momentumBasedController.HighLevelHumanoidControllerToolbox;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector2DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicReferenceFrame;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicVector;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.TwistBasics;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.math.filters.AlphaFilteredYoVariable;
import us.ihmc.robotics.partNames.LegJointName;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.parameters.BooleanParameter;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class LegSingularityAndKneeCollapseAvoidanceControlModule {
    private boolean visualize = true;
    private boolean moreVisualizers = true;
    private static final boolean USE_KNEE_MECHANICAL_LIMIT_AVOIDANCE_SWING = false;
    private static final boolean USE_HIP_MECHANICAL_LIMIT_AVOIDANCE_SWING = false;
    private static final boolean USE_UNREACHABLE_FOOTSTEP_CORRECTION = true;
    private static final boolean USE_UNREACHABLE_FOOTSTEP_CORRECTION_ON_POSITION = true;
    private static final boolean USE_COLLAPSE_AVOIDANCE = false;
    private final BooleanParameter useSingularityAvoidanceInSwing;
    private final BooleanParameter useSingularityAvoidanceInSupport;
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final ReferenceFrame endEffectorFrame;
    private final ReferenceFrame virtualLegTangentialFrameHipCentered;
    private final ReferenceFrame virtualLegTangentialFrameAnkleCentered;
    private final YoRegistry registry;
    private final YoBoolean checkVelocityForSwingSingularityAvoidance;
    private final YoDouble alphaSwingSingularityAvoidance;
    private final YoDouble alphaSwingKneeMechanicalLimitAvoidance;
    private final YoDouble alphaSwingHipMechanicalLimitAvoidance;
    private final YoDouble alphaSupportSingularityAvoidance;
    private final YoDouble alphaCollapseAvoidance;
    private final YoDouble alphaUnreachableFootstep;
    private final YoDouble maximumLegLength;
    private final DoubleParameter minimumLegLength;
    private final YoDouble percentOfLegLengthThresholdToEnableSwingKneeLimitAvoidance;
    private final YoDouble hipFlexionAngleThresholdToEnableSwingHipLimitAvoidance;
    private final YoDouble hipFlexionMechanicalLimit;
    private final YoDouble percentOfLegLengthThresholdToEnableSingularityAvoidance;
    private final YoDouble percentOfLegLengthThresholdToDisableSingularityAvoidance;
    private final YoDouble percentOfLegLengthThresholdForCollapseAvoidance;
    private final YoDouble maxPercentOfLegLengthForSingularityAvoidanceInSwing;
    private final YoDouble maxPercentOfLegLengthForSingularityAvoidanceInSupport;
    private final YoDouble minPercentOfLegLengthForCollapseAvoidance;
    private final YoDouble minMechanicalPercentOfLegLength;
    private final YoDouble footLoadThresholdToEnableCollapseAvoidance;
    private final YoDouble footLoadThresholdToDisableCollapseAvoidance;
    private final YoDouble timeDelayToDisableCollapseAvoidance;
    private final YoDouble timeSwitchCollapseAvoidance;
    private final YoDouble timeRemainingToDisableCollapseAvoidance;
    private final YoDouble yoTime;
    private final YoDouble timeSwitchSingularityAvoidance;
    private final YoDouble desiredPercentOfLegLength;
    private final YoDouble currentPercentOfLegLength;
    private final YoDouble correctedDesiredPercentOfLegLength;
    private final YoDouble desiredLegLength;
    private final YoDouble currentLegLength;
    private final YoDouble correctedDesiredLegLength;
    private final RigidBodyBasics pelvis;
    private final FrameVector3D unachievedSwingTranslationTemp = new FrameVector3D();
    private final FrameVector3D unachievedSwingVelocityTemp = new FrameVector3D();
    private final FrameVector3D unachievedSwingAccelerationTemp = new FrameVector3D();
    private final YoFrameVector3D unachievedSwingTranslation;
    private final YoFrameVector3D unachievedSwingVelocity;
    private final YoFrameVector3D unachievedSwingAcceleration;
    private final FramePoint3D desiredCenterOfMassHeightPoint = new FramePoint3D(worldFrame);
    private final FramePoint3D anklePosition = new FramePoint3D(worldFrame);
    private final FrameVector3D equivalentDesiredHipPitchHeightTranslation = new FrameVector3D();
    private final FrameVector3D equivalentDesiredHipVelocity = new FrameVector3D();
    private final FrameVector3D equivalentDesiredHipPitchAcceleration = new FrameVector3D();
    private final ReferenceFrame frameBeforeHipPitchJoint;
    private final Twist pelvisTwist = new Twist();
    private final FrameVector3D pelvisLinearVelocity = new FrameVector3D();
    private final FramePoint3D desiredFootPosition = new FramePoint3D();
    private final FrameVector3D desiredFootLinearVelocity = new FrameVector3D();
    private final FrameVector3D desiredFootLinearAcceleration = new FrameVector3D();
    private final YoFramePoint3D yoCurrentFootPosition;
    private final YoFramePoint3D yoDesiredFootPosition;
    private final YoFramePoint3D yoCorrectedDesiredFootPosition;
    private final YoFrameVector3D yoDesiredFootLinearVelocity;
    private final YoFrameVector3D yoCorrectedDesiredFootLinearVelocity;
    private final YoGraphicReferenceFrame virtualLegTangentialFrameHipCenteredGraphics;
    private final YoGraphicReferenceFrame virtualLegTangentialFrameAnkleCenteredGraphics;
    private final YoGraphicPosition yoDesiredFootPositionGraphic;
    private final YoGraphicPosition yoCorrectedDesiredFootPositionGraphic;
    private final YoGraphicVector yoDesiredFootLinearVelocityGraphic;
    private final YoGraphicVector yoCorrectedDesiredFootLinearVelocityGraphic;
    private final YoBoolean isSwingMechanicalLimitAvoidanceUsed;
    private final YoBoolean isSwingSingularityAvoidanceUsed;
    private final YoBoolean isSupportSingularityAvoidanceUsed;
    private final YoBoolean isSupportCollapseAvoidanceUsed;
    private final YoBoolean isUnreachableFootstepCompensated;
    private final YoBoolean doSmoothTransitionOutOfCollapseAvoidance;
    private final YoBoolean doSmoothTransitionOutOfSingularityAvoidance;
    private final YoDouble correctionAlphaFilter;
    private final AlphaFilteredYoVariable heightCorrectedFilteredForCollapseAvoidance;
    private final AlphaFilteredYoVariable heightVelocityCorrectedFilteredForCollapseAvoidance;
    private final AlphaFilteredYoVariable heightAcceleretionCorrectedFilteredForCollapseAvoidance;
    private final AlphaFilteredYoVariable heightCorrectedFilteredForSingularityAvoidance;
    private final AlphaFilteredYoVariable heightVelocityCorrectedFilteredForSingularityAvoidance;
    private final AlphaFilteredYoVariable heightAcceleretionCorrectedFilteredForSingularityAvoidance;
    private final YoDouble yoUnachievedSwingTranslation;
    private final YoDouble timeToCorrectForUnachievedSwingTranslation;
    private final AlphaFilteredYoVariable unachievedSwingTranslationFiltered;
    private final AlphaFilteredYoVariable unachievedSwingVelocityFiltered;
    private final AlphaFilteredYoVariable unachievedSwingAccelerationFiltered;
    private final double controlDT;
    private final OneDoFJointBasics hipPitchJoint;
    private final FrameVector2D comVelocity = new FrameVector2D();

    public LegSingularityAndKneeCollapseAvoidanceControlModule(String namePrefix, ContactablePlaneBody contactablePlaneBody, RobotSide robotSide, WalkingControllerParameters walkingControllerParameters, HighLevelHumanoidControllerToolbox controllerToolbox, YoRegistry parentRegistry) {
        this.registry = new YoRegistry(namePrefix + this.getClass().getSimpleName());
        parentRegistry.addChild(this.registry);
        this.unachievedSwingTranslation = new YoFrameVector3D("unachievedSwingTranslation", ReferenceFrame.getWorldFrame(), this.registry);
        this.unachievedSwingVelocity = new YoFrameVector3D("unachievedSwingVelocity", ReferenceFrame.getWorldFrame(), this.registry);
        this.unachievedSwingAcceleration = new YoFrameVector3D("unachievedSwingAcceleration", ReferenceFrame.getWorldFrame(), this.registry);
        this.maximumLegLength = new YoDouble(namePrefix + "MaxLegLength", this.registry);
        this.maximumLegLength.set(walkingControllerParameters.getMaximumLegLengthForSingularityAvoidance());
        this.minimumLegLength = new DoubleParameter(namePrefix + "MinLegLength", this.registry, walkingControllerParameters.getSwingTrajectoryParameters().getMinMechanicalLegLength());
        this.controlDT = controllerToolbox.getControlDT();
        this.yoTime = controllerToolbox.getYoTime();
        FullHumanoidRobotModel fullRobotModel = controllerToolbox.getFullRobotModel();
        this.pelvis = fullRobotModel.getPelvis();
        this.hipPitchJoint = fullRobotModel.getLegJoint((Enum)robotSide, LegJointName.HIP_PITCH);
        this.frameBeforeHipPitchJoint = this.hipPitchJoint.getFrameBeforeJoint();
        this.endEffectorFrame = contactablePlaneBody.getFrameAfterParentJoint();
        this.checkVelocityForSwingSingularityAvoidance = new YoBoolean(namePrefix + "CheckVelocityForSwingSingularityAvoidance", this.registry);
        this.alphaSwingSingularityAvoidance = new YoDouble(namePrefix + "AlphaSwingSingularityAvoidance", this.registry);
        this.alphaSwingKneeMechanicalLimitAvoidance = new YoDouble(namePrefix + "AlphaSwingKneeMechanicalLimitAvoidance", this.registry);
        this.alphaSwingHipMechanicalLimitAvoidance = new YoDouble(namePrefix + "AlphaSwingHipMechanicalLimitAvoidance", this.registry);
        this.alphaSupportSingularityAvoidance = new YoDouble(namePrefix + "AlphaSupportSingularityAvoidance", this.registry);
        this.alphaCollapseAvoidance = new YoDouble(namePrefix + "AlphaCollapseAvoidance", this.registry);
        this.alphaUnreachableFootstep = new YoDouble(namePrefix + "AlphaUnreachableFootstep", this.registry);
        this.alphaUnreachableFootstep.set(0.25);
        this.yoUnachievedSwingTranslation = new YoDouble(namePrefix + "UnachievedSwingTranslation", this.registry);
        this.timeToCorrectForUnachievedSwingTranslation = new YoDouble(namePrefix + "TimeToCorrectForUnachievedSwingTranslation", this.registry);
        this.timeToCorrectForUnachievedSwingTranslation.set(0.2);
        this.unachievedSwingTranslationFiltered = new AlphaFilteredYoVariable(namePrefix + "UnachievedSwingTranslationFiltered", this.registry, (DoubleProvider)this.alphaUnreachableFootstep);
        this.unachievedSwingVelocityFiltered = new AlphaFilteredYoVariable(namePrefix + "UnachievedSwingVelocityFiltered", this.registry, (DoubleProvider)this.alphaUnreachableFootstep);
        this.unachievedSwingAccelerationFiltered = new AlphaFilteredYoVariable(namePrefix + "UnachievedSwingAccelerationFiltered", this.registry, (DoubleProvider)this.alphaUnreachableFootstep);
        this.percentOfLegLengthThresholdToEnableSwingKneeLimitAvoidance = new YoDouble(namePrefix + "PercThresSwingKneeLimitAvoidance", this.registry);
        this.hipFlexionAngleThresholdToEnableSwingHipLimitAvoidance = new YoDouble(namePrefix + "ThresholdToEnableSwingHipLimitAvoidance", this.registry);
        this.hipFlexionMechanicalLimit = new YoDouble(namePrefix + "HipFlexionMechanicalLimit", this.registry);
        this.percentOfLegLengthThresholdToEnableSingularityAvoidance = new YoDouble(namePrefix + "PercThresSingularityAvoidance", this.registry);
        this.percentOfLegLengthThresholdToDisableSingularityAvoidance = new YoDouble(namePrefix + "PercThresToDisableSingularityAvoidance", this.registry);
        this.maxPercentOfLegLengthForSingularityAvoidanceInSwing = new YoDouble(namePrefix + "MaxPercOfLegLengthForSingularityAvoidanceInSwing", this.registry);
        this.maxPercentOfLegLengthForSingularityAvoidanceInSupport = new YoDouble(namePrefix + "MaxPercOfLegLengthForSingularityAvoidanceInSupport", this.registry);
        this.percentOfLegLengthThresholdForCollapseAvoidance = new YoDouble(namePrefix + "PercThresCollapseAvoidance", this.registry);
        this.minPercentOfLegLengthForCollapseAvoidance = new YoDouble(namePrefix + "MinPercOfLegLengthForCollapseAvoidance", this.registry);
        this.minMechanicalPercentOfLegLength = new YoDouble(namePrefix + "MinMechanicalPercOfLegLength", this.registry);
        this.footLoadThresholdToEnableCollapseAvoidance = new YoDouble(namePrefix + "LoadThresholdToEnableCollapseAvoidance", this.registry);
        this.footLoadThresholdToDisableCollapseAvoidance = new YoDouble(namePrefix + "LoadThresholdToDisableCollapseAvoidance", this.registry);
        this.timeDelayToDisableCollapseAvoidance = new YoDouble(namePrefix + "TimeDelayToDisableCollapseAvoidance", this.registry);
        this.timeSwitchCollapseAvoidance = new YoDouble(namePrefix + "TimeSwitchCollapseAvoidance", this.registry);
        this.timeRemainingToDisableCollapseAvoidance = new YoDouble(namePrefix + "TimeRemainingToDisableCollapseAvoidance", this.registry);
        this.timeSwitchSingularityAvoidance = new YoDouble(namePrefix + "TimeSwitchSingularityAvoidance", this.registry);
        this.percentOfLegLengthThresholdToEnableSingularityAvoidance.set(0.87);
        this.percentOfLegLengthThresholdToDisableSingularityAvoidance.set(0.85);
        this.maxPercentOfLegLengthForSingularityAvoidanceInSwing.set(0.97);
        this.maxPercentOfLegLengthForSingularityAvoidanceInSupport.set(0.98);
        this.percentOfLegLengthThresholdForCollapseAvoidance.set(0.83);
        this.minPercentOfLegLengthForCollapseAvoidance.set(0.76);
        this.footLoadThresholdToEnableCollapseAvoidance.set(0.62);
        this.footLoadThresholdToDisableCollapseAvoidance.set(0.59);
        this.timeDelayToDisableCollapseAvoidance.set(0.5);
        this.timeRemainingToDisableCollapseAvoidance.set(this.timeDelayToDisableCollapseAvoidance.getDoubleValue());
        this.timeSwitchCollapseAvoidance.set(this.yoTime.getDoubleValue());
        SwingTrajectoryParameters swingTrajectoryParameters = walkingControllerParameters.getSwingTrajectoryParameters();
        this.useSingularityAvoidanceInSwing = new BooleanParameter(namePrefix + "UseSingularityAvoidanceInSwing", this.registry, swingTrajectoryParameters.useSingularityAvoidanceInSwing());
        this.useSingularityAvoidanceInSupport = new BooleanParameter(namePrefix + "UseSingularityAvoidanceInSupport", this.registry, swingTrajectoryParameters.useSingularityAvoidanceInSupport());
        double deltaAwayFromLimit = Math.toRadians(20.0);
        if (this.hipPitchJoint.getJointAxis().getY() > 0.0) {
            this.hipFlexionMechanicalLimit.set(this.hipPitchJoint.getJointLimitLower());
            this.hipFlexionAngleThresholdToEnableSwingHipLimitAvoidance.set(this.hipPitchJoint.getJointLimitLower() + deltaAwayFromLimit);
        } else {
            this.hipFlexionMechanicalLimit.set(this.hipPitchJoint.getJointLimitUpper());
            this.hipFlexionAngleThresholdToEnableSwingHipLimitAvoidance.set(this.hipPitchJoint.getJointLimitUpper() - deltaAwayFromLimit);
        }
        this.correctionAlphaFilter = new YoDouble(namePrefix + "CorrectionAlphaFilter", this.registry);
        this.heightCorrectedFilteredForCollapseAvoidance = new AlphaFilteredYoVariable(namePrefix + "HeightCorrectedFilteredForCollapseAvoidance", this.registry, (DoubleProvider)this.correctionAlphaFilter);
        this.heightVelocityCorrectedFilteredForCollapseAvoidance = new AlphaFilteredYoVariable(namePrefix + "HeightVelocityCorrectedFilteredForCollapseAvoidance", this.registry, (DoubleProvider)this.correctionAlphaFilter);
        this.heightAcceleretionCorrectedFilteredForCollapseAvoidance = new AlphaFilteredYoVariable(namePrefix + "HeightAcceleretionCorrectedFilteredForCollapseAvoidance", this.registry, (DoubleProvider)this.correctionAlphaFilter);
        this.heightCorrectedFilteredForSingularityAvoidance = new AlphaFilteredYoVariable(namePrefix + "HeightCorrectedFilteredForSingularityAvoidance", this.registry, (DoubleProvider)this.correctionAlphaFilter);
        this.heightVelocityCorrectedFilteredForSingularityAvoidance = new AlphaFilteredYoVariable(namePrefix + "HeightVelocityCorrectedFilteredForSingularityAvoidance", this.registry, (DoubleProvider)this.correctionAlphaFilter);
        this.heightAcceleretionCorrectedFilteredForSingularityAvoidance = new AlphaFilteredYoVariable(namePrefix + "HeightAcceleretionCorrectedFilteredForSingularityAvoidance", this.registry, (DoubleProvider)this.correctionAlphaFilter);
        this.correctionAlphaFilter.set(0.98);
        this.desiredPercentOfLegLength = new YoDouble(namePrefix + "DesiredPercentOfLegLength", this.registry);
        this.correctedDesiredPercentOfLegLength = new YoDouble(namePrefix + "CorrectedDesiredPercentOfLegLength", this.registry);
        this.currentPercentOfLegLength = new YoDouble(namePrefix + "CurrentPercentOfLegLength", this.registry);
        this.desiredLegLength = new YoDouble(namePrefix + "DesiredLegLength", this.registry);
        this.correctedDesiredLegLength = new YoDouble(namePrefix + "CorrectedDesiredLegLength", this.registry);
        this.currentLegLength = new YoDouble(namePrefix + "CurrentLegLength", this.registry);
        this.isSwingMechanicalLimitAvoidanceUsed = new YoBoolean(namePrefix + "IsSwingMechanicalLimitAvoidanceUsed", this.registry);
        this.isSwingSingularityAvoidanceUsed = new YoBoolean(namePrefix + "IsSwingSingularityAvoidanceUsed", this.registry);
        this.isSupportSingularityAvoidanceUsed = new YoBoolean(namePrefix + "IsSupportSingularityAvoidanceUsed", this.registry);
        this.isSupportCollapseAvoidanceUsed = new YoBoolean(namePrefix + "IsSupportCollapseAvoidanceUsed", this.registry);
        this.isUnreachableFootstepCompensated = new YoBoolean(namePrefix + "IsUnreachableFootstepCompensated", this.registry);
        this.doSmoothTransitionOutOfCollapseAvoidance = new YoBoolean(namePrefix + "DoSmoothTransitionCollapseAvoidance", this.registry);
        this.doSmoothTransitionOutOfSingularityAvoidance = new YoBoolean(namePrefix + "DoSmoothTransitionSingularityAvoidance", this.registry);
        MovingReferenceFrame pelvisFrame = this.pelvis.getParentJoint().getFrameAfterJoint();
        this.virtualLegTangentialFrameHipCentered = new ReferenceFrame(namePrefix + "VirtualLegTangentialFrameHipCentered", (ReferenceFrame)pelvisFrame){
            private final AxisAngle hipPitchRotationToParentFrame;
            private final FramePoint3D tempPoint;
            private final FrameVector3D footToHipAxis;
            private final FramePoint3D hipPitchPosition;
            {
                this.hipPitchRotationToParentFrame = new AxisAngle();
                this.tempPoint = new FramePoint3D();
                this.footToHipAxis = new FrameVector3D();
                this.hipPitchPosition = new FramePoint3D();
            }

            protected void updateTransformToParent(RigidBodyTransform transformToParent) {
                this.tempPoint.setToZero(LegSingularityAndKneeCollapseAvoidanceControlModule.this.frameBeforeHipPitchJoint);
                this.tempPoint.changeFrame(LegSingularityAndKneeCollapseAvoidanceControlModule.this.endEffectorFrame);
                this.footToHipAxis.setIncludingFrame((FrameTuple3DReadOnly)this.tempPoint);
                this.footToHipAxis.changeFrame(this.getParent());
                EuclidGeometryTools.orientation3DFromZUpToVector3D((Vector3DReadOnly)this.footToHipAxis, (Orientation3DBasics)this.hipPitchRotationToParentFrame);
                this.hipPitchPosition.setToZero(LegSingularityAndKneeCollapseAvoidanceControlModule.this.frameBeforeHipPitchJoint);
                this.hipPitchPosition.changeFrame(this.getParent());
                transformToParent.setRotationAndZeroTranslation((Orientation3DReadOnly)this.hipPitchRotationToParentFrame);
                transformToParent.getTranslation().set((Tuple3DReadOnly)this.hipPitchPosition);
            }
        };
        this.virtualLegTangentialFrameAnkleCentered = new ReferenceFrame(namePrefix + "VirtualLegTangentialFrameAnkleCentered", (ReferenceFrame)pelvisFrame){
            private final AxisAngle anklePitchRotationToParentFrame;
            private final FramePoint3D tempPoint;
            private final FrameVector3D footToHipAxis;
            private final FramePoint3D anklePitchPosition;
            {
                this.anklePitchRotationToParentFrame = new AxisAngle();
                this.tempPoint = new FramePoint3D();
                this.footToHipAxis = new FrameVector3D();
                this.anklePitchPosition = new FramePoint3D();
            }

            protected void updateTransformToParent(RigidBodyTransform transformToParent) {
                this.tempPoint.setToZero(LegSingularityAndKneeCollapseAvoidanceControlModule.this.frameBeforeHipPitchJoint);
                this.tempPoint.changeFrame(LegSingularityAndKneeCollapseAvoidanceControlModule.this.endEffectorFrame);
                this.footToHipAxis.setIncludingFrame((FrameTuple3DReadOnly)this.tempPoint);
                this.footToHipAxis.changeFrame(this.getParent());
                EuclidGeometryTools.orientation3DFromZUpToVector3D((Vector3DReadOnly)this.footToHipAxis, (Orientation3DBasics)this.anklePitchRotationToParentFrame);
                this.anklePitchPosition.setToZero(LegSingularityAndKneeCollapseAvoidanceControlModule.this.endEffectorFrame);
                this.anklePitchPosition.changeFrame(this.getParent());
                transformToParent.setRotationAndZeroTranslation((Orientation3DReadOnly)this.anklePitchRotationToParentFrame);
                transformToParent.getTranslation().set((Tuple3DReadOnly)this.anklePitchPosition);
            }
        };
        YoGraphicsListRegistry yoGraphicsListRegistry = controllerToolbox.getYoGraphicsListRegistry();
        this.visualize = this.visualize && yoGraphicsListRegistry != null;
        this.moreVisualizers = this.visualize && this.moreVisualizers;
        this.yoCurrentFootPosition = new YoFramePoint3D(namePrefix + "CurrentFootPosition", worldFrame, this.registry);
        this.yoDesiredFootPosition = new YoFramePoint3D(namePrefix + "DesiredFootPosition", worldFrame, this.registry);
        this.yoCorrectedDesiredFootPosition = new YoFramePoint3D(namePrefix + "CorrectedDesiredFootPosition", worldFrame, this.registry);
        this.yoDesiredFootLinearVelocity = new YoFrameVector3D(namePrefix + "DesiredFootLinearVelocity", worldFrame, this.registry);
        this.yoCorrectedDesiredFootLinearVelocity = new YoFrameVector3D(namePrefix + "CorrectedDesiredFootLinearVelocity", worldFrame, this.registry);
        this.yoDesiredFootPosition.setToNaN();
        this.yoCorrectedDesiredFootPosition.setToNaN();
        this.yoDesiredFootLinearVelocity.setToNaN();
        this.yoCorrectedDesiredFootLinearVelocity.setToNaN();
        if (this.visualize) {
            this.yoDesiredFootPositionGraphic = new YoGraphicPosition(namePrefix + "DesiredFootPosition", this.yoDesiredFootPosition, 0.025, YoAppearance.Red(), YoGraphicPosition.GraphicType.BALL);
            yoGraphicsListRegistry.registerYoGraphic("SingularityCollapseAvoidance", (YoGraphic)this.yoDesiredFootPositionGraphic);
            this.yoCorrectedDesiredFootPositionGraphic = new YoGraphicPosition(namePrefix + "CorrectedDesiredFootPosition", this.yoCorrectedDesiredFootPosition, 0.025, YoAppearance.Green(), YoGraphicPosition.GraphicType.BALL);
            yoGraphicsListRegistry.registerYoGraphic("SingularityCollapseAvoidance", (YoGraphic)this.yoCorrectedDesiredFootPositionGraphic);
        } else {
            this.yoDesiredFootPositionGraphic = null;
            this.yoCorrectedDesiredFootPositionGraphic = null;
        }
        if (this.moreVisualizers) {
            this.virtualLegTangentialFrameHipCenteredGraphics = new YoGraphicReferenceFrame(this.virtualLegTangentialFrameHipCentered, this.registry, false, 0.1);
            this.virtualLegTangentialFrameAnkleCenteredGraphics = new YoGraphicReferenceFrame(this.virtualLegTangentialFrameAnkleCentered, this.registry, false, 0.1);
            yoGraphicsListRegistry.registerYoGraphic("SingularityCollapseAvoidance", (YoGraphic)this.virtualLegTangentialFrameHipCenteredGraphics);
            yoGraphicsListRegistry.registerYoGraphic("SingularityCollapseAvoidance", (YoGraphic)this.virtualLegTangentialFrameAnkleCenteredGraphics);
            this.yoDesiredFootLinearVelocityGraphic = new YoGraphicVector(namePrefix + "DesiredFootLinearVelocity", this.yoCurrentFootPosition, this.yoDesiredFootLinearVelocity, 0.2, YoAppearance.Red());
            yoGraphicsListRegistry.registerYoGraphic("SingularityCollapseAvoidance", (YoGraphic)this.yoDesiredFootLinearVelocityGraphic);
            this.yoCorrectedDesiredFootLinearVelocityGraphic = new YoGraphicVector(namePrefix + "CorrectedDesiredFootLinearVelocity", this.yoCurrentFootPosition, this.yoCorrectedDesiredFootLinearVelocity, 0.2, YoAppearance.Green());
            yoGraphicsListRegistry.registerYoGraphic("SingularityCollapseAvoidance", (YoGraphic)this.yoCorrectedDesiredFootLinearVelocityGraphic);
        } else {
            this.virtualLegTangentialFrameHipCenteredGraphics = null;
            this.virtualLegTangentialFrameAnkleCenteredGraphics = null;
            this.yoDesiredFootLinearVelocityGraphic = null;
            this.yoCorrectedDesiredFootLinearVelocityGraphic = null;
        }
    }

    public void update() {
        this.virtualLegTangentialFrameHipCentered.update();
        this.virtualLegTangentialFrameAnkleCentered.update();
        this.anklePosition.setToZero(this.endEffectorFrame);
        this.yoCurrentFootPosition.setMatchingFrame((FrameTuple3DReadOnly)this.anklePosition);
        this.anklePosition.changeFrame(this.virtualLegTangentialFrameHipCentered);
        this.currentLegLength.set(-this.anklePosition.getZ());
    }

    public void resetHeightCorrectionParameters() {
        this.doSmoothTransitionOutOfCollapseAvoidance.set(false);
        this.doSmoothTransitionOutOfSingularityAvoidance.set(false);
        this.isSupportCollapseAvoidanceUsed.set(false);
        this.isSupportSingularityAvoidanceUsed.set(false);
    }

    public void resetSwingParameters() {
        this.yoDesiredFootPosition.setToNaN();
        this.yoCorrectedDesiredFootPosition.setToNaN();
        this.yoDesiredFootLinearVelocity.setToNaN();
        this.yoCorrectedDesiredFootLinearVelocity.setToNaN();
        if (this.visualize) {
            this.yoDesiredFootPositionGraphic.hideGraphicObject();
            this.yoCorrectedDesiredFootPositionGraphic.hideGraphicObject();
            if (this.moreVisualizers) {
                this.virtualLegTangentialFrameHipCenteredGraphics.update();
                this.virtualLegTangentialFrameAnkleCenteredGraphics.update();
                this.yoDesiredFootLinearVelocityGraphic.hideGraphicObject();
                this.yoCorrectedDesiredFootLinearVelocityGraphic.hideGraphicObject();
            }
        }
        this.alphaSwingSingularityAvoidance.set(0.0);
        this.unachievedSwingTranslation.setToZero();
        this.unachievedSwingVelocity.setToZero();
        this.unachievedSwingAcceleration.setToZero();
    }

    public void setCheckVelocityForSwingSingularityAvoidance(boolean value) {
        this.checkVelocityForSwingSingularityAvoidance.set(value);
    }

    public void correctSwingFootTrajectory(FramePoint3D desiredFootPositionToCorrect, FrameVector3D desiredFootLinearVelocityToCorrect, FrameVector3D desiredFootLinearAccelerationToCorrect) {
        this.isSwingSingularityAvoidanceUsed.set(false);
        this.alphaSwingSingularityAvoidance.set(0.0);
        this.isSwingMechanicalLimitAvoidanceUsed.set(false);
        this.alphaSwingKneeMechanicalLimitAvoidance.set(0.0);
        this.yoDesiredFootPosition.set((FrameTuple3DReadOnly)desiredFootPositionToCorrect);
        this.yoDesiredFootLinearVelocity.set((FrameTuple3DReadOnly)desiredFootLinearVelocityToCorrect);
        this.anklePosition.setToZero(this.endEffectorFrame);
        this.anklePosition.changeFrame(worldFrame);
        this.yoCurrentFootPosition.set((FrameTuple3DReadOnly)this.anklePosition);
        this.anklePosition.changeFrame(this.virtualLegTangentialFrameHipCentered);
        this.currentLegLength.set(-this.anklePosition.getZ());
        this.currentPercentOfLegLength.set(this.currentLegLength.getDoubleValue() / this.maximumLegLength.getDoubleValue());
        this.desiredFootPosition.setIncludingFrame((FrameTuple3DReadOnly)desiredFootPositionToCorrect);
        this.desiredFootLinearAcceleration.setIncludingFrame((FrameTuple3DReadOnly)desiredFootLinearAccelerationToCorrect);
        this.desiredFootLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)desiredFootLinearVelocityToCorrect);
        this.desiredFootPosition.changeFrame(this.virtualLegTangentialFrameHipCentered);
        this.desiredFootLinearAcceleration.changeFrame(this.virtualLegTangentialFrameHipCentered);
        this.desiredFootLinearVelocity.changeFrame(this.virtualLegTangentialFrameHipCentered);
        this.desiredLegLength.set(-this.desiredFootPosition.getZ());
        this.desiredPercentOfLegLength.set(this.desiredLegLength.getDoubleValue() / this.maximumLegLength.getDoubleValue());
        this.correctedDesiredLegLength.set(this.desiredLegLength.getDoubleValue());
        this.correctedDesiredPercentOfLegLength.set(this.desiredPercentOfLegLength.getDoubleValue());
        if (this.useSingularityAvoidanceInSwing.getValue()) {
            this.correctSwingFootTrajectoryForSingularityAvoidance(desiredFootPositionToCorrect, desiredFootLinearVelocityToCorrect, desiredFootLinearAccelerationToCorrect);
        }
    }

    private void correctSwingFootTrajectoryForMechanicalLimitAvoidance(FramePoint3D desiredFootPositionToCorrect, FrameVector3D desiredFootLinearVelocityToCorrect, FrameVector3D desiredFootLinearAccelerationToCorrect) {
        this.minMechanicalPercentOfLegLength.set(this.minimumLegLength.getValue() / this.maximumLegLength.getDoubleValue());
        this.percentOfLegLengthThresholdToEnableSwingKneeLimitAvoidance.set(0.07 + this.minMechanicalPercentOfLegLength.getDoubleValue());
        if (this.desiredPercentOfLegLength.getDoubleValue() > this.percentOfLegLengthThresholdToEnableSwingKneeLimitAvoidance.getDoubleValue()) {
            return;
        }
        this.desiredFootLinearVelocity.changeFrame(this.virtualLegTangentialFrameAnkleCentered);
        this.pelvis.getBodyFixedFrame().getTwistOfFrame((TwistBasics)this.pelvisTwist);
        this.pelvisLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.pelvisTwist.getLinearPart());
        this.pelvisLinearVelocity.changeFrame(this.virtualLegTangentialFrameAnkleCentered);
        this.isSwingMechanicalLimitAvoidanceUsed.set(true);
        this.alphaSwingKneeMechanicalLimitAvoidance.set((this.desiredPercentOfLegLength.getDoubleValue() - this.percentOfLegLengthThresholdToEnableSwingKneeLimitAvoidance.getDoubleValue()) / (this.minMechanicalPercentOfLegLength.getDoubleValue() - this.percentOfLegLengthThresholdToEnableSwingKneeLimitAvoidance.getDoubleValue()));
        this.alphaSwingKneeMechanicalLimitAvoidance.set(MathTools.clamp((double)this.alphaSwingKneeMechanicalLimitAvoidance.getDoubleValue(), (double)0.0, (double)1.0));
        double correctedDesiredPositionZ = (1.0 - this.alphaSwingKneeMechanicalLimitAvoidance.getDoubleValue()) * this.desiredLegLength.getDoubleValue() + this.alphaSwingKneeMechanicalLimitAvoidance.getDoubleValue() * this.currentLegLength.getDoubleValue();
        correctedDesiredPositionZ = -Math.max(correctedDesiredPositionZ, this.minimumLegLength.getValue());
        this.desiredFootPosition.setZ(correctedDesiredPositionZ);
        this.correctedDesiredLegLength.set(Math.abs(correctedDesiredPositionZ));
        this.correctedDesiredPercentOfLegLength.set(this.correctedDesiredLegLength.getDoubleValue() / this.maximumLegLength.getDoubleValue());
        double desiredLinearVelocityX = this.desiredFootLinearVelocity.getX();
        double desiredLinearVelocityY = this.desiredFootLinearVelocity.getY();
        double desiredLinearVelocityZ = (1.0 - this.alphaSwingKneeMechanicalLimitAvoidance.getDoubleValue()) * this.desiredFootLinearVelocity.getZ() + this.alphaSwingKneeMechanicalLimitAvoidance.getDoubleValue() * this.pelvisLinearVelocity.getZ();
        this.desiredFootLinearVelocity.setIncludingFrame(this.virtualLegTangentialFrameAnkleCentered, desiredLinearVelocityX, desiredLinearVelocityY, desiredLinearVelocityZ);
        this.desiredFootLinearAcceleration.setZ((1.0 - this.alphaSwingKneeMechanicalLimitAvoidance.getDoubleValue()) * this.desiredFootLinearAcceleration.getZ());
        this.desiredFootPosition.changeFrame(desiredFootPositionToCorrect.getReferenceFrame());
        this.desiredFootLinearVelocity.changeFrame(desiredFootLinearVelocityToCorrect.getReferenceFrame());
        this.desiredFootLinearAcceleration.changeFrame(desiredFootLinearAccelerationToCorrect.getReferenceFrame());
        desiredFootPositionToCorrect.set(this.desiredFootPosition);
        desiredFootLinearVelocityToCorrect.set(this.desiredFootLinearVelocity);
        desiredFootLinearAccelerationToCorrect.set(this.desiredFootLinearAcceleration);
        this.yoCorrectedDesiredFootPosition.set((FrameTuple3DReadOnly)desiredFootPositionToCorrect);
        this.yoCorrectedDesiredFootLinearVelocity.set((FrameTuple3DReadOnly)desiredFootLinearVelocityToCorrect);
        if (this.visualize) {
            this.yoDesiredFootPositionGraphic.showGraphicObject();
            this.yoCorrectedDesiredFootPositionGraphic.showGraphicObject();
            if (this.moreVisualizers) {
                this.yoDesiredFootLinearVelocityGraphic.showGraphicObject();
                this.yoCorrectedDesiredFootLinearVelocityGraphic.showGraphicObject();
            }
        }
    }

    private void correctSwingFootTrajectoryForSingularityAvoidance(FramePoint3D desiredFootPositionToCorrect, FrameVector3D desiredFootLinearVelocityToCorrect, FrameVector3D desiredFootLinearAccelerationToCorrect) {
        double desiredOrMaxLegLength;
        if (this.desiredPercentOfLegLength.getDoubleValue() < this.percentOfLegLengthThresholdToEnableSingularityAvoidance.getDoubleValue()) {
            return;
        }
        this.desiredFootLinearVelocity.changeFrame(this.virtualLegTangentialFrameAnkleCentered);
        this.pelvis.getBodyFixedFrame().getTwistOfFrame((TwistBasics)this.pelvisTwist);
        this.pelvisLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.pelvisTwist.getLinearPart());
        this.pelvisLinearVelocity.changeFrame(this.virtualLegTangentialFrameAnkleCentered);
        if (this.checkVelocityForSwingSingularityAvoidance.getBooleanValue() && this.desiredFootLinearVelocity.getZ() - this.pelvisLinearVelocity.getZ() > -1.0E-10) {
            return;
        }
        this.checkVelocityForSwingSingularityAvoidance.set(false);
        this.isSwingSingularityAvoidanceUsed.set(true);
        this.alphaSwingSingularityAvoidance.set((this.desiredPercentOfLegLength.getDoubleValue() - this.percentOfLegLengthThresholdToEnableSingularityAvoidance.getDoubleValue()) / (this.maxPercentOfLegLengthForSingularityAvoidanceInSwing.getDoubleValue() - this.percentOfLegLengthThresholdToEnableSingularityAvoidance.getDoubleValue()));
        this.alphaSwingSingularityAvoidance.set(MathTools.clamp((double)this.alphaSwingSingularityAvoidance.getDoubleValue(), (double)0.0, (double)1.0));
        double correctedDesiredPositionZ = desiredOrMaxLegLength = -Math.min(this.desiredLegLength.getDoubleValue(), this.maxPercentOfLegLengthForSingularityAvoidanceInSwing.getDoubleValue() * this.maximumLegLength.getDoubleValue());
        this.unachievedSwingTranslationTemp.setIncludingFrame(this.desiredFootPosition.getReferenceFrame(), 0.0, 0.0, this.desiredFootPosition.getZ() - correctedDesiredPositionZ);
        this.unachievedSwingTranslationTemp.changeFrame(worldFrame);
        this.unachievedSwingTranslation.set((FrameTuple3DReadOnly)this.unachievedSwingTranslationTemp);
        this.yoUnachievedSwingTranslation.set(this.unachievedSwingTranslation.getZ());
        this.desiredFootPosition.setZ(correctedDesiredPositionZ);
        this.correctedDesiredLegLength.set(Math.abs(correctedDesiredPositionZ));
        this.correctedDesiredPercentOfLegLength.set(this.correctedDesiredLegLength.getDoubleValue() / this.maximumLegLength.getDoubleValue());
        double desiredLinearVelocityX = this.desiredFootLinearVelocity.getX();
        double desiredLinearVelocityY = this.desiredFootLinearVelocity.getY();
        double desiredLinearVelocityZ = (1.0 - this.alphaSwingSingularityAvoidance.getDoubleValue()) * this.desiredFootLinearVelocity.getZ() + this.alphaSwingSingularityAvoidance.getDoubleValue() * this.pelvisLinearVelocity.getZ();
        this.unachievedSwingVelocityTemp.setIncludingFrame(this.desiredFootLinearVelocity.getReferenceFrame(), 0.0, 0.0, this.desiredFootLinearVelocity.getZ() - desiredLinearVelocityZ);
        this.unachievedSwingVelocityTemp.changeFrame(worldFrame);
        this.unachievedSwingVelocity.set((FrameTuple3DReadOnly)this.unachievedSwingVelocityTemp);
        this.desiredFootLinearVelocity.setIncludingFrame(this.virtualLegTangentialFrameAnkleCentered, desiredLinearVelocityX, desiredLinearVelocityY, desiredLinearVelocityZ);
        this.unachievedSwingAccelerationTemp.setIncludingFrame(this.desiredFootLinearVelocity.getReferenceFrame(), 0.0, 0.0, this.alphaSwingSingularityAvoidance.getDoubleValue() * this.desiredFootLinearAcceleration.getZ());
        this.unachievedSwingAccelerationTemp.changeFrame(worldFrame);
        this.unachievedSwingAcceleration.set((FrameTuple3DReadOnly)this.unachievedSwingAccelerationTemp);
        this.desiredFootLinearAcceleration.setZ((1.0 - this.alphaSwingSingularityAvoidance.getDoubleValue()) * this.desiredFootLinearAcceleration.getZ());
        this.desiredFootPosition.changeFrame(desiredFootPositionToCorrect.getReferenceFrame());
        this.desiredFootLinearVelocity.changeFrame(desiredFootLinearVelocityToCorrect.getReferenceFrame());
        this.desiredFootLinearAcceleration.changeFrame(desiredFootLinearAccelerationToCorrect.getReferenceFrame());
        desiredFootPositionToCorrect.set(this.desiredFootPosition);
        desiredFootLinearVelocityToCorrect.set(this.desiredFootLinearVelocity);
        desiredFootLinearAccelerationToCorrect.set(this.desiredFootLinearAcceleration);
        this.yoCorrectedDesiredFootPosition.set((FrameTuple3DReadOnly)desiredFootPositionToCorrect);
        this.yoCorrectedDesiredFootLinearVelocity.set((FrameTuple3DReadOnly)desiredFootLinearVelocityToCorrect);
        if (this.visualize) {
            this.yoDesiredFootPositionGraphic.showGraphicObject();
            this.yoCorrectedDesiredFootPositionGraphic.showGraphicObject();
            if (this.moreVisualizers) {
                this.yoDesiredFootLinearVelocityGraphic.showGraphicObject();
                this.yoCorrectedDesiredFootLinearVelocityGraphic.showGraphicObject();
            }
        }
    }

    public void correctCoMHeightTrajectoryForSupportLeg(FrameVector2D comXYVelocity, YoCoMHeightTimeDerivativesData comHeightDataToCorrect, double zCurrent, ReferenceFrame pelvisZUpFrame, double footLoadPercentage, FootControlModule.ConstraintType constraintType) {
        this.correctCoMHeightTrajectoryForSingularityAvoidance((FrameVector2DReadOnly)comXYVelocity, comHeightDataToCorrect, zCurrent, pelvisZUpFrame, constraintType);
        if (!this.isSupportSingularityAvoidanceUsed.getBooleanValue()) {
            this.correctCoMHeightTrajectoryForCollapseAvoidance(comXYVelocity, comHeightDataToCorrect, zCurrent, pelvisZUpFrame, footLoadPercentage, constraintType);
        }
    }

    public void correctCoMHeightTrajectoryForSingularityAvoidance(FrameVector2DReadOnly comXYVelocity, YoCoMHeightTimeDerivativesData comHeightDataToCorrect, double zCurrent, ReferenceFrame pelvisZUpFrame, FootControlModule.ConstraintType constraintType) {
        if (!this.useSingularityAvoidanceInSupport.getValue()) {
            this.alphaSupportSingularityAvoidance.set(0.0);
            this.isSupportSingularityAvoidanceUsed.set(false);
            this.doSmoothTransitionOutOfSingularityAvoidance.set(false);
            return;
        }
        comHeightDataToCorrect.getComHeight((FramePoint3DBasics)this.desiredCenterOfMassHeightPoint);
        this.desiredCenterOfMassHeightPoint.changeFrame(worldFrame);
        this.equivalentDesiredHipPitchHeightTranslation.setIncludingFrame(worldFrame, 0.0, 0.0, this.desiredCenterOfMassHeightPoint.getZ() - zCurrent);
        this.equivalentDesiredHipPitchHeightTranslation.changeFrame(this.virtualLegTangentialFrameAnkleCentered);
        this.equivalentDesiredHipVelocity.setIncludingFrame(worldFrame, 0.0, 0.0, comHeightDataToCorrect.getComHeightVelocity());
        this.equivalentDesiredHipVelocity.changeFrame(pelvisZUpFrame);
        this.comVelocity.setIncludingFrame((FrameTuple2DReadOnly)comXYVelocity);
        this.comVelocity.changeFrame(pelvisZUpFrame);
        this.equivalentDesiredHipVelocity.setX(this.comVelocity.getX());
        this.equivalentDesiredHipVelocity.changeFrame(this.virtualLegTangentialFrameAnkleCentered);
        this.equivalentDesiredHipPitchAcceleration.setIncludingFrame(worldFrame, 0.0, 0.0, comHeightDataToCorrect.getComHeightAcceleration());
        this.equivalentDesiredHipPitchAcceleration.changeFrame(this.virtualLegTangentialFrameAnkleCentered);
        this.desiredLegLength.set(this.equivalentDesiredHipPitchHeightTranslation.getZ() + this.currentLegLength.getDoubleValue());
        this.desiredPercentOfLegLength.set(this.desiredLegLength.getDoubleValue() / this.maximumLegLength.getDoubleValue());
        this.correctedDesiredLegLength.set(this.desiredLegLength.getDoubleValue());
        this.correctedDesiredPercentOfLegLength.set(this.desiredPercentOfLegLength.getDoubleValue());
        if (constraintType != FootControlModule.ConstraintType.FULL) {
            this.alphaSupportSingularityAvoidance.set(0.0);
            this.doSmoothTransitionOutOfSingularityAvoidance.set(this.isSupportSingularityAvoidanceUsed.getBooleanValue());
            if (!this.isSupportSingularityAvoidanceUsed.getBooleanValue()) {
                return;
            }
        }
        if ((this.isSupportSingularityAvoidanceUsed.getBooleanValue() || this.doSmoothTransitionOutOfSingularityAvoidance.getBooleanValue()) && this.desiredPercentOfLegLength.getDoubleValue() < this.percentOfLegLengthThresholdToDisableSingularityAvoidance.getDoubleValue() && !this.doSmoothTransitionOutOfSingularityAvoidance.getBooleanValue()) {
            this.alphaSupportSingularityAvoidance.set(0.0);
            this.doSmoothTransitionOutOfSingularityAvoidance.set(true);
        }
        if (this.desiredPercentOfLegLength.getDoubleValue() < this.percentOfLegLengthThresholdToEnableSingularityAvoidance.getDoubleValue()) {
            if (!this.isSupportSingularityAvoidanceUsed.getBooleanValue() && !this.doSmoothTransitionOutOfSingularityAvoidance.getBooleanValue()) {
                return;
            }
        } else if (!this.isSupportSingularityAvoidanceUsed.getBooleanValue()) {
            this.isSupportSingularityAvoidanceUsed.set(true);
            this.doSmoothTransitionOutOfSingularityAvoidance.set(false);
            this.timeSwitchSingularityAvoidance.set(this.yoTime.getDoubleValue());
            this.heightCorrectedFilteredForSingularityAvoidance.reset();
            this.heightVelocityCorrectedFilteredForSingularityAvoidance.reset();
            this.heightAcceleretionCorrectedFilteredForSingularityAvoidance.reset();
            this.heightCorrectedFilteredForSingularityAvoidance.update(this.desiredCenterOfMassHeightPoint.getZ());
            this.heightVelocityCorrectedFilteredForSingularityAvoidance.update(comHeightDataToCorrect.getComHeightVelocity());
            this.heightAcceleretionCorrectedFilteredForSingularityAvoidance.update(comHeightDataToCorrect.getComHeightAcceleration());
        }
        if (this.doSmoothTransitionOutOfSingularityAvoidance.getBooleanValue()) {
            this.heightCorrectedFilteredForSingularityAvoidance.update(this.desiredCenterOfMassHeightPoint.getZ());
            this.heightVelocityCorrectedFilteredForSingularityAvoidance.set(comHeightDataToCorrect.getComHeightVelocity());
            this.heightAcceleretionCorrectedFilteredForSingularityAvoidance.set(comHeightDataToCorrect.getComHeightAcceleration());
            comHeightDataToCorrect.setComHeight(this.desiredCenterOfMassHeightPoint.getReferenceFrame(), this.heightCorrectedFilteredForSingularityAvoidance.getDoubleValue());
            comHeightDataToCorrect.setComHeightVelocity(this.heightVelocityCorrectedFilteredForSingularityAvoidance.getDoubleValue());
            comHeightDataToCorrect.setComHeightAcceleration(this.heightAcceleretionCorrectedFilteredForSingularityAvoidance.getDoubleValue());
            if (Math.abs(this.desiredCenterOfMassHeightPoint.getZ() - this.heightCorrectedFilteredForSingularityAvoidance.getDoubleValue()) <= 0.005) {
                this.alphaSupportSingularityAvoidance.set(0.0);
                this.isSupportSingularityAvoidanceUsed.set(false);
                this.doSmoothTransitionOutOfSingularityAvoidance.set(false);
            } else if (this.desiredCenterOfMassHeightPoint.getZ() <= this.heightCorrectedFilteredForSingularityAvoidance.getDoubleValue() && this.desiredPercentOfLegLength.getDoubleValue() < this.percentOfLegLengthThresholdToEnableSingularityAvoidance.getDoubleValue()) {
                this.heightCorrectedFilteredForSingularityAvoidance.update(this.desiredCenterOfMassHeightPoint.getZ());
                this.heightCorrectedFilteredForSingularityAvoidance.update(this.desiredCenterOfMassHeightPoint.getZ());
                if (this.desiredPercentOfLegLength.getDoubleValue() < this.percentOfLegLengthThresholdToDisableSingularityAvoidance.getDoubleValue() - 0.05) {
                    this.alphaSupportSingularityAvoidance.set(0.0);
                    this.isSupportSingularityAvoidanceUsed.set(false);
                    this.doSmoothTransitionOutOfSingularityAvoidance.set(false);
                }
            }
            return;
        }
        this.anklePosition.setToZero(this.endEffectorFrame);
        this.anklePosition.changeFrame(worldFrame);
        this.yoCurrentFootPosition.set((FrameTuple3DReadOnly)this.anklePosition);
        this.anklePosition.changeFrame(this.virtualLegTangentialFrameHipCentered);
        this.currentLegLength.set(-this.anklePosition.getZ());
        this.currentPercentOfLegLength.set(this.currentLegLength.getDoubleValue() / this.maximumLegLength.getDoubleValue());
        this.alphaSupportSingularityAvoidance.set((this.desiredPercentOfLegLength.getDoubleValue() - this.percentOfLegLengthThresholdToEnableSingularityAvoidance.getDoubleValue()) / (this.maxPercentOfLegLengthForSingularityAvoidanceInSupport.getDoubleValue() - this.percentOfLegLengthThresholdToEnableSingularityAvoidance.getDoubleValue()));
        this.alphaSupportSingularityAvoidance.set(MathTools.clamp((double)this.alphaSupportSingularityAvoidance.getDoubleValue(), (double)0.0, (double)1.0));
        double desiredOrMaxLegLength = Math.min(this.desiredLegLength.getDoubleValue(), this.maxPercentOfLegLengthForSingularityAvoidanceInSupport.getDoubleValue() * this.maximumLegLength.getDoubleValue());
        double correctedDesiredTranslationZ = desiredOrMaxLegLength - this.currentLegLength.getDoubleValue();
        this.equivalentDesiredHipPitchHeightTranslation.setZ(correctedDesiredTranslationZ);
        this.equivalentDesiredHipPitchHeightTranslation.changeFrame(worldFrame);
        this.correctedDesiredLegLength.set(correctedDesiredTranslationZ + this.currentLegLength.getDoubleValue());
        this.correctedDesiredPercentOfLegLength.set(this.correctedDesiredLegLength.getDoubleValue() / this.maximumLegLength.getDoubleValue());
        this.desiredCenterOfMassHeightPoint.setZ(zCurrent + this.equivalentDesiredHipPitchHeightTranslation.getZ());
        this.heightCorrectedFilteredForSingularityAvoidance.update(this.desiredCenterOfMassHeightPoint.getZ());
        comHeightDataToCorrect.setComHeight(this.desiredCenterOfMassHeightPoint.getReferenceFrame(), this.heightCorrectedFilteredForSingularityAvoidance.getDoubleValue());
        this.equivalentDesiredHipVelocity.setZ((1.0 - this.alphaSupportSingularityAvoidance.getDoubleValue()) * this.equivalentDesiredHipVelocity.getZ());
        this.equivalentDesiredHipVelocity.changeFrame(pelvisZUpFrame);
        if (Math.abs(this.comVelocity.getX()) > 0.001 && Math.abs(this.equivalentDesiredHipVelocity.getX()) > 0.001) {
            this.equivalentDesiredHipVelocity.scale(this.comVelocity.getX() / this.equivalentDesiredHipVelocity.getX());
        }
        this.equivalentDesiredHipVelocity.changeFrame(worldFrame);
        this.heightVelocityCorrectedFilteredForSingularityAvoidance.update(this.equivalentDesiredHipVelocity.getZ());
        comHeightDataToCorrect.setComHeightVelocity(this.heightVelocityCorrectedFilteredForSingularityAvoidance.getDoubleValue());
        this.equivalentDesiredHipPitchAcceleration.setZ((1.0 - this.alphaSupportSingularityAvoidance.getDoubleValue()) * this.equivalentDesiredHipPitchAcceleration.getZ());
        this.equivalentDesiredHipPitchAcceleration.changeFrame(worldFrame);
        this.heightAcceleretionCorrectedFilteredForSingularityAvoidance.update(this.equivalentDesiredHipPitchAcceleration.getZ());
        comHeightDataToCorrect.setComHeightAcceleration(this.heightAcceleretionCorrectedFilteredForSingularityAvoidance.getDoubleValue());
    }

    public void correctCoMHeightTrajectoryForCollapseAvoidance(FrameVector2D comXYVelocity, YoCoMHeightTimeDerivativesData comHeightDataToCorrect, double zCurrent, ReferenceFrame pelvisZUpFrame, double footLoadPercentage, FootControlModule.ConstraintType constraintType) {
        this.alphaCollapseAvoidance.set(0.0);
        this.isSupportCollapseAvoidanceUsed.set(false);
        this.doSmoothTransitionOutOfCollapseAvoidance.set(false);
    }

    public void correctCoMHeightTrajectoryForUnreachableFootStep(YoCoMHeightTimeDerivativesData comHeightDataToCorrect, FootControlModule.ConstraintType constraintType) {
        this.isUnreachableFootstepCompensated.set(false);
        if (constraintType != FootControlModule.ConstraintType.SWING && constraintType != FootControlModule.ConstraintType.MOVE_VIA_WAYPOINTS) {
            return;
        }
        comHeightDataToCorrect.getComHeight((FramePoint3DBasics)this.desiredCenterOfMassHeightPoint);
        this.desiredCenterOfMassHeightPoint.changeFrame(worldFrame);
        if (!(this.unachievedSwingTranslation.getZ() < 0.0)) {
            this.unachievedSwingTranslationFiltered.set(0.0);
            this.unachievedSwingVelocityFiltered.set(0.0);
            this.unachievedSwingAccelerationFiltered.set(0.0);
            return;
        }
        this.isUnreachableFootstepCompensated.set(true);
        this.unachievedSwingTranslationFiltered.update(this.unachievedSwingTranslation.getZ());
        this.desiredCenterOfMassHeightPoint.setZ(this.desiredCenterOfMassHeightPoint.getZ() + this.unachievedSwingTranslationFiltered.getDoubleValue());
        comHeightDataToCorrect.setComHeight(worldFrame, this.desiredCenterOfMassHeightPoint.getZ());
        this.unachievedSwingVelocityFiltered.update(this.unachievedSwingTranslationFiltered.getDoubleValue() / this.timeToCorrectForUnachievedSwingTranslation.getDoubleValue());
        this.unachievedSwingAccelerationFiltered.update(this.unachievedSwingVelocityFiltered.getDoubleValue() / this.timeToCorrectForUnachievedSwingTranslation.getDoubleValue());
        comHeightDataToCorrect.setComHeightVelocity(comHeightDataToCorrect.getComHeightVelocity() + this.unachievedSwingVelocityFiltered.getDoubleValue());
        comHeightDataToCorrect.setComHeightAcceleration(comHeightDataToCorrect.getComHeightAcceleration() + this.unachievedSwingAccelerationFiltered.getDoubleValue());
    }
}

