/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.foot;

import us.ihmc.commonWalkingControlModules.configurations.ToeOffParameters;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.robotics.math.filters.GlitchFilteredYoBoolean;
import us.ihmc.yoVariables.parameters.BooleanParameter;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class LegJointLimitsInspector {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private static final int largeGlitchWindowSize = 10;
    private static final double jointLimitThreshold = 0.02;
    private final DoubleProvider ankleLowerLimitToTriggerToeOff;
    private final DoubleProvider kneeUpperLimitToTriggerToeOff;
    private final DoubleProvider kneeLowerLimitToTriggerToeOff;
    private final YoDouble ankleMaxLowerLimitForToeOff = new YoDouble("ankleMaxLowerLimitToTriggerToeOff", this.registry);
    private final YoDouble kneeMinUpperLimitToTriggerToeOff = new YoDouble("kneeMinUpperLimitToTriggerToeOff", this.registry);
    private final YoDouble kneeMaxLowerLimitToTriggerToeOff = new YoDouble("kneeMaxLowerLimitToTriggerToeOff", this.registry);
    private final YoBoolean isRearAnklePitchHittingLimit = new YoBoolean("isRearAnklePitchHittingLimit", this.registry);
    private final YoBoolean isLeadingKneePitchHittingUpperLimit = new YoBoolean("isLeadingKneePitchHittingUpperLimit", this.registry);
    private final YoBoolean isRearKneePitchHittingLowerLimit = new YoBoolean("isRearKneePitchHittingLowerLimit", this.registry);
    private final GlitchFilteredYoBoolean isRearAnklePitchHittingLimitFilt = new GlitchFilteredYoBoolean("isRearAnklePitchHittingLimitFilt", this.registry, this.isRearAnklePitchHittingLimit, 10);
    private final GlitchFilteredYoBoolean isLeadingKneePitchHittingUpperLimitFilt = new GlitchFilteredYoBoolean("isLeadingKneePitchHittingUpperLimitFilt", this.registry, this.isLeadingKneePitchHittingUpperLimit, 10);
    private final GlitchFilteredYoBoolean isRearKneePitchHittingLowerLimitFilt = new GlitchFilteredYoBoolean("isRearKneePitchHittingLowerLimitFilt", this.registry, this.isRearKneePitchHittingLowerLimit, 10);
    private final BooleanProvider doToeOffWhenHittingAnkleLimit;
    private final BooleanProvider doToeOffWhenHittingLeadingKneeUpperLimit;
    private final BooleanProvider doToeOffWhenHittingRearKneeLowerLimit;
    private final YoBoolean needToSwitchToToeOffForJointLimit = new YoBoolean("needToSwitchToToeOffForJointLimit", this.registry);
    private final YoBoolean needToSwitchToToeOffForAnkleLimit = new YoBoolean("needToSwitchToToeOffForAnkleLimit", this.registry);
    private final YoBoolean needToSwitchToToeOffForLeadingKneeAtLimit = new YoBoolean("needToSwitchToToeOffForLeadingKneeAtLimit", this.registry);
    private final YoBoolean needToSwitchToToeOffForTrailingKneeAtLimit = new YoBoolean("needToSwitchToToeOffForTrailingKneeAtLimit", this.registry);

    public LegJointLimitsInspector(ToeOffParameters toeOffParameters, YoRegistry parentRegistry) {
        this.ankleLowerLimitToTriggerToeOff = new DoubleParameter("ankleLowerLimitToTriggerToeOff", this.registry, toeOffParameters.getAnkleLowerLimitToTriggerToeOff());
        this.kneeUpperLimitToTriggerToeOff = new DoubleParameter("kneeUpperLimitToTriggerToeOff", this.registry, toeOffParameters.getKneeUpperLimitToTriggerToeOff());
        this.kneeLowerLimitToTriggerToeOff = new DoubleParameter("kneeLowerLimitToTriggerToeOff", this.registry, toeOffParameters.getKneeLowerLimitToTriggerToeOff());
        this.doToeOffWhenHittingAnkleLimit = new BooleanParameter("doToeOffWhenHittingAnkleLimit", this.registry, toeOffParameters.doToeOffWhenHittingAnkleLimit());
        this.doToeOffWhenHittingLeadingKneeUpperLimit = new BooleanParameter("doToeOffWhenHittingLeadingKneeUpperLimit", this.registry, toeOffParameters.doToeOffWhenHittingLeadingKneeUpperLimit());
        this.doToeOffWhenHittingRearKneeLowerLimit = new BooleanParameter("doToeOffWhenHittingRearKneeLowerLimit", this.registry, toeOffParameters.doToeOffWhenHittingTrailingKneeLowerLimit());
        this.needToSwitchToToeOffForJointLimit.set(false);
        parentRegistry.addChild(this.registry);
    }

    public void reset() {
        this.isRearAnklePitchHittingLimit.set(false);
        this.isRearAnklePitchHittingLimitFilt.set(false);
        this.isLeadingKneePitchHittingUpperLimit.set(false);
        this.isLeadingKneePitchHittingUpperLimitFilt.set(false);
        this.isRearKneePitchHittingLowerLimit.set(false);
        this.isRearKneePitchHittingLowerLimitFilt.set(false);
        this.needToSwitchToToeOffForJointLimit.set(false);
        this.needToSwitchToToeOffForTrailingKneeAtLimit.set(false);
        this.needToSwitchToToeOffForLeadingKneeAtLimit.set(false);
        this.needToSwitchToToeOffForAnkleLimit.set(false);
    }

    public void updateTrailingAnkleLowerLimitsStatus(OneDoFJointBasics anklePitch) {
        this.ankleMaxLowerLimitForToeOff.set(Math.max(anklePitch.getJointLimitLower() + 0.02, this.ankleLowerLimitToTriggerToeOff.getValue()));
        this.isRearAnklePitchHittingLimit.set(anklePitch.getQ() < this.ankleMaxLowerLimitForToeOff.getDoubleValue());
        this.isRearAnklePitchHittingLimitFilt.update();
        if (!this.doToeOffWhenHittingAnkleLimit.getValue()) {
            this.needToSwitchToToeOffForAnkleLimit.set(false);
        } else {
            this.needToSwitchToToeOffForAnkleLimit.set(this.isRearAnklePitchHittingLimitFilt.getBooleanValue());
        }
    }

    public void updateLeadingKneeUpperLimitsStatus(OneDoFJointBasics kneePitch) {
        this.kneeMinUpperLimitToTriggerToeOff.set(Math.min(kneePitch.getJointLimitUpper() - 0.02, this.kneeUpperLimitToTriggerToeOff.getValue()));
        this.isLeadingKneePitchHittingUpperLimit.set(kneePitch.getQ() > this.kneeMinUpperLimitToTriggerToeOff.getDoubleValue());
        this.isLeadingKneePitchHittingUpperLimitFilt.update();
        if (!this.doToeOffWhenHittingLeadingKneeUpperLimit.getValue()) {
            this.needToSwitchToToeOffForLeadingKneeAtLimit.set(false);
        } else {
            this.needToSwitchToToeOffForLeadingKneeAtLimit.set(this.isLeadingKneePitchHittingUpperLimitFilt.getBooleanValue());
        }
    }

    public void updateTrailingKneeLowerLimitsStatus(OneDoFJointBasics kneePitch) {
        this.kneeMaxLowerLimitToTriggerToeOff.set(Math.max(kneePitch.getJointLimitLower() + 0.02, this.kneeLowerLimitToTriggerToeOff.getValue()));
        this.isRearKneePitchHittingLowerLimit.set(kneePitch.getQ() < this.kneeMaxLowerLimitToTriggerToeOff.getDoubleValue());
        this.isRearKneePitchHittingLowerLimitFilt.update();
        if (!this.doToeOffWhenHittingRearKneeLowerLimit.getValue()) {
            this.needToSwitchToToeOffForTrailingKneeAtLimit.set(false);
        } else {
            this.needToSwitchToToeOffForTrailingKneeAtLimit.set(this.isRearKneePitchHittingLowerLimitFilt.getBooleanValue());
        }
    }

    public void updateSwitchToToeOffDueToJointLimits() {
        this.needToSwitchToToeOffForJointLimit.set(this.needToSwitchToToeOffForAnkleLimit.getBooleanValue() || this.needToSwitchToToeOffForLeadingKneeAtLimit.getBooleanValue() || this.needToSwitchToToeOffForTrailingKneeAtLimit.getBooleanValue());
    }

    public boolean needToSwitchToToeOffDueToJointLimit() {
        return this.needToSwitchToToeOffForJointLimit.getBooleanValue();
    }

    public boolean isRearAnklePitchHittingLowerLimitFilt() {
        return this.isRearAnklePitchHittingLimitFilt.getBooleanValue();
    }

    public boolean isKneePitchHittingUpperLimitFilt() {
        return this.isLeadingKneePitchHittingUpperLimitFilt.getBooleanValue();
    }

    public boolean isKneePitchHittingLowerLimitFilt() {
        return this.isRearKneePitchHittingLowerLimitFilt.getBooleanValue();
    }

    public double getAnkleMaxLowerLimitForToeOff() {
        return this.ankleMaxLowerLimitForToeOff.getDoubleValue();
    }

    public double getKneeMinUpperLimitToTriggerToeOff() {
        return this.kneeMinUpperLimitToTriggerToeOff.getDoubleValue();
    }

    public double getKneeMaxLowerLimitToTriggerToeOff() {
        return this.kneeMaxLowerLimitToTriggerToeOff.getDoubleValue();
    }
}

