/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.foot;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.interfaces.linsol.LinearSolverDense;
import us.ihmc.commonWalkingControlModules.momentumBasedController.HighLevelHumanoidControllerToolbox;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemFactories;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.kinematics.NumericalInverseKinematicsCalculator;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.screwTheory.GeometricJacobian;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoseUsingYawPitchRoll;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class LegJointLimitAvoidanceControlModule {
    private static final int maxIterationsForIK = 8;
    private static final boolean translationFixOnly = true;
    private boolean visualize = true;
    private boolean enableCorrection = false;
    private static final double lambdaLeastSquares = 1.0E-6;
    private static final double tolerance = 1.0E-8;
    private static final double maxStepSize = 0.1;
    private static final double minRandomSearchScalar = 1.0;
    private static final double maxRandomSearchScalar = 1.0;
    private final YoDouble percentJointRangeForThreshold;
    private FullHumanoidRobotModel robotModel;
    private RigidBodyBasics base;
    private OneDoFJointBasics[] robotJoints;
    private OneDoFJointBasics[] ikJoints;
    private NumericalInverseKinematicsCalculator inverseKinematicsCalculator;
    private GeometricJacobian jacobian;
    private int numJoints;
    private YoDouble[] originalDesiredPositions;
    private YoDouble[] alphas;
    private YoDouble[] comparisonValues;
    private YoDouble[] adjustedDesiredPositions;
    private YoDouble[] lowerLimits;
    private YoDouble[] upperLimits;
    private YoFramePoseUsingYawPitchRoll originalDesiredYoPose;
    private FramePose3D originalDesiredPose;
    private FramePoint3D adjustedDesiredPosition;
    private FrameQuaternion adjustedDesiredOrientation;
    private YoFramePoseUsingYawPitchRoll adjustedDesiredPose;
    private RigidBodyTransform desiredTransform;
    private YoFrameVector3D originalDesiredLinearVelocity;
    private YoFrameVector3D adjustedDesiredLinearVelocity;
    private final LinearSolverDense<DMatrixRMaj> solver;
    private final DMatrixRMaj jacobianMatrix;
    private final DMatrixRMaj jacobianMatrixTransposed;
    private final DMatrixRMaj jacobianTimesJaconianTransposedMatrix;
    private final DMatrixRMaj lamdaSquaredMatrix;
    private final DMatrixRMaj jacobianTimesJaconianTransposedPlusLamdaSquaredMatrix;
    private final DMatrixRMaj translationSelectionMatrix;
    private final DMatrixRMaj allSelectionMatrix;
    private final DMatrixRMaj originalDesiredVelocity;
    private final DMatrixRMaj intermediateResult;
    private final DMatrixRMaj jointVelocities;
    private final DMatrixRMaj adjustedDesiredVelocity;
    private final YoGraphicPosition yoDesiredFootPositionGraphic;
    private final YoGraphicPosition yoCorrectedDesiredFootPositionGraphic;

    public LegJointLimitAvoidanceControlModule(String prefix, YoRegistry registry, HighLevelHumanoidControllerToolbox controllerToolbox, RobotSide robotSide) {
        this.robotModel = controllerToolbox.getFullRobotModel();
        this.base = this.robotModel.getPelvis();
        RigidBodyBasics foot = this.robotModel.getFoot((Enum)robotSide);
        this.robotJoints = (OneDoFJointBasics[])MultiBodySystemTools.filterJoints((JointReadOnly[])MultiBodySystemTools.createJointPath((RigidBodyBasics)this.base, (RigidBodyBasics)foot), OneDoFJointBasics.class);
        this.ikJoints = (OneDoFJointBasics[])MultiBodySystemTools.filterJoints((JointReadOnly[])MultiBodySystemFactories.cloneKinematicChain((JointReadOnly[])this.robotJoints), OneDoFJointBasics.class);
        this.jacobian = new GeometricJacobian((JointBasics[])this.ikJoints, (ReferenceFrame)this.ikJoints[this.ikJoints.length - 1].getSuccessor().getBodyFixedFrame());
        this.inverseKinematicsCalculator = new NumericalInverseKinematicsCalculator(this.jacobian, 1.0E-6, 1.0E-8, 8, 0.1, 1.0, 1.0);
        this.inverseKinematicsCalculator.setLimitJointAngles(true);
        this.numJoints = this.ikJoints.length;
        this.originalDesiredPositions = new YoDouble[this.numJoints];
        this.alphas = new YoDouble[this.numJoints];
        this.comparisonValues = new YoDouble[this.numJoints];
        this.adjustedDesiredPositions = new YoDouble[this.numJoints];
        this.lowerLimits = new YoDouble[this.numJoints];
        this.upperLimits = new YoDouble[this.numJoints];
        for (int i = 0; i < this.numJoints; ++i) {
            this.originalDesiredPositions[i] = new YoDouble(prefix + "originalDesiredPositions" + i, registry);
            this.alphas[i] = new YoDouble(prefix + "alpha" + i, registry);
            this.comparisonValues[i] = new YoDouble(prefix + "comparisonValues" + i, registry);
            this.adjustedDesiredPositions[i] = new YoDouble(prefix + "adjustedDesiredPositions" + i, registry);
            this.lowerLimits[i] = new YoDouble(prefix + "lowerLimits" + i, registry);
            this.upperLimits[i] = new YoDouble(prefix + "upperLimits" + i, registry);
        }
        this.originalDesiredPose = new FramePose3D();
        this.originalDesiredYoPose = new YoFramePoseUsingYawPitchRoll(prefix + "originalDesiredYoPose", ReferenceFrame.getWorldFrame(), registry);
        this.adjustedDesiredPose = new YoFramePoseUsingYawPitchRoll(prefix + "adjustedDesiredPose", ReferenceFrame.getWorldFrame(), registry);
        this.desiredTransform = new RigidBodyTransform();
        this.adjustedDesiredPosition = new FramePoint3D(ReferenceFrame.getWorldFrame());
        this.adjustedDesiredOrientation = new FrameQuaternion(ReferenceFrame.getWorldFrame());
        this.percentJointRangeForThreshold = new YoDouble(prefix + "percentJointRangeForThreshold", registry);
        this.percentJointRangeForThreshold.set(0.5);
        this.jacobianMatrix = new DMatrixRMaj(6, this.numJoints);
        this.jacobianMatrixTransposed = new DMatrixRMaj(this.numJoints, 6);
        this.jacobianTimesJaconianTransposedMatrix = new DMatrixRMaj(6, 6);
        this.lamdaSquaredMatrix = new DMatrixRMaj(this.numJoints, this.numJoints);
        this.jacobianTimesJaconianTransposedPlusLamdaSquaredMatrix = new DMatrixRMaj(this.numJoints, this.numJoints);
        this.solver = LinearSolverFactory_DDRM.leastSquares((int)6, (int)6);
        this.translationSelectionMatrix = new DMatrixRMaj(3, 6);
        this.translationSelectionMatrix.set(0, 3, 1.0);
        this.translationSelectionMatrix.set(1, 4, 1.0);
        this.translationSelectionMatrix.set(2, 5, 1.0);
        this.allSelectionMatrix = new DMatrixRMaj(6, 6);
        this.allSelectionMatrix.set(5, 5, 1.0);
        this.originalDesiredVelocity = new DMatrixRMaj(6, 1);
        this.intermediateResult = new DMatrixRMaj(6, 1);
        this.jointVelocities = new DMatrixRMaj(this.numJoints, 1);
        this.adjustedDesiredVelocity = new DMatrixRMaj(6, 1);
        this.originalDesiredLinearVelocity = new YoFrameVector3D(prefix + "originalDesiredLinearVelocity", ReferenceFrame.getWorldFrame(), registry);
        this.adjustedDesiredLinearVelocity = new YoFrameVector3D(prefix + "adjustedDesiredLinearVelocity", ReferenceFrame.getWorldFrame(), registry);
        YoGraphicsListRegistry yoGraphicsListRegistry = controllerToolbox.getYoGraphicsListRegistry();
        if (this.visualize) {
            this.yoDesiredFootPositionGraphic = new YoGraphicPosition(prefix + "DesiredFootPosition", this.originalDesiredYoPose.getPosition(), 0.025, YoAppearance.Yellow(), YoGraphicPosition.GraphicType.BALL);
            yoGraphicsListRegistry.registerYoGraphic("SingularityCollapseAvoidance", (YoGraphic)this.yoDesiredFootPositionGraphic);
            this.yoCorrectedDesiredFootPositionGraphic = new YoGraphicPosition(prefix + "CorrectedDesiredFootPosition", this.adjustedDesiredPose.getPosition(), 0.025, YoAppearance.Blue(), YoGraphicPosition.GraphicType.BALL);
            yoGraphicsListRegistry.registerYoGraphic("SingularityCollapseAvoidance", (YoGraphic)this.yoCorrectedDesiredFootPositionGraphic);
        } else {
            this.yoDesiredFootPositionGraphic = null;
            this.yoCorrectedDesiredFootPositionGraphic = null;
        }
    }

    public void correctSwingFootTrajectory(FramePoint3D desiredPosition, FrameQuaternion desiredOrientation, FrameVector3D desiredLinearVelocityOfOrigin, FrameVector3D desiredAngularVelocity, FrameVector3D desiredLinearAccelerationOfOrigin, FrameVector3D desiredAngularAcceleration) {
        this.updateJointPositions();
        Twist rootJointTist = new Twist();
        rootJointTist.setIncludingFrame((SpatialMotionReadOnly)this.robotModel.getRootJoint().getJointTwist());
        FrameVector3D linearRootJointVelocity = new FrameVector3D();
        linearRootJointVelocity.setIncludingFrame((FrameTuple3DReadOnly)rootJointTist.getLinearPart());
        linearRootJointVelocity.scale(0.004);
        this.originalDesiredPose.set((FrameTuple3DReadOnly)desiredPosition, (FrameOrientation3DReadOnly)desiredOrientation);
        this.originalDesiredYoPose.set((FramePose3DReadOnly)this.originalDesiredPose);
        this.originalDesiredPose.changeFrame(this.jacobian.getBaseFrame());
        this.originalDesiredPose.get((RigidBodyTransformBasics)this.desiredTransform);
        this.originalDesiredPose.changeFrame(ReferenceFrame.getWorldFrame());
        this.inverseKinematicsCalculator.solve(this.desiredTransform);
        this.adjustJointPositions();
        this.ikJoints[0].updateFramesRecursively();
        RigidBodyTransform newFootTransform = this.jacobian.getEndEffectorFrame().getTransformToDesiredFrame(this.jacobian.getBaseFrame());
        RigidBodyTransform footInWorldTransform = this.jacobian.getEndEffectorFrame().getTransformToDesiredFrame(ReferenceFrame.getWorldFrame());
        ReferenceFrame adjustedFootFrame = this.jacobian.getEndEffectorFrame();
        this.adjustedDesiredPosition.setToZero(adjustedFootFrame);
        this.adjustedDesiredPosition.changeFrame(ReferenceFrame.getWorldFrame());
        this.adjustedDesiredOrientation.setToZero(adjustedFootFrame);
        this.adjustedDesiredOrientation.changeFrame(ReferenceFrame.getWorldFrame());
        this.adjustedDesiredPose.setPosition((FrameTuple3DReadOnly)this.adjustedDesiredPosition);
        if (this.enableCorrection) {
            desiredPosition.set(this.adjustedDesiredPosition);
        }
        desiredAngularVelocity.get(0, (DMatrix)this.originalDesiredVelocity);
        desiredLinearVelocityOfOrigin.get(3, (DMatrix)this.originalDesiredVelocity);
        this.calculateAdjustedVelocities();
        double[] adjustedVelocities = this.adjustedDesiredVelocity.getData();
        desiredLinearVelocityOfOrigin.set(adjustedVelocities[3], adjustedVelocities[4], adjustedVelocities[5]);
        if (this.visualize) {
            this.yoDesiredFootPositionGraphic.showGraphicObject();
            this.yoCorrectedDesiredFootPositionGraphic.showGraphicObject();
        }
    }

    private void updateJointPositions() {
        for (int i = 0; i < this.numJoints; ++i) {
            this.ikJoints[i].setQ(this.robotJoints[i].getQ());
        }
    }

    private void adjustJointPositions() {
        int size = this.ikJoints.length;
        double rangePercentageForThreshold = this.percentJointRangeForThreshold.getDoubleValue();
        double lambda = 1.0 - rangePercentageForThreshold;
        for (int i = 0; i < size; ++i) {
            double lowerLimit = this.ikJoints[i].getJointLimitLower();
            double upperLimit = this.ikJoints[i].getJointLimitUpper();
            this.lowerLimits[i].set(lowerLimit);
            this.upperLimits[i].set(upperLimit);
            double midpointOfLimits = (lowerLimit + upperLimit) / 2.0;
            double range = upperLimit - lowerLimit;
            this.originalDesiredPositions[i].set(this.ikJoints[i].getQ());
            double adjustedPosition = this.originalDesiredPositions[i].getDoubleValue();
            double comparisonValue = 2.0 * (this.originalDesiredPositions[i].getDoubleValue() - midpointOfLimits) / range;
            comparisonValue = Math.min(comparisonValue, 1.0);
            comparisonValue = Math.max(comparisonValue, -1.0);
            double alpha = 0.0;
            if (comparisonValue > lambda || comparisonValue < -lambda) {
                alpha = Math.max(0.0, (Math.abs(comparisonValue) - lambda) / rangePercentageForThreshold);
            }
            this.alphas[i].set(alpha);
            adjustedPosition = (1.0 - alpha) * this.ikJoints[i].getQ() + alpha * this.robotJoints[i].getQ();
            adjustedPosition = Math.max(lowerLimit, adjustedPosition);
            adjustedPosition = Math.min(upperLimit, adjustedPosition);
            this.adjustedDesiredPositions[i].set(adjustedPosition);
            this.ikJoints[i].setQ(adjustedPosition);
        }
    }

    private void calculateAdjustedVelocities() {
        int numberOfConstraints = 6;
        this.updateJointPositions();
        this.jacobian.compute();
        this.jacobianMatrix.set((DMatrixD1)this.jacobian.getJacobianMatrix());
        CommonOps_DDRM.transpose((DMatrixRMaj)this.jacobianMatrix, (DMatrixRMaj)this.jacobianMatrixTransposed);
        CommonOps_DDRM.multOuter((DMatrix1Row)this.jacobianMatrix, (DMatrix1Row)this.jacobianTimesJaconianTransposedMatrix);
        this.intermediateResult.reshape(numberOfConstraints, 1);
        this.lamdaSquaredMatrix.reshape(numberOfConstraints, numberOfConstraints);
        CommonOps_DDRM.setIdentity((DMatrix1Row)this.lamdaSquaredMatrix);
        this.lamdaSquaredMatrix.zero();
        this.jacobianTimesJaconianTransposedPlusLamdaSquaredMatrix.reshape(numberOfConstraints, numberOfConstraints);
        this.jacobianTimesJaconianTransposedPlusLamdaSquaredMatrix.set((DMatrixD1)this.jacobianTimesJaconianTransposedMatrix);
        CommonOps_DDRM.add((DMatrixD1)this.jacobianTimesJaconianTransposedMatrix, (DMatrixD1)this.lamdaSquaredMatrix, (DMatrixD1)this.jacobianTimesJaconianTransposedPlusLamdaSquaredMatrix);
        boolean success = this.solver.setA((Matrix)this.jacobianTimesJaconianTransposedPlusLamdaSquaredMatrix);
        this.solver.solve((Matrix)this.originalDesiredVelocity, (Matrix)this.intermediateResult);
        CommonOps_DDRM.mult((DMatrix1Row)this.jacobianMatrixTransposed, (DMatrix1Row)this.intermediateResult, (DMatrix1Row)this.jointVelocities);
        for (int i = 0; i < this.numJoints; ++i) {
            if (!(this.comparisonValues[i].getDoubleValue() * this.jointVelocities.get(i) > 0.0)) continue;
            this.jointVelocities.times(i, 1.0 - this.alphas[i].getDoubleValue());
        }
        CommonOps_DDRM.mult((DMatrix1Row)this.jacobianMatrix, (DMatrix1Row)this.jointVelocities, (DMatrix1Row)this.adjustedDesiredVelocity);
    }
}

