/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.foot;

import java.awt.Color;
import java.util.List;
import us.ihmc.commonWalkingControlModules.controlModules.foot.ExplorationParameters;
import us.ihmc.commonWalkingControlModules.controlModules.foot.FootRotationCalculator;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FrameLine2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex2DSupplier;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicVector;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsList;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.graphicsDescription.yoGraphics.plotting.ArtifactList;
import us.ihmc.graphicsDescription.yoGraphics.plotting.YoArtifactLineSegment2d;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.geometry.algorithms.FrameConvexPolygonWithLineIntersector2d;
import us.ihmc.robotics.math.filters.AlphaFilteredYoFramePoint;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameLineSegment2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class GeometricFootRotationCalculator
implements FootRotationCalculator {
    private static final boolean VISUALIZE = false;
    private static final Vector3D zero = new Vector3D(0.0, 0.0, 0.0);
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final ReferenceFrame soleFrame;
    private final FrameConvexPolygon2D defaultFootPolygon;
    private final FrameLine2D lineOfRotationInSoleFrame = new FrameLine2D();
    private final FrameLine2D lineOfRotationInWorldFrame = new FrameLine2D();
    private final FrameConvexPolygon2D footPolygonInWorld = new FrameConvexPolygon2D();
    private final FrameConvexPolygonWithLineIntersector2d frameConvexPolygonWithLineIntersector2d = new FrameConvexPolygonWithLineIntersector2d();
    private final FramePoint3D measuredCoPInWorld = new FramePoint3D();
    private final AlphaFilteredYoFramePoint measuredCoPFiltered;
    private final YoFrameLineSegment2D lineSegmentOfRotation;
    private final YoFrameVector3D groundPlaneNormal;
    private final YoDouble angleFootGround;
    private final YoDouble angleThreshold;
    private final YoBoolean footRotating;
    private final FrameVector3D lineOfContact = new FrameVector3D();
    private final FrameVector3D footNormal = new FrameVector3D();

    public GeometricFootRotationCalculator(String namePrefix, ContactablePlaneBody contactableFoot, ExplorationParameters explorationParameters, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry parentRegistry) {
        YoRegistry registry = new YoRegistry(namePrefix + this.getClass().getSimpleName());
        parentRegistry.addChild(registry);
        this.soleFrame = contactableFoot.getSoleFrame();
        this.defaultFootPolygon = new FrameConvexPolygon2D(FrameVertex2DSupplier.asFrameVertex2DSupplier((List)contactableFoot.getContactPoints2d()));
        this.angleFootGround = new YoDouble(namePrefix + "AngleToGround", registry);
        this.angleThreshold = explorationParameters.getGeometricDetectionAngleThreshold();
        this.footRotating = new YoBoolean(namePrefix + "RotatingGeometry", registry);
        YoDouble copAlpha = explorationParameters.getGeometricDetectionPlanePointAlpha();
        this.measuredCoPFiltered = AlphaFilteredYoFramePoint.createAlphaFilteredYoFramePoint((String)(namePrefix + "CoPFiltered"), (String)"", (YoRegistry)registry, (DoubleProvider)copAlpha, (ReferenceFrame)worldFrame);
        this.groundPlaneNormal = new YoFrameVector3D(namePrefix + "PlaneNormal", worldFrame, registry);
        this.lineSegmentOfRotation = new YoFrameLineSegment2D(namePrefix + "LineOfRotationGeometric", "", worldFrame, registry);
        if (yoGraphicsListRegistry != null) {
            String listName = this.getClass().getSimpleName();
            ArtifactList artifactList = new ArtifactList(listName);
            YoGraphicsList graphicsList = new YoGraphicsList(listName);
            YoGraphicPosition planePointViz = new YoGraphicPosition(namePrefix + "PlanePoint", (YoFramePoint3D)this.measuredCoPFiltered, 0.005, YoAppearance.Blue(), YoGraphicPosition.GraphicType.SOLID_BALL);
            YoGraphicVector planeNormalViz = new YoGraphicVector(namePrefix + "PlaneNormal", (YoFramePoint3D)this.measuredCoPFiltered, this.groundPlaneNormal, YoAppearance.Blue());
            YoArtifactLineSegment2d lineOfRotationArtifact = new YoArtifactLineSegment2d(namePrefix + "LineOfRotationGeometric", this.lineSegmentOfRotation, Color.GREEN, 0.01, 0.01);
            graphicsList.add((YoGraphic)planeNormalViz);
            artifactList.add((Artifact)planePointViz.createArtifact());
            artifactList.add((Artifact)lineOfRotationArtifact);
            graphicsList.setVisible(false);
            artifactList.setVisible(false);
            yoGraphicsListRegistry.registerYoGraphicsList(graphicsList);
            yoGraphicsListRegistry.registerArtifactList(artifactList);
        }
    }

    @Override
    public void compute(FramePoint2DReadOnly desiredCoP, FramePoint2DReadOnly measuredCoP) {
        this.measuredCoPInWorld.setMatchingFrame((FrameTuple2DReadOnly)measuredCoP, 0.0);
        this.measuredCoPFiltered.update((FrameTuple3DReadOnly)this.measuredCoPInWorld);
        this.groundPlaneNormal.set(worldFrame, 0.0, 0.0, 1.0);
        this.footNormal.setIncludingFrame(this.soleFrame, 0.0, 0.0, 1.0);
        this.footNormal.normalize();
        this.footNormal.changeFrame(worldFrame);
        this.lineOfContact.cross((FrameVector3DReadOnly)this.groundPlaneNormal, (FrameVector3DReadOnly)this.footNormal);
        if (this.lineOfContact.epsilonEquals((Tuple3DReadOnly)zero, 1.0E-11)) {
            return;
        }
        double cosAlpha = Math.abs(this.groundPlaneNormal.dot((FrameVector3DReadOnly)this.footNormal));
        double alpha = Math.acos(cosAlpha);
        this.angleFootGround.set(alpha);
        this.footRotating.set(alpha > this.angleThreshold.getDoubleValue());
        this.lineOfRotationInWorldFrame.set((FramePoint3DReadOnly)this.measuredCoPInWorld, (FrameVector3DReadOnly)this.lineOfContact);
        this.lineOfRotationInSoleFrame.setIncludingFrame((FrameLine2DReadOnly)this.lineOfRotationInWorldFrame);
        this.lineOfRotationInSoleFrame.changeFrameAndProjectToXYPlane(this.soleFrame);
        this.intersectLineOfRotationWithFootPolygon();
    }

    private void intersectLineOfRotationWithFootPolygon() {
        this.footPolygonInWorld.setIncludingFrame((FrameVertex2DSupplier)this.defaultFootPolygon);
        this.footPolygonInWorld.changeFrameAndProjectToXYPlane(worldFrame);
        this.frameConvexPolygonWithLineIntersector2d.intersectWithLine((FrameConvexPolygon2DReadOnly)this.footPolygonInWorld, (FrameLine2DReadOnly)this.lineOfRotationInWorldFrame);
        if (FootRotationCalculator.isIntersectionValid(this.frameConvexPolygonWithLineIntersector2d)) {
            this.lineSegmentOfRotation.set((FramePoint2DReadOnly)this.frameConvexPolygonWithLineIntersector2d.getIntersectionPointOne(), (FramePoint2DReadOnly)this.frameConvexPolygonWithLineIntersector2d.getIntersectionPointTwo());
        } else {
            this.lineSegmentOfRotation.setToNaN();
        }
    }

    @Override
    public void reset() {
        this.measuredCoPFiltered.reset();
        this.footRotating.set(false);
        this.lineSegmentOfRotation.setToNaN();
        this.groundPlaneNormal.setToNaN();
    }

    @Override
    public boolean isFootRotating() {
        return this.footRotating.getBooleanValue();
    }

    @Override
    public void getLineOfRotation(FrameLine2DBasics lineOfRotationToPack) {
        lineOfRotationToPack.setIncludingFrame((FrameLine2DReadOnly)this.lineOfRotationInSoleFrame);
    }
}

