/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.foot;

import java.awt.Color;
import us.ihmc.commonWalkingControlModules.controlModules.foot.FeetManager;
import us.ihmc.commonWalkingControlModules.momentumBasedController.ParameterProvider;
import us.ihmc.euclid.geometry.interfaces.Line2DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameLine3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameLine2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector2DReadOnly;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.graphicsDescription.yoGraphics.plotting.YoArtifactLineSegment2d;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.robotics.math.filters.AlphaFilteredYoFramePoint2d;
import us.ihmc.robotics.math.filters.AlphaFilteredYoFrameVector2d;
import us.ihmc.robotics.math.filters.AlphaFilteredYoVariable;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.statistics.Line2DStatisticsCalculator;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameLine2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector2D;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class FootRotationDetector {
    private final YoRegistry registry;
    private final YoFramePoint2D linePointA;
    private final YoFramePoint2D linePointB;
    private final double dt;
    private final MovingReferenceFrame soleFrame;
    private final AlphaFilteredYoFramePoint2d filteredPointOfRotation;
    private final AlphaFilteredYoFrameVector2d filteredAxisOfRotation;
    private final FixedFrameLine2DBasics lineOfRotationInSole;
    private final YoDouble integratedRotationAngle;
    private final YoDouble absoluteFootOmega;
    private final YoBoolean isRotating;
    private final DoubleProvider omegaThresholdForEstimation;
    private final DoubleProvider decayBreakFrequency;
    private final DoubleProvider filterBreakFrequency;
    private final DoubleProvider rotationThreshold;
    private final Line2DStatisticsCalculator lineOfRotationStandardDeviation;
    private final FrameVector3D tempPointOfRotation = new FrameVector3D();
    private final FrameLine3DBasics tempLineOfRotationInWorld = new FrameLine3D();

    public FootRotationDetector(RobotSide side, MovingReferenceFrame soleFrame, double dt, YoRegistry parentRegistry, YoGraphicsListRegistry graphicsRegistry) {
        this.soleFrame = soleFrame;
        this.dt = dt;
        this.registry = new YoRegistry(this.getClass().getSimpleName() + side.getPascalCaseName());
        this.linePointA = new YoFramePoint2D("FootRotationPointA", ReferenceFrame.getWorldFrame(), this.registry);
        this.linePointB = new YoFramePoint2D("FootRotationPointB", ReferenceFrame.getWorldFrame(), this.registry);
        parentRegistry.addChild(this.registry);
        String feetManagerName = FeetManager.class.getSimpleName();
        String paramRegistryName = this.getClass().getSimpleName() + "Parameters";
        this.omegaThresholdForEstimation = ParameterProvider.getOrCreateParameter(feetManagerName, paramRegistryName, "omegaThresholdForEstimation", this.registry, 3.0);
        this.decayBreakFrequency = ParameterProvider.getOrCreateParameter(feetManagerName, paramRegistryName, "decayBreakFrequency", this.registry, 1.0);
        this.filterBreakFrequency = ParameterProvider.getOrCreateParameter(feetManagerName, paramRegistryName, "filterBreakFrequency", this.registry, 1.0);
        this.rotationThreshold = ParameterProvider.getOrCreateParameter(feetManagerName, paramRegistryName, "rotationThreshold", this.registry, 0.2);
        this.integratedRotationAngle = new YoDouble(side.getLowerCaseName() + "IntegratedRotationAngle", this.registry);
        this.absoluteFootOmega = new YoDouble(side.getLowerCaseName() + "AbsoluteFootOmega", this.registry);
        this.isRotating = new YoBoolean(side.getLowerCaseName() + "IsRotating", this.registry);
        YoFramePoint2D point = new YoFramePoint2D(side.getLowerCaseName() + "LineOfRotationPoint", (ReferenceFrame)soleFrame, this.registry);
        YoFrameVector2D direction = new YoFrameVector2D(side.getLowerCaseName() + "LineOfRotationDirection", (ReferenceFrame)soleFrame, this.registry);
        this.lineOfRotationInSole = new YoFrameLine2D(point, direction);
        this.lineOfRotationStandardDeviation = new Line2DStatisticsCalculator(side.getLowerCaseName() + "LineOfRotation", (Line2DReadOnly)this.lineOfRotationInSole, this.registry);
        DoubleProvider alpha = () -> AlphaFilteredYoVariable.computeAlphaGivenBreakFrequencyProperly((double)this.filterBreakFrequency.getValue(), (double)dt);
        this.filteredPointOfRotation = new AlphaFilteredYoFramePoint2d(side + "FilteredPointOfRotation", "", this.registry, alpha, (ReferenceFrame)soleFrame);
        this.filteredAxisOfRotation = new AlphaFilteredYoFrameVector2d(side + "FilteredAxisOfRotation", "", this.registry, alpha, (ReferenceFrame)soleFrame);
        this.reset();
        if (graphicsRegistry != null) {
            YoArtifactLineSegment2d lineArtifact = new YoArtifactLineSegment2d(side.getLowerCaseName() + "LineOfRotation", this.linePointA, this.linePointB, Color.ORANGE, 0.005, 0.01);
            graphicsRegistry.registerArtifact(this.getClass().getSimpleName(), (Artifact)lineArtifact);
        }
    }

    public boolean compute() {
        TwistReadOnly soleFrameTwist = this.soleFrame.getTwistOfFrame();
        double omegaSquared = soleFrameTwist.getAngularPart().lengthSquared();
        this.absoluteFootOmega.set(Math.sqrt(omegaSquared));
        if (this.absoluteFootOmega.getValue() > this.omegaThresholdForEstimation.getValue()) {
            this.tempPointOfRotation.setToZero((ReferenceFrame)this.soleFrame);
            this.tempPointOfRotation.cross(soleFrameTwist.getAngularPart(), soleFrameTwist.getLinearPart());
            this.tempPointOfRotation.scale(1.0 / omegaSquared);
            this.lineOfRotationInSole.setToZero();
            this.lineOfRotationInSole.getPoint().set((FrameTuple3DReadOnly)this.tempPointOfRotation);
            this.lineOfRotationInSole.getDirection().set((FrameTuple3DReadOnly)soleFrameTwist.getAngularPart());
            double omega = soleFrameTwist.getAngularPart().length();
            this.integratedRotationAngle.add(this.dt * omega);
            this.lineOfRotationInSole.getDirection().scale(1.0 / omega);
            if (this.lineOfRotationInSole.getDirection().dot((FrameVector2DReadOnly)this.filteredAxisOfRotation) < 0.0) {
                this.lineOfRotationInSole.getDirection().negate();
            }
            this.filteredPointOfRotation.update((FrameTuple2DReadOnly)this.lineOfRotationInSole.getPoint());
            this.filteredAxisOfRotation.update((FrameTuple2DReadOnly)this.lineOfRotationInSole.getDirection());
            this.lineOfRotationInSole.set((FramePoint2DReadOnly)this.filteredPointOfRotation, (FrameVector2DReadOnly)this.filteredAxisOfRotation);
            this.lineOfRotationInSole.getDirection().normalize();
            this.lineOfRotationStandardDeviation.update();
        } else if (!this.isRotating.getValue()) {
            this.filteredPointOfRotation.reset();
            this.filteredAxisOfRotation.reset();
            this.lineOfRotationInSole.setToZero();
            this.lineOfRotationStandardDeviation.reset();
        }
        if (!this.isRotating.getValue()) {
            this.isRotating.set(this.integratedRotationAngle.getValue() > this.rotationThreshold.getValue());
        }
        this.integratedRotationAngle.mul(AlphaFilteredYoVariable.computeAlphaGivenBreakFrequencyProperly((double)this.decayBreakFrequency.getValue(), (double)this.dt));
        this.updateGraphics();
        return this.isRotating.getValue();
    }

    private void updateGraphics() {
        if (!this.isRotating.getValue()) {
            this.linePointA.setToNaN();
            this.linePointB.setToNaN();
            return;
        }
        this.tempLineOfRotationInWorld.setToZero((ReferenceFrame)this.soleFrame);
        this.tempLineOfRotationInWorld.getPoint().set((FrameTuple2DReadOnly)this.lineOfRotationInSole.getPoint());
        this.tempLineOfRotationInWorld.getDirection().set((FrameTuple2DReadOnly)this.lineOfRotationInSole.getDirection());
        this.tempLineOfRotationInWorld.changeFrame(ReferenceFrame.getWorldFrame());
        this.linePointA.set((FrameTuple3DReadOnly)this.tempLineOfRotationInWorld.getDirection());
        this.linePointA.scale(-0.05);
        this.linePointA.add(this.tempLineOfRotationInWorld.getPointX(), this.tempLineOfRotationInWorld.getPointY());
        this.linePointB.set((FrameTuple3DReadOnly)this.tempLineOfRotationInWorld.getDirection());
        this.linePointB.scale(0.05);
        this.linePointB.add(this.tempLineOfRotationInWorld.getPointX(), this.tempLineOfRotationInWorld.getPointY());
    }

    public FrameLine2DReadOnly getLineOfRotation() {
        return this.lineOfRotationInSole;
    }

    public void reset() {
        this.linePointA.setToNaN();
        this.linePointB.setToNaN();
        this.filteredPointOfRotation.reset();
        this.filteredAxisOfRotation.reset();
        this.lineOfRotationInSole.setToZero();
        this.integratedRotationAngle.set(0.0);
        this.absoluteFootOmega.set(0.0);
        this.isRotating.set(false);
    }
}

