/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.foot;

import java.util.Arrays;
import java.util.EnumMap;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.YoPlaneContactState;
import us.ihmc.commonWalkingControlModules.configurations.AnkleIKSolver;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.configurations.YoSwingTrajectoryParameters;
import us.ihmc.commonWalkingControlModules.controlModules.SwingTrajectoryCalculator;
import us.ihmc.commonWalkingControlModules.controlModules.foot.AbstractFootControlState;
import us.ihmc.commonWalkingControlModules.controlModules.foot.ExplorationParameters;
import us.ihmc.commonWalkingControlModules.controlModules.foot.FeetManager;
import us.ihmc.commonWalkingControlModules.controlModules.foot.FootControlHelper;
import us.ihmc.commonWalkingControlModules.controlModules.foot.MoveViaWaypointsState;
import us.ihmc.commonWalkingControlModules.controlModules.foot.OnToesState;
import us.ihmc.commonWalkingControlModules.controlModules.foot.SupportState;
import us.ihmc.commonWalkingControlModules.controlModules.foot.SupportStateParameters;
import us.ihmc.commonWalkingControlModules.controlModules.foot.SwingState;
import us.ihmc.commonWalkingControlModules.controlModules.foot.UnloadedAnkleControlModule;
import us.ihmc.commonWalkingControlModules.controlModules.foot.WorkspaceLimiterControlModule;
import us.ihmc.commonWalkingControlModules.controlModules.foot.WorkspaceLimiterParameters;
import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.FootholdRotationParameters;
import us.ihmc.commonWalkingControlModules.controlModules.foot.toeOffCalculator.ToeOffCalculator;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommandList;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.ContactWrenchCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommandList;
import us.ihmc.commonWalkingControlModules.heightPlanning.CoMHeightTimeDerivativesDataBasics;
import us.ihmc.commonWalkingControlModules.momentumBasedController.HighLevelHumanoidControllerToolbox;
import us.ihmc.commonWalkingControlModules.momentumBasedController.ParameterProvider;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.FootTrajectoryCommand;
import us.ihmc.humanoidRobotics.footstep.Footstep;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.controllers.pidGains.PIDSE3GainsReadOnly;
import us.ihmc.robotics.math.trajectories.generators.MultipleWaypointsPoseTrajectoryGenerator;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.stateMachine.core.State;
import us.ihmc.robotics.stateMachine.core.StateMachine;
import us.ihmc.robotics.stateMachine.factories.StateMachineFactory;
import us.ihmc.robotics.trajectories.TrajectoryType;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputListReadOnly;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;

public class FootControlModule {
    private final YoRegistry registry;
    private final ContactablePlaneBody contactableFoot;
    private static final double defaultCoefficientOfFriction = 0.8;
    private final DoubleParameter coefficientOfFriction;
    private final StateMachine<ConstraintType, AbstractFootControlState> stateMachine;
    private final YoEnum<ConstraintType> requestedState;
    private final EnumMap<ConstraintType, boolean[]> contactStatesMap = new EnumMap(ConstraintType.class);
    private final HighLevelHumanoidControllerToolbox controllerToolbox;
    private final RobotSide robotSide;
    private final WorkspaceLimiterControlModule workspaceLimiterControlModule;
    private final SwingState swingState;
    private final MoveViaWaypointsState moveViaWaypointsState;
    private final OnToesState onToesState;
    private final SupportState supportState;
    private final YoDouble footLoadThresholdToHoldPosition;
    private final FootControlHelper footControlHelper;
    private final YoBoolean requestExploration;
    private final YoBoolean resetFootPolygon;
    private final InverseDynamicsCommandList inverseDynamicsCommandList = new InverseDynamicsCommandList();
    private final UnloadedAnkleControlModule ankleControlModule;
    private final DoubleProvider maxWeightFractionPerFoot;
    private final DoubleProvider minWeightFractionPerFoot;
    private final YoDouble minZForce;
    private final YoDouble maxZForce;
    private final double robotWeightFz;
    private final ContactWrenchCommand maxWrenchCommand;
    private final ContactWrenchCommand minWrenchCommand;
    private final int numberOfBasisVectors;
    private final FrameVector3D normalVector = new FrameVector3D();

    public FootControlModule(RobotSide robotSide, ToeOffCalculator toeOffCalculator, WalkingControllerParameters walkingControllerParameters, YoSwingTrajectoryParameters swingTrajectoryParameters, WorkspaceLimiterParameters workspaceLimiterParameters, PIDSE3GainsReadOnly swingFootControlGains, PIDSE3GainsReadOnly holdPositionFootControlGains, PIDSE3GainsReadOnly toeOffFootControlGains, HighLevelHumanoidControllerToolbox controllerToolbox, ExplorationParameters explorationParameters, FootholdRotationParameters footholdRotationParameters, SupportStateParameters supportStateParameters, DoubleProvider minWeightFractionPerFoot, DoubleProvider maxWeightFractionPerFoot, YoRegistry parentRegistry) {
        this.contactableFoot = (ContactablePlaneBody)controllerToolbox.getContactableFeet().get((Enum)robotSide);
        controllerToolbox.setFootContactStateFullyConstrained(robotSide);
        String sidePrefix = robotSide.getCamelCaseNameForStartOfExpression();
        String namePrefix = sidePrefix + "Foot";
        this.registry = new YoRegistry(sidePrefix + this.getClass().getSimpleName());
        parentRegistry.addChild(this.registry);
        this.footControlHelper = new FootControlHelper(robotSide, walkingControllerParameters, swingTrajectoryParameters, workspaceLimiterParameters, controllerToolbox, explorationParameters, footholdRotationParameters, supportStateParameters, this.registry);
        this.controllerToolbox = controllerToolbox;
        this.robotSide = robotSide;
        this.footLoadThresholdToHoldPosition = new YoDouble("footLoadThresholdToHoldPosition", this.registry);
        this.footLoadThresholdToHoldPosition.set(0.2);
        this.workspaceLimiterControlModule = this.footControlHelper.getWorkspaceLimiterControlModule();
        this.requestedState = new YoEnum(namePrefix + "RequestedState", "", this.registry, ConstraintType.class, true);
        this.requestedState.set(null);
        this.setupContactStatesMap();
        this.onToesState = new OnToesState(this.footControlHelper, toeOffCalculator, toeOffFootControlGains, this.registry);
        this.supportState = new SupportState(this.footControlHelper, holdPositionFootControlGains, this.registry);
        this.swingState = new SwingState(this.footControlHelper, swingFootControlGains, this.registry);
        this.moveViaWaypointsState = new MoveViaWaypointsState(this.footControlHelper, swingFootControlGains, this.registry);
        this.stateMachine = this.setupStateMachine(namePrefix);
        this.requestExploration = new YoBoolean(namePrefix + "RequestExploration", this.registry);
        this.resetFootPolygon = new YoBoolean(namePrefix + "ResetFootPolygon", this.registry);
        AnkleIKSolver ankleIKSolver = walkingControllerParameters.getAnkleIKSolver();
        if (ankleIKSolver != null) {
            FullHumanoidRobotModel fullRobotModel = controllerToolbox.getFullRobotModel();
            this.ankleControlModule = new UnloadedAnkleControlModule(fullRobotModel, robotSide, ankleIKSolver, this.registry);
        } else {
            this.ankleControlModule = null;
        }
        this.maxWeightFractionPerFoot = maxWeightFractionPerFoot;
        this.minWeightFractionPerFoot = minWeightFractionPerFoot;
        this.robotWeightFz = controllerToolbox.getFullRobotModel().getTotalMass() * controllerToolbox.getGravityZ();
        if (minWeightFractionPerFoot != null && maxWeightFractionPerFoot != null) {
            this.maxWrenchCommand = new ContactWrenchCommand(us.ihmc.commonWalkingControlModules.controllerCore.command.ConstraintType.LEQ_INEQUALITY);
            this.minWrenchCommand = new ContactWrenchCommand(us.ihmc.commonWalkingControlModules.controllerCore.command.ConstraintType.GEQ_INEQUALITY);
            this.setupWrenchCommand(this.maxWrenchCommand);
            this.setupWrenchCommand(this.minWrenchCommand);
            this.minZForce = new YoDouble(robotSide.getLowerCaseName() + "MinZForce", this.registry);
            this.maxZForce = new YoDouble(robotSide.getLowerCaseName() + "MaxZForce", this.registry);
        } else {
            this.maxWrenchCommand = null;
            this.minWrenchCommand = null;
            this.minZForce = null;
            this.maxZForce = null;
        }
        this.numberOfBasisVectors = walkingControllerParameters.getMomentumOptimizationSettings().getNumberOfBasisVectorsPerContactPoint();
        String targetRegistryName = FeetManager.class.getSimpleName();
        String parameterRegistryName = FootControlModule.class.getSimpleName() + "Parameters";
        this.coefficientOfFriction = ParameterProvider.getOrCreateParameter(targetRegistryName, parameterRegistryName, "CoefficientOfFriction", this.registry, 0.8);
    }

    private void setupWrenchCommand(ContactWrenchCommand command) {
        command.setRigidBody(this.contactableFoot.getRigidBody());
        command.getSelectionMatrix().clearSelection();
        command.getSelectionMatrix().setSelectionFrame(ReferenceFrame.getWorldFrame());
        command.getSelectionMatrix().selectLinearZ(true);
        command.getWrench().setToZero((ReferenceFrame)this.contactableFoot.getRigidBody().getBodyFixedFrame(), ReferenceFrame.getWorldFrame());
    }

    private void setupContactStatesMap() {
        boolean[] falses = new boolean[this.contactableFoot.getTotalNumberOfContactPoints()];
        Arrays.fill(falses, false);
        boolean[] trues = new boolean[this.contactableFoot.getTotalNumberOfContactPoints()];
        Arrays.fill(trues, true);
        this.contactStatesMap.put(ConstraintType.SWING, falses);
        this.contactStatesMap.put(ConstraintType.MOVE_VIA_WAYPOINTS, falses);
        this.contactStatesMap.put(ConstraintType.FULL, trues);
        this.contactStatesMap.put(ConstraintType.TOES, trues);
    }

    private StateMachine<ConstraintType, AbstractFootControlState> setupStateMachine(String namePrefix) {
        StateMachineFactory factory = new StateMachineFactory(ConstraintType.class);
        factory.setNamePrefix(namePrefix).setRegistry(this.registry).buildYoClock((DoubleProvider)this.footControlHelper.getHighLevelHumanoidControllerToolbox().getYoTime());
        factory.addState((Enum)ConstraintType.TOES, (State)this.onToesState);
        factory.addState((Enum)ConstraintType.FULL, (State)this.supportState);
        factory.addState((Enum)ConstraintType.SWING, (State)this.swingState);
        factory.addState((Enum)ConstraintType.MOVE_VIA_WAYPOINTS, (State)this.moveViaWaypointsState);
        for (ConstraintType from : ConstraintType.values()) {
            factory.addRequestedTransition((Enum)from, this.requestedState);
            factory.addRequestedTransition((Enum)from, (Enum)from, this.requestedState);
        }
        return factory.build((Enum)ConstraintType.FULL);
    }

    public void setWeights(Vector3DReadOnly loadedFootAngularWeight, Vector3DReadOnly loadedFootLinearWeight, Vector3DReadOnly footAngularWeight, Vector3DReadOnly footLinearWeight) {
        this.swingState.setWeights(footAngularWeight, footLinearWeight);
        this.moveViaWaypointsState.setWeights(footAngularWeight, footLinearWeight);
        this.onToesState.setWeights(loadedFootAngularWeight, loadedFootLinearWeight);
        this.supportState.setWeights(loadedFootAngularWeight, loadedFootLinearWeight);
    }

    public void setAdjustedFootstepAndTime(Footstep adjustedFootstep, double swingTime) {
        this.swingState.setAdjustedFootstepAndTime(adjustedFootstep, swingTime);
    }

    public void requestTouchdownForDisturbanceRecovery() {
        if (this.stateMachine.getCurrentState() == this.moveViaWaypointsState) {
            this.moveViaWaypointsState.requestTouchdownForDisturbanceRecovery(this.stateMachine.getTimeInCurrentState());
        }
    }

    public void requestStopTrajectoryIfPossible() {
        if (this.stateMachine.getCurrentState() == this.moveViaWaypointsState) {
            this.moveViaWaypointsState.requestStopTrajectory();
        }
    }

    public void setContactState(ConstraintType constraintType) {
        this.setContactState(constraintType, null);
    }

    public void setContactState(ConstraintType constraintType, FrameVector3D normalContactVector) {
        if (constraintType == ConstraintType.FULL) {
            this.footControlHelper.setFullyConstrainedNormalContactVector(normalContactVector);
        }
        this.controllerToolbox.setFootContactState(this.robotSide, this.contactStatesMap.get((Object)constraintType), normalContactVector);
        if (this.getCurrentConstraintType() == constraintType) {
            return;
        }
        this.requestedState.set((Enum)constraintType);
    }

    public ConstraintType getCurrentConstraintType() {
        return (ConstraintType)this.stateMachine.getCurrentStateKey();
    }

    public void initialize() {
        this.stateMachine.resetToInitialState();
        this.resetLoadConstraints();
    }

    public void saveCurrentPositionAsLastFootstepPosition() {
        this.footControlHelper.getSwingTrajectoryCalculator().saveCurrentPositionAsLastFootstepPosition();
    }

    public void initializeSwingTrajectoryPreview(Footstep footstep, double swingDuration) {
        SwingTrajectoryCalculator swingTrajectoryCalculator = this.footControlHelper.getSwingTrajectoryCalculator();
        swingTrajectoryCalculator.setInitialConditionsToCurrent();
        swingTrajectoryCalculator.setFootstep(footstep);
        swingTrajectoryCalculator.setSwingDuration(swingDuration);
        swingTrajectoryCalculator.setShouldVisualize(false);
        swingTrajectoryCalculator.initializeTrajectoryWaypoints(true);
    }

    public void updateSwingTrajectoryPreview() {
        SwingTrajectoryCalculator swingTrajectoryCalculator = this.footControlHelper.getSwingTrajectoryCalculator();
        if (swingTrajectoryCalculator.getActiveTrajectoryType() != TrajectoryType.WAYPOINTS && swingTrajectoryCalculator.doOptimizationUpdate()) {
            swingTrajectoryCalculator.initializeTrajectoryWaypoints(false);
        }
    }

    public void doControl() {
        this.controllerToolbox.setFootContactCoefficientOfFriction(this.robotSide, this.coefficientOfFriction.getValue());
        if (this.workspaceLimiterControlModule != null) {
            this.workspaceLimiterControlModule.resetSwingParameters();
        }
        this.footControlHelper.update();
        if (this.resetFootPolygon.getBooleanValue()) {
            this.resetFootPolygon();
        }
        if (this.requestExploration.getBooleanValue()) {
            this.requestExploration();
        }
        this.stateMachine.doTransitions();
        if (!this.isInFlatSupportState() && this.footControlHelper.getPartialFootholdControlModule() != null) {
            this.footControlHelper.getPartialFootholdControlModule().reset();
        }
        this.stateMachine.doAction();
        if (this.ankleControlModule != null) {
            this.ankleControlModule.compute((ConstraintType)this.stateMachine.getCurrentStateKey(), (AbstractFootControlState)this.stateMachine.getCurrentState());
        }
    }

    public void resetCurrentState() {
        this.stateMachine.resetCurrentState();
    }

    public boolean isInFlatSupportState() {
        ConstraintType currentConstraintType = this.getCurrentConstraintType();
        return currentConstraintType == ConstraintType.FULL;
    }

    public boolean isInToeOff() {
        return this.getCurrentConstraintType() == ConstraintType.TOES;
    }

    public void setUsePointContactInToeOff(boolean usePointContact) {
        this.onToesState.setUsePointContact(usePointContact);
    }

    public boolean isUsingPointContactInToeOff() {
        return this.onToesState.isUsingPointContact();
    }

    public void updateLegSingularityModule() {
        if (this.workspaceLimiterControlModule != null) {
            this.workspaceLimiterControlModule.update();
        }
    }

    public boolean correctCoMHeightTrajectoryForSupportSingularityAvoidance(CoMHeightTimeDerivativesDataBasics comHeightDataToCorrect, double zCurrent, ReferenceFrame pelvisZUpFrame) {
        if (this.workspaceLimiterControlModule != null) {
            return this.workspaceLimiterControlModule.correctCoMHeightTrajectoryForSingularityAvoidanceInSupport(comHeightDataToCorrect, zCurrent, pelvisZUpFrame, this.getCurrentConstraintType());
        }
        return false;
    }

    public boolean correctCoMHeightTrajectoryForUnreachableFootStep(CoMHeightTimeDerivativesDataBasics comHeightDataToCorrect) {
        if (this.workspaceLimiterControlModule != null) {
            return this.workspaceLimiterControlModule.correctCoMHeightTrajectoryForUnreachableFootStep(comHeightDataToCorrect, this.getCurrentConstraintType());
        }
        return false;
    }

    public void setFootstep(Footstep footstep, double swingTime) {
        this.setFootstep(footstep, swingTime, null, null);
    }

    public void setFootstep(Footstep footstep, double swingTime, FrameVector3DReadOnly finalCoMVelocity, FrameVector3DReadOnly finalCoMAcceleration) {
        this.swingState.setFootstep(footstep, swingTime, finalCoMVelocity, finalCoMAcceleration);
    }

    public void handleFootTrajectoryCommand(FootTrajectoryCommand command) {
        this.moveViaWaypointsState.handleFootTrajectoryCommand(command);
    }

    public void resetHeightCorrectionParametersForSingularityAvoidance() {
        if (this.workspaceLimiterControlModule != null) {
            this.workspaceLimiterControlModule.resetHeightCorrectionParameters();
        }
    }

    public double requestSwingSpeedUp(double speedUpFactor) {
        return this.swingState.requestSwingSpeedUp(speedUpFactor);
    }

    public double getSwingTimeRemaining() {
        if (this.stateMachine.getCurrentState() != this.swingState) {
            return Double.NaN;
        }
        return this.swingState.getSwingTimeRemaining();
    }

    public double getFractionThroughSwing() {
        if (this.stateMachine.getCurrentState() != this.swingState) {
            return Double.NaN;
        }
        return this.swingState.getFractionThroughSwing();
    }

    public InverseDynamicsCommand<?> getInverseDynamicsCommand() {
        this.inverseDynamicsCommandList.clear();
        this.inverseDynamicsCommandList.addCommand(((AbstractFootControlState)this.stateMachine.getCurrentState()).getInverseDynamicsCommand());
        if (this.ankleControlModule != null) {
            this.inverseDynamicsCommandList.addCommand(this.ankleControlModule.getInverseDynamicsCommand());
        }
        if (this.maxWrenchCommand != null && ((ConstraintType)this.stateMachine.getCurrentStateKey()).isLoadBearing()) {
            this.inverseDynamicsCommandList.addCommand(this.maxWrenchCommand);
            this.inverseDynamicsCommandList.addCommand(this.minWrenchCommand);
        }
        return this.inverseDynamicsCommandList;
    }

    public FeedbackControlCommand<?> getFeedbackControlCommand() {
        return ((AbstractFootControlState)this.stateMachine.getCurrentState()).getFeedbackControlCommand();
    }

    public JointDesiredOutputListReadOnly getJointDesiredData() {
        if (this.ankleControlModule != null) {
            return this.ankleControlModule.getJointDesiredOutputList();
        }
        return null;
    }

    public FeedbackControlCommandList createFeedbackControlTemplate() {
        FeedbackControlCommandList ret = new FeedbackControlCommandList();
        for (ConstraintType constraintType : ConstraintType.values()) {
            AbstractFootControlState state = (AbstractFootControlState)this.stateMachine.getState((Enum)constraintType);
            if (state == null || state.getFeedbackControlCommand() == null) continue;
            ret.addCommand(state.getFeedbackControlCommand());
        }
        return ret;
    }

    public void initializeFootExploration() {
        this.supportState.requestFootholdExploration();
    }

    public boolean isFootToeingOffSlipping() {
        if (this.getCurrentConstraintType() != ConstraintType.TOES) {
            return false;
        }
        if (this.footControlHelper.getToeSlippingDetector() == null) {
            return false;
        }
        return this.footControlHelper.getToeSlippingDetector().isToeSlipping();
    }

    private void requestExploration() {
        if (!this.isInFlatSupportState()) {
            return;
        }
        this.requestExploration.set(false);
        this.initializeFootExploration();
    }

    private void resetFootPolygon() {
        if (!this.isInFlatSupportState()) {
            return;
        }
        this.resetFootPolygon.set(false);
        if (this.footControlHelper.getPartialFootholdControlModule() != null) {
            this.footControlHelper.getPartialFootholdControlModule().reset();
        }
        this.controllerToolbox.resetFootSupportPolygon(this.robotSide);
    }

    public void unload(double percentInUnloading, double rhoMin) {
        if (this.minWrenchCommand == null) {
            return;
        }
        this.minZForce.set((1.0 - percentInUnloading) * this.minWeightFractionPerFoot.getValue() * this.robotWeightFz);
        this.maxZForce.set((1.0 - percentInUnloading) * this.maxWeightFractionPerFoot.getValue() * this.robotWeightFz);
        this.maxZForce.set(Math.max(this.maxZForce.getValue(), this.computeMinZForceBasedOnRhoMin(rhoMin) + 1.0E-5));
        this.updateWrenchCommands();
    }

    private double computeMinZForceBasedOnRhoMin(double rhoMin) {
        YoPlaneContactState contactState = this.controllerToolbox.getFootContactState(this.robotSide);
        contactState.getContactNormalFrameVector(this.normalVector);
        this.normalVector.changeFrame(ReferenceFrame.getWorldFrame());
        this.normalVector.normalize();
        double friction = contactState.getCoefficientOfFriction();
        int points = contactState.getNumberOfContactPointsInContact();
        return this.normalVector.getZ() * rhoMin * (double)this.numberOfBasisVectors * (double)points / Math.sqrt(1.0 + friction * friction);
    }

    public void resetLoadConstraints() {
        if (this.minWrenchCommand == null) {
            return;
        }
        this.minZForce.set(this.minWeightFractionPerFoot.getValue() * this.robotWeightFz);
        this.maxZForce.set(this.maxWeightFractionPerFoot.getValue() * this.robotWeightFz);
        this.updateWrenchCommands();
    }

    private void updateWrenchCommands() {
        this.maxZForce.set(Math.max(this.maxZForce.getValue(), this.minZForce.getValue() + 1.0E-5));
        this.minWrenchCommand.getWrench().setLinearPartZ(this.minZForce.getValue());
        this.maxWrenchCommand.getWrench().setLinearPartZ(this.maxZForce.getValue());
    }

    public Object pollStatusToReport() {
        return ((AbstractFootControlState)this.stateMachine.getCurrentState()).pollStatusToReport();
    }

    public void liftOff(double pitch, double pitchVelocity, double duration) {
        if (this.getCurrentConstraintType() != ConstraintType.FULL) {
            return;
        }
        this.supportState.liftOff(pitch, pitchVelocity, duration);
    }

    public void touchDown(double initialPitch, double initialPitchVelocity, double pitch, double duration) {
        this.supportState.touchDown(initialPitch, initialPitchVelocity, pitch, duration);
    }

    public MultipleWaypointsPoseTrajectoryGenerator getSwingTrajectory() {
        return this.footControlHelper.getSwingTrajectoryCalculator().getSwingTrajectory();
    }

    public static enum ConstraintType {
        FULL,
        TOES,
        SWING,
        MOVE_VIA_WAYPOINTS;


        public boolean isLoadBearing() {
            switch (this) {
                case FULL: 
                case TOES: {
                    return true;
                }
            }
            return false;
        }
    }
}

