/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.foot;

import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.BipedSupportPolygons;
import us.ihmc.commonWalkingControlModules.configurations.ToeOffParameters;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.configurations.YoSwingTrajectoryParameters;
import us.ihmc.commonWalkingControlModules.controlModules.SwingTrajectoryCalculator;
import us.ihmc.commonWalkingControlModules.controlModules.foot.ExplorationParameters;
import us.ihmc.commonWalkingControlModules.controlModules.foot.PartialFootholdControlModule;
import us.ihmc.commonWalkingControlModules.controlModules.foot.SupportStateParameters;
import us.ihmc.commonWalkingControlModules.controlModules.foot.ToeSlippingDetector;
import us.ihmc.commonWalkingControlModules.controlModules.foot.WorkspaceLimiterControlModule;
import us.ihmc.commonWalkingControlModules.controlModules.foot.WorkspaceLimiterParameters;
import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.FootholdRotationParameters;
import us.ihmc.commonWalkingControlModules.momentumBasedController.HighLevelHumanoidControllerToolbox;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.bipedSupportPolygons.ContactableFoot;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.sensors.FootSwitchInterface;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;

public class FootControlHelper {
    private final RobotSide robotSide;
    private final ContactableFoot contactableFoot;
    private final HighLevelHumanoidControllerToolbox controllerToolbox;
    private final WalkingControllerParameters walkingControllerParameters;
    private final PartialFootholdControlModule partialFootholdControlModule;
    private final FrameVector3D fullyConstrainedNormalContactVector;
    private final YoBoolean isDesiredCoPOnEdge;
    private final BipedSupportPolygons bipedSupportPolygons;
    private final WorkspaceLimiterControlModule workspaceLimiterControlModule;
    private final ToeSlippingDetector toeSlippingDetector;
    private final ExplorationParameters explorationParameters;
    private final FootholdRotationParameters footholdRotationParameters;
    private final SupportStateParameters supportStateParameters;
    private final SwingTrajectoryCalculator swingTrajectoryCalculator;
    private final YoSwingTrajectoryParameters swingTrajectoryParameters;
    private final FramePoint2D desiredCoP = new FramePoint2D();

    public FootControlHelper(RobotSide robotSide, WalkingControllerParameters walkingControllerParameters, YoSwingTrajectoryParameters swingTrajectoryParameters, WorkspaceLimiterParameters workspaceLimiterParameters, HighLevelHumanoidControllerToolbox controllerToolbox, ExplorationParameters explorationParameters, FootholdRotationParameters footholdRotationParameters, SupportStateParameters supportStateParameters, YoRegistry registry) {
        this.robotSide = robotSide;
        this.controllerToolbox = controllerToolbox;
        this.walkingControllerParameters = walkingControllerParameters;
        this.explorationParameters = explorationParameters;
        this.footholdRotationParameters = footholdRotationParameters;
        this.supportStateParameters = supportStateParameters;
        this.swingTrajectoryParameters = swingTrajectoryParameters;
        this.swingTrajectoryCalculator = new SwingTrajectoryCalculator(robotSide.getCamelCaseNameForStartOfExpression(), robotSide, controllerToolbox, walkingControllerParameters, swingTrajectoryParameters, registry);
        this.contactableFoot = (ContactableFoot)controllerToolbox.getContactableFeet().get((Enum)robotSide);
        RigidBodyBasics foot = this.contactableFoot.getRigidBody();
        String namePrefix = foot.getName();
        YoGraphicsListRegistry yoGraphicsListRegistry = controllerToolbox.getYoGraphicsListRegistry();
        this.partialFootholdControlModule = walkingControllerParameters.createFootholdExplorationTools() && explorationParameters != null ? new PartialFootholdControlModule(robotSide, controllerToolbox, walkingControllerParameters, explorationParameters, registry, yoGraphicsListRegistry) : null;
        this.isDesiredCoPOnEdge = new YoBoolean(namePrefix + "IsDesiredCoPOnEdge", registry);
        this.fullyConstrainedNormalContactVector = new FrameVector3D(this.contactableFoot.getSoleFrame(), 0.0, 0.0, 1.0);
        this.bipedSupportPolygons = controllerToolbox.getBipedSupportPolygons();
        this.workspaceLimiterControlModule = walkingControllerParameters.enableLegSingularityAndKneeCollapseAvoidanceModule() ? new WorkspaceLimiterControlModule(namePrefix, (ContactablePlaneBody)this.contactableFoot, robotSide, workspaceLimiterParameters, walkingControllerParameters, controllerToolbox, registry) : null;
        if (walkingControllerParameters.enableToeOffSlippingDetection()) {
            double controlDT = controllerToolbox.getControlDT();
            FootSwitchInterface footSwitch = (FootSwitchInterface)controllerToolbox.getFootSwitches().get((Enum)robotSide);
            this.toeSlippingDetector = new ToeSlippingDetector(namePrefix, controlDT, foot, footSwitch, registry);
            this.toeSlippingDetector.configure(walkingControllerParameters.getToeSlippingDetectorParameters());
        } else {
            this.toeSlippingDetector = null;
        }
    }

    public void update() {
        this.controllerToolbox.getDesiredCenterOfPressure((ContactablePlaneBody)this.contactableFoot, this.desiredCoP);
        if (this.desiredCoP.containsNaN()) {
            this.isDesiredCoPOnEdge.set(false);
        } else {
            double epsilon = this.isDesiredCoPOnEdge.getBooleanValue() ? this.supportStateParameters.getCopOnEdgeEpsilonWithHysteresis() : this.supportStateParameters.getCopOnEdgeEpsilon();
            FrameConvexPolygon2DReadOnly footSupportPolygon = this.bipedSupportPolygons.getFootPolygonInSoleFrame(this.robotSide);
            this.isDesiredCoPOnEdge.set(!footSupportPolygon.isPointInside((FramePoint2DReadOnly)this.desiredCoP, -epsilon));
        }
    }

    public boolean isCoPOnEdge() {
        return this.isDesiredCoPOnEdge.getBooleanValue();
    }

    public RobotSide getRobotSide() {
        return this.robotSide;
    }

    public ContactableFoot getContactableFoot() {
        return this.contactableFoot;
    }

    public HighLevelHumanoidControllerToolbox getHighLevelHumanoidControllerToolbox() {
        return this.controllerToolbox;
    }

    public WalkingControllerParameters getWalkingControllerParameters() {
        return this.walkingControllerParameters;
    }

    public ToeOffParameters getToeOffParameters() {
        return this.walkingControllerParameters.getToeOffParameters();
    }

    public PartialFootholdControlModule getPartialFootholdControlModule() {
        return this.partialFootholdControlModule;
    }

    public void setFullyConstrainedNormalContactVector(FrameVector3D normalContactVector) {
        if (normalContactVector != null) {
            this.fullyConstrainedNormalContactVector.setIncludingFrame((FrameTuple3DReadOnly)normalContactVector);
        } else {
            this.fullyConstrainedNormalContactVector.setIncludingFrame(this.contactableFoot.getSoleFrame(), 0.0, 0.0, 1.0);
        }
    }

    public FrameVector3D getFullyConstrainedNormalContactVector() {
        return this.fullyConstrainedNormalContactVector;
    }

    public WorkspaceLimiterControlModule getWorkspaceLimiterControlModule() {
        return this.workspaceLimiterControlModule;
    }

    public ToeSlippingDetector getToeSlippingDetector() {
        return this.toeSlippingDetector;
    }

    public ExplorationParameters getExplorationParameters() {
        return this.explorationParameters;
    }

    public FootholdRotationParameters getFootholdRotationParameters() {
        return this.footholdRotationParameters;
    }

    public SupportStateParameters getSupportStateParameters() {
        return this.supportStateParameters;
    }

    public YoSwingTrajectoryParameters getSwingTrajectoryParameters() {
        return this.swingTrajectoryParameters;
    }

    public SwingTrajectoryCalculator getSwingTrajectoryCalculator() {
        return this.swingTrajectoryCalculator;
    }
}

