/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules;

import java.util.List;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex2DSupplier;
import us.ihmc.humanoidRobotics.footstep.Footstep;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class WalkingFailureDetectionControlModule {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final FrameConvexPolygon2D combinedFootPolygon = new FrameConvexPolygon2D();
    private final FrameConvexPolygon2D combinedFootPolygonWithNextFootstep = new FrameConvexPolygon2D();
    private final SideDependentList<FrameConvexPolygon2D> footPolygons = new SideDependentList();
    private final FrameConvexPolygon2D nextFootstepPolygon = new FrameConvexPolygon2D();
    private final SideDependentList<FrameConvexPolygon2D> footPolygonsInWorldFrame = new SideDependentList();
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoBoolean isUsingNextFootstep;
    private final YoBoolean isFallDetectionActivated;
    private final YoDouble icpDistanceFromFootPolygon;
    private final YoDouble icpDistanceFromFootPolygonThreshold;
    private final YoBoolean isRobotFalling;
    private final FrameVector2D fallingDirection2D = new FrameVector2D();
    private final FrameVector3D fallingDirection3D = new FrameVector3D();
    private final FrameVector2D tempFallingDirection = new FrameVector2D();

    public WalkingFailureDetectionControlModule(SideDependentList<? extends ContactablePlaneBody> contactableFeet, YoRegistry parentRegistry) {
        for (RobotSide robotSide : RobotSide.values) {
            FrameConvexPolygon2D footPolygonInFootFrame = new FrameConvexPolygon2D(FrameVertex2DSupplier.asFrameVertex2DSupplier((List)((ContactablePlaneBody)contactableFeet.get((Enum)robotSide)).getContactPoints2d()));
            this.footPolygons.put((Enum)robotSide, (Object)footPolygonInFootFrame);
            FrameConvexPolygon2D footPolygonInWorldFrame = new FrameConvexPolygon2D();
            this.footPolygonsInWorldFrame.put((Enum)robotSide, (Object)footPolygonInWorldFrame);
        }
        this.nextFootstepPolygon.setIncludingFrame((FrameVertex2DSupplier)this.footPolygons.get((Enum)RobotSide.LEFT));
        this.isUsingNextFootstep = new YoBoolean("isFallDetectionUsingNextFootstep", this.registry);
        this.isUsingNextFootstep.set(false);
        this.updateCombinedPolygon();
        this.isFallDetectionActivated = new YoBoolean("isFallDetectionActivated", this.registry);
        this.isFallDetectionActivated.set(true);
        this.icpDistanceFromFootPolygonThreshold = new YoDouble("icpDistanceFromFootPolygonThreshold", this.registry);
        this.icpDistanceFromFootPolygonThreshold.set(0.05);
        this.icpDistanceFromFootPolygon = new YoDouble("icpDistanceFromFootPolygon", this.registry);
        this.isRobotFalling = new YoBoolean("isRobotFalling", this.registry);
        parentRegistry.addChild(this.registry);
    }

    private void updateCombinedPolygon() {
        for (RobotSide robotSide : RobotSide.values) {
            FrameConvexPolygon2D footPolygonInWorldFrame = (FrameConvexPolygon2D)this.footPolygonsInWorldFrame.get((Enum)robotSide);
            footPolygonInWorldFrame.setIncludingFrame((FrameVertex2DSupplier)this.footPolygons.get((Enum)robotSide));
            footPolygonInWorldFrame.changeFrameAndProjectToXYPlane(worldFrame);
        }
        this.combinedFootPolygon.setIncludingFrame((FrameVertex2DSupplier)this.footPolygonsInWorldFrame.get((Enum)RobotSide.LEFT), (FrameVertex2DSupplier)this.footPolygonsInWorldFrame.get((Enum)RobotSide.RIGHT));
        if (this.isUsingNextFootstep.getBooleanValue()) {
            this.combinedFootPolygonWithNextFootstep.setIncludingFrame((FrameVertex2DSupplier)this.combinedFootPolygon, (FrameVertex2DSupplier)this.nextFootstepPolygon);
        }
    }

    public void setNextFootstep(Footstep nextFootstep) {
        this.isUsingNextFootstep.set(nextFootstep != null);
        if (this.isUsingNextFootstep.getBooleanValue()) {
            ReferenceFrame footstepSoleFrame = nextFootstep.getSoleReferenceFrame();
            this.nextFootstepPolygon.setIncludingFrame(footstepSoleFrame, (Vertex2DSupplier)this.footPolygons.get((Enum)nextFootstep.getRobotSide()));
            this.nextFootstepPolygon.changeFrameAndProjectToXYPlane(worldFrame);
        }
    }

    public void checkIfRobotIsFalling(FramePoint2DReadOnly capturePoint2d, FramePoint2DReadOnly desiredCapturePoint2d) {
        this.updateCombinedPolygon();
        if (this.isUsingNextFootstep.getBooleanValue()) {
            this.icpDistanceFromFootPolygon.set(this.combinedFootPolygonWithNextFootstep.distance(capturePoint2d));
        } else {
            this.icpDistanceFromFootPolygon.set(this.combinedFootPolygon.distance(capturePoint2d));
        }
        boolean isCapturePointCloseToFootPolygon = this.icpDistanceFromFootPolygon.getDoubleValue() < this.icpDistanceFromFootPolygonThreshold.getDoubleValue();
        boolean isCapturePointCloseToDesiredCapturePoint = desiredCapturePoint2d.distance(capturePoint2d) < this.icpDistanceFromFootPolygonThreshold.getDoubleValue();
        this.isRobotFalling.set(!isCapturePointCloseToFootPolygon && !isCapturePointCloseToDesiredCapturePoint);
        if (this.isRobotFalling.getBooleanValue()) {
            this.tempFallingDirection.set((FrameTuple2DReadOnly)capturePoint2d);
            FramePoint2DReadOnly footCenter = this.combinedFootPolygon.getCentroid();
            this.tempFallingDirection.changeFrame(ReferenceFrame.getWorldFrame());
            this.tempFallingDirection.sub((FrameTuple2DReadOnly)footCenter);
            this.fallingDirection2D.set(this.tempFallingDirection);
            this.fallingDirection3D.setIncludingFrame((FrameTuple2DReadOnly)this.fallingDirection2D, 0.0);
        }
    }

    public boolean isRobotFalling() {
        if (!this.isFallDetectionActivated.getBooleanValue()) {
            return false;
        }
        return this.isRobotFalling.getBooleanValue();
    }

    public FrameVector2D getFallingDirection2D() {
        return this.fallingDirection2D;
    }

    public FrameVector3D getFallingDirection3D() {
        return this.fallingDirection3D;
    }

    public FrameConvexPolygon2D getCombinedFootPolygon() {
        return this.combinedFootPolygon;
    }

    public FrameConvexPolygon2DReadOnly getCombinedFootPolygonWithNextFootstep() {
        return this.combinedFootPolygonWithNextFootstep;
    }
}

