/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules;

import controller_msgs.msg.dds.TaskspaceTrajectoryStatusMessage;
import us.ihmc.commonWalkingControlModules.controlModules.TrajectoryStatusMessageHelper;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.OrientationFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.PointFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.SpatialFeedbackControlCommand;
import us.ihmc.communication.packets.ExecutionMode;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePose3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.EuclideanTrajectoryControllerCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.SE3TrajectoryControllerCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.SO3TrajectoryControllerCommand;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;

public class TaskspaceTrajectoryStatusMessageHelper
extends TrajectoryStatusMessageHelper<TaskspaceTrajectoryStatusMessage> {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final TaskspaceTrajectoryStatusMessage statusMessage = new TaskspaceTrajectoryStatusMessage();
    private final FixedFramePose3DBasics controlFramePose = new FramePose3D(worldFrame);
    private final FixedFramePose3DBasics desiredPose = new FramePose3D(worldFrame);

    public TaskspaceTrajectoryStatusMessageHelper(RigidBodyReadOnly endEffector) {
        this.statusMessage.getEndEffectorName().append(endEffector.getName());
    }

    public TaskspaceTrajectoryStatusMessageHelper(String endEffectorName) {
        this.statusMessage.getEndEffectorName().append(endEffectorName);
        this.clear();
    }

    @Override
    public void clear() {
        super.clear();
        this.controlFramePose.setToNaN();
        this.desiredPose.setToNaN();
        this.statusMessage.getActualEndEffectorOrientation().setToNaN();
        this.statusMessage.getActualEndEffectorPosition().setToNaN();
        this.statusMessage.getDesiredEndEffectorOrientation().setToNaN();
        this.statusMessage.getDesiredEndEffectorPosition().setToNaN();
    }

    public void registerNewTrajectory(SE3TrajectoryControllerCommand command) {
        if (command.getExecutionMode() == ExecutionMode.OVERRIDE) {
            this.clear();
            this.registerNewTrajectory(command.getSequenceId(), 0.0, command.getLastTrajectoryPoint().getTime());
        } else {
            this.registerNewTrajectory(command.getSequenceId(), command.getTrajectoryPoint(0).getTime(), command.getLastTrajectoryPoint().getTime());
        }
    }

    public void registerNewTrajectory(SO3TrajectoryControllerCommand command) {
        if (command.getExecutionMode() == ExecutionMode.OVERRIDE) {
            this.clear();
            this.registerNewTrajectory(command.getSequenceId(), 0.0, command.getLastTrajectoryPoint().getTime());
        } else {
            this.registerNewTrajectory(command.getSequenceId(), command.getTrajectoryPoint(0).getTime(), command.getLastTrajectoryPoint().getTime());
        }
    }

    public void registerNewTrajectory(EuclideanTrajectoryControllerCommand command) {
        if (command.getExecutionMode() == ExecutionMode.OVERRIDE) {
            this.clear();
            this.registerNewTrajectory(command.getSequenceId(), 0.0, command.getLastTrajectoryPoint().getTime());
        } else {
            this.registerNewTrajectory(command.getSequenceId(), command.getTrajectoryPoint(0).getTime(), command.getLastTrajectoryPoint().getTime());
        }
    }

    public TaskspaceTrajectoryStatusMessage pollStatusMessage(SpatialFeedbackControlCommand feedbackControlCommand) {
        TrajectoryStatusMessageHelper.TrajectoryStatus currentStatus = this.pollStatus();
        if (currentStatus == null) {
            return null;
        }
        this.updateStatusCommonInfo(currentStatus);
        this.updateStatusInfo(feedbackControlCommand);
        return this.statusMessage;
    }

    public TaskspaceTrajectoryStatusMessage pollStatusMessage(OrientationFeedbackControlCommand feedbackControlCommand) {
        TrajectoryStatusMessageHelper.TrajectoryStatus currentStatus = this.pollStatus();
        if (currentStatus == null) {
            return null;
        }
        this.updateStatusCommonInfo(currentStatus);
        this.updateStatusInfo(feedbackControlCommand);
        return this.statusMessage;
    }

    public TaskspaceTrajectoryStatusMessage pollStatusMessage(PointFeedbackControlCommand feedbackControlCommand) {
        TrajectoryStatusMessageHelper.TrajectoryStatus currentStatus = this.pollStatus();
        if (currentStatus == null) {
            return null;
        }
        this.updateStatusCommonInfo(currentStatus);
        this.updateStatusInfo(feedbackControlCommand);
        return this.statusMessage;
    }

    public TaskspaceTrajectoryStatusMessage pollStatusMessage(FramePoint2DReadOnly desiredPositionInWorld, FramePoint2DReadOnly actualPositionInWorld) {
        TrajectoryStatusMessageHelper.TrajectoryStatus currentStatus = this.pollStatus();
        if (currentStatus == null) {
            return null;
        }
        this.updateStatusCommonInfo(currentStatus);
        desiredPositionInWorld.checkReferenceFrameMatch(worldFrame);
        actualPositionInWorld.checkReferenceFrameMatch(worldFrame);
        this.updateStatusInfo((Point2DReadOnly)desiredPositionInWorld, (Point2DReadOnly)actualPositionInWorld);
        return this.statusMessage;
    }

    public TaskspaceTrajectoryStatusMessage pollStatusMessage(FramePoint3DReadOnly desiredPositionInWorld, FramePoint3DReadOnly actualPositionInWorld) {
        TrajectoryStatusMessageHelper.TrajectoryStatus currentStatus = this.pollStatus();
        if (currentStatus == null) {
            return null;
        }
        this.updateStatusCommonInfo(currentStatus);
        desiredPositionInWorld.checkReferenceFrameMatch(worldFrame);
        actualPositionInWorld.checkReferenceFrameMatch(worldFrame);
        this.updateStatusInfo((Point3DReadOnly)desiredPositionInWorld, (Point3DReadOnly)actualPositionInWorld);
        return this.statusMessage;
    }

    private void updateStatusCommonInfo(TrajectoryStatusMessageHelper.TrajectoryStatus currentStatus) {
        this.statusMessage.setSequenceId(currentStatus.getSequenceID());
        this.statusMessage.setTimestamp(currentStatus.getTimeInTrajectory());
        this.statusMessage.setTrajectoryExecutionStatus(currentStatus.getStatus().toByte());
    }

    private void updateStatusInfo(SpatialFeedbackControlCommand feedbackControlCommand) {
        this.controlFramePose.setMatchingFrame((FramePose3DReadOnly)feedbackControlCommand.getControlFramePose());
        this.desiredPose.getOrientation().setMatchingFrame((FrameQuaternionReadOnly)feedbackControlCommand.getReferenceOrientation());
        this.desiredPose.getPosition().setMatchingFrame((FrameTuple3DReadOnly)feedbackControlCommand.getReferencePosition());
        this.updateStatusInfo((Pose3DReadOnly)this.desiredPose, (Pose3DReadOnly)this.controlFramePose);
    }

    private void updateStatusInfo(OrientationFeedbackControlCommand feedbackControlCommand) {
        this.controlFramePose.getOrientation().setMatchingFrame((FrameQuaternionReadOnly)feedbackControlCommand.getBodyFixedOrientationToControl());
        this.controlFramePose.getPosition().setToNaN();
        this.desiredPose.getOrientation().setMatchingFrame((FrameQuaternionReadOnly)feedbackControlCommand.getReferenceOrientation());
        this.desiredPose.getPosition().setToNaN();
        this.updateStatusInfo((Pose3DReadOnly)this.desiredPose, (Pose3DReadOnly)this.controlFramePose);
    }

    private void updateStatusInfo(PointFeedbackControlCommand feedbackControlCommand) {
        this.controlFramePose.getOrientation().setToNaN();
        this.controlFramePose.getPosition().setMatchingFrame((FrameTuple3DReadOnly)feedbackControlCommand.getBodyFixedPointToControl());
        this.desiredPose.getOrientation().setToNaN();
        this.desiredPose.getPosition().setMatchingFrame((FrameTuple3DReadOnly)feedbackControlCommand.getReferencePosition());
        this.updateStatusInfo((Pose3DReadOnly)this.desiredPose, (Pose3DReadOnly)this.controlFramePose);
    }

    private void updateStatusInfo(Point2DReadOnly desiredPosition, Point2DReadOnly actualPosition) {
        this.statusMessage.getDesiredEndEffectorOrientation().setToNaN();
        this.statusMessage.getDesiredEndEffectorPosition().set((Tuple2DReadOnly)desiredPosition, Double.NaN);
        this.statusMessage.getActualEndEffectorOrientation().setToNaN();
        this.statusMessage.getActualEndEffectorPosition().set((Tuple2DReadOnly)actualPosition, Double.NaN);
    }

    private void updateStatusInfo(Point3DReadOnly desiredPosition, Point3DReadOnly actualPosition) {
        this.statusMessage.getDesiredEndEffectorOrientation().setToNaN();
        this.statusMessage.getDesiredEndEffectorPosition().set((Tuple3DReadOnly)desiredPosition);
        this.statusMessage.getActualEndEffectorOrientation().setToNaN();
        this.statusMessage.getActualEndEffectorPosition().set((Tuple3DReadOnly)actualPosition);
    }

    private void updateStatusInfo(Pose3DReadOnly desiredPose, Pose3DReadOnly actualPose) {
        this.statusMessage.getDesiredEndEffectorOrientation().set(desiredPose.getOrientation());
        this.statusMessage.getDesiredEndEffectorPosition().set((Tuple3DReadOnly)desiredPose.getPosition());
        this.statusMessage.getActualEndEffectorOrientation().set(actualPose.getOrientation());
        this.statusMessage.getActualEndEffectorPosition().set((Tuple3DReadOnly)actualPose.getPosition());
    }
}

