/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules;

import controller_msgs.msg.dds.JointspaceTrajectoryStatusMessage;
import us.ihmc.commonWalkingControlModules.controlModules.TrajectoryStatusMessageHelper;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.JointspaceFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.OneDoFJointFeedbackControlCommand;
import us.ihmc.communication.packets.ExecutionMode;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.JointspaceTrajectoryCommand;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;

public class JointspaceTrajectoryStatusMessageHelper
extends TrajectoryStatusMessageHelper<JointspaceTrajectoryStatusMessage> {
    private final JointspaceTrajectoryStatusMessage statusMessage = new JointspaceTrajectoryStatusMessage();

    public JointspaceTrajectoryStatusMessageHelper(OneDoFJointReadOnly[] joints) {
        for (OneDoFJointReadOnly joint : joints) {
            this.statusMessage.getJointNames().add(joint.getName());
            this.statusMessage.getActualJointPositions().add(Double.NaN);
            this.statusMessage.getDesiredJointPositions().add(Double.NaN);
        }
        this.clear();
    }

    @Override
    public void clear() {
        super.clear();
        for (int jointIndex = 0; jointIndex < this.statusMessage.getDesiredJointPositions().size(); ++jointIndex) {
            this.statusMessage.getActualJointPositions().set(jointIndex, Double.NaN);
            this.statusMessage.getDesiredJointPositions().set(jointIndex, Double.NaN);
        }
    }

    public void registerNewTrajectory(JointspaceTrajectoryCommand command) {
        if (command.getExecutionMode() == ExecutionMode.OVERRIDE) {
            this.clear();
            this.registerNewTrajectory(command.getSequenceId(), 0.0, command.getTrajectoryEndTime());
        } else {
            this.registerNewTrajectory(command.getSequenceId(), command.getTrajectoryStartTime(), command.getTrajectoryEndTime());
        }
    }

    public JointspaceTrajectoryStatusMessage pollStatusMessage(JointspaceFeedbackControlCommand feedbackControlCommand) {
        TrajectoryStatusMessageHelper.TrajectoryStatus currentStatus = this.pollStatus();
        if (currentStatus == null) {
            return null;
        }
        this.statusMessage.setSequenceId(currentStatus.getSequenceID());
        this.statusMessage.setTimestamp(currentStatus.getTimeInTrajectory());
        this.statusMessage.setTrajectoryExecutionStatus(currentStatus.getStatus().toByte());
        this.updateStatusInfo(feedbackControlCommand);
        return this.statusMessage;
    }

    private void updateStatusInfo(JointspaceFeedbackControlCommand feedbackControlCommand) {
        for (int jointIndex = 0; jointIndex < feedbackControlCommand.getNumberOfJoints(); ++jointIndex) {
            OneDoFJointFeedbackControlCommand jointCommand = feedbackControlCommand.getJointCommand(jointIndex);
            double qCurrent = jointCommand.getJoint().getQ();
            double qDesired = jointCommand.getReferencePosition();
            this.statusMessage.getActualJointPositions().set(jointIndex, qCurrent);
            this.statusMessage.getDesiredJointPositions().set(jointIndex, qDesired);
        }
    }
}

