/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.contact.particleFilter;

import org.ejml.data.DMatrixRMaj;
import us.ihmc.commonWalkingControlModules.contact.particleFilter.ExternalForceEstimationTools;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotics.screwTheory.GeometricJacobian;
import us.ihmc.robotics.screwTheory.PointJacobian;

public class PredefinedContactPoint {
    private final RigidBodyBasics rigidBody;
    private final Vector3D contactPointOffset = new Vector3D();
    private final ReferenceFrame contactPointFrame;
    private final GeometricJacobian contactPointJacobian;
    private final boolean assumeZeroTorque;
    private final int numberOfDecisionVariables;
    private final PointJacobian pointJacobian = new PointJacobian();
    private final int[] indexMap;
    private final FramePoint3D tempPoint = new FramePoint3D();

    public PredefinedContactPoint(JointBasics[] orderedJoints, final RigidBodyBasics rigidBody, boolean assumeZeroTorque) {
        this.rigidBody = rigidBody;
        this.assumeZeroTorque = assumeZeroTorque;
        this.numberOfDecisionVariables = assumeZeroTorque ? 3 : 6;
        RigidBodyBasics baseLink = orderedJoints[0].getPredecessor();
        this.contactPointJacobian = new GeometricJacobian(baseLink, rigidBody, (ReferenceFrame)baseLink.getBodyFixedFrame());
        this.contactPointFrame = new ReferenceFrame(rigidBody.getName() + "ContactFrame", ReferenceFrame.getWorldFrame()){

            protected void updateTransformToParent(RigidBodyTransform transformToParent) {
                PredefinedContactPoint.this.tempPoint.setIncludingFrame((ReferenceFrame)rigidBody.getParentJoint().getFrameAfterJoint(), (Tuple3DReadOnly)PredefinedContactPoint.this.contactPointOffset);
                PredefinedContactPoint.this.tempPoint.changeFrame(ReferenceFrame.getWorldFrame());
                transformToParent.setTranslationAndIdentityRotation((Tuple3DReadOnly)PredefinedContactPoint.this.tempPoint);
            }
        };
        this.contactPointJacobian.changeFrame(this.contactPointFrame);
        this.indexMap = ExternalForceEstimationTools.createIndexMap(this.contactPointJacobian, orderedJoints);
    }

    public DMatrixRMaj computeContactJacobian() {
        if (this.assumeZeroTorque) {
            ReferenceFrame baseFrame = this.contactPointJacobian.getBaseFrame();
            this.contactPointJacobian.changeFrame(baseFrame);
            this.contactPointJacobian.compute();
            this.tempPoint.setIncludingFrame((ReferenceFrame)this.rigidBody.getParentJoint().getFrameAfterJoint(), (Tuple3DReadOnly)this.contactPointOffset);
            this.pointJacobian.set(this.contactPointJacobian, this.tempPoint);
            this.pointJacobian.compute();
            return this.pointJacobian.getJacobianMatrix();
        }
        this.contactPointFrame.update();
        this.contactPointJacobian.compute();
        return this.contactPointJacobian.getJacobianMatrix();
    }

    public void setContactPointOffset(Tuple3DReadOnly contactPointPosition) {
        this.contactPointOffset.set(contactPointPosition);
    }

    public boolean getAssumeZeroTorque() {
        return this.assumeZeroTorque;
    }

    public int getNumberOfDecisionVariables() {
        return this.numberOfDecisionVariables;
    }

    public Tuple3DReadOnly getContactPointOffset() {
        return this.contactPointOffset;
    }

    public RigidBodyBasics getRigidBody() {
        return this.rigidBody;
    }

    public int getSystemJacobianIndex(int contactPointJacobianIndex) {
        return this.indexMap[contactPointJacobianIndex];
    }
}

