/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.contact.particleFilter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.contact.particleFilter.ExternalTorqueEstimator;
import us.ihmc.commonWalkingControlModules.contact.particleFilter.ExternalTorqueEstimatorInterface;
import us.ihmc.commonWalkingControlModules.contact.particleFilter.ForceEstimatorDynamicMatrixUpdater;
import us.ihmc.commonWalkingControlModules.contact.particleFilter.PredefinedContactPoint;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicVector;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.yoVariables.spatial.YoFixedFrameSpatialVector;
import us.ihmc.robotics.functionApproximation.DampedLeastSquaresSolver;
import us.ihmc.simulationconstructionset.util.RobotController;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class PredefinedContactExternalForceSolver
implements RobotController {
    public static final double forceGraphicScale = 0.035;
    private static final int maximumNumberOfContactPoints = 10;
    private static final boolean useDiscreteTimeFilter = false;
    private final String name = this.getClass().getSimpleName();
    private final YoRegistry registry = new YoRegistry(this.name);
    private final YoBoolean firstTick = new YoBoolean("firstTick", this.registry);
    private final YoDouble solverAlpha = new YoDouble("solverAlpha", this.registry);
    private final JointBasics[] joints;
    private final int dofs;
    private final List<PredefinedContactPoint> contactPoints = new ArrayList<PredefinedContactPoint>();
    private final ExternalTorqueEstimatorInterface externalTorqueEstimator;
    private final YoFixedFrameSpatialVector[] estimatedExternalWrenches = new YoFixedFrameSpatialVector[10];
    private final YoFramePoint3D[] contactPointPositions = new YoFramePoint3D[10];
    private DMatrixRMaj externalWrenchJacobian;
    private DMatrixRMaj externalWrenchJacobianTranspose;
    private DMatrixRMaj estimatedExternalWrenchMatrix;
    private DampedLeastSquaresSolver forceEstimateSolver;
    private final FramePoint3D tempPoint = new FramePoint3D();

    public PredefinedContactExternalForceSolver(JointBasics[] joints, double dt, ForceEstimatorDynamicMatrixUpdater dynamicMatrixUpdater, YoGraphicsListRegistry graphicsListRegistry, YoRegistry parentRegistry) {
        this.solverAlpha.set(0.001);
        this.joints = joints;
        this.firstTick.set(true);
        this.dofs = Arrays.stream(joints).mapToInt(JointReadOnly::getDegreesOfFreedom).sum();
        this.externalTorqueEstimator = new ExternalTorqueEstimator(joints, dt, dynamicMatrixUpdater, this.registry);
        for (int i = 0; i < 10; ++i) {
            this.estimatedExternalWrenches[i] = new YoFixedFrameSpatialVector("estimatedExternalWrench" + i, ReferenceFrame.getWorldFrame(), this.registry);
            this.contactPointPositions[i] = new YoFramePoint3D("contactPoint" + i, ReferenceFrame.getWorldFrame(), this.registry);
            if (graphicsListRegistry == null) continue;
            YoGraphicVector forceGraphic = new YoGraphicVector("estimatedForceGraphic" + i, this.contactPointPositions[i], this.estimatedExternalWrenches[i].getLinearPart(), 0.035);
            graphicsListRegistry.registerYoGraphic(this.name, (YoGraphic)forceGraphic);
        }
        if (parentRegistry != null) {
            parentRegistry.addChild(this.registry);
        }
    }

    public void addContactPoint(RigidBodyBasics rigidBody, Tuple3DReadOnly contactPointOffset, boolean assumeZeroTorque) {
        if (this.contactPoints.size() == 10) {
            throw new RuntimeException("The maximum number of contact points (10) has been reached. Increase to add more points");
        }
        PredefinedContactPoint contactPoint = new PredefinedContactPoint(this.joints, rigidBody, assumeZeroTorque);
        contactPoint.setContactPointOffset(contactPointOffset);
        this.contactPoints.add(contactPoint);
    }

    public void clearContactPoints() {
        this.contactPoints.clear();
    }

    public void initialize() {
        for (int i = 0; i < 10; ++i) {
            this.estimatedExternalWrenches[i].setToNaN();
            this.contactPointPositions[i].setToNaN();
        }
        int decisionVariables = this.contactPoints.stream().mapToInt(PredefinedContactPoint::getNumberOfDecisionVariables).sum();
        this.externalWrenchJacobian = new DMatrixRMaj(decisionVariables, this.dofs);
        this.externalWrenchJacobianTranspose = new DMatrixRMaj(this.dofs, decisionVariables);
        this.estimatedExternalWrenchMatrix = new DMatrixRMaj(decisionVariables, 1);
        this.forceEstimateSolver = new DampedLeastSquaresSolver(this.dofs, this.solverAlpha.getDoubleValue());
        this.externalTorqueEstimator.initialize();
    }

    public void doControl() {
        if (this.firstTick.getValue()) {
            this.initialize();
            this.firstTick.set(false);
        }
        this.externalTorqueEstimator.doControl();
        CommonOps_DDRM.fill((DMatrixD1)this.externalWrenchJacobian, (double)0.0);
        for (int i = 0; i < this.contactPoints.size(); ++i) {
            PredefinedContactPoint forceEstimatorContactPoint = this.contactPoints.get(i);
            int numberOfRows = forceEstimatorContactPoint.getNumberOfDecisionVariables();
            int rowOffset = IntStream.range(0, i).map(index -> this.contactPoints.get(index).getNumberOfDecisionVariables()).sum();
            DMatrixRMaj contactJacobianMatrix = forceEstimatorContactPoint.computeContactJacobian();
            for (int j = 0; j < contactJacobianMatrix.getNumCols(); ++j) {
                int column = forceEstimatorContactPoint.getSystemJacobianIndex(j);
                MatrixTools.setMatrixBlock((DMatrix)this.externalWrenchJacobian, (int)rowOffset, (int)column, (DMatrix)contactJacobianMatrix, (int)0, (int)j, (int)numberOfRows, (int)1, (double)1.0);
            }
        }
        DMatrixRMaj observedExternalJointTorque = this.externalTorqueEstimator.getEstimatedExternalTorque();
        CommonOps_DDRM.transpose((DMatrixRMaj)this.externalWrenchJacobian, (DMatrixRMaj)this.externalWrenchJacobianTranspose);
        this.forceEstimateSolver.setA(this.externalWrenchJacobianTranspose);
        this.forceEstimateSolver.solve(observedExternalJointTorque, this.estimatedExternalWrenchMatrix);
        for (int i = 0; i < this.contactPoints.size(); ++i) {
            int rowOffset = IntStream.range(0, i).map(index -> this.contactPoints.get(index).getNumberOfDecisionVariables()).sum();
            if (this.contactPoints.get(i).getAssumeZeroTorque()) {
                this.estimatedExternalWrenches[i].getAngularPart().setToZero();
                this.estimatedExternalWrenches[i].getLinearPart().set(rowOffset, (DMatrix)this.estimatedExternalWrenchMatrix);
            } else {
                this.estimatedExternalWrenches[i].set(rowOffset, (DMatrix)this.estimatedExternalWrenchMatrix);
            }
            this.tempPoint.setIncludingFrame((ReferenceFrame)this.contactPoints.get(i).getRigidBody().getParentJoint().getFrameAfterJoint(), this.contactPoints.get(i).getContactPointOffset());
            this.tempPoint.changeFrame(ReferenceFrame.getWorldFrame());
            this.contactPointPositions[i].set((FrameTuple3DReadOnly)this.tempPoint);
        }
    }

    public YoRegistry getYoRegistry() {
        return this.registry;
    }

    public YoFixedFrameSpatialVector[] getEstimatedExternalWrenches() {
        return this.estimatedExternalWrenches;
    }

    public int getNumberOfContactPoints() {
        return this.contactPoints.size();
    }

    public void setSolverAlpha(double alpha) {
        this.solverAlpha.set(alpha);
    }

    public void setEstimatorGain(double estimatorGain) {
        this.externalTorqueEstimator.setEstimatorGain(estimatorGain);
    }
}

