/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.contact.particleFilter;

import java.util.Arrays;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.contact.particleFilter.ExternalTorqueEstimatorInterface;
import us.ihmc.commonWalkingControlModules.contact.particleFilter.ForceEstimatorDynamicMatrixUpdater;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class DiscreteTimeExternalTorqueEstimator
implements ExternalTorqueEstimatorInterface {
    private final String name = this.getClass().getSimpleName();
    private final YoRegistry registry = new YoRegistry(this.name);
    private final YoBoolean requestInitialize = new YoBoolean("requestInitialize", this.registry);
    private final double dt;
    private final YoDouble discreteTimeGain = new YoDouble("discreteTimeFilterGain", this.registry);
    private final YoDouble beta = new YoDouble("discreteTimeMomentumGain", this.registry);
    private final JointBasics[] joints;
    private final int dofs;
    private final DMatrixRMaj tau;
    private final DMatrixRMaj qd;
    private final DMatrixRMaj massMatrix;
    private final DMatrixRMaj massMatrixPrev;
    private final DMatrixRMaj massMatrixDot;
    private final DMatrixRMaj hqd;
    private final DMatrixRMaj hdqd;
    private final DMatrixRMaj coriolisGravityTerm;
    private final DMatrixRMaj estimatedExternalTorque;
    private final DMatrixRMaj sampledFilterValue;
    private final DMatrixRMaj runningFilteredValue;
    private final ForceEstimatorDynamicMatrixUpdater dynamicMatrixUpdater;
    private final YoDouble[] yoObservedExternalJointTorque;
    private final YoDouble[] yoSimulatedTorqueSensingError;
    private boolean firstTick = true;

    public DiscreteTimeExternalTorqueEstimator(JointBasics[] joints, double dt, ForceEstimatorDynamicMatrixUpdater dynamicMatrixUpdater, YoRegistry parentRegistry) {
        this.joints = joints;
        this.dt = dt;
        this.dynamicMatrixUpdater = dynamicMatrixUpdater;
        this.dofs = Arrays.stream(joints).mapToInt(JointReadOnly::getDegreesOfFreedom).sum();
        this.tau = new DMatrixRMaj(this.dofs, 1);
        this.qd = new DMatrixRMaj(this.dofs, 1);
        this.coriolisGravityTerm = new DMatrixRMaj(this.dofs, 1);
        this.hqd = new DMatrixRMaj(this.dofs, 1);
        this.hdqd = new DMatrixRMaj(this.dofs, 1);
        this.massMatrix = new DMatrixRMaj(this.dofs, this.dofs);
        this.massMatrixPrev = new DMatrixRMaj(this.dofs, this.dofs);
        this.massMatrixDot = new DMatrixRMaj(this.dofs, this.dofs);
        this.sampledFilterValue = new DMatrixRMaj(this.dofs, 1);
        this.runningFilteredValue = new DMatrixRMaj(this.dofs, 1);
        this.estimatedExternalTorque = new DMatrixRMaj(this.dofs, 1);
        this.yoObservedExternalJointTorque = new YoDouble[this.dofs];
        this.yoSimulatedTorqueSensingError = new YoDouble[this.dofs];
        this.discreteTimeGain.set(DiscreteTimeExternalTorqueEstimator.computeDiscreteTimeGain(0.7, dt));
        this.beta.set(DiscreteTimeExternalTorqueEstimator.computeMomentumGain(this.discreteTimeGain.getValue(), dt));
        for (int i = 0; i < this.dofs; ++i) {
            String nameSuffix = joints[i].getName();
            this.yoObservedExternalJointTorque[i] = new YoDouble("estimatedExternalTau_" + nameSuffix, this.registry);
            this.yoSimulatedTorqueSensingError[i] = new YoDouble("simulatedTauSensorError_" + nameSuffix, this.registry);
        }
        if (parentRegistry != null) {
            parentRegistry.addChild(this.registry);
        }
    }

    private static double computeDiscreteTimeGain(double continuousTimeGain, double dt) {
        return Math.exp(-continuousTimeGain * dt);
    }

    private static double computeMomentumGain(double discreteTimeGain, double dt) {
        return (1.0 - discreteTimeGain) / (discreteTimeGain * dt);
    }

    public void initialize() {
        this.firstTick = true;
        CommonOps_DDRM.fill((DMatrixD1)this.estimatedExternalTorque, (double)0.0);
        CommonOps_DDRM.fill((DMatrixD1)this.runningFilteredValue, (double)0.0);
    }

    public void doControl() {
        int i;
        if (this.requestInitialize.getValue()) {
            this.initialize();
            this.requestInitialize.set(false);
        }
        this.massMatrixPrev.set((DMatrixD1)this.massMatrix);
        this.dynamicMatrixUpdater.update(this.massMatrix, this.coriolisGravityTerm, this.tau);
        MultiBodySystemTools.extractJointsState((JointReadOnly[])this.joints, (JointStateType)JointStateType.VELOCITY, (DMatrix)this.qd);
        if (this.firstTick) {
            this.firstTick = false;
        } else {
            CommonOps_DDRM.subtract((DMatrixD1)this.massMatrix, (DMatrixD1)this.massMatrixPrev, (DMatrixD1)this.massMatrixDot);
            CommonOps_DDRM.scale((double)(1.0 / this.dt), (DMatrixD1)this.massMatrixDot);
        }
        for (i = 0; i < this.dofs; ++i) {
            this.tau.set(i, 0, this.tau.get(i, 0) - this.yoSimulatedTorqueSensingError[i].getValue());
        }
        CommonOps_DDRM.mult((DMatrix1Row)this.massMatrix, (DMatrix1Row)this.qd, (DMatrix1Row)this.hqd);
        CommonOps_DDRM.mult((DMatrix1Row)this.massMatrixDot, (DMatrix1Row)this.qd, (DMatrix1Row)this.hdqd);
        this.sampledFilterValue.set((DMatrixD1)this.hqd);
        CommonOps_DDRM.scale((double)this.beta.getValue(), (DMatrixD1)this.sampledFilterValue);
        CommonOps_DDRM.addEquals((DMatrixD1)this.sampledFilterValue, (DMatrixD1)this.tau);
        CommonOps_DDRM.subtractEquals((DMatrixD1)this.sampledFilterValue, (DMatrixD1)this.coriolisGravityTerm);
        CommonOps_DDRM.addEquals((DMatrixD1)this.sampledFilterValue, (DMatrixD1)this.hdqd);
        CommonOps_DDRM.scale((double)(1.0 - this.discreteTimeGain.getValue()), (DMatrixD1)this.sampledFilterValue);
        CommonOps_DDRM.scale((double)this.discreteTimeGain.getValue(), (DMatrixD1)this.runningFilteredValue);
        CommonOps_DDRM.addEquals((DMatrixD1)this.runningFilteredValue, (DMatrixD1)this.sampledFilterValue);
        this.estimatedExternalTorque.set((DMatrixD1)this.hqd);
        CommonOps_DDRM.scale((double)this.beta.getValue(), (DMatrixD1)this.estimatedExternalTorque);
        CommonOps_DDRM.subtractEquals((DMatrixD1)this.estimatedExternalTorque, (DMatrixD1)this.runningFilteredValue);
        for (i = 0; i < this.dofs; ++i) {
            this.yoObservedExternalJointTorque[i].set(this.estimatedExternalTorque.get(i, 0));
        }
    }

    @Override
    public DMatrixRMaj getEstimatedExternalTorque() {
        return this.estimatedExternalTorque;
    }

    @Override
    public void requestInitialize() {
        this.requestInitialize.set(true);
    }

    @Override
    public void setEstimatorGain(double estimatorGain) {
        this.discreteTimeGain.set(DiscreteTimeExternalTorqueEstimator.computeDiscreteTimeGain(estimatorGain, this.dt));
        this.beta.set(DiscreteTimeExternalTorqueEstimator.computeMomentumGain(this.discreteTimeGain.getValue(), this.dt));
    }

    public YoRegistry getYoRegistry() {
        return this.registry;
    }
}

