/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.contact.particleFilter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotics.physics.Collidable;

public class ContactPointProjector {
    private final RigidBodyBasics[] collidableRigidBodies;
    private final Map<RigidBodyBasics, List<Collidable>> collidableMap = new HashMap<RigidBodyBasics, List<Collidable>>();

    public ContactPointProjector(List<Collidable> allCollidables) {
        allCollidables.forEach(collidable -> this.collidableMap.computeIfAbsent(collidable.getRigidBody(), r -> new ArrayList()).add(collidable));
        this.collidableRigidBodies = this.collidableMap.keySet().toArray(new RigidBodyBasics[0]);
    }

    public boolean isPointInsideAnyRigidBody(FramePoint3DBasics queryPoint) {
        return this.isPointInside(queryPoint, this.collidableRigidBodies);
    }

    public boolean isPointInside(FramePoint3DBasics queryPoint, RigidBodyBasics ... rigidBodiesToCheck) {
        for (int i = 0; i < rigidBodiesToCheck.length; ++i) {
            List<Collidable> collidablesToCheck = this.collidableMap.get(rigidBodiesToCheck[i]);
            for (int j = 0; j < collidablesToCheck.size(); ++j) {
                FrameShape3DReadOnly collisionShape = collidablesToCheck.get(j).getShape();
                queryPoint.changeFrame(collisionShape.getReferenceFrame());
                if (!collidablesToCheck.get(j).getShape().isPointInside((FramePoint3DReadOnly)queryPoint)) continue;
                return true;
            }
        }
        return false;
    }

    public List<RigidBodyBasics> computeCollidingRigidBodies(FramePoint3DBasics queryPoint) {
        ArrayList<RigidBodyBasics> collidingRigidBodies = new ArrayList<RigidBodyBasics>();
        block0: for (int i = 0; i < this.collidableRigidBodies.length; ++i) {
            List<Collidable> collidablesToCheck = this.collidableMap.get(this.collidableRigidBodies[i]);
            for (int j = 0; j < collidablesToCheck.size(); ++j) {
                FrameShape3DReadOnly collisionShape = collidablesToCheck.get(j).getShape();
                queryPoint.changeFrame(collisionShape.getReferenceFrame());
                if (!collidablesToCheck.get(j).getShape().isPointInside((FramePoint3DReadOnly)queryPoint)) continue;
                collidingRigidBodies.add(collidablesToCheck.get(j).getRigidBody());
                continue block0;
            }
        }
        return collidingRigidBodies;
    }

    public void projectToSpecificLink(FramePoint3DBasics pointToProject, FramePoint3D contactPointPosition, FrameVector3D surfaceNormal, RigidBodyBasics rigidBody) {
        this.projectPoint(pointToProject, contactPointPosition, surfaceNormal, rigidBody);
    }

    public RigidBodyBasics projectToClosestLink(FramePoint3DBasics pointToProject, FramePoint3D contactPointPosition, FrameVector3D surfaceNormal) {
        return this.projectPoint(pointToProject, contactPointPosition, surfaceNormal, this.collidableRigidBodies);
    }

    public RigidBodyBasics projectPoint(FramePoint3DBasics pointToProject, FramePoint3D contactPointPosition, FrameVector3D surfaceNormal, RigidBodyBasics ... rigidBodiesToCheck) {
        double minimumProjectionDistance = Double.MAX_VALUE;
        RigidBodyBasics minimumDistanceBody = null;
        int minimumDistanceIndex = -1;
        for (int i = 0; i < rigidBodiesToCheck.length; ++i) {
            List<Collidable> collidablesToCheck = this.collidableMap.get(rigidBodiesToCheck[i]);
            for (int j = 0; j < collidablesToCheck.size(); ++j) {
                FrameShape3DReadOnly collisionShape = collidablesToCheck.get(j).getShape();
                pointToProject.changeFrame(collisionShape.getReferenceFrame());
                collisionShape.evaluatePoint3DCollision((FramePoint3DReadOnly)pointToProject, (FramePoint3DBasics)contactPointPosition, (FrameVector3DBasics)surfaceNormal);
                pointToProject.changeFrame(contactPointPosition.getReferenceFrame());
                double distance = contactPointPosition.distance((FramePoint3DReadOnly)pointToProject);
                if (!(distance < minimumProjectionDistance)) continue;
                minimumProjectionDistance = distance;
                minimumDistanceBody = rigidBodiesToCheck[i];
                minimumDistanceIndex = j;
            }
        }
        FrameShape3DReadOnly shapeToProjectTo = this.collidableMap.get(minimumDistanceBody).get(minimumDistanceIndex).getShape();
        pointToProject.changeFrame(shapeToProjectTo.getReferenceFrame());
        shapeToProjectTo.evaluatePoint3DCollision((FramePoint3DReadOnly)pointToProject, (FramePoint3DBasics)contactPointPosition, (FrameVector3DBasics)surfaceNormal);
        return minimumDistanceBody;
    }

    public RigidBodyBasics[] getCollidableRigidBodies() {
        return this.collidableRigidBodies;
    }
}

