/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.contact.particleFilter;

import org.ejml.data.DMatrixRMaj;
import us.ihmc.commonWalkingControlModules.contact.particleFilter.ExternalForceEstimationTools;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.robotics.screwTheory.GeometricJacobian;
import us.ihmc.robotics.screwTheory.PointJacobian;

public class ContactPointParticle {
    private RigidBodyBasics rigidBody;
    private final RigidBodyBasics baseLink;
    private final JointBasics[] orderedJoints;
    private final FramePoint3D contactPointPosition = new FramePoint3D();
    private final FrameVector3D surfaceNormal = new FrameVector3D();
    private final FramePose3D surfacePose = new FramePose3D();
    private final PoseReferenceFrame contactPointFrame;
    private GeometricJacobian contactPointJacobian;
    private final PointJacobian pointJacobian = new PointJacobian();
    private int[] indexMap;

    public ContactPointParticle(String namePrefix, JointBasics[] orderedJoints) {
        this.orderedJoints = orderedJoints;
        this.baseLink = orderedJoints[0].getPredecessor();
        this.contactPointFrame = new PoseReferenceFrame(namePrefix + "ContactFrame", ReferenceFrame.getWorldFrame());
    }

    public void setRigidBody(RigidBodyBasics rigidBody) {
        this.rigidBody = rigidBody;
        this.contactPointJacobian = new GeometricJacobian(this.baseLink, rigidBody, (ReferenceFrame)this.baseLink.getBodyFixedFrame());
        this.contactPointJacobian.changeFrame((ReferenceFrame)this.contactPointFrame);
        this.indexMap = ExternalForceEstimationTools.createIndexMap(this.contactPointJacobian, this.orderedJoints);
    }

    public DMatrixRMaj computeContactJacobian() {
        this.assertInitialized();
        ReferenceFrame baseFrame = this.contactPointJacobian.getBaseFrame();
        this.contactPointJacobian.changeFrame(baseFrame);
        this.contactPointJacobian.compute();
        this.contactPointPosition.changeFrame((ReferenceFrame)this.contactPointFrame);
        this.pointJacobian.set(this.contactPointJacobian, this.contactPointPosition);
        this.pointJacobian.compute();
        return this.pointJacobian.getJacobianMatrix();
    }

    public void update() {
        this.assertInitialized();
        this.contactPointPosition.changeFrame(ReferenceFrame.getWorldFrame());
        this.surfaceNormal.changeFrame(ReferenceFrame.getWorldFrame());
        this.surfacePose.getPosition().set((FrameTuple3DReadOnly)this.contactPointPosition);
        EuclidGeometryTools.orientation3DFromFirstToSecondVector3D((Vector3DReadOnly)Axis3D.Z, (Vector3DReadOnly)this.surfaceNormal, (Orientation3DBasics)this.surfacePose.getOrientation());
        this.contactPointFrame.setPoseAndUpdate((FramePose3DReadOnly)this.surfacePose);
    }

    private void assertInitialized() {
        if (this.rigidBody == null) {
            throw new RuntimeException("Rigid body hasn't been set.");
        }
    }

    public FramePoint3D getContactPointPosition() {
        return this.contactPointPosition;
    }

    public FrameVector3D getSurfaceNormal() {
        return this.surfaceNormal;
    }

    public ReferenceFrame getContactPointFrame() {
        return this.contactPointFrame;
    }

    public RigidBodyBasics getRigidBody() {
        return this.rigidBody;
    }

    public int getSystemJacobianIndex(int contactPointJacobianIndex) {
        return this.indexMap[contactPointJacobianIndex];
    }
}

