/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.contact.particleFilter;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.convexOptimization.quadraticProgram.SimpleEfficientActiveSetQPSolver;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.matrixlib.NativeCommonOps;

public class ContactPointEvaluator {
    private final SimpleEfficientActiveSetQPSolver qpSolver = new SimpleEfficientActiveSetQPSolver();
    private final double convergenceThreshold = 1.0E-10;
    private final int maximumNumberOfIterations = 500;
    private final double dampingTerm = 1.0E-5;
    private final Vector3D[] polyhedraBasisVectors = new Vector3D[4];
    private final FrameVector3D[] polyhedraFrameBasisVectors = new FrameVector3D[4];
    private final DMatrixRMaj basisVectorMatrix = new DMatrixRMaj(3, 4);
    private final DMatrixRMaj JTF = new DMatrixRMaj(0);
    private final DMatrixRMaj SInvJTF = new DMatrixRMaj(0);
    private final DMatrixRMaj sigmaInv = new DMatrixRMaj(0);
    private final DMatrixRMaj diagonalCost = new DMatrixRMaj(0);
    private final DMatrixRMaj quadraticCost = new DMatrixRMaj(0);
    private final DMatrixRMaj linearCost = new DMatrixRMaj(0);
    private final DMatrixRMaj scalarCost = new DMatrixRMaj(0);
    private final DMatrixRMaj Ain = new DMatrixRMaj(4, 4);
    private final DMatrixRMaj bin = new DMatrixRMaj(4, 1);
    private final DMatrixRMaj Aeq = new DMatrixRMaj(0, 4);
    private final DMatrixRMaj beq = new DMatrixRMaj(0, 1);
    private final DMatrixRMaj rho = new DMatrixRMaj(4, 1);
    private final DMatrixRMaj estimatedForce = new DMatrixRMaj(3, 1);

    public ContactPointEvaluator() {
        for (int i = 0; i < this.polyhedraBasisVectors.length; ++i) {
            this.polyhedraBasisVectors[i] = new Vector3D();
            this.polyhedraBasisVectors[i].setToNaN();
            this.polyhedraFrameBasisVectors[i] = new FrameVector3D();
        }
        CommonOps_DDRM.setIdentity((DMatrix1Row)this.Ain);
        CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)this.Ain);
        CommonOps_DDRM.fill((DMatrixD1)this.beq, (double)0.0);
    }

    public void setCoefficientOfFriction(double coefficientOfFriction) {
        double angleFromNormal = Math.atan(coefficientOfFriction);
        for (int i = 0; i < this.polyhedraBasisVectors.length; ++i) {
            Vector3D basisVector = this.polyhedraBasisVectors[i];
            basisVector.set((Tuple3DReadOnly)Axis3D.Z);
            double angleToRotateAroundInXY = (double)i * Math.PI / 2.0;
            AxisAngle basisVectorRotation = new AxisAngle(Math.cos(angleToRotateAroundInXY), Math.sin(angleToRotateAroundInXY), 0.0, angleFromNormal);
            basisVectorRotation.transform((Tuple3DBasics)basisVector);
            basisVector.negate();
        }
    }

    public double computeMaximumLikelihoodForce(DMatrixRMaj jointspaceResidual, DMatrixRMaj contactPointJacobian, DMatrixRMaj sigma, ReferenceFrame zInContactFrame) {
        if (this.polyhedraBasisVectors[0].containsNaN()) {
            LogTools.debug((String)"Coefficient of friction has not been set yet");
            return 0.0;
        }
        for (int i = 0; i < this.polyhedraFrameBasisVectors.length; ++i) {
            this.polyhedraFrameBasisVectors[i].setIncludingFrame(zInContactFrame, (Tuple3DReadOnly)this.polyhedraBasisVectors[i]);
            this.polyhedraFrameBasisVectors[i].changeFrame(ReferenceFrame.getWorldFrame());
            this.polyhedraFrameBasisVectors[i].get(0, i, (DMatrix)this.basisVectorMatrix);
        }
        CommonOps_DDRM.invert((DMatrixRMaj)sigma, (DMatrixRMaj)this.sigmaInv);
        CommonOps_DDRM.multTransA((DMatrix1Row)contactPointJacobian, (DMatrix1Row)this.basisVectorMatrix, (DMatrix1Row)this.JTF);
        NativeCommonOps.multQuad((DMatrix1Row)this.JTF, (DMatrix1Row)this.sigmaInv, (DMatrix1Row)this.quadraticCost);
        this.diagonalCost.reshape(this.quadraticCost.getNumRows(), this.quadraticCost.getNumCols());
        CommonOps_DDRM.setIdentity((DMatrix1Row)this.diagonalCost);
        CommonOps_DDRM.scale((double)1.0E-5, (DMatrixD1)this.diagonalCost);
        CommonOps_DDRM.addEquals((DMatrixD1)this.quadraticCost, (DMatrixD1)this.diagonalCost);
        CommonOps_DDRM.mult((DMatrix1Row)this.sigmaInv, (DMatrix1Row)this.JTF, (DMatrix1Row)this.SInvJTF);
        CommonOps_DDRM.multTransA((DMatrix1Row)this.SInvJTF, (DMatrix1Row)jointspaceResidual, (DMatrix1Row)this.linearCost);
        CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)this.linearCost);
        NativeCommonOps.multQuad((DMatrix1Row)jointspaceResidual, (DMatrix1Row)this.sigmaInv, (DMatrix1Row)this.scalarCost);
        this.qpSolver.clear();
        this.qpSolver.resetActiveSet();
        this.qpSolver.setMaxNumberOfIterations(500);
        this.qpSolver.setConvergenceThreshold(1.0E-10);
        this.qpSolver.setQuadraticCostFunction((DMatrix)this.quadraticCost, (DMatrix)this.linearCost, this.scalarCost.get(0, 0));
        this.qpSolver.setLinearInequalityConstraints((DMatrix)this.Aeq, (DMatrix)this.beq);
        this.qpSolver.setLinearInequalityConstraints((DMatrix)this.Ain, (DMatrix)this.bin);
        this.qpSolver.solve((DMatrix)this.rho);
        CommonOps_DDRM.mult((DMatrix1Row)this.basisVectorMatrix, (DMatrix1Row)this.rho, (DMatrix1Row)this.estimatedForce);
        return this.qpSolver.getObjectiveCost(this.rho);
    }

    public DMatrixRMaj getEstimatedForce() {
        return this.estimatedForce;
    }
}

