/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.contact.particleFilter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.commons.lang3.mutable.MutableInt;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.contact.particleFilter.ContactPointEvaluator;
import us.ihmc.commonWalkingControlModules.contact.particleFilter.ContactPointParticle;
import us.ihmc.commonWalkingControlModules.contact.particleFilter.ContactPointProjector;
import us.ihmc.commonWalkingControlModules.contact.particleFilter.ExternalForceEstimationTools;
import us.ihmc.commonWalkingControlModules.contact.particleFilter.ExternalTorqueEstimator;
import us.ihmc.commonWalkingControlModules.contact.particleFilter.ForceEstimatorDynamicMatrixUpdater;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicVector;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsList;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.matrixlib.NativeCommonOps;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotics.physics.Collidable;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class ContactParticleFilter {
    private static final int numberOfParticles = 150;
    private static final int estimationVariables = 3;
    private final String name = this.getClass().getSimpleName();
    private final YoRegistry registry = new YoRegistry(this.name);
    private final Random random = new Random(34098L);
    private final YoDouble coefficientOfFriction = new YoDouble("coefficientOfFriction", this.registry);
    private final YoDouble maximumSampleStandardDeviation = new YoDouble("maximumSampleStandardDeviation", this.registry);
    private final YoDouble minimumSampleStandardDeviation = new YoDouble("minimumSampleStandardDeviation", this.registry);
    private final YoDouble upperMotionBoundForSamplingAdjustment = new YoDouble("upperMotionBoundForSamplingAdjustment", this.registry);
    private final JointBasics[] joints;
    private final int dofs;
    private final ExternalTorqueEstimator externalTorqueEstimator;
    private final DMatrixRMaj systemJacobian;
    private final DMatrixRMaj jointNoiseVariance;
    private final DMatrixRMaj jointNoiseVarianceInv;
    private final DMatrixRMaj jointspaceResidualMagnitude = new DMatrixRMaj(1, 1);
    private final YoDouble yoJointspaceResidualMagnitude = new YoDouble("jointspaceResidualMagnitude", this.registry);
    private final ContactPointEvaluator contactPointEvaluator = new ContactPointEvaluator();
    private final ContactPointProjector contactPointProjector;
    private final Set<RigidBodyBasics> rigidBodiesToConsiderQueue = new HashSet<RigidBodyBasics>();
    private RigidBodyBasics[] rigidBodiesToConsider;
    private final ContactPointParticle[] contactPointParticles = new ContactPointParticle[150];
    private final YoDouble[] contactPointProbabilities = new YoDouble[150];
    private final FramePoint3D[] sampledContactPositions = new FramePoint3D[150];
    private final YoFramePoint3D[] contactPointPositions = new YoFramePoint3D[150];
    private final YoFrameVector3D[] scaledSurfaceNormal = new YoFrameVector3D[150];
    private final ContactPointParticle averageProjectedParticle;
    private final YoFramePoint3D yoEstimatedContactPosition = new YoFramePoint3D("estimatedContactPosition", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoFrameVector3D yoEstimatedContactNormal = new YoFrameVector3D("estimatedContactNormal", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoFrameVector3D estimatedExternalForce = new YoFrameVector3D("estimatedExternalForce", ReferenceFrame.getWorldFrame(), this.registry);
    private final double[] histogramValues = new double[150];
    private final int[] contactPointIndicesToSample = new int[150];
    private final FramePoint3D pointToProject = new FramePoint3D();
    private final YoFramePoint3D averageParticlePosition = new YoFramePoint3D("averageParticlePosition", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoFramePoint3D filteredAverageParticlePosition = new YoFramePoint3D("filteredAverageParticlePosition", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoDouble alphaAverageParticlePosition = new YoDouble("alphaAverageParticlePosition", this.registry);
    private final YoDouble filteredAverageParticleVelocity = new YoDouble("filteredAverageParticleVelocity", this.registry);
    private final FramePoint3D previousFilteredAverageParticlePosition = new FramePoint3D();
    private RigidBodyBasics estimatedContactingBody = null;
    private final Map<RigidBodyBasics, MutableInt> contactingBodyHistogram = new HashMap<RigidBodyBasics, MutableInt>();
    private final YoInteger iterations = new YoInteger("iterations", this.registry);
    private final YoInteger maxIterations = new YoInteger("maxIterations", this.registry);
    private final YoInteger minIterations = new YoInteger("minIterations", this.registry);
    private final YoDouble terminalParticleVelocity = new YoDouble("terminalParticleVelocity", this.registry);
    private final YoBoolean hasConverged = new YoBoolean("hasConverged", this.registry);
    private final YoDouble closestParticleProbability = new YoDouble("closestParticleProbability", this.registry);
    private final YoDouble maximumProbabilityParticle = new YoDouble("maximumProbabilityParticle", this.registry);
    private final YoDouble errorOfMaximumProbabilityParticle = new YoDouble("errorOfMaximumProbabilityParticle", this.registry);
    private RigidBodyBasics actualContactingBody;
    private final Vector3D actualContactPointInParentJointFrame = new Vector3D();
    private final FramePoint3D actualContactPoint = new FramePoint3D();
    private final YoFramePoint3D yoActualContactPoint = new YoFramePoint3D("debugContactPoint", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoFrameVector3D yoActualSurfaceNormal = new YoFrameVector3D("debugSurfaceNormal", ReferenceFrame.getWorldFrame(), this.registry);
    private boolean firstTick;

    public ContactParticleFilter(JointBasics[] joints, double dt, ForceEstimatorDynamicMatrixUpdater dynamicMatrixUpdater, List<Collidable> collidables, YoGraphicsListRegistry graphicsListRegistry, YoRegistry parentRegistry) {
        this.joints = joints;
        this.externalTorqueEstimator = new ExternalTorqueEstimator(joints, dt, dynamicMatrixUpdater, this.registry);
        this.dofs = Arrays.stream(joints).mapToInt(JointReadOnly::getDegreesOfFreedom).sum();
        this.systemJacobian = new DMatrixRMaj(3, this.dofs);
        this.jointNoiseVariance = CommonOps_DDRM.identity((int)this.dofs);
        this.jointNoiseVarianceInv = CommonOps_DDRM.identity((int)this.dofs);
        this.contactPointProjector = new ContactPointProjector(collidables);
        this.averageProjectedParticle = new ContactPointParticle("averageParticle", joints);
        for (int i = 0; i < 150; ++i) {
            this.contactPointProbabilities[i] = new YoDouble("cpProb_" + i, this.registry);
            this.contactPointPositions[i] = new YoFramePoint3D("cpPosition_" + i, ReferenceFrame.getWorldFrame(), this.registry);
            this.scaledSurfaceNormal[i] = new YoFrameVector3D("cpNorm_" + i, ReferenceFrame.getWorldFrame(), this.registry);
            this.sampledContactPositions[i] = new FramePoint3D();
            this.contactPointParticles[i] = new ContactPointParticle("particle" + i, joints);
        }
        if (graphicsListRegistry != null) {
            YoGraphicsList actualContactList = new YoGraphicsList("actualContact");
            YoGraphicPosition actualContactPointGraphic = new YoGraphicPosition("cpPositionVizDebug", this.yoActualContactPoint, 0.025, YoAppearance.Red());
            YoGraphicVector actualContactVectorGraphic = new YoGraphicVector("cpNormVizDebug", this.yoActualContactPoint, this.yoActualSurfaceNormal, 1.0, YoAppearance.Red());
            actualContactList.add((YoGraphic)actualContactPointGraphic);
            actualContactList.add((YoGraphic)actualContactVectorGraphic);
            graphicsListRegistry.registerYoGraphicsList(actualContactList);
            YoGraphicPosition averageParticlePositionGraphic = new YoGraphicPosition("averageParticleViz", this.filteredAverageParticlePosition, 0.025, YoAppearance.DarkBlue());
            YoGraphicPosition estimatedContactPositionGraphic = new YoGraphicPosition("estimatedCPViz", this.yoEstimatedContactPosition, 0.025, YoAppearance.Green());
            YoGraphicVector estimatedContactNormalGraphic = new YoGraphicVector("estimatedCPNormalViz", this.yoEstimatedContactPosition, this.yoEstimatedContactNormal, 0.07, YoAppearance.Green());
            YoGraphicVector estimatedForceGraphic = new YoGraphicVector("estimatedForceViz", this.yoEstimatedContactPosition, this.estimatedExternalForce, 0.05, YoAppearance.DarkCyan());
            graphicsListRegistry.registerYoGraphic(this.name, (YoGraphic)averageParticlePositionGraphic);
            graphicsListRegistry.registerYoGraphic(this.name, (YoGraphic)estimatedContactPositionGraphic);
            graphicsListRegistry.registerYoGraphic(this.name, (YoGraphic)estimatedContactNormalGraphic);
            graphicsListRegistry.registerYoGraphic(this.name, (YoGraphic)estimatedForceGraphic);
            for (int i = 0; i < 150; ++i) {
                YoGraphicPosition contactPointGraphic = new YoGraphicPosition("cpPositionViz_" + i, this.contactPointPositions[i], 0.005, YoAppearance.Blue());
                graphicsListRegistry.registerYoGraphic(this.name, (YoGraphic)contactPointGraphic);
            }
        }
        this.coefficientOfFriction.set(0.5);
        this.maximumSampleStandardDeviation.set(0.1);
        this.minimumSampleStandardDeviation.set(0.02);
        this.upperMotionBoundForSamplingAdjustment.set(0.1);
        this.filteredAverageParticleVelocity.set(this.upperMotionBoundForSamplingAdjustment.getDoubleValue());
        this.alphaAverageParticlePosition.set(0.2);
        double maxTime = 20.0;
        this.minIterations.set(500);
        this.maxIterations.set((int)(maxTime / dt));
        this.terminalParticleVelocity.set(1.0E-5);
        if (parentRegistry != null) {
            parentRegistry.addChild(this.registry);
        }
    }

    public void initializeJointspaceEstimator() {
        this.externalTorqueEstimator.initialize();
        this.contactPointEvaluator.setCoefficientOfFriction(this.coefficientOfFriction.getDoubleValue());
    }

    public void initializeParticleFilter() {
        if (this.rigidBodiesToConsiderQueue.isEmpty()) {
            this.rigidBodiesToConsider = this.contactPointProjector.getCollidableRigidBodies();
        } else {
            this.rigidBodiesToConsider = this.rigidBodiesToConsiderQueue.toArray(new RigidBodyBasics[0]);
            this.rigidBodiesToConsiderQueue.clear();
        }
        this.contactingBodyHistogram.clear();
        for (int i = 0; i < this.rigidBodiesToConsider.length; ++i) {
            this.contactingBodyHistogram.put(this.rigidBodiesToConsider[i], new MutableInt());
        }
        this.computeInitialProjection();
        this.firstTick = true;
        this.iterations.set(0);
        this.hasConverged.set(false);
        this.filteredAverageParticleVelocity.set(this.upperMotionBoundForSamplingAdjustment.getValue());
    }

    public void clearRigidBodiesToConsider() {
        this.rigidBodiesToConsiderQueue.clear();
    }

    public void addRigidBodyToConsider(RigidBodyBasics rigidBody) {
        this.rigidBodiesToConsiderQueue.add(rigidBody);
    }

    private void computeInitialProjection() {
        double initialProjectionRadius = 1.0;
        for (int i = 0; i < 150; ++i) {
            RigidBodyBasics rigidBody = this.rigidBodiesToConsider[i % this.rigidBodiesToConsider.length];
            Vector3D randomVector = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)this.random, (double)initialProjectionRadius);
            this.pointToProject.setIncludingFrame((ReferenceFrame)rigidBody.getBodyFixedFrame(), (Tuple3DReadOnly)randomVector);
            this.pointToProject.changeFrame(ReferenceFrame.getWorldFrame());
            this.contactPointParticles[i].setRigidBody(rigidBody);
            this.contactPointProjector.projectToSpecificLink((FramePoint3DBasics)this.pointToProject, this.contactPointParticles[i].getContactPointPosition(), this.contactPointParticles[i].getSurfaceNormal(), rigidBody);
            this.contactPointParticles[i].update();
        }
    }

    public double computeJointspaceDisturbance() {
        this.externalTorqueEstimator.doControl();
        DMatrixRMaj jointspaceResidual = this.externalTorqueEstimator.getEstimatedExternalTorque();
        NativeCommonOps.multQuad((DMatrix1Row)jointspaceResidual, (DMatrix1Row)this.jointNoiseVarianceInv, (DMatrix1Row)this.jointspaceResidualMagnitude);
        this.yoJointspaceResidualMagnitude.set(this.jointspaceResidualMagnitude.get(0, 0));
        return this.yoJointspaceResidualMagnitude.getValue();
    }

    public void computeParticleFilterEstimation() {
        int i;
        DMatrixRMaj observedExternalJointTorque = this.externalTorqueEstimator.getEstimatedExternalTorque();
        double totalWeight = 0.0;
        for (i = 0; i < 150; ++i) {
            ContactPointParticle contactPoint = this.contactPointParticles[i];
            DMatrixRMaj contactPointJacobian = contactPoint.computeContactJacobian();
            for (int j = 0; j < contactPointJacobian.getNumCols(); ++j) {
                int column = contactPoint.getSystemJacobianIndex(j);
                MatrixTools.setMatrixBlock((DMatrix)this.systemJacobian, (int)0, (int)column, (DMatrix)contactPointJacobian, (int)0, (int)j, (int)3, (int)1, (double)1.0);
            }
            double likelihoodCost = this.contactPointEvaluator.computeMaximumLikelihoodForce(observedExternalJointTorque, this.systemJacobian, this.jointNoiseVariance, this.contactPointParticles[i].getContactPointFrame());
            double likelihoodWeight = Math.exp(-0.5 * likelihoodCost);
            this.contactPointProbabilities[i].set(likelihoodWeight);
            totalWeight += likelihoodWeight;
        }
        for (i = 0; i < 150; ++i) {
            this.contactPointProbabilities[i].mul(1.0 / totalWeight);
            double previousHistogramValue = i == 0 ? 0.0 : this.histogramValues[i - 1];
            this.histogramValues[i] = previousHistogramValue + this.contactPointProbabilities[i].getDoubleValue();
        }
        block3: for (i = 0; i < 150; ++i) {
            double randomDouble = EuclidCoreRandomTools.nextDouble((Random)this.random, (double)((double)i / 150.0), (double)((double)(i + 1) / 150.0));
            for (int j = 0; j < this.histogramValues.length; ++j) {
                if (j != this.histogramValues.length - 1 && !(this.histogramValues[j] > randomDouble)) continue;
                this.contactPointIndicesToSample[i] = j;
                continue block3;
            }
        }
        this.updateDebugVariables();
        for (i = 0; i < 150; ++i) {
            int resampleIndex = this.contactPointIndicesToSample[i];
            ContactPointParticle contactPointToSample = this.contactPointParticles[resampleIndex];
            boolean foundPointOutsideMesh = false;
            while (!foundPointOutsideMesh) {
                Vector3D offset = this.generateSamplingOffset();
                FramePoint3D sampledContactPosition = this.sampledContactPositions[i];
                sampledContactPosition.setIncludingFrame(contactPointToSample.getContactPointFrame(), (Tuple3DReadOnly)offset);
                if (this.contactPointProjector.isPointInsideAnyRigidBody((FramePoint3DBasics)sampledContactPosition)) continue;
                foundPointOutsideMesh = true;
            }
        }
        for (i = 0; i < 150; ++i) {
            RigidBodyBasics closestLink = this.contactPointProjector.projectPoint((FramePoint3DBasics)this.sampledContactPositions[i], this.contactPointParticles[i].getContactPointPosition(), this.contactPointParticles[i].getSurfaceNormal(), this.rigidBodiesToConsider);
            this.contactPointParticles[i].setRigidBody(closestLink);
            this.contactPointParticles[i].update();
            this.contactPointParticles[i].getContactPointPosition().changeFrame(ReferenceFrame.getWorldFrame());
            this.contactPointParticles[i].getSurfaceNormal().changeFrame(ReferenceFrame.getWorldFrame());
            this.contactPointPositions[i].set((FrameTuple3DReadOnly)this.contactPointParticles[i].getContactPointPosition());
            this.scaledSurfaceNormal[i].set((FrameTuple3DReadOnly)this.contactPointParticles[i].getSurfaceNormal());
            this.scaledSurfaceNormal[i].scale(this.contactPointProbabilities[i].getDoubleValue());
        }
        FramePoint3D averageParticlePosition = this.averageProjectedParticle.getContactPointPosition();
        averageParticlePosition.setToZero(ReferenceFrame.getWorldFrame());
        for (int i2 = 0; i2 < 150; ++i2) {
            averageParticlePosition.add((FrameTuple3DReadOnly)this.contactPointPositions[i2]);
        }
        averageParticlePosition.scale(0.006666666666666667);
        if (this.firstTick) {
            this.filteredAverageParticlePosition.set((FrameTuple3DReadOnly)averageParticlePosition);
        }
        this.previousFilteredAverageParticlePosition.setIncludingFrame((FrameTuple3DReadOnly)this.filteredAverageParticlePosition);
        this.averageParticlePosition.set((FrameTuple3DReadOnly)averageParticlePosition);
        this.filteredAverageParticlePosition.interpolate((FrameTuple3DReadOnly)this.averageParticlePosition, this.alphaAverageParticlePosition.getValue());
        if (!this.firstTick) {
            this.filteredAverageParticleVelocity.set(this.previousFilteredAverageParticlePosition.distance((FramePoint3DReadOnly)this.filteredAverageParticlePosition));
        }
        this.projectEstimatedPoint();
        this.averageProjectedParticle.getContactPointPosition().changeFrame(ReferenceFrame.getWorldFrame());
        this.averageProjectedParticle.getSurfaceNormal().changeFrame(ReferenceFrame.getWorldFrame());
        this.yoEstimatedContactPosition.set((FrameTuple3DReadOnly)this.averageProjectedParticle.getContactPointPosition());
        this.yoEstimatedContactNormal.set((FrameTuple3DReadOnly)this.averageProjectedParticle.getSurfaceNormal());
        this.computeEstimatedForceAtAveragePoint();
        this.hasConverged.set(this.checkTerminationConditions());
        this.firstTick = false;
    }

    public void computeEstimatedForceAtAveragePoint() {
        this.averageProjectedParticle.setRigidBody(this.estimatedContactingBody);
        this.averageProjectedParticle.update();
        DMatrixRMaj contactPointJacobian = this.averageProjectedParticle.computeContactJacobian();
        for (int j = 0; j < contactPointJacobian.getNumCols(); ++j) {
            int column = this.averageProjectedParticle.getSystemJacobianIndex(j);
            MatrixTools.setMatrixBlock((DMatrix)this.systemJacobian, (int)0, (int)column, (DMatrix)contactPointJacobian, (int)0, (int)j, (int)3, (int)1, (double)1.0);
        }
        this.contactPointEvaluator.computeMaximumLikelihoodForce(this.externalTorqueEstimator.getEstimatedExternalTorque(), this.systemJacobian, this.jointNoiseVariance, this.averageProjectedParticle.getContactPointFrame());
        this.estimatedExternalForce.set((DMatrix)this.contactPointEvaluator.getEstimatedForce());
    }

    public void setDoFVariance(int dofIndex, double variance) {
        this.jointNoiseVariance.set(dofIndex, dofIndex, variance);
        this.jointNoiseVarianceInv.set(dofIndex, dofIndex, 1.0 / variance);
    }

    private void projectEstimatedPoint() {
        int i;
        this.contactingBodyHistogram.values().forEach(m -> m.setValue(0));
        int numberOfParticlesOnHighestCountBody = 0;
        for (i = 0; i < this.contactPointParticles.length; ++i) {
            this.contactingBodyHistogram.get(this.contactPointParticles[i].getRigidBody()).increment();
        }
        for (i = 0; i < this.contactPointParticles.length; ++i) {
            RigidBodyBasics rigidBody = this.contactPointParticles[i].getRigidBody();
            int contactingBodyCount = this.contactingBodyHistogram.get(rigidBody).getValue();
            if (contactingBodyCount <= numberOfParticlesOnHighestCountBody) continue;
            numberOfParticlesOnHighestCountBody = contactingBodyCount;
            this.estimatedContactingBody = rigidBody;
        }
        FramePoint3D estimatedContactPosition = this.averageProjectedParticle.getContactPointPosition();
        FrameVector3D estimatedSurfaceNormal = this.averageProjectedParticle.getSurfaceNormal();
        if (this.contactPointProjector.isPointInside((FramePoint3DBasics)estimatedContactPosition, this.estimatedContactingBody)) {
            Vector3D sphericalQuery = new Vector3D();
            estimatedContactPosition.changeFrame((ReferenceFrame)this.estimatedContactingBody.getBodyFixedFrame());
            ExternalForceEstimationTools.transformToSphericalCoordinates((Tuple3DReadOnly)estimatedContactPosition, (Tuple3DBasics)sphericalQuery);
            boolean pointIsInside = true;
            double radiusIncrement = 0.01;
            while (pointIsInside) {
                sphericalQuery.addX(radiusIncrement);
                estimatedContactPosition.changeFrame((ReferenceFrame)this.estimatedContactingBody.getBodyFixedFrame());
                ExternalForceEstimationTools.transformToCartesianCoordinates((Tuple3DReadOnly)sphericalQuery, (Tuple3DBasics)estimatedContactPosition);
                pointIsInside = this.contactPointProjector.isPointInside((FramePoint3DBasics)estimatedContactPosition, this.estimatedContactingBody);
            }
            this.pointToProject.setIncludingFrame((FrameTuple3DReadOnly)estimatedContactPosition);
            this.contactPointProjector.projectToClosestLink((FramePoint3DBasics)this.pointToProject, estimatedContactPosition, estimatedSurfaceNormal);
        } else {
            this.pointToProject.setIncludingFrame((FrameTuple3DReadOnly)estimatedContactPosition);
            this.contactPointProjector.projectToSpecificLink((FramePoint3DBasics)this.pointToProject, estimatedContactPosition, estimatedSurfaceNormal, this.estimatedContactingBody);
        }
    }

    private Vector3D generateSamplingOffset() {
        double clampedEstimatedPositionMotion = EuclidCoreTools.clamp((double)this.filteredAverageParticleVelocity.getDoubleValue(), (double)0.0, (double)this.upperMotionBoundForSamplingAdjustment.getDoubleValue());
        double standardDeviation = EuclidCoreTools.interpolate((double)this.minimumSampleStandardDeviation.getDoubleValue(), (double)this.maximumSampleStandardDeviation.getDoubleValue(), (double)(clampedEstimatedPositionMotion / this.upperMotionBoundForSamplingAdjustment.getDoubleValue()));
        double offsetRadius = standardDeviation * Math.abs(this.random.nextGaussian());
        double theta = Math.PI * 2 * this.random.nextDouble();
        double phi = Math.acos(this.random.nextDouble());
        double offsetX = offsetRadius * Math.cos(theta) * Math.sin(phi);
        double offsetY = offsetRadius * Math.sin(theta) * Math.sin(phi);
        double offsetZ = offsetRadius * Math.cos(phi);
        return new Vector3D(offsetX, offsetY, offsetZ);
    }

    public void setActualContactingBodyForDebugging(String parentJointName, Tuple3DReadOnly offsetInParentJointFrame) {
        for (int i = 0; i < this.joints.length; ++i) {
            if (!this.joints[i].getName().equals(parentJointName)) continue;
            this.actualContactingBody = this.joints[i].getSuccessor();
            break;
        }
        this.actualContactPointInParentJointFrame.set(offsetInParentJointFrame);
    }

    private boolean checkTerminationConditions() {
        this.iterations.increment();
        return this.iterations.getValue() > this.minIterations.getValue() && (this.iterations.getValue() >= this.maxIterations.getValue() || this.filteredAverageParticleVelocity.getValue() < this.terminalParticleVelocity.getValue());
    }

    public boolean hasConverged() {
        return this.hasConverged.getBooleanValue();
    }

    private void updateDebugVariables() {
        if (this.actualContactingBody == null) {
            return;
        }
        this.actualContactPoint.setIncludingFrame((ReferenceFrame)this.actualContactingBody.getParentJoint().getFrameAfterJoint(), (Tuple3DReadOnly)this.actualContactPointInParentJointFrame);
        this.actualContactPoint.changeFrame(ReferenceFrame.getWorldFrame());
        this.yoActualContactPoint.set((FrameTuple3DReadOnly)this.actualContactPoint);
        double maxProbability = -1.0;
        double distanceOfMaxProbability = 0.0;
        double closestParticleDistance = Double.POSITIVE_INFINITY;
        int indexClosestParticle = -1;
        for (int i = 0; i < 150; ++i) {
            double distance;
            this.contactPointParticles[i].getContactPointPosition().changeFrame(ReferenceFrame.getWorldFrame());
            if (this.contactPointProbabilities[i].getValue() > maxProbability) {
                maxProbability = this.contactPointProbabilities[i].getValue();
                distanceOfMaxProbability = this.contactPointParticles[i].getContactPointPosition().distance((FramePoint3DReadOnly)this.actualContactPoint);
            }
            if (!((distance = this.contactPointParticles[i].getContactPointPosition().distance((FramePoint3DReadOnly)this.actualContactPoint)) < closestParticleDistance)) continue;
            closestParticleDistance = distance;
            indexClosestParticle = i;
        }
        this.maximumProbabilityParticle.set(maxProbability);
        this.errorOfMaximumProbabilityParticle.set(distanceOfMaxProbability);
        this.closestParticleProbability.set(this.contactPointProbabilities[indexClosestParticle].getValue());
    }

    public FramePoint3D getEstimatedContactPosition() {
        return this.averageProjectedParticle.getContactPointPosition();
    }

    public RigidBodyBasics getEstimatedContactingBody() {
        return this.estimatedContactingBody;
    }

    public DMatrixRMaj getJointResiduals() {
        return this.externalTorqueEstimator.getEstimatedExternalTorque();
    }
}

