/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.configurations;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.commonWalkingControlModules.configurations.SwingTrajectoryParameters;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.dataStructures.parameters.FrameParameterVector3D;
import us.ihmc.robotics.dataStructures.parameters.ParameterVector3D;
import us.ihmc.yoVariables.parameters.BooleanParameter;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;

public class YoSwingTrajectoryParameters {
    private final BooleanParameter doHeelTouchdownIfPossible;
    private final DoubleParameter heelTouchdownAngle;
    private final DoubleParameter maximumHeightForHeelTouchdown;
    private final DoubleParameter heelTouchdownLengthRatio;
    private final BooleanParameter doToeTouchdownIfPossible;
    private final DoubleParameter toeTouchdownAngle;
    private final DoubleParameter stepDownHeightForToeTouchdown;
    private final DoubleParameter toeTouchdownDepthRatio;
    private final BooleanParameter addOrientationMidpointForClearance;
    private final DoubleParameter midpointOrientationInterpolationForClearance;
    private final DoubleParameter minHeightDifferenceForObstacleClearance;
    private final DoubleParameter finalSwingHeightOffset;
    private final List<DoubleProvider> defaultWaypointProportions = new ArrayList<DoubleProvider>();
    private final List<DoubleProvider> defaultObstacleClearanceWaypointProportions = new ArrayList<DoubleProvider>();
    private final ParameterVector3D touchdownVelocityWeight;
    private final FrameParameterVector3D touchdownVelocity;
    private final FrameParameterVector3D touchdownAcceleration;
    private final DoubleProvider finalCoMVelocityInjectionRatio;
    private final DoubleProvider finalCoMAccelerationInjectionRatio;
    private final BooleanProvider ignoreInitialAngularVelocityZ;
    private final DoubleProvider maxInitialLinearVelocityMagnitude;
    private final DoubleProvider maxInitialAngularVelocityMagnitude;
    private final DoubleProvider velocityAdjustmentDamping;

    public YoSwingTrajectoryParameters(String namePrefix, WalkingControllerParameters walkingControllerParameters, YoRegistry registry) {
        this(namePrefix, walkingControllerParameters, walkingControllerParameters.getSwingTrajectoryParameters(), registry);
    }

    public YoSwingTrajectoryParameters(String namePrefix, WalkingControllerParameters walkingControllerParameters, SwingTrajectoryParameters parameters, YoRegistry registry) {
        this.doHeelTouchdownIfPossible = new BooleanParameter(namePrefix + "DoHeelTouchdownIfPossible", registry, parameters.doHeelTouchdownIfPossible());
        this.heelTouchdownAngle = new DoubleParameter(namePrefix + "HeelTouchdownAngle", registry, parameters.getHeelTouchdownAngle());
        this.maximumHeightForHeelTouchdown = new DoubleParameter(namePrefix + "MaximumHeightForHeelTouchdown", registry, parameters.getMaximumHeightForHeelTouchdown());
        this.heelTouchdownLengthRatio = new DoubleParameter(namePrefix + "HeelTouchdownLengthRatio", registry, parameters.getHeelTouchdownLengthRatio());
        this.doToeTouchdownIfPossible = new BooleanParameter(namePrefix + "DoToeTouchdownIfPossible", registry, parameters.doToeTouchdownIfPossible());
        this.toeTouchdownAngle = new DoubleParameter(namePrefix + "ToeTouchdownAngle", registry, parameters.getToeTouchdownAngle());
        this.stepDownHeightForToeTouchdown = new DoubleParameter(namePrefix + "StepDownHeightForToeTouchdown", registry, parameters.getStepDownHeightForToeTouchdown());
        this.toeTouchdownDepthRatio = new DoubleParameter(namePrefix + "ToeTouchdownDepthRatio", registry, parameters.getToeTouchdownDepthRatio());
        this.addOrientationMidpointForClearance = new BooleanParameter(namePrefix + "AddOrientationMidpointForClearance", registry, parameters.addOrientationMidpointForObstacleClearance());
        this.midpointOrientationInterpolationForClearance = new DoubleParameter(namePrefix + "MidpointOrientationInterpolationForClearance", registry, parameters.midpointOrientationInterpolationForObstacleClearance());
        this.minHeightDifferenceForObstacleClearance = new DoubleParameter(namePrefix + "MinHeightDifferenceForObstacleClearance", registry, parameters.getMinHeightDifferenceForStepUpOrDown());
        int numberWaypoints = 2;
        double[] defaultWaypointProportions = parameters.getSwingWaypointProportions();
        double[] defaultObstacleClearanceWaypointProportions = parameters.getObstacleClearanceProportions();
        for (int i = 0; i < numberWaypoints; ++i) {
            DoubleParameter waypointProportion = new DoubleParameter(namePrefix + "WaypointProportion" + i, registry, defaultWaypointProportions[i]);
            DoubleParameter obstacleClearanceWaypointProportion = new DoubleParameter(namePrefix + "ObstacleClearanceWaypointProportion" + i, registry, defaultObstacleClearanceWaypointProportions[i]);
            this.defaultWaypointProportions.add((DoubleProvider)waypointProportion);
            this.defaultObstacleClearanceWaypointProportions.add((DoubleProvider)obstacleClearanceWaypointProportion);
        }
        this.touchdownVelocityWeight = new ParameterVector3D(namePrefix + "TouchdownVelocityWeight", parameters.getTouchdownVelocityWeight(), registry);
        this.finalSwingHeightOffset = new DoubleParameter(namePrefix + "FinalHeightOffset", registry, parameters.getDesiredTouchdownHeightOffset());
        Vector3D defaultTouchdownVelocity = new Vector3D(0.0, 0.0, parameters.getDesiredTouchdownVelocity());
        this.touchdownVelocity = new FrameParameterVector3D(namePrefix + "TouchdownVelocity", ReferenceFrame.getWorldFrame(), (Vector3DReadOnly)defaultTouchdownVelocity, registry);
        this.finalCoMVelocityInjectionRatio = new DoubleParameter(namePrefix + "FinalCoMVelocityInjectionRatio", registry, parameters.getFinalCoMVelocityInjectionRatio());
        this.finalCoMAccelerationInjectionRatio = new DoubleParameter(namePrefix + "finalCoMAccelerationInjectionRatio", registry, parameters.getFinalCoMAccelerationInjectionRatio());
        Vector3D defaultTouchdownAcceleration = new Vector3D(0.0, 0.0, parameters.getDesiredTouchdownAcceleration());
        this.touchdownAcceleration = new FrameParameterVector3D(namePrefix + "TouchdownAcceleration", ReferenceFrame.getWorldFrame(), (Vector3DReadOnly)defaultTouchdownAcceleration, registry);
        this.ignoreInitialAngularVelocityZ = new BooleanParameter(namePrefix + "IgnoreInitialAngularVelocityZ", registry, walkingControllerParameters.ignoreSwingInitialAngularVelocityZ());
        this.maxInitialLinearVelocityMagnitude = new DoubleParameter(namePrefix + "MaxInitialLinearVelocityMagnitude", registry, walkingControllerParameters.getMaxSwingInitialLinearVelocityMagnitude());
        this.maxInitialAngularVelocityMagnitude = new DoubleParameter(namePrefix + "MaxInitialAngularVelocityMagnitude", registry, walkingControllerParameters.getMaxSwingInitialAngularVelocityMagnitude());
        this.velocityAdjustmentDamping = new DoubleParameter(namePrefix + "VelocityAdjustmentDamping", registry, parameters.getSwingFootVelocityAdjustmentDamping());
    }

    public boolean doToeTouchdownIfPossible() {
        return this.doToeTouchdownIfPossible.getValue();
    }

    public double getToeTouchdownAngle() {
        return this.toeTouchdownAngle.getValue();
    }

    public double getToeTouchdownDepthRatio() {
        return this.toeTouchdownDepthRatio.getValue();
    }

    public double getStepDownHeightForToeTouchdown() {
        return this.stepDownHeightForToeTouchdown.getValue();
    }

    public boolean doHeelTouchdownIfPossible() {
        return this.doHeelTouchdownIfPossible.getValue();
    }

    public double getHeelTouchdownAngle() {
        return this.heelTouchdownAngle.getValue();
    }

    public double getHeelTouchdownLengthRatio() {
        return this.heelTouchdownLengthRatio.getValue();
    }

    public double getMaximumHeightForHeelTouchdown() {
        return this.maximumHeightForHeelTouchdown.getValue();
    }

    public boolean addOrientationMidpointForObstacleClearance() {
        return this.addOrientationMidpointForClearance.getValue();
    }

    public double getMidpointOrientationInterpolationForObstacleClearance() {
        return this.midpointOrientationInterpolationForClearance.getValue();
    }

    public double getMinHeightDifferenceForStepUpOrDown() {
        return this.minHeightDifferenceForObstacleClearance.getValue();
    }

    public List<DoubleProvider> getSwingWaypointProportions() {
        return this.defaultWaypointProportions;
    }

    public List<DoubleProvider> getObstacleClearanceProportions() {
        return this.defaultObstacleClearanceWaypointProportions;
    }

    public Tuple3DReadOnly getTouchdownVelocityWeight() {
        return this.touchdownVelocityWeight;
    }

    public double getDesiredTouchdownHeightOffset() {
        return this.finalSwingHeightOffset.getValue();
    }

    public FrameVector3DReadOnly getDesiredTouchdownVelocity() {
        return this.touchdownVelocity;
    }

    public FrameVector3DReadOnly getDesiredTouchdownAcceleration() {
        return this.touchdownAcceleration;
    }

    public double getFinalCoMVelocityInjectionRatio() {
        return this.finalCoMVelocityInjectionRatio.getValue();
    }

    public double getFinalCoMAccelerationInjectionRatio() {
        return this.finalCoMAccelerationInjectionRatio.getValue();
    }

    public boolean ignoreSwingInitialAngularVelocityZ() {
        return this.ignoreInitialAngularVelocityZ.getValue();
    }

    public double getMaxSwingInitialLinearVelocityMagnitude() {
        return this.maxInitialLinearVelocityMagnitude.getValue();
    }

    public double getMaxSwingInitialAngularVelocityMagnitude() {
        return this.maxInitialAngularVelocityMagnitude.getValue();
    }

    public double getSwingFootVelocityAdjustmentDamping() {
        return this.velocityAdjustmentDamping.getValue();
    }
}

