/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.captureRegion;

import java.util.List;
import us.ihmc.commonWalkingControlModules.captureRegion.FootstepAdjusterVisualizer;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DBasics;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex2DSupplier;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.footstep.Footstep;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.geometry.ConvexPolygonTools;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.yoVariables.registry.YoRegistry;

public class FootstepAdjustor {
    private static final boolean VISUALIZE = true;
    private static final double SHRINK_TOUCHDOWN_POLYGON_FACTOR = 0.5;
    private final YoRegistry registry = new YoRegistry("FootstepAdjustor");
    private final SideDependentList<ConvexPolygon2D> defaultSupportPolygons;
    private FootstepAdjusterVisualizer footstepAdjusterVisualizer = null;
    private final ConvexPolygonTools convexPolygonTools = new ConvexPolygonTools();
    private final FrameConvexPolygon2D touchdownFootPolygon = new FrameConvexPolygon2D();
    private final FrameConvexPolygon2D desiredSteppingRegion = new FrameConvexPolygon2D();
    private final FrameConvexPolygon2D intersection = new FrameConvexPolygon2D();
    private final FramePoint2D nextStep2d = new FramePoint2D();
    private final FramePoint2D projection = new FramePoint2D();
    private final FrameVector2D direction = new FrameVector2D();
    private final FramePoint2D centroid2d = new FramePoint2D();
    private final FramePoint3D centroid3d = new FramePoint3D();

    public FootstepAdjustor(SideDependentList<? extends ContactablePlaneBody> contactableFeet, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        parentRegistry.addChild(this.registry);
        if (yoGraphicsListRegistry != null) {
            this.footstepAdjusterVisualizer = new FootstepAdjusterVisualizer(this, yoGraphicsListRegistry, this.registry);
        }
        this.defaultSupportPolygons = new SideDependentList();
        for (RobotSide robotSide : RobotSide.values) {
            this.defaultSupportPolygons.put((Enum)robotSide, (Object)new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier((List)((ContactablePlaneBody)contactableFeet.get((Enum)robotSide)).getContactPoints2d())));
        }
    }

    public boolean adjustFootstep(Footstep footstep, FramePoint2DReadOnly supportCentroid, FrameConvexPolygon2DReadOnly captureRegion) {
        boolean footstepChanged = false;
        if (captureRegion.isEmpty()) {
            this.updateVisualizer();
            return footstepChanged;
        }
        this.desiredSteppingRegion.setIncludingFrame((FrameVertex2DSupplier)captureRegion);
        this.calculateTouchdownFootPolygon(footstep, this.desiredSteppingRegion.getReferenceFrame(), this.touchdownFootPolygon);
        this.desiredSteppingRegion.checkReferenceFrameMatch((ReferenceFrameHolder)this.touchdownFootPolygon);
        this.intersection.clear(this.desiredSteppingRegion.getReferenceFrame());
        boolean nextStepInside = this.convexPolygonTools.computeIntersectionOfPolygons((ConvexPolygon2DReadOnly)this.desiredSteppingRegion, (ConvexPolygon2DReadOnly)this.touchdownFootPolygon, (ConvexPolygon2DBasics)this.intersection);
        if (nextStepInside) {
            this.updateVisualizer();
            return footstepChanged;
        }
        footstepChanged = true;
        this.projectFootstepInCaptureRegion(footstep, supportCentroid, (FrameConvexPolygon2DReadOnly)this.desiredSteppingRegion);
        this.updateVisualizer();
        return footstepChanged;
    }

    private void projectFootstepInCaptureRegion(Footstep footstep, FramePoint2DReadOnly projectionPoint, FrameConvexPolygon2DReadOnly captureRegion) {
        ReferenceFrame footstepFrame = footstep.getFootstepPose().getReferenceFrame();
        footstepFrame.checkReferenceFrameMatch(ReferenceFrame.getWorldFrame());
        this.projection.setIncludingFrame((FrameTuple2DReadOnly)projectionPoint);
        this.projection.changeFrame(footstepFrame);
        this.nextStep2d.setIncludingFrame((FrameTuple2DReadOnly)captureRegion.getCentroid());
        this.nextStep2d.changeFrame(footstepFrame);
        this.direction.setIncludingFrame((FrameTuple2DReadOnly)this.nextStep2d);
        this.direction.sub((FrameTuple2DReadOnly)this.projection);
        this.direction.normalize();
        this.direction.scale(10.0);
        this.nextStep2d.add((FrameTuple2DReadOnly)this.direction);
        this.nextStep2d.changeFrame(captureRegion.getReferenceFrame());
        captureRegion.orthogonalProjection((FramePoint2DBasics)this.nextStep2d);
        this.nextStep2d.changeFrame(footstepFrame);
        footstep.setPositionChangeOnlyXY((FramePoint2DReadOnly)this.nextStep2d);
        this.calculateTouchdownFootPolygon(footstep, captureRegion.getReferenceFrame(), this.touchdownFootPolygon);
    }

    private void calculateTouchdownFootPolygon(Footstep footstep, ReferenceFrame desiredFrame, FrameConvexPolygon2D polygonToPack) {
        footstep.getPosition(this.centroid3d);
        this.centroid2d.setIncludingFrame((FrameTuple3DReadOnly)this.centroid3d);
        this.centroid2d.changeFrame(desiredFrame);
        polygonToPack.setIncludingFrame(footstep.getSoleReferenceFrame(), (Vertex2DSupplier)this.defaultSupportPolygons.get((Enum)footstep.getRobotSide()));
        polygonToPack.changeFrameAndProjectToXYPlane(desiredFrame);
        polygonToPack.scale((FramePoint2DReadOnly)this.centroid2d, 0.5);
    }

    public FrameConvexPolygon2D getTouchdownFootPolygon() {
        return this.touchdownFootPolygon;
    }

    public void updateVisualizer() {
        if (this.footstepAdjusterVisualizer != null) {
            this.footstepAdjusterVisualizer.update();
        }
    }

    public void hideTouchdownPolygons() {
        if (this.footstepAdjusterVisualizer != null) {
            this.footstepAdjusterVisualizer.hide();
        }
    }
}

